/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ConnectionUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.MetadataResource;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

@SASScope
public class MdSecurityUtilImpl
implements MdSecurityUtil {
    protected static MetadataResource bundle = new MetadataResource(MdSecurityUtilImpl.class);
    private static final String PERMISSION_WRITEMETADATA = "WriteMetadata";
    private static final String PERMISSION_WRITEMEMBERMETADATA = "WriteMemberMetadata";
    private static final String PERMISSION_READMETADATA = "ReadMetadata";
    private MdFactory _factory = null;

    public MdSecurityUtilImpl(MdFactory factory) throws RemoteException {
        this._factory = factory;
        if (this._factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public void dispose() throws RemoteException {
        if (this._factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this._factory = null;
    }

    @Override
    public boolean isReadAuthorized(String metadataType, String metadataID) throws MdException, RemoteException {
        return this.isAuthorized(PERMISSION_READMETADATA, metadataID, metadataType);
    }

    @Override
    public boolean isWriteAuthorized(String metadataType, String metadataID) throws MdException, RemoteException {
        return this.isAuthorized(PERMISSION_WRITEMETADATA, metadataID, metadataType);
    }

    @Override
    public boolean isFolderWriteAuthorized(String folderID) throws MdException, RemoteException {
        return this.isAuthorized(PERMISSION_WRITEMEMBERMETADATA, folderID, "Tree");
    }

    private boolean isAuthorized(String permissionType, String objectID, String metadataType) throws MdException, RemoteException {
        ISecurity_1_1 isec = null;
        String resource = "OMSOBJ:" + metadataType + "/" + objectID;
        StringHolder permissionCondition = new StringHolder();
        BooleanHolder authorized = new BooleanHolder();
        try {
            isec = this._factory.getConnection().MakeISecurityConnection();
            if (isec == null) {
                throw new MdException(bundle.getString("MdSecurityUtilImpl.InvalidConnection.txt"));
            }
            isec.IsAuthorized("", resource, permissionType, permissionCondition, authorized);
            boolean bl = authorized.value;
            return bl;
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this._factory, e)) {
                boolean bl = this.isAuthorized(permissionType, objectID, metadataType);
                return bl;
            }
            throw new MdException(e);
        }
        finally {
            if (isec != null) {
                this._factory.getConnection().closeISecurityConnection((ISecurity)isec);
            }
        }
    }

    @Override
    public int getAssociationCountForObject(CMetadata meta, String associationName) throws MdException, RemoteException {
        String type = meta.getCMetadataType();
        StringBuffer sb = new StringBuffer();
        sb.append("<XMLSelect search=\"*[@Id='");
        sb.append(meta.getId());
        sb.append("']\"/>");
        sb.append("<Templates><");
        sb.append(meta.getCMetadataType());
        sb.append("><");
        sb.append(associationName);
        sb.append("/></");
        sb.append(meta.getCMetadataType());
        sb.append("></Templates>");
        String reposId = "A0000001." + meta.getRepositoryID();
        int flags = 388;
        int count = this.getCountNoSecurity(reposId, sb.toString(), type, associationName, flags);
        return count;
    }

    @Override
    public int getCountNoSecurity(String reposID, String xmlSelect, String metadataType) throws MdException, RemoteException {
        return this.getCountNoSecurity(reposID, xmlSelect, metadataType, 0);
    }

    @Override
    public int getCountNoSecurity(String reposID, String xmlSelect, String metadataType, int flags) throws MdException, RemoteException {
        return this.getCountNoSecurity(reposID, xmlSelect, metadataType, "", flags);
    }

    private int getCountNoSecurity(String reposID, String xmlSelect, String metadataType, String permission, int flags) throws MdException, RemoteException {
        ISecurity_1_1 isec = null;
        VariableArray2dOfStringHolder result = new VariableArray2dOfStringHolder();
        flags |= 0x100;
        flags |= 0x80;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<GetMetadataObjects>");
        buffer.append("  <Reposid>" + reposID + "</Reposid>");
        buffer.append("  <Type>" + metadataType + "</Type>");
        buffer.append("  <Objects/>");
        buffer.append("  <NS>SAS</NS>");
        buffer.append("  <Flags>" + flags + "</Flags>");
        buffer.append("  <options>");
        buffer.append(xmlSelect);
        buffer.append("  </options>");
        buffer.append("</GetMetadataObjects>");
        try {
            isec = this._factory.getConnection().MakeISecurityConnection();
            if (isec == null) {
                throw new MdException(bundle.getString("MdSecurityUtilImpl.InvalidConnection.txt"));
            }
            isec.GetAuthorizations("getCountNoSecurity", "", buffer.toString(), permission, result);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this._factory, e)) {
                int n = this.getCountNoSecurity(reposID, xmlSelect, metadataType, permission, flags);
                return n;
            }
            throw new MdException(e);
        }
        finally {
            if (isec != null) {
                this._factory.getConnection().closeISecurityConnection((ISecurity)isec);
            }
        }
        if (result != null) {
            String string = result.value[0][1];
            int count = Integer.parseInt(string);
            return count;
        }
        return 0;
    }
}

