/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryCache;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.TypeDefinition;
import java.rmi.RemoteException;
import java.util.Iterator;

@SASScope
public class MdResponsibilitiesUtil {
    private static final String PROPERTY_KEY = "com.sas.metadata.disableCreatedModifiedBy";
    public static final String ROLE_MODIFIED_BY = "Modified By";
    public static final String ROLE_CREATED_BY = "Created By";
    private static final String CACHE_PROPERTY_CREATEDBY = "MdResponsibilitiesUtil.CreatedBy";
    private static final String CACHE_PROPERTY_MODIFIEDBY = "MdResponsibilitiesUtil.ModifiedBy";
    private static final String CONTAINER_TYPE_FOLDER = "Folder";
    private static final String CONTAINER_TYPE_FOLDER_SUBTYPE = "Folder.";
    private static boolean setValuesOnUpdate = true;

    public static String getCreatedByValue(PrimaryType object) throws MdException, RemoteException {
        return MdResponsibilitiesUtil.getCreatedModifiedByInfo(object, ROLE_CREATED_BY);
    }

    public static String getModifiedByValue(PrimaryType object) throws MdException, RemoteException {
        return MdResponsibilitiesUtil.getCreatedModifiedByInfo(object, ROLE_MODIFIED_BY);
    }

    private static String getCreatedModifiedByInfo(PrimaryType object, String role) throws MdException, RemoteException {
        String value = "";
        if (object != null && object.getPublicType() != null && object.getPublicType().length() > 0) {
            AssociationList responsibilities = object.getResponsibleParties();
            for (ResponsibleParty responsibility : responsibilities) {
                AssociationList identities;
                if (!role.equalsIgnoreCase(responsibility.getRole()) || (identities = responsibility.getPersons()).isEmpty()) continue;
                value = ((Identity)identities.get(0)).getName();
                break;
            }
        }
        return value;
    }

    public static void setCreatedModifiedByValues(CMetadata object) throws MdException, RemoteException {
        if (object instanceof PrimaryType && ((PrimaryType)object).getPublicType() != null && ((PrimaryType)object).getPublicType().length() > 0) {
            MdResponsibilitiesUtil.setCreatedByModifiedByValuesInternal(object, object.isNewObject());
        }
    }

    public static void setCreatedModifiedByValues(CMetadata object, boolean isNew) throws MdException, RemoteException {
        if (object instanceof PrimaryType && ((PrimaryType)object).getPublicType() != null && ((PrimaryType)object).getPublicType().length() > 0) {
            MdResponsibilitiesUtil.setCreatedByModifiedByValuesInternal(object, isNew);
        }
    }

    public static void setCreatedByValue(CMetadata object, String identityName) throws MdException, RemoteException {
        if (identityName == null || identityName.isEmpty()) {
            return;
        }
        if (object.isNewObject()) {
            return;
        }
        MdObjectStore store = (MdObjectStore)object.getObjectStore();
        MdFactory factory = store.getFactory();
        MdFactoryCache cache = factory.getFactoryCache();
        TypeDefinition typeDef = cache.getTypeDefinition(((PrimaryType)object).getPublicType());
        if (typeDef != null && MdResponsibilitiesUtil.isContainedByFolder(typeDef.getContainerType())) {
            AssociationList responsibilities = ((PrimaryType)object).getResponsibleParties();
            ResponsibleParty createdByReponsibility = MdResponsibilitiesUtil.getCreatedByResponsibility(factory, store, identityName);
            if (createdByReponsibility != null) {
                MdResponsibilitiesUtil.setResponsibility(store, factory, responsibilities, createdByReponsibility);
            }
        }
    }

    private static void setCreatedByModifiedByValuesInternal(CMetadata object, boolean isNew) throws RemoteException, MdException {
        if (!setValuesOnUpdate) {
            return;
        }
        MdObjectStore store = (MdObjectStore)object.getObjectStore();
        MdFactory factory = store.getFactory();
        MdFactoryCache cache = factory.getFactoryCache();
        TypeDefinition typeDef = cache.getTypeDefinition(((PrimaryType)object).getPublicType());
        if (typeDef != null && MdResponsibilitiesUtil.isContainedByFolder(typeDef.getContainerType())) {
            ResponsibleParty modifiedByReponsibility;
            ResponsibleParty createdByReponsibility;
            AssociationList responsibilities = ((PrimaryType)object).getResponsibleParties();
            if (isNew && (createdByReponsibility = MdResponsibilitiesUtil.getCreatedByResponsibility(factory, cache)) != null) {
                MdResponsibilitiesUtil.setResponsibility(store, factory, responsibilities, createdByReponsibility);
            }
            if ((modifiedByReponsibility = MdResponsibilitiesUtil.getModifiedByResponsibility(factory, cache)) != null) {
                MdResponsibilitiesUtil.setResponsibility(store, factory, responsibilities, modifiedByReponsibility);
            }
        }
    }

    private static void setResponsibility(MdObjectStore store, MdFactory factory, AssociationList responsibilities, ResponsibleParty responsibilityToClone) throws RemoteException {
        if (responsibilityToClone != null) {
            Iterator iter = responsibilities.iterator();
            while (iter.hasNext()) {
                ResponsibleParty responsibility = (ResponsibleParty)iter.next();
                if (!responsibilityToClone.getRole().equalsIgnoreCase(responsibility.getRole())) continue;
                iter.remove();
            }
            ResponsibleParty responsibility = (ResponsibleParty)factory.createComplexMetadataObject(store, responsibilityToClone.getName(), "ResponsibleParty", responsibilityToClone.getId());
            responsibility.setRole(responsibilityToClone.getRole(), 2);
            responsibilities.add(responsibility);
        }
    }

    private static ResponsibleParty getCreatedByResponsibility(MdFactory factory, MdFactoryCache cache) throws MdException, RemoteException {
        ResponsibleParty createdByResponsibility = (ResponsibleParty)cache.getObjectFromCache(CACHE_PROPERTY_CREATEDBY);
        if (createdByResponsibility == null) {
            createdByResponsibility = MdResponsibilitiesUtil.getResponsibility(factory, cache, ROLE_CREATED_BY);
            cache.addObjectToCache(CACHE_PROPERTY_CREATEDBY, createdByResponsibility);
        }
        return createdByResponsibility;
    }

    private static ResponsibleParty getCreatedByResponsibility(MdFactory factory, MdObjectStore store, String identityName) throws MdException, RemoteException {
        return MdResponsibilitiesUtil.getResponsibility(factory, store, identityName, ROLE_CREATED_BY);
    }

    private static ResponsibleParty getModifiedByResponsibility(MdFactory factory, MdFactoryCache cache) throws MdException, RemoteException {
        ResponsibleParty modifiedByResponsibility = (ResponsibleParty)cache.getObjectFromCache(CACHE_PROPERTY_MODIFIEDBY);
        if (modifiedByResponsibility == null) {
            modifiedByResponsibility = MdResponsibilitiesUtil.getResponsibility(factory, cache, ROLE_MODIFIED_BY);
            cache.addObjectToCache(CACHE_PROPERTY_MODIFIEDBY, modifiedByResponsibility);
        }
        return modifiedByResponsibility;
    }

    private static ResponsibleParty getResponsibility(MdFactory factory, MdFactoryCache cache, String role) throws MdException, RemoteException {
        String identityName = cache.getConnectedUserName();
        return MdResponsibilitiesUtil.getResponsibility(factory, cache.getObjectStore(), identityName, role);
    }

    private static ResponsibleParty getResponsibility(MdFactory factory, MdObjectStore store, String identityName, String role) throws MdException, RemoteException {
        ResponsibleParty responsibility = null;
        if (identityName != null) {
            responsibility = factory.getOMIUtil().getResponsibleParty(store, identityName, role);
        }
        return responsibility;
    }

    private static boolean isContainedByFolder(String containerType) {
        return CONTAINER_TYPE_FOLDER.equalsIgnoreCase(containerType) || containerType.startsWith(CONTAINER_TYPE_FOLDER_SUBTYPE);
    }

    static {
        String setCreatedModifiedByInfo = System.getProperty(PROPERTY_KEY);
        if (Boolean.TRUE.toString().equalsIgnoreCase(setCreatedModifiedByInfo)) {
            setValuesOnUpdate = false;
        }
    }
}

