/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ConnectionUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdRepositoryUtil;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class MdRepositoryUtilImpl
implements MdRepositoryUtil {
    private static final String REPOSITORY_TYPE = "RepositoryBase";
    private MdFactory _factory = null;

    public MdRepositoryUtilImpl(MdFactory factory) throws RemoteException {
        this._factory = factory;
        if (this._factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public void dispose() throws RemoteException {
        if (this._factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this._factory = null;
    }

    @Override
    public String getRepositoryType(String repositoryID) throws MdException, RemoteException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\" RepositoryType=\"\"/>");
        inXML.append(getXML);
        inXML.append("</Metadata><Ns>REPOS</Ns><Flags>");
        inXML.append(1);
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        this._factory.getUtil().printLoglnClient(inXML.toString());
        try {
            this._factory.getConnection().getCMRHandle().GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this._factory, e)) {
                return this.getRepositoryType(repositoryID);
            }
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        this._factory.getUtil().printLoglnServer(outXMLString);
        String repositoryType = null;
        Pattern p = Pattern.compile("RepositoryType=\"([0-9a-zA-Z.]+)\"");
        Matcher m = p.matcher(outXMLString);
        if (m.find()) {
            repositoryType = m.group(1);
        }
        return repositoryType;
    }

    @Override
    public String getRepositoryName(String repositoryID) throws MdException, RemoteException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\" Name=\"\"/>");
        inXML.append(getXML);
        inXML.append("</Metadata><Ns>REPOS</Ns><Flags>");
        inXML.append(1);
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        this._factory.getUtil().printLoglnClient(inXML.toString());
        try {
            this._factory.getConnection().getCMRHandle().GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this._factory, e)) {
                return this.getRepositoryName(repositoryID);
            }
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        this._factory.getUtil().printLoglnServer(outXMLString);
        String repositoryName = null;
        Document doc = this._factory.getOMIUtil().parseXML(outXMLString);
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            NamedNodeMap nodeMap = firstNode.getAttributes();
            repositoryName = this._factory.getOMIUtil().getAttribute("Name", nodeMap);
        }
        doc = null;
        return repositoryName;
    }

    @Override
    public String getRepositoryIDFromName(String name) throws MdException, RemoteException {
        String repos_manager_id = "A0000001.A0000001";
        int flags = 384;
        String options = "<XMLSelect Search=\"@Name='" + name + "'\"/>";
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadataObjects><ReposId>");
        inXML.append("A0000001.A0000001");
        inXML.append("</ReposId><Type><RepositoryBase>");
        inXML.append("</Type><Ns>REPOS</Ns><Flags>");
        inXML.append(flags);
        inXML.append("</Flags><Options>");
        inXML.append(options);
        inXML.append("</Options></GetMetadataObjects>");
        StringHolder outXML = new StringHolder();
        this._factory.getUtil().printLoglnClient(inXML.toString());
        try {
            this._factory.getConnection().getCMRHandle().GetMetadataObjects("A0000001.A0000001", REPOSITORY_TYPE, outXML, "REPOS", flags, options);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this._factory, e)) {
                return this.getRepositoryIDFromName(name);
            }
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        this._factory.getUtil().printLoglnServer(outXMLString);
        String id = null;
        Pattern p = Pattern.compile("Id=\"([0-9a-zA-Z.]+)\"");
        Matcher m = p.matcher(outXMLString);
        if (m.find()) {
            id = m.group(1);
        }
        return id;
    }

    @Override
    public List getDependentRepositories(String repositoryID) throws MdException, RemoteException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\"><DependencyUsedBy/></RepositoryBase>");
        inXML.append(getXML.substring(0));
        inXML.append("</Metadata><NS>REPOS</NS><Flags>0");
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        this._factory.getUtil().printLoglnClient(getXML.substring(0));
        try {
            this._factory.getConnection().getCMRHandle().GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this._factory, e)) {
                return this.getDependentRepositories(repositoryID);
            }
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        this._factory.getUtil().printLoglnServer(outXMLString);
        ArrayList<String> returnObjects = new ArrayList<String>();
        Document doc = this._factory.getOMIUtil().parseXML(outXMLString);
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                NodeList childList = currentNode.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node childNode = childList.item(j);
                    NamedNodeMap childNodeMap = childNode.getAttributes();
                    String id = this._factory.getOMIUtil().getAttribute("Id", childNodeMap);
                    if (id == null) continue;
                    returnObjects.add(id);
                }
            }
        }
        doc = null;
        return returnObjects;
    }

    @Override
    public List getUsedByRepositories(String repositoryID) throws MdException, RemoteException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\"><DependencyUses/></RepositoryBase>");
        inXML.append(getXML.substring(0));
        inXML.append("</Metadata><NS>REPOS</NS><Flags>0");
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        this._factory.getUtil().printLoglnClient(getXML.substring(0));
        try {
            this._factory.getConnection().getCMRHandle().GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this._factory, e)) {
                return this.getUsedByRepositories(repositoryID);
            }
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        this._factory.getUtil().printLoglnServer(outXMLString);
        ArrayList<String> returnObjects = new ArrayList<String>();
        Document doc = this._factory.getOMIUtil().parseXML(outXMLString);
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                NodeList childList = currentNode.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node childNode = childList.item(j);
                    NamedNodeMap childNodeMap = childNode.getAttributes();
                    String id = this._factory.getOMIUtil().getAttribute("Id", childNodeMap);
                    if (id == null) continue;
                    returnObjects.add(id);
                }
            }
        }
        doc = null;
        return returnObjects;
    }

    @Override
    public boolean isDependentRepository(String repositoryID) throws MdException, RemoteException {
        List reposList = this.getUsedByRepositories(repositoryID);
        return reposList.size() > 0;
    }

    @Override
    public boolean hasDependentRepositories(String repositoryID) throws MdException, RemoteException {
        List reposList = this.getDependentRepositories(repositoryID);
        return reposList.size() > 0;
    }

    @Override
    public boolean isFoundationType(String repositoryID) throws MdException, RemoteException {
        return this.getRepositoryType(repositoryID).equalsIgnoreCase("FOUNDATION");
    }

    @Override
    public boolean isCustomType(String repositoryID) throws MdException, RemoteException {
        return this.getRepositoryType(repositoryID).equalsIgnoreCase("CUSTOM");
    }

    @Override
    public boolean isProjectType(String repositoryID) throws MdException, RemoteException {
        return this.getRepositoryType(repositoryID).equalsIgnoreCase("PROJECT");
    }
}

