/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdAbstractHandler;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectAttribute;
import com.sas.metadata.remote.MdSAXStackAssocProperty;
import com.sas.metadata.remote.MdStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@SASScope
public class MdGetObjectHandler
extends MdAbstractHandler {
    static final int DEFAULT_SKIP_VALUE = -1;
    static final String metadata_tag = "Metadata";
    static final String objects_tag = "Objects";
    List objectsCreated = new ArrayList();
    List rootLevelObjects = new ArrayList();
    ArrayList stackObjects = new ArrayList();
    Stack assocObjectStack = new Stack();
    boolean inAssoc = false;
    boolean processing_metadata_object = false;
    MdStore store = null;
    private int _skipLevel = -1;
    protected MdFactory factory = null;

    protected MdGetObjectHandler(SAXParserFactory parserFactory) throws RemoteException {
        super(parserFactory);
    }

    public MdGetObjectHandler(MdStore store, SAXParserFactory parserFactory) throws RemoteException {
        super(parserFactory);
        this.store = store;
        this.factory = store.getFactory();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.processing_metadata_object) {
            if (qName.equalsIgnoreCase(metadata_tag)) {
                this.processing_metadata_object = true;
                return;
            }
            if (qName.equalsIgnoreCase(objects_tag)) {
                this.processing_metadata_object = true;
                return;
            }
            if (this.isFlagSet(MDSTORE_XML)) {
                this.processing_metadata_object = true;
                return;
            }
            this.processing_metadata_object = true;
        }
        if (this.processing_metadata_object) {
            this.processMetadataObject(uri, localName, qName, attributes);
        }
    }

    public void processMetadataObject(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.level < 0) {
            return;
        }
        if (this.isSkippingNode(this.level)) {
            ++this.level;
            return;
        }
        try {
            int attrLength = attributes.getLength();
            HashMap attrs = null;
            String id = null;
            String name = null;
            boolean attributes_set = false;
            boolean populateAttributes = false;
            if (attrLength > 0) {
                boolean bLocalState = this.isFlagSet(LOCAL_STATE_ON);
                MapPool.instance();
                attrs = MapPool.getMap();
                for (int i = 0; i < attrLength; ++i) {
                    String attr = attributes.getQName(i);
                    if (id == null) {
                        if (attr.equalsIgnoreCase("Id")) {
                            populateAttributes = true;
                            id = attributes.getValue(i);
                            continue;
                        }
                        if (attr.equalsIgnoreCase("ObjRef")) {
                            id = attributes.getValue(i);
                            continue;
                        }
                    }
                    if (name == null && attr.equalsIgnoreCase("Name")) {
                        name = attributes.getValue(i);
                    }
                    attrs.put(attr, new MdObjectAttribute(attr, bLocalState ? 1 : 2, attributes.getValue(i)));
                }
            }
            if (!attributes_set && id != null) {
                attributes_set = true;
            }
            if (id != null) {
                CMetadata myObject = null;
                if (name == null) {
                    name = "";
                }
                if ((myObject = this.isFlagSet(CREATE_SIMPLE_OBJECTS_ONLY) ? this.factory.createSimpleMetadataObject(name, qName, id) : this.factory.createComplexMetadataObject(this.store, null, name, qName, id, null)) != null) {
                    this.addObjectToStack(myObject);
                    if (!this.inAssoc) {
                        this.rootLevelObjects.add(myObject);
                    } else {
                        MdSAXStackAssocProperty assocProperty = (MdSAXStackAssocProperty)this.assocObjectStack.get(this.assocObjectStack.size() - 1);
                        assocProperty.getAssocValues().add(myObject);
                    }
                    if (populateAttributes) {
                        this.setAttributes(myObject, attrs);
                        if ((myObject.getState() & 4) > 0) {
                            myObject.resetState(4);
                        }
                    }
                    this.objectsCreated.add(myObject);
                } else {
                    this.skipNode(this.level);
                }
            } else if (!attributes_set) {
                this.inAssoc = true;
                if (this.stackObjects.size() >= this.level && this.stackObjects.size() > 0) {
                    CMetadata parentObject = null;
                    Object stackObj = this.stackObjects.get(this.level - 1);
                    parentObject = stackObj.getClass().equals(MdSAXStackAssocProperty.class) ? ((MdSAXStackAssocProperty)stackObj).getParent() : (CMetadata)stackObj;
                    if (parentObject != null) {
                        MdSAXStackAssocProperty assocProperty = new MdSAXStackAssocProperty(qName, parentObject, this.level);
                        this.assocObjectStack.push(assocProperty);
                        this.addObjectToStack(assocProperty);
                    }
                }
            }
            if (attrs != null) {
                MapPool.returnMap(attrs);
            }
            ++this.level;
        }
        catch (Exception e) {
            throw new SAXException(e.toString());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.level < 0) {
            if (this.processing_metadata_object && qName.equalsIgnoreCase(metadata_tag)) {
                this.processing_metadata_object = false;
            } else if (this.processing_metadata_object && qName.equalsIgnoreCase(objects_tag)) {
                this.processing_metadata_object = false;
            } else if (this.processing_metadata_object && this.isFlagSet(MDSTORE_XML)) {
                this.processing_metadata_object = false;
            }
            return;
        }
        if (this.isInitialSkippedNode(this.level)) {
            this.resetSkipLevel();
            --this.level;
        } else if (this.isSkippingNode(this.level)) {
            --this.level;
        } else {
            try {
                this.processAssociation(qName);
                --this.level;
            }
            catch (Exception e) {
                SAXException se = new SAXException(e.getLocalizedMessage());
                se.initCause(e);
                throw se;
            }
        }
    }

    private void skipNode(int nodeLevel) {
        this._skipLevel = nodeLevel;
    }

    private boolean isInitialSkippedNode(int nodeLevel) {
        return this._skipLevel == -1 ? false : this._skipLevel == nodeLevel - 1;
    }

    private boolean isSkippingNode(int nodeLevel) {
        return this._skipLevel == -1 ? false : nodeLevel > this._skipLevel;
    }

    private void resetSkipLevel() {
        this._skipLevel = -1;
    }

    protected void addObjectToStack(Object input) {
        if (this.stackObjects.size() <= this.level) {
            this.stackObjects.add(this.level, input);
        } else {
            this.stackObjects.set(this.level, input);
        }
    }

    public void setAttributes(CMetadata inObject, Map<String, MdObjectAttribute> inAttributes) throws RemoteException {
        if (!this.isFlagSet(OVERRIDE_LOCALLYSET_ATTRIBUTES)) {
            Map<String, String> attrs = inObject.getUpdatedAttrs();
            if (attrs.size() > 0) {
                for (String attributeName : attrs.keySet()) {
                    inAttributes.remove(attributeName);
                }
            }
            MapPool.returnMap(attrs);
        }
        inObject.setAttrs(inAttributes);
    }

    public void processAssociation(String qName) throws RemoteException {
        if (this.inAssoc) {
            if (this.assocObjectStack.size() > 0) {
                MdSAXStackAssocProperty assocProperty = (MdSAXStackAssocProperty)this.assocObjectStack.get(this.assocObjectStack.size() - 1);
                if (!qName.equalsIgnoreCase(assocProperty.getAssociationName()) && assocProperty.getLevel() == this.level) {
                    MdSAXStackAssocProperty prop;
                    for (int i = this.assocObjectStack.size() - 1; i >= 0 && (prop = (MdSAXStackAssocProperty)this.assocObjectStack.get(i)).getLevel() == this.level; --i) {
                        this.persistAssoc(prop);
                    }
                    if (this.assocObjectStack.size() <= 0) {
                        this.inAssoc = false;
                    }
                }
                assocProperty = null;
            }
        } else if (this.level > 0 && this.stackObjects.size() > 0 && this.stackObjects.get(this.level - 1) instanceof MdSAXStackAssocProperty && this.assocObjectStack.size() > 0) {
            MdSAXStackAssocProperty assocProperty = (MdSAXStackAssocProperty)this.assocObjectStack.get(this.assocObjectStack.size() - 1);
            if (qName.equalsIgnoreCase(assocProperty.getAssociationName())) {
                this.persistAssoc(assocProperty);
            }
            Object var2_3 = null;
        }
    }

    public void persistAssoc(MdSAXStackAssocProperty assocProperty) throws RemoteException {
        this.assocObjectStack.pop();
        if (!this.isFlagSet(CREATE_SIMPLE_OBJECTS_ONLY)) {
            CMetadata parentObject;
            if (!this.isFlagSet(OVERRIDE_LOCALLYSET_ASSOCIATIONS)) {
                parentObject = assocProperty.getParent();
                Map<String, AssociationList> assocs = parentObject.getPopulatedAssocs();
                AssociationList assn = assocs.get(assocProperty.getAssociationName());
                MapPool.returnMap(assocs);
                if (assn != null) {
                    return;
                }
            }
            parentObject = assocProperty.getParent();
            AssociationList complexAssoc = new AssociationList(assocProperty.getAssociationName(), assocProperty.getAssocValues(), parentObject);
            if (this.isFlagSet(LOCAL_STATE_ON)) {
                complexAssoc.setState(4);
            } else {
                complexAssoc.setState(1);
            }
            assocProperty.getParent().setMdObjectAssociation(complexAssoc);
        }
        assocProperty.dispose();
    }

    @Override
    public void dispose() {
        this.rootLevelObjects.clear();
        this.rootLevelObjects = null;
        this.stackObjects.clear();
        this.stackObjects = null;
        if (this.assocObjectStack.size() > 0) {
            int len = this.assocObjectStack.size();
            for (int i = 0; i < len; ++i) {
                Object o = this.assocObjectStack.pop();
                if (o == null) continue;
                MdSAXStackAssocProperty prop = (MdSAXStackAssocProperty)o;
                prop.dispose();
            }
        }
        this.assocObjectStack.clear();
        this.assocObjectStack = null;
        this.objectsCreated.clear();
        this.objectsCreated = null;
    }

    public List getRootLevelCreatedObjects() {
        return this.rootLevelObjects;
    }

    public List getObjectCreatedList() {
        return this.objectsCreated;
    }
}

