/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryCache;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.TypeDefinition;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.StringHolder;

@SASScope
public class MdFactoryCacheImpl
implements MdFactoryCache,
Serializable {
    private static final long serialVersionUID = -3508111067623356443L;
    private MdFactory factory;
    private MdObjectStore store;
    private String foundationReposId;
    private String identityName;
    private Map<String, TypeDefinition> typeDefinitionCache;
    private Map<String, Object> cache;

    public MdFactoryCacheImpl(MdFactory factory) throws RemoteException {
        this.factory = factory;
        if (factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public void dispose() throws RemoteException {
        this.foundationReposId = null;
        this.identityName = null;
        this.typeDefinitionCache = null;
        if (this.store != null) {
            this.store.dispose();
        }
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
        if (this.factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addObjectToCache(String key, Object value) {
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>();
        }
        this.cache.put(key, value);
    }

    @Override
    public Object getObjectFromCache(String key) {
        return this.cache == null ? null : this.cache.get(key);
    }

    @Override
    public void removeObjectFromCache(Object key) {
        if (this.cache != null) {
            this.cache.remove(key);
        }
    }

    @Override
    public MdObjectStore getObjectStore() throws RemoteException {
        if (this.store == null) {
            this.store = this.factory.createObjectStore(null, "FactoryCacheStore");
        }
        return this.store;
    }

    @Override
    public TypeDefinition getTypeDefinition(String publicType) throws MdException, RemoteException {
        if (this.typeDefinitionCache == null) {
            this.typeDefinitionCache = this.loadTypeDefintions();
        }
        return this.typeDefinitionCache.get(publicType);
    }

    @Override
    public String getConnectedUserName() throws MdException, RemoteException {
        String id;
        if (this.identityName == null && (id = this.getConnectedUserId()) != null && !id.equals("UNKOWN")) {
            String reposId = this.getFoundationRepositoryId();
            String options = "<XMLSELECT Search=\"@Id='" + id + "'\"/>";
            int flags = 408;
            List<FastMetadata> identities = this.factory.getOMIUtil().getFastMetadataObjects("Identity", reposId, options, flags);
            if (identities != null && identities.size() > 0) {
                this.identityName = identities.get(0).getAttribute("Name");
            }
        }
        return this.identityName;
    }

    public String getConnectedUserId() throws MdException, RemoteException {
        String id = null;
        MdOMRConnection connection = this.factory.getConnection();
        ISecurity_1_1 isecurity = this.factory.getConnection().MakeISecurityConnection(connection.getCMRHandle());
        StringHolder idHolder = new StringHolder();
        try {
            isecurity.GetIdentity("", idHolder);
            id = idHolder.value;
            if (id != null) {
                int index = id.indexOf(47);
                id = id.substring(index + 1);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return id;
    }

    public String getFoundationRepositoryId() throws MdException, RemoteException {
        if (this.foundationReposId == null) {
            this.foundationReposId = this.factory.getOMIUtil().getFoundationReposID();
        }
        return this.foundationReposId;
    }

    private Map<String, TypeDefinition> loadTypeDefintions() throws MdException, RemoteException {
        HashMap<String, TypeDefinition> cache = new HashMap<String, TypeDefinition>();
        MdObjectStore store = this.getObjectStore();
        String reposId = this.getFoundationRepositoryId();
        int flags = 264;
        List definitions = this.factory.getOMIUtil().getMetadataObjectsSubset(store, reposId, "TypeDefinition", flags, "");
        if (definitions != null && !definitions.isEmpty()) {
            for (TypeDefinition definition : definitions) {
                cache.put(definition.getTypeName(), definition);
            }
        }
        return cache;
    }
}

