/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.metadata.remote.MetadataResource;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MdException
extends Exception {
    private static final long serialVersionUID = 3144380142439852442L;
    protected static MetadataResource bundle = new MetadataResource(MdException.class);
    private static final String DEFAULT_MESSAGE = bundle.getString("MdException.DefaultMessage.txt");
    private String SASMessage;
    private String SASMessageSeverity;
    private Throwable cause;
    private transient DocumentBuilderFactory dbf;
    private transient DocumentBuilder myDocBuilder;

    public MdException() {
    }

    public MdException(String s) {
        super(s);
    }

    public MdException(Throwable t) {
        this.cause = t;
        if (t.getCause() != null) {
            this.cause = t.getCause();
        }
        String Message = this.cause.getLocalizedMessage();
        Document errorDoc = null;
        if (Message != null && Message.length() > 0 && Message.charAt(0) == '<') {
            try {
                this.dbf = DocumentBuilderFactory.newInstance();
                this.myDocBuilder = this.dbf.newDocumentBuilder();
                errorDoc = this.parseXML(Message);
            }
            catch (ParserConfigurationException pe) {
                pe.printStackTrace();
            }
            catch (Exception exp) {
                return;
            }
            NodeList errorList = errorDoc.getElementsByTagName("SASMessage");
            for (int i = 0; i < errorList.getLength(); ++i) {
                Node error = errorList.item(i);
                NamedNodeMap attributes = error.getAttributes();
                NodeList children = error.getChildNodes();
                this.SASMessageSeverity = attributes.item(0).getNodeValue();
                this.SASMessage = children.item(0).getNodeValue();
            }
            errorDoc = null;
            this.myDocBuilder = null;
            this.dbf = null;
        }
    }

    public MdException(String s, String SAS_Message, String SAS_MessageSeverity) {
        super(s);
        this.SASMessage = SAS_Message;
        super.printStackTrace();
        this.SASMessageSeverity = SAS_MessageSeverity;
    }

    public String getSASMessage() {
        return this.SASMessage;
    }

    public String getSASMessageSeverity() {
        return this.SASMessageSeverity;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getLocalizedMessage() {
        String msg = null;
        msg = this.cause == null ? super.getLocalizedMessage() : (this.SASMessage != null ? this.SASMessage : this.cause.getLocalizedMessage());
        return msg == null ? DEFAULT_MESSAGE : msg;
    }

    @Override
    public String getMessage() {
        String msg = null;
        msg = this.cause == null ? super.getMessage() : (this.SASMessage != null ? this.SASMessage : this.cause.getMessage());
        return msg == null ? DEFAULT_MESSAGE : msg;
    }

    @Override
    public void printStackTrace() {
        if (this.cause == null) {
            super.printStackTrace();
        } else {
            this.cause.printStackTrace();
        }
    }

    public Document parseXML(String strXML) throws MdException {
        StringReader strReader = new StringReader(strXML);
        Document doc = null;
        try {
            doc = this.myDocBuilder.parse(new InputSource(strReader));
        }
        catch (IOException e) {
            throw new MdException(e.toString());
        }
        catch (SAXException e) {
            throw new MdException(e.toString());
        }
        return doc;
    }
}

