/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdChangeManagementEventListener;
import com.sas.metadata.remote.MdChangeManagementUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.XMLUtil;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class MdChangeManagementUtilImpl
extends UnicastRemoteObject
implements MdChangeManagementUtil {
    protected static EventListenerList listenerList = new EventListenerList();
    protected static List groupableTypes = null;
    protected static List checkoutableTypes = null;
    protected MdFactory m_factory = null;

    public MdChangeManagementUtilImpl(MdFactory factory) throws RemoteException {
        this();
        this.m_factory = factory;
    }

    private MdChangeManagementUtilImpl() throws RemoteException {
    }

    @Override
    public void checkOut(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        if (metaObjects == null || metaObjects.size() == 0) {
            return;
        }
        int flags = 1032;
        StringBuffer outXML = new StringBuffer("<CheckoutMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appendXML = new StringBuffer("<");
            appendXML.append(object.getCMetadataType());
            appendXML.append(" Id=\"");
            appendXML.append(object.getFQID());
            appendXML.append("\" />");
            outXML.append(appendXML);
        }
        outXML.append("</METADATA><ProjectReposid>");
        outXML.append("</ProjectReposid><ns>SAS</ns><flags>");
        outXML.append(flags);
        outXML.append("</flags><options/></CheckoutMetadata>");
        try {
            ioutDoc = this.m_factory.getOMIUtil().DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = this.m_factory.createObjectStore();
        List newSimpleObjects = this.createAllObjects(store, ioutDoc);
        this.fireMetadataCheckOut(new ChangeEvent(projectRepository), newSimpleObjects);
        store.dispose();
    }

    @Override
    public void addObjects(MdObjectStore store, CMetadata projectRepository) throws MdException, RemoteException {
        throw new MdException("NOT IMPLEMENTED");
    }

    @Override
    public void newObjectsAdded(CMetadata projectRepository, List objects) throws MdException, RemoteException {
        this.fireNewObjectsAdded(new ChangeEvent(projectRepository), objects);
    }

    @Override
    public boolean isGroupableObject(CMetadata object) throws RemoteException {
        List groups = this.getGroupObjectTypes();
        return groups.contains(object.getCMetadataType());
    }

    @Override
    public boolean isCheckoutableObject(CMetadata object) throws RemoteException {
        return this.isCheckoutableObject(object.getCMetadataType());
    }

    @Override
    public boolean isCheckoutableObject(String sType) throws RemoteException {
        List types = this.getCheckoutObjectTypes();
        return types.contains(sType);
    }

    @Override
    public List createAllObjects(MdObjectStore store, Document outDoc) throws MdException, RemoteException {
        Node newNode = outDoc.getFirstChild().getFirstChild();
        ArrayList<Root> objects = new ArrayList<Root>();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return objects;
        }
        NodeList tempNodeList = newNodeList;
        if (tempNodeList.item(0).getNodeName().equals("UpdatedObjects")) {
            newNodeList = tempNodeList.item(0).getChildNodes();
        } else if (tempNodeList.item(0).getNodeName().equals("DeletedObjects")) {
            return objects;
        }
        int length = newNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strType = newNodeList.item(i).getNodeName();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (newNodeMap == null || newNodeMap.getLength() == 0) continue;
            String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
            String strName = "";
            Node nameNode = newNodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            String strChangeState = null;
            Node changestateNode = newNodeMap.getNamedItem("ChangeState");
            if (changestateNode != null) {
                strChangeState = changestateNode.getNodeValue();
            } else {
                this.m_factory.getUtil().printOutputln("Missing changestate ");
            }
            Root object = (Root)this.m_factory.createComplexMetadataObject(store, strName, strType, strNewId);
            if (strChangeState != null) {
                object.setChangeState(strChangeState);
            }
            if (strChangeState == null) {
                objects.add(object);
                continue;
            }
            if (strChangeState.indexOf("New") >= 0) continue;
            objects.add(object);
        }
        return objects;
    }

    @Override
    public List createDestroyedObjects(Document outDoc) throws RemoteException {
        Node newNode = outDoc.getFirstChild().getFirstChild();
        ArrayList<String> objects = new ArrayList<String>();
        NodeList newNodeList = newNode.getChildNodes();
        int newNodeListLength = newNodeList.getLength();
        if (newNodeListLength == 0) {
            return objects;
        }
        NodeList tempNodeList = newNodeList;
        for (int j = 0; j < newNodeListLength; ++j) {
            if (!tempNodeList.item(j).getNodeName().equals("DeletedObjects")) continue;
            newNodeList = tempNodeList.item(j).getChildNodes();
            int length = newNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
                String strNewId = newNodeMap.getNamedItem("Id").getNodeValue();
                objects.add(strNewId);
            }
        }
        return objects;
    }

    @Override
    public List checkIn(CMetadata projectRepository, String strChangeName, String strChangeDesc) throws MdException, RemoteException {
        List oldDestroyedObjects;
        Document ioutDoc;
        String strCleanChangeName = XMLUtil.normalize(strChangeName);
        String strCleanChangeDesc = XMLUtil.normalize(strChangeDesc);
        StringBuffer outXML = new StringBuffer("<CheckinMetadata><Metadata/><ProjectReposid>");
        outXML.append(projectRepository.getFQID());
        outXML.append("</ProjectReposid><ChangeName>");
        outXML.append(strCleanChangeName);
        outXML.append("</ChangeName>");
        if (strChangeDesc != null && strChangeDesc.length() > 0) {
            outXML.append("<ChangeDesc>");
            outXML.append(strCleanChangeDesc);
            outXML.append("</ChangeDesc>");
        }
        outXML.append("<ns>SAS</ns><flags>");
        outXML.append(1024);
        outXML.append("</flags><options></options></CheckinMetadata>");
        this.m_factory.getUtil().printOutputln("Starting checkin");
        try {
            ioutDoc = this.m_factory.getOMIUtil().DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = this.m_factory.createObjectStore();
        List newSimpleObjects = this.createAllObjects(store, ioutDoc);
        if (newSimpleObjects.size() > 0) {
            this.fireMetadataCheckIn(new ChangeEvent(projectRepository), newSimpleObjects);
        }
        if ((oldDestroyedObjects = this.createDestroyedObjects(ioutDoc)).size() > 0) {
            this.fireMetadataDestroyed(new ChangeEvent(projectRepository), oldDestroyedObjects);
        }
        if (newSimpleObjects.size() == 0) {
            store.dispose();
        }
        this.m_factory.getUtil().printOutputln("Ending checkin");
        return newSimpleObjects;
    }

    @Override
    public void fetch(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        StringBuffer outXML = new StringBuffer("<FetchMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ProjectReposid>");
        outXML.append(projectRepository.getFQID());
        outXML.append("</ProjectReposid><ns>SAS</ns><flags>");
        outXML.append(1024);
        outXML.append("</flags><options></options></FetchMetadata>");
        this.m_factory.getUtil().printOutputln("Starting fetch");
        try {
            ioutDoc = this.m_factory.getOMIUtil().DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = this.m_factory.createObjectStore();
        List newSimpleObjects = this.createAllObjects(store, ioutDoc);
        this.fireMetadataFetched(new ChangeEvent(projectRepository), newSimpleObjects);
        store.dispose();
        this.m_factory.getUtil().printOutputln("Ending fetch");
    }

    @Override
    public void copyObjects(List metaObjects, CMetadata repository) throws MdException, RemoteException {
        Document ioutDoc;
        StringBuffer outXML = new StringBuffer("<CopyMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ToReposid>");
        outXML.append(repository.getFQID());
        outXML.append("</ToReposid><ns>SAS</ns><flags>");
        outXML.append(1024);
        outXML.append("</flags><options></options></CopyMetadata>");
        this.m_factory.getUtil().printOutputln("Starting copy");
        try {
            ioutDoc = this.m_factory.getOMIUtil().DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = this.m_factory.createObjectStore();
        List newSimpleObjects = this.createAllObjects(store, ioutDoc);
        this.fireMetadataCopied(new ChangeEvent(repository), newSimpleObjects);
        store.dispose();
        this.m_factory.getUtil().printOutputln("Ending copy");
    }

    @Override
    public void undoCheckout(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        Document ioutDoc;
        StringBuffer outXML = new StringBuffer("<UndoCheckoutMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ns>SAS</ns><flags>");
        int flags = 1032;
        outXML.append(flags);
        outXML.append("</flags><options></options></UndoCheckoutMetadata>");
        this.m_factory.getUtil().printOutputln("Starting undocheckout");
        try {
            ioutDoc = this.m_factory.getOMIUtil().DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        MdObjectStore store = this.m_factory.createObjectStore();
        List newSimpleObjects = this.createAllObjects(store, ioutDoc);
        this.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), newSimpleObjects);
        this.m_factory.getUtil().printOutputln("Ending undocheckout");
        store.dispose();
    }

    @Override
    public void destroy(List metaObjects, CMetadata projectRepository) throws MdException, RemoteException {
        StringBuffer outXML = new StringBuffer("<DeleteMetadata><METADATA>");
        for (int i = 0; i < metaObjects.size(); ++i) {
            CMetadata object = (CMetadata)metaObjects.get(i);
            StringBuffer appXML = new StringBuffer("<");
            appXML.append(object.getCMetadataType());
            appXML.append(" Id=\"");
            appXML.append(object.getFQID());
            appXML.append("\" />");
            outXML.append(appXML);
        }
        outXML.append("</METADATA><ns>SAS</ns><flags>");
        outXML.append(0x10000000);
        outXML.append("</flags><options></options></DeleteMetadata>");
        this.m_factory.getUtil().printOutputln("Starting destroy");
        try {
            this.m_factory.getOMIUtil().DoRequest(outXML.toString(), false);
        }
        catch (Exception e) {
            throw new MdException(e.toString());
        }
        this.fireMetadataUndoCheckout(new ChangeEvent(projectRepository), metaObjects);
        this.m_factory.getUtil().printOutputln("Ending destroy");
    }

    @Override
    public void lockObjects(CMetadata cmGroupTop, List nodeObjects, CMetadata projectRepository) throws MdException, RemoteException {
    }

    @Override
    public void addMdChangeManagementEventListener(MdChangeManagementEventListener l) throws RemoteException {
        listenerList.add(MdChangeManagementEventListener.class, l);
    }

    @Override
    public void removeMdChangeManagementEventListener(MdChangeManagementEventListener l) throws RemoteException {
        listenerList.remove(MdChangeManagementEventListener.class, l);
    }

    @Override
    public void fireMetadataCheckOut(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsCheckedOut(e, items);
        }
    }

    @Override
    public void fireNewObjectsAdded(ChangeEvent e, List objects) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsNewAdded(e, objects);
        }
    }

    @Override
    public void fireMetadataFetched(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsFetched(e, items);
        }
    }

    @Override
    public void fireMetadataCopied(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsCopied(e, items);
        }
    }

    @Override
    public void fireMetadataLocked(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsLocked(e, items);
        }
    }

    @Override
    public void fireMetadataUnLocked(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsUnLocked(e, items);
        }
    }

    @Override
    public void fireMetadataCheckIn(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsCheckedIn(e, items);
        }
    }

    @Override
    public void fireMetadataDestroyed(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsDestroyed(e, items);
        }
    }

    @Override
    public void fireMetadataUndoCheckout(ChangeEvent e, List items) throws RemoteException {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdChangeManagementEventListener.class) continue;
            ((MdChangeManagementEventListener)listeners[i + 1]).objectsUndoCheckout(e, items);
        }
    }

    private List getGroupObjectTypes() {
        if (groupableTypes == null || groupableTypes.size() == 0) {
            groupableTypes = new ArrayList();
            groupableTypes.add("Cube");
            groupableTypes.add("ExternalTable");
            groupableTypes.add("PhysicalTable");
            groupableTypes.add("Report");
            groupableTypes.add("TextStore");
            groupableTypes.add("Document");
            groupableTypes.add("DeployedComponent");
            groupableTypes.add("SASLibrary");
            groupableTypes.add("Tree");
            groupableTypes.add("Job");
        }
        return groupableTypes;
    }

    private List getCheckoutObjectTypes() {
        if (checkoutableTypes == null || checkoutableTypes.size() == 0) {
            checkoutableTypes = new ArrayList();
            checkoutableTypes.add("Cube");
            checkoutableTypes.add("ExternalTable");
            checkoutableTypes.add("PhysicalTable");
            checkoutableTypes.add("Report");
            checkoutableTypes.add("TextStore");
            checkoutableTypes.add("Document");
            checkoutableTypes.add("DeployedComponent");
            checkoutableTypes.add("SASLibrary");
            checkoutableTypes.add("Tree");
            checkoutableTypes.add("Job");
        }
        return checkoutableTypes;
    }
}

