/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@SASScope
public abstract class MdAbstractHandler
extends DefaultHandler {
    private SAXParserFactory parserFactory = null;
    public static final int FLAGS_OFF = 0;
    public static int OVERRIDE_LOCALLYSET_ATTRIBUTES = 1;
    public static int OVERRIDE_LOCALLYSET_ASSOCIATIONS = 2;
    public static int SERVER_STATE_ON = 4;
    public static int LOCAL_STATE_ON = 8;
    public static int MDSTORE_XML = 512;
    public static int CREATE_SIMPLE_OBJECTS_ONLY = 1024;
    protected int flags = 0;
    protected int level = 0;

    public MdAbstractHandler(SAXParserFactory factory) {
        this.parserFactory = factory;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlag(int inState) {
        this.flags = inState == 0 ? 0 : (this.flags |= inState);
    }

    public boolean isFlagSet(int inFlag) {
        return (this.flags & inFlag) > 0;
    }

    public void parseXML(String iXML) throws MdException {
        try {
            StringReader strReader = new StringReader(iXML);
            SAXParser parser = this.parserFactory.newSAXParser();
            parser.parse(new InputSource(strReader), (DefaultHandler)this);
            parser = null;
            strReader = null;
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        catch (IOException e) {
            throw new MdException(e);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
    }

    public void parseXML(InputStream is) throws MdException {
        try {
            SAXParser parser = this.parserFactory.newSAXParser();
            parser.parse(new InputSource(is), (DefaultHandler)this);
            parser = null;
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        catch (IOException e) {
            throw new MdException(e);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
    }

    @Override
    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    @Override
    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public abstract void dispose();
}

