/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.metadata.remote.MdConnectionEvent;
import com.sas.metadata.remote.MdConnectionListener;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import java.io.IOException;
import java.rmi.RemoteException;

class ConnectionUtil {
    private static final String EX_MSG_CONNECTIONABORT = "connection abort";
    private static final String EX_MSG_EOFEXCEPTION = "EOFException";
    private static final String EX_MSG_SOCKETEXCEPTION = "SocketException";

    ConnectionUtil() {
    }

    static boolean shouldRetryFailedRequest(MdFactory factory, Exception e) throws RemoteException, MdException {
        MdConnectionEvent event;
        MdConnectionListener listener;
        return ConnectionUtil.isConnectionException(e) && (listener = factory.getMdConnectionListener()) != null && listener.notify(event = new MdConnectionEvent(ConnectionUtil.class, factory, e));
    }

    private static boolean isConnectionException(Throwable ex) {
        String mexMessage = ex.getMessage();
        return mexMessage != null && (mexMessage.indexOf(EX_MSG_EOFEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_SOCKETEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_CONNECTIONABORT) > -1) || ConnectionUtil.ioExceptionInChain(ex);
    }

    private static boolean ioExceptionInChain(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return true;
            }
            Throwable t = ex.getCause();
            if (t == ex) break;
            ex = t;
        }
        return false;
    }
}

