/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr.util;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Timestamp {
    private static final DateTimeFormatter[] TIME_PARSERS = new DateTimeFormatter[]{ISODateTimeFormat.timeParser().withZone(DateTimeZone.UTC), Timestamp.parserFormatter("HH:mm:ssZ"), Timestamp.parserFormatter("HH:mm:ss")};
    private static final DateTimeFormatter[] DATE_PARSERS = new DateTimeFormatter[]{ISODateTimeFormat.dateParser().withZone(DateTimeZone.UTC), Timestamp.parserFormatter("yyyy-MM-ddZ")};
    private static final DateTimeFormatter[] TIMESTAMP_PARSERS = new DateTimeFormatter[]{ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC), Timestamp.parserFormatter("yyyy-MM-dd'T'HH:mm:ssZ")};
    private static final DateTimeFormatter TIME_FORMATTER = ISODateTimeFormat.time().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter DATE_FORMATTER = Timestamp.parserFormatter("yyyy-MM-dd'Z'");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = Timestamp.parserFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    private static final DateTimeFormatter parserFormatter(String spec) {
        return DateTimeFormat.forPattern((String)spec).withZone(DateTimeZone.UTC);
    }

    public static Date parseTimestampAsDate(String timestamp) throws IllegalArgumentException {
        DateTime dateTime = Timestamp.parseTimestampAsDateTime(timestamp);
        return dateTime.toDate();
    }

    public static DateTime parseDateAsDateTime(String date) throws IllegalArgumentException {
        return Timestamp.tryParsing(date, DATE_PARSERS);
    }

    public static DateTime parseTimeAsDateTime(String time) throws IllegalArgumentException {
        return Timestamp.tryParsing(time, TIME_PARSERS);
    }

    public static DateTime parseTimestampAsDateTime(String timestamp) throws IllegalArgumentException {
        return Timestamp.tryParsing(timestamp, TIMESTAMP_PARSERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTime tryParsing(String time, DateTimeFormatter[] parsers) throws IllegalArgumentException {
        DateTime dateTime = null;
        IllegalArgumentException last = null;
        for (DateTimeFormatter parser : parsers) {
            try {
                DateTime dateTime2 = dateTime = parser.parseDateTime(time);
                return dateTime2;
            }
            catch (IllegalArgumentException e) {
                last = e;
            }
        }
        throw last;
    }

    public static String timestamp(DateTime timestamp) {
        return timestamp.toString(TIMESTAMP_FORMATTER);
    }

    public static String timestamp(Date timestamp) {
        return Timestamp.timestamp(timestamp.getTime());
    }

    public static String timestamp(long millisSinceJavaEpoch) {
        DateTime timestamp = new DateTime(millisSinceJavaEpoch);
        return Timestamp.timestamp(timestamp);
    }

    public static String timeString(DateTime time) {
        return time.toString(TIME_FORMATTER);
    }

    public static String timeString(Date time) {
        return Timestamp.timeString(time.getTime());
    }

    public static String timeString(long millisSinceJavaEpoch) {
        DateTime dateTime = new DateTime(millisSinceJavaEpoch);
        return Timestamp.timeString(dateTime);
    }

    public static String dateString(DateTime date) {
        return date.toString(DATE_FORMATTER);
    }

    public static String dateString(Date date) {
        return Timestamp.dateString(date.getTime());
    }

    public static String dateString(long millisSinceJavaEpoch) {
        DateTime dateTime = new DateTime(millisSinceJavaEpoch);
        return Timestamp.dateString(dateTime);
    }
}

