/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.AbstractExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.util.Timestamp;
import com.sas.commons.lang.NullArgumentException;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.joda.time.DateTime;

public class TimeExpression
extends AbstractExpression {
    private static final long serialVersionUID = 1L;
    private final DateTime dateTime;

    public TimeExpression(@NonNull String timeString) {
        NullArgumentException.throwIfNull((Object)timeString, (String)"timeString");
        this.dateTime = Timestamp.parseTimeAsDateTime(timeString);
    }

    @Override
    public Expression accept(@NonNull ExpressionVisitor visitor) {
        return visitor.visitTime(this);
    }

    @Override
    @NonNull
    public StringBuilder toString(@NonNull StringBuilder s) {
        s.append(Timestamp.timeString(this.dateTime));
        return s;
    }

    @NonNull
    public DateTime getDateTime() {
        return this.dateTime;
    }
}

