/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.AbstractExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import edu.umd.cs.findbugs.annotations.NonNull;

public class NumberExpression
extends AbstractExpression {
    private static final long serialVersionUID = 1L;
    private final Number n;

    public NumberExpression(@NonNull Number n) {
        this.n = n;
    }

    public NumberExpression(@NonNull String text) {
        this(NumberExpression.number(text));
    }

    @NonNull
    private static Number number(String text) {
        Number number = NumberExpression.isDouble(text) ? (Number)Double.valueOf(text) : (Number)Long.valueOf(text);
        return number;
    }

    private static boolean isDouble(String text) {
        boolean d = text.indexOf(46) > -1 || text.indexOf(101) > -1 || text.indexOf(69) > -1;
        return d;
    }

    @Override
    public Expression accept(@NonNull ExpressionVisitor visitor) {
        return visitor.visitNumber(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberExpression other = (NumberExpression)obj;
        return this.n.equals(other.n);
    }

    @NonNull
    public Number getValue() {
        return this.n;
    }

    @Override
    public int hashCode() {
        return this.n.hashCode();
    }

    @Override
    @NonNull
    public StringBuilder toString(StringBuilder s) {
        if (s == null) {
            s = new StringBuilder();
        }
        return s.append(this.n.toString());
    }
}

