/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.NumberExpression;
import com.sas.commons.expr.SASMissingValue;
import com.sas.commons.lang.EmptyStringException;
import com.sas.commons.lang.NullArgumentException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashMap;

public final class MissingLiteral
extends NumberExpression {
    private static final long serialVersionUID = 1L;
    private static HashMap<String, MissingLiteral> nameMap = new HashMap();
    private final SASMissingValue value;
    public static final MissingLiteral Underscore = new MissingLiteral(SASMissingValue.Underscore);
    public static final MissingLiteral Dot = new MissingLiteral(SASMissingValue.Dot);
    public static final MissingLiteral A = new MissingLiteral(SASMissingValue.A);
    public static final MissingLiteral B = new MissingLiteral(SASMissingValue.B);
    public static final MissingLiteral C = new MissingLiteral(SASMissingValue.C);
    public static final MissingLiteral D = new MissingLiteral(SASMissingValue.D);
    public static final MissingLiteral E = new MissingLiteral(SASMissingValue.E);
    public static final MissingLiteral F = new MissingLiteral(SASMissingValue.F);
    public static final MissingLiteral G = new MissingLiteral(SASMissingValue.G);
    public static final MissingLiteral H = new MissingLiteral(SASMissingValue.H);
    public static final MissingLiteral I = new MissingLiteral(SASMissingValue.I);
    public static final MissingLiteral J = new MissingLiteral(SASMissingValue.J);
    public static final MissingLiteral K = new MissingLiteral(SASMissingValue.K);
    public static final MissingLiteral L = new MissingLiteral(SASMissingValue.L);
    public static final MissingLiteral M = new MissingLiteral(SASMissingValue.M);
    public static final MissingLiteral N = new MissingLiteral(SASMissingValue.N);
    public static final MissingLiteral O = new MissingLiteral(SASMissingValue.O);
    public static final MissingLiteral P = new MissingLiteral(SASMissingValue.P);
    public static final MissingLiteral Q = new MissingLiteral(SASMissingValue.Q);
    public static final MissingLiteral R = new MissingLiteral(SASMissingValue.R);
    public static final MissingLiteral S = new MissingLiteral(SASMissingValue.S);
    public static final MissingLiteral T = new MissingLiteral(SASMissingValue.T);
    public static final MissingLiteral U = new MissingLiteral(SASMissingValue.U);
    public static final MissingLiteral V = new MissingLiteral(SASMissingValue.V);
    public static final MissingLiteral W = new MissingLiteral(SASMissingValue.W);
    public static final MissingLiteral X = new MissingLiteral(SASMissingValue.X);
    public static final MissingLiteral Y = new MissingLiteral(SASMissingValue.Y);
    public static final MissingLiteral Z = new MissingLiteral(SASMissingValue.Z);

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MissingLiteral that = (MissingLiteral)obj;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    @NonNull
    public Number getValue() {
        return this.value.nan();
    }

    @NonNull
    @SuppressWarnings(value={"DM_CONVERT_CASE"}, justification="only valid missings are a-z A-Z; toUpper is OK")
    public static MissingLiteral from(@NonNull String text) {
        NullArgumentException.throwIfNull((Object)text, (String)"text");
        EmptyStringException.throwIfEmpty((String)text, (String)"text");
        switch (text.length()) {
            case 1: {
                if (text.charAt(0) == '.') {
                    return Dot;
                }
                char m = text.charAt(0);
                MissingLiteral l = nameMap.get('.' + text.toUpperCase());
                assert (l != null) : String.format("No such missing value .%c", Character.valueOf(m));
                return l;
            }
            case 2: {
                assert (text.charAt(0) == '.');
                char m = text.charAt(1);
                MissingLiteral l = nameMap.get(text.toUpperCase());
                assert (l != null) : String.format("No such missing value .%c", Character.valueOf(m));
                return l;
            }
        }
        assert (false) : "Missing value literals must be 1 or 2 characters long.";
        return null;
    }

    private MissingLiteral(@NonNull SASMissingValue val) {
        super(val.nan());
        this.value = val;
        nameMap.put(this.toString(), this);
    }

    @NonNull
    public SASMissingValue missingValue() {
        return this.value;
    }

    @Override
    @NonNull
    public StringBuilder toString(StringBuilder s) {
        if (s == null) {
            s = new StringBuilder();
        }
        s.append(this.value.toString());
        return s;
    }
}

