/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.AbstractExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.util.Timestamp;
import com.sas.commons.lang.NullArgumentException;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.joda.time.DateTime;

public class DateTimeExpression
extends AbstractExpression {
    private static final long serialVersionUID = 1L;
    private final DateTime dateTime;

    public DateTimeExpression(String dateString) {
        NullArgumentException.throwIfNull((Object)dateString, (String)"dateString");
        this.dateTime = Timestamp.parseTimestampAsDateTime(dateString);
    }

    @Override
    public Expression accept(ExpressionVisitor visitor) {
        return visitor.visitDateTime(this);
    }

    @Override
    public StringBuilder toString(StringBuilder s) {
        s.append(Timestamp.dateString(this.dateTime));
        return s;
    }

    @NonNull
    public DateTime getDateTime() {
        return this.dateTime;
    }
}

