/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.AbstractExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.util.Timestamp;
import com.sas.commons.lang.NullArgumentException;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.joda.time.DateTime;

public class DateExpression
extends AbstractExpression {
    private static final long serialVersionUID = 1L;
    private final DateTime dateTime;

    public DateExpression(@NonNull String dateString) {
        NullArgumentException.throwIfNull((Object)dateString, (String)"dateString");
        this.dateTime = Timestamp.parseDateAsDateTime(dateString);
    }

    public DateExpression(@NonNull DateTime dateString) {
        NullArgumentException.throwIfNull((Object)dateString, (String)"dateString");
        this.dateTime = dateString;
    }

    @Override
    public Expression accept(@NonNull ExpressionVisitor visitor) {
        return visitor.visitDate(this);
    }

    @Override
    @NonNull
    public StringBuilder toString(@NonNull StringBuilder s) {
        s.append(Timestamp.dateString(this.dateTime));
        return s;
    }

    @NonNull
    public DateTime getDateTime() {
        return this.dateTime;
    }
}

