/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.BooleanExpression;
import com.sas.commons.expr.DateExpression;
import com.sas.commons.expr.DateTimeExpression;
import com.sas.commons.expr.DottedName;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.Function;
import com.sas.commons.expr.NumberExpression;
import com.sas.commons.expr.SimpleName;
import com.sas.commons.expr.StringExpression;
import com.sas.commons.expr.TimeExpression;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;

public class BaseVisitor
implements ExpressionVisitor {
    @Override
    public Expression visitDottedName(@NonNull DottedName name) {
        return name;
    }

    @Override
    public Expression visitFunction(@NonNull Function function) {
        SimpleName name = function.getName();
        List<Expression> args = function.getArguments();
        int len = args.size();
        ArrayList<Expression> newArgs = new ArrayList<Expression>(len);
        for (int i = 0; i < len; ++i) {
            newArgs.add(args.get(i).accept(this));
        }
        return new Function(name, newArgs);
    }

    @Override
    public Expression visitSimpleName(@NonNull SimpleName name) {
        return name;
    }

    @Override
    public Expression visitNumber(@NonNull NumberExpression number) {
        return number;
    }

    @Override
    public Expression visitString(@NonNull StringExpression string) {
        return string;
    }

    @Override
    public Expression visitBoolean(@NonNull BooleanExpression booleanExpression) {
        return booleanExpression;
    }

    @Override
    public Expression visitDate(DateExpression dateExpression) {
        return dateExpression;
    }

    @Override
    public Expression visitDateTime(DateTimeExpression dateTimeExpression) {
        return dateTimeExpression;
    }

    @Override
    public Expression visitTime(TimeExpression timeExpression) {
        return timeExpression;
    }
}

