/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPortListCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import com.sas.workspace.mgmt.visuals.customizers.iom.MachineListCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.MachineListSelector;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MachineList
extends IOMProperty {
    protected JButton m_btnNew;
    protected JButton m_btnRemove;
    protected MachineListSelector m_dlMachines;
    private Prototype m_machineProto;
    private AssociationProperty m_machineProp;
    private Machine m_machine;
    private IOMPropertyList m_machProps;
    private boolean m_diff;

    public MachineList(ServerComponent comp, AssociationProperty metaProp, int viewType) {
        super((CMetadata)comp, (AbstractProperty)metaProp, viewType);
    }

    @Override
    public void addPropertyToPanel(JPanel panel) {
        try {
            GridBagConstraints gbc;
            if (!this.m_visible) {
                return;
            }
            int gridx = 0;
            int gridy = MachineList.getNextComponentHorizontalGridValue(panel);
            GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
            if (this.m_viewType == 0 || this.m_viewType == 2) {
                this.m_dlMachines.setPreferredSize(new Dimension(200, 70));
            }
            if (this.m_sep != null) {
                gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.gridx = gridx;
                gbc.gridy = gridy++;
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.insets = new Insets(12, 12, 0, 0);
                gbLayout.setConstraints(this.m_sep, gbc);
                panel.add(this.m_sep);
            } else if (this.m_useLabel) {
                ((JLabel)this.m_label).setLabelFor((Component)((Object)this.m_dlMachines));
                MachineList.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.fill = 1;
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.insets = new Insets(0, 12, 0, 0);
                gbLayout.setConstraints(this.m_label, gbc);
                panel.add(this.m_label);
            }
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = gridx;
            gbc.gridy = gridy++;
            gbc.weightx = 0.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(0, 12, 0, 12);
            gbLayout.setConstraints((Component)((Object)this.m_dlMachines), gbc);
            panel.add((Component)((Object)this.m_dlMachines));
            JPanel btnPanel = new JPanel();
            GridLayout btnLayout = new GridLayout(1, 2, 12, 12);
            btnPanel.setLayout(btnLayout);
            btnPanel.add(this.m_btnNew);
            btnPanel.add(this.m_btnRemove);
            gbc = new GridBagConstraints();
            gbc.gridy = gridy;
            gbc.gridx = gridx;
            gbc.anchor = 11;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(8, 12, 0, 12);
            gbLayout.setConstraints(btnPanel, gbc);
            panel.add(btnPanel);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void addTargetMachine(Machine machine) {
        DefaultListModel current = (DefaultListModel)this.m_dlMachines.getTargetModel();
        if (!current.contains(machine)) {
            current.addElement(machine);
            ((DefaultListModel)this.m_dlMachines.getModel()).removeElement(machine);
        }
    }

    @Override
    public Property createNewProperty() {
        return null;
    }

    @Override
    public Object getDataValue() {
        return null;
    }

    protected List<?> getMachineObjects() {
        return this.getAllMachineObjects();
    }

    protected List<?> getAllMachineObjects() {
        List machines = new Vector();
        int flags = 8604;
        String strTemplate = "<TEMPLATES><Machine/></TEMPLATES>";
        try {
            machines = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_object.getObjectStore(), "A0000001." + this.m_object.getRepositoryID(), "Machine", flags, strTemplate);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception ex) {
            ex.getMessage();
        }
        return machines;
    }

    public List<Object> getMachines() {
        Vector<Object> machines = new Vector<Object>();
        ListModel model = this.m_dlMachines.getTargetModel();
        for (int i = 0; i < model.getSize(); ++i) {
            machines.add(model.getElementAt(i));
        }
        return machines;
    }

    @Override
    protected void initialize() {
        this.m_diff = false;
        boolean newEnabled = true;
        try {
            AssociationList protos = ((AssociationProperty)this.m_metaProp).getAssociatedPrototypes();
            Prototype listProto = null;
            for (int i = 0; i < protos.size(); ++i) {
                Prototype temp = (Prototype)protos.get(i);
                if (!temp.getMetadataType().equals("Tree")) continue;
                listProto = (Prototype)protos.get(i);
                break;
            }
            if (listProto == null) {
                throw new IOMProperty.IllegalPropertyTypeException();
            }
            PropertyGroup pGroup = listProto.getPrimaryPropertyGroup();
            AssociationList props = pGroup.getGroupedProperties();
            block4: for (int j = 0; j < props.size(); ++j) {
                AbstractProperty prop = (AbstractProperty)props.get(j);
                if (!(prop instanceof AssociationProperty) || !((AssociationProperty)prop).getMetadataType().equals("Machine")) continue;
                this.m_machineProp = (AssociationProperty)prop;
                AssociationList propProtos = ((AssociationProperty)prop).getAssociatedPrototypes();
                for (int k = 0; k < propProtos.size(); ++k) {
                    if (!((Prototype)propProtos.get(k)).getMetadataType().equals("Machine")) continue;
                    this.m_machineProto = (Prototype)propProtos.get(k);
                    continue block4;
                }
            }
            if (this.m_machineProto == null) {
                throw new IOMProperty.IllegalPropertyTypeException();
            }
            if (this.m_machineProp.getCustomizers().size() == 0) {
                newEnabled = false;
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_dlMachines = new MachineListSelector();
        this.m_dlMachines.setPreferredSize(new Dimension(370, 90));
        this.m_dlMachines.setMinimumSize(new Dimension(75, 75));
        ((JList)this.m_dlMachines.getSourceComponent()).addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MachineList.this.onListSelectionChanged();
            }
        });
        ((JList)this.m_dlMachines.getTargetComponent()).addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MachineList.this.onListSelectionChanged();
            }
        });
        this.m_btnNew = new JButton(MachineList.getDisplayString(0, "MachineList.Button.New.Name.xmlKey.txt"));
        this.m_btnNew.setEnabled(true);
        MachineList.setMnemonic(this.m_btnNew, 0, "MachineList.Button.New.Name.xmlKey.txt");
        this.m_btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MachineList.this.onNewMachine();
            }
        });
        this.m_btnNew.setEnabled(newEnabled);
        this.m_btnRemove = new JButton(MachineList.getDisplayString(0, "MachineList.Button.Delete.Name.xmlKey.txt"));
        this.m_btnRemove.setEnabled(false);
        MachineList.setMnemonic(this.m_btnRemove, 0, "MachineList.Button.Delete.Name.xmlKey.txt");
        this.m_btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MachineList.this.onRemoveMachine();
            }
        });
        List<?> machines = this.getMachineObjects();
        DefaultListModel sourceModel = new DefaultListModel();
        for (int i = 0; i < machines.size(); ++i) {
            sourceModel.addElement(machines.get(i));
        }
        this.m_dlMachines.setModel(sourceModel);
        ((JList)this.m_dlMachines.getSourceComponent()).clearSelection();
        ((JList)this.m_dlMachines.getTargetComponent()).clearSelection();
        this.m_dlMachines.setToolTipText(this.m_dlMachines.getSourceComponent(), MachineList.getDisplayString(1, "MachineList.Source.Desc.xmlKey.txt"));
        this.m_dlMachines.setToolTipText(this.m_dlMachines.getTargetComponent(), MachineList.getDisplayString(1, "MachineList.Target.Desc.xmlKey.txt"));
        this.addPersistedPropertyEventListener(new MachineListPersistedPropertyListener());
    }

    public void onListSelectionChanged() {
        JList source = (JList)this.m_dlMachines.getSourceComponent();
        JList target = (JList)this.m_dlMachines.getTargetComponent();
        try {
            if (source.getSelectedValues().length >= 1 || target.getSelectedValues().length >= 1) {
                this.m_btnRemove.setEnabled(true);
                List permTargets = this.m_dlMachines.getPermanentTargets();
                Object[] selected = target.getSelectedValues();
                for (int i = 0; i < permTargets.size(); ++i) {
                    for (int j = 0; j < selected.length; ++j) {
                        if (!permTargets.get(i).equals(selected[j])) continue;
                        this.m_btnRemove.setEnabled(false);
                    }
                }
            } else {
                this.m_btnRemove.setEnabled(false);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.m_btnRemove.setEnabled(false);
        }
    }

    public void onNewMachine() {
        this.m_machProps = new IOMPropertyList();
        try {
            this.m_machine = (Machine)Workspace.getMdFactory().createComplexMetadataObject(Workspace.getMdFactory().createObjectStore(), null, "", "Machine", this.m_object.getRepositoryID(), null);
            PropertyGroup pGroup = this.m_machineProto.getPrimaryPropertyGroup();
            AssociationList props = pGroup.getGroupedProperties();
            for (int i = 0; i < props.size(); ++i) {
                if (!(props.get(i) instanceof AttributeProperty) && !(props.get(i) instanceof Property)) continue;
                IOMProperty iomProp = new IOMProperty((CMetadata)this.m_machine, (AbstractProperty)props.get(i), this.m_viewType);
                iomProp.setDataColumns(15);
                this.m_machProps.add(iomProp);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accesing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (this.m_machine == null) {
            return;
        }
        WAPanel panel = new WAPanel();
        panel.add((Component)this.m_machProps.getPropertiesPanel());
        WAStandardDialog dialog = new WAStandardDialog((Dialog)this.m_btnNew.getTopLevelAncestor(), MachineList.getDisplayString(0, "MachineListDialog.Title.xmlKey.txt"), true, panel){
            private static final long serialVersionUID = 1L;

            protected boolean onOK() {
                try {
                    int i;
                    IOMProperty propName = null;
                    for (int i2 = 0; i2 < MachineList.this.m_machProps.size(); ++i2) {
                        if (!MachineList.this.m_machProps.get(i2).getPropertyName().equals("Name")) continue;
                        propName = MachineList.this.m_machProps.get(i2);
                        break;
                    }
                    if (propName == null) {
                        return false;
                    }
                    if (propName.getDataValue().toString().trim().length() == 0) {
                        JOptionPane.showMessageDialog(this.getOwner(), IOMProperty.getDisplayString(0, "MachineListDialog.Error.NoMachine.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "MachineListDialog.Error.NoMachine.Title.xmlKey.txt"), 0);
                        return false;
                    }
                    List<?> machines = MachineList.this.getAllMachineObjects();
                    for (i = 0; i < machines.size(); ++i) {
                        if (!((Machine)machines.get(i)).getName().equals(propName.getDataValue().toString().trim())) continue;
                        JOptionPane.showMessageDialog(this.getOwner(), IOMProperty.getDisplayString(0, "MachineListDialog.Error.DuplicateMachine.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "MachineListDialog.Error.DuplicateMachine.Title.xmlKey.txt"), 0);
                        return false;
                    }
                    for (i = 0; i < MachineList.this.m_machProps.size(); ++i) {
                        MachineList.this.m_machProps.get(i).writeProperty();
                    }
                    try {
                        MachineList.this.m_machine.updateMetadataAll();
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accesing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    ((DefaultListModel)MachineList.this.m_dlMachines.getTargetModel()).addElement(MachineList.this.m_machine);
                    return super.onOK();
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                    return false;
                }
            }

            protected boolean onCancel() {
                try {
                    MachineList.this.m_object.getObjectStore().deleteObject((CMetadata)MachineList.this.m_machine);
                    return super.onCancel();
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                    return false;
                }
            }
        };
        dialog.setHelpProduct("templatedata");
        dialog.setHelpTopic("newmachine");
        dialog.pack();
        dialog.show();
    }

    public void onRemoveMachine() {
        try {
            JList list = (JList)this.m_dlMachines.getSourceComponent();
            if (list.getSelectedValues().length == 0) {
                list = (JList)this.m_dlMachines.getTargetComponent();
            }
            Object[] machines = list.getSelectedValues();
            int value = JOptionPane.showOptionDialog(((Dialog)this.m_dlMachines.getTopLevelAncestor()).getOwner(), MachineList.getDisplayString(0, "MachineList.Warning.MachineDeletion.Message.xmlKey.txt"), MachineList.getDisplayString(0, "MachineList.Warning.MachineDeletion.Title.xmlKey.txt"), 0, 2, null, null, null);
            if (value != 0) {
                return;
            }
            for (int i = 0; i < machines.length; ++i) {
                this.m_object.getObjectStore().deleteObject((CMetadata)((Machine)machines[i]));
                ((DefaultListModel)list.getModel()).removeElement(machines[i]);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setOwningDialog(Dialog owner) {
    }

    public void setPermanentTarget(String name) {
        try {
            Machine machine;
            ListModel source = this.m_dlMachines.getModel();
            ListModel target = this.m_dlMachines.getTargetModel();
            boolean found = false;
            for (int i = 0; i < target.getSize() && !found; ++i) {
                machine = (Machine)target.getElementAt(i);
                if (!machine.getName().equals(name)) continue;
                this.m_dlMachines.setPermanentTarget(machine);
                found = true;
            }
            for (int j = 0; j < source.getSize() && !found; ++j) {
                machine = (Machine)source.getElementAt(j);
                if (!machine.getName().equals(name)) continue;
                this.m_dlMachines.setPermanentTarget(machine);
                found = true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setTargetMachines(AssociationList machines) {
        DefaultListModel current = (DefaultListModel)this.m_dlMachines.getTargetModel();
        for (int i = 0; i < machines.size(); ++i) {
            if (current.contains(machines.get(i))) continue;
            current.addElement(machines.get(i));
            ((DefaultListModel)this.m_dlMachines.getModel()).removeElement(machines.get(i));
        }
    }

    @Override
    public String toString() {
        try {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(((JLabel)this.m_label).getText());
            strBuffer.append("\n\t");
            List<Object> machines = this.getMachines();
            for (int i = 0; i < machines.size(); ++i) {
                strBuffer.append(((Machine)machines.get(i)).getName());
                strBuffer.append("\n\t");
            }
            strBuffer.append("\n");
            return strBuffer.toString();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    @Override
    public void writeProperty() {
        this.fireWritePropertyEvent(new IOMProperty.PersistedPropertyEvent(this));
    }

    public class MachineListPersistedPropertyListener
    implements IOMProperty.PersistedPropertyEventListener {
        @Override
        public void deleteProperty(IOMProperty.PersistedPropertyEvent evt) {
            try {
                AssociationList trees = ((ServerComponent)MachineList.this.m_object).getSoftwareTrees(true);
                Tree machineGroup = null;
                for (int i = 0; i < trees.size(); ++i) {
                    Tree tree;
                    if (!(trees.get(i) instanceof Tree) || !(tree = (Tree)trees.get(i)).getTreeType().equals("MachineGroup")) continue;
                    machineGroup = (Tree)trees.get(i);
                    break;
                }
                MachineList.this.m_object.getObjectStore().deleteObject(machineGroup);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void readProperty(IOMProperty.PersistedPropertyEvent evt) {
            try {
                String hostName;
                AssociationList conns;
                ServerComponent sc = (ServerComponent)MachineList.this.m_object;
                AssociationList trees = sc.getSoftwareTrees();
                Tree machineGroup = null;
                if (trees.size() > 0) {
                    for (int i = 0; i < trees.size(); ++i) {
                        Tree tree = (Tree)trees.get(i);
                        if (!tree.getTreeType().equals("MachineGroup")) continue;
                        machineGroup = (Tree)trees.get(i);
                        break;
                    }
                    if (machineGroup != null) {
                        MachineList.this.setTargetMachines(machineGroup.getMembers());
                    }
                } else if (trees.size() == 0 && (conns = sc.getSourceConnections()).size() > 0 && conns.get(0) instanceof TCPIPConnection && (hostName = ((TCPIPConnection)conns.get(0)).getHostName()).trim().length() > 0) {
                    MachineList.this.addTargetMachine(MachineListCustomizer.findMachine((Root)sc, hostName));
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void writeProperty(IOMProperty.PersistedPropertyEvent evt) {
            try {
                ServerComponent server = (ServerComponent)MachineList.this.m_object;
                List<Object> machines = MachineList.this.getMachines();
                AssociationList trees = server.getSoftwareTrees(false);
                Tree machineGroup = null;
                AssociationList machinesInGroup = null;
                for (int i = 0; i < trees.size(); ++i) {
                    Tree tree;
                    if (!(trees.get(i) instanceof Tree) || !(tree = (Tree)trees.get(i)).getTreeType().equals("MachineGroup")) continue;
                    machineGroup = tree;
                    break;
                }
                if (machineGroup != null && machines.size() == 0) {
                    MachineList.this.m_object.getObjectStore().deleteObject(machineGroup);
                } else if (machines.size() > 0) {
                    if (machineGroup == null) {
                        machineGroup = (Tree)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)MachineList.this.m_object.getObjectStore(), null, "MachineGroup", "Tree", MachineList.this.m_object.getRepositoryID(), null);
                        machineGroup.setTreeType("MachineGroup");
                        trees.add((Object)machineGroup);
                    }
                    if ((machinesInGroup = machineGroup.getMembers(true)).size() == machines.size()) {
                        for (int m = 0; m < machines.size() && !MachineList.this.m_diff; ++m) {
                            MachineList.this.m_diff = machinesInGroup.get(m) != machines.get(m);
                        }
                    } else {
                        MachineList.this.m_diff = true;
                    }
                    if (MachineList.this.m_diff) {
                        machinesInGroup.clear();
                        for (int j = 0; j < machines.size(); ++j) {
                            machinesInGroup.add(machines.get(j));
                        }
                        machineGroup.setMembers(machinesInGroup);
                        if (machines.size() == 1) {
                            server.setAssociatedMachine((Machine)machines.get(0));
                        } else {
                            server.setAssociatedMachine(null);
                        }
                    }
                }
                if (MachineList.this.m_diff && MachineList.this.m_viewType != 0) {
                    if (server.getPublicType().equals("Spawner.IOM")) {
                        IOMPortListCustomizer.setRootConnectionHostName("Operator", server);
                        IOMPortListCustomizer.setRootConnectionHostName("PortBank", server);
                    } else {
                        IOMPortListCustomizer.setRootConnectionHostName("Bridge", server);
                        IOMPortListCustomizer.setRootConnectionHostName("MultiBridge", server);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

