/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.LoginSearchModel;
import com.sas.workspace.mgmt.visuals.LoginSearchPanel;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import com.sas.workspace.mgmt.visuals.customizers.iom.DefaultPropertyListener;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class LoginProperty
extends IOMProperty {
    protected List<Login> m_loginList;
    private Login m_currentLogin;

    public LoginProperty(CMetadata object, AssociationProperty metaProp, int viewType) {
        super(object, (AbstractProperty)metaProp, viewType);
    }

    @Override
    protected void initialize() {
        try {
            String desc;
            boolean enabled = this.m_metaProp.getIsUpdateable() != 0;
            this.m_propName = this.m_name;
            this.m_loginList = new Vector<Login>();
            this.m_label.setEnabled(enabled);
            this.m_type = 2003;
            this.m_data = new JComboBox();
            this.m_data.setEnabled(enabled);
            ((JComboBox)this.m_data).setRenderer(new MetadataObjectCellRenderer());
            ((JComboBox)this.m_data).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    LoginProperty.this.onMoreLogins(evt);
                }
            });
            this.addPersistedPropertyEventListener(new DefaultPropertyListener(){

                @Override
                public void readProperty(IOMProperty.PersistedPropertyEvent evt) {
                    IOMProperty iomProp = evt.getProperty();
                    Root parent = (Root)iomProp.getParentObject();
                    try {
                        AssociationProperty assocProp = (AssociationProperty)iomProp.getMetadataProperty();
                        String strMethod = "get" + assocProp.getAssociationName();
                        Method method = parent.getClass().getMethod(strMethod, new Class[0]);
                        AssociationList objList = (AssociationList)method.invoke((Object)parent, new Object[0]);
                        for (int i = 0; i < objList.size(); ++i) {
                            if (!(objList.get(i) instanceof Login)) continue;
                            LoginProperty.this.m_currentLogin = (Login)objList.get(i);
                            LoginProperty.this.m_loginList.add(LoginProperty.this.m_currentLogin);
                        }
                        Class<?> metaType = Class.forName("com.sas.metadata.remote.impl." + assocProp.getMetadataType() + "Impl");
                        for (int i = 0; i < objList.size(); ++i) {
                            if (!objList.get(i).getClass().equals(metaType)) continue;
                            iomProp.setPropertyValue(objList.get(i));
                            break;
                        }
                    }
                    catch (SecurityException assocProp) {
                    }
                    catch (NoSuchMethodException assocProp) {
                    }
                    catch (IllegalArgumentException assocProp) {
                    }
                    catch (IllegalAccessException assocProp) {
                    }
                    catch (InvocationTargetException assocProp) {
                    }
                    catch (ClassNotFoundException assocProp) {
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                    LoginProperty.this.getLogins();
                    if (LoginProperty.this.m_currentLogin != null) {
                        ((JComboBox)LoginProperty.this.m_data).setSelectedItem(LoginProperty.this.m_currentLogin);
                    }
                }
            });
            if (this.m_metaProp.getDesc().trim().length() > 0 && (desc = IOMProperty.getDisplayString(1, this.m_metaProp.getDesc())) != null) {
                this.m_data.setToolTipText(desc);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void getLogins() {
        try {
            Vector<String> mruList = new Vector<String>(3);
            for (int i = 1; i < 4; ++i) {
                String strMruDomain = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Domain." + String.valueOf(i));
                String strMruLogin = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Login." + String.valueOf(i));
                if (strMruDomain.length() <= 0 || strMruLogin.length() <= 0) continue;
                mruList.add(strMruDomain);
                mruList.add(strMruLogin);
            }
            String strTemplate = "<TEMPLATES><Login><Domain/></Login></TEMPLATES>";
            int flags = 8604;
            for (int mruIndex = 0; mruIndex < mruList.size(); mruIndex += 2) {
                String strDomain = ((String)mruList.get(mruIndex)).trim();
                String strLogin = (String)mruList.get(mruIndex + 1);
                String strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "'][Domain/AuthenticationDomain[@Name='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strDomain) + "']]\" />";
                if (strDomain.length() == 0) {
                    strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "']\" />";
                }
                String strOptions = strTemplate + strXMLSelect;
                try {
                    List loginList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_object.getObjectStore(), "A0000001." + this.m_object.getFQID().substring(0, 8), "Login", flags, strOptions);
                    for (int loginIndex = 0; loginIndex < loginList.size(); ++loginIndex) {
                        Login login = (Login)loginList.get(loginIndex);
                        if (this.m_loginList.contains(login)) continue;
                        this.m_loginList.add(login);
                    }
                    continue;
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            this.populateLogins();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void onMoreLogins(ItemEvent evt) {
        try {
            String strObj;
            if (evt.getStateChange() != 1) {
                return;
            }
            Object obj = evt.getItem();
            if (obj instanceof String && (strObj = (String)obj).equalsIgnoreCase(LoginProperty.getDisplayString(1, "Logins.Options.MoreLogins.Title.xmlKey.txt"))) {
                LoginSearchModel model = new LoginSearchModel(Workspace.getWorkspace().getCMRHandle(), (MdObjectStore)this.m_object.getObjectStore(), "A0000001." + this.m_object.getFQID().substring(0, 8));
                if (this.m_currentLogin != null) {
                    model.setUserID(this.m_currentLogin.getUserID());
                }
                LoginSearchPanel panel = new LoginSearchPanel(model);
                Container parent = this.m_data.getTopLevelAncestor();
                WAStandardDialog dialog = null;
                if (parent instanceof JFrame) {
                    dialog = new WAStandardDialog((Frame)((JFrame)parent));
                }
                if (parent instanceof Dialog) {
                    dialog = new WAStandardDialog((Dialog)parent);
                }
                dialog.setModal(true);
                dialog.setTitle(LoginProperty.getDisplayString(1, "Logins.SearchPanel.Title.xmlKey.txt"));
                dialog.setMainPanel((WAPanel)panel);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    List resultsList = model.getResults();
                    if (resultsList.size() > 0) {
                        Login resultLogin = (Login)resultsList.get(0);
                        if (resultLogin != this.m_currentLogin && !this.m_loginList.contains(resultLogin)) {
                            this.m_loginList.add(resultLogin);
                            this.populateLogins();
                        }
                        ((JComboBox)this.m_data).setSelectedItem(resultLogin);
                    }
                } else if (this.m_currentLogin != null) {
                    ((JComboBox)this.m_data).setSelectedItem(this.m_currentLogin);
                } else {
                    ((JComboBox)this.m_data).setSelectedIndex(0);
                }
                model.dispose();
                model = null;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void populateLogins() {
        JComboBox loginChoice = (JComboBox)this.m_data;
        loginChoice.removeAllItems();
        loginChoice.addItem(LoginProperty.getDisplayString(1, "Server.Common.Property.Value.None.xmlKey.txt"));
        loginChoice.setSelectedItem(LoginProperty.getDisplayString(1, "Server.Common.Property.Value.None.xmlKey.txt"));
        if (null != this.m_loginList) {
            for (int i = 0; i < this.m_loginList.size(); ++i) {
                loginChoice.addItem(this.m_loginList.get(i));
            }
        }
        loginChoice.addItem(LoginProperty.getDisplayString(1, "Logins.Options.MoreLogins.Title.xmlKey.txt"));
    }

    @Override
    public Object getDataValue() {
        if (this.m_data instanceof JComboBox) {
            return ((JComboBox)this.m_data).getSelectedItem();
        }
        return null;
    }

    @Override
    public String toString() {
        if (!this.m_visible) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(((JLabel)this.m_label).getText());
        strBuffer.append("\n\t");
        try {
            Object obj = this.getDataValue();
            if (obj != null) {
                if (obj instanceof Login) {
                    Login login = (Login)obj;
                    strBuffer.append(login.getUserID());
                } else {
                    strBuffer.append(obj.toString());
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        strBuffer.append("\n");
        return strBuffer.toString();
    }

    @Override
    protected void updateProperty() {
    }
}

