/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMServerPropertiesCustomizer;
import java.rmi.RemoteException;
import java.util.List;

public class LBServerPropertiesCustomizer
extends IOMServerPropertiesCustomizer {
    private static final long serialVersionUID = 1L;

    public LBServerPropertiesCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    @Override
    protected boolean showProperty(Root lsobj, String role) {
        if (role.length() == 0) {
            return true;
        }
        List pairs = this.parseRoleAttribute(role);
        String type = (String)pairs.get(0);
        String transRole = "Load Balancing";
        String alg = "tklbcost";
        if (lsobj != null) {
            if (!(lsobj instanceof Transformation)) {
                return false;
            }
            try {
                AssociationList properties = lsobj.getProperties();
                alg = null;
                for (int i = 0; i < properties.size(); ++i) {
                    if (!((Property)properties.get(i)).getPropertyName().equals("BalancingAlgorithm")) continue;
                    alg = ((Property)properties.get(i)).getDefaultValue();
                    break;
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return false;
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        if (!transRole.equals(type)) {
            return false;
        }
        if (pairs.size() > 1) {
            String name = (String)pairs.get(1);
            String value = (String)pairs.get(2);
            if (!name.equals("BalancingAlgorithm") || !value.equals(alg)) {
                return false;
            }
        }
        return true;
    }
}

