/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.impl.RootImpl;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.TitledSeparator;
import com.sas.workspace.mgmt.visuals.customizers.iom.CustomIOMServersLoginView;
import com.sas.workspace.mgmt.visuals.customizers.iom.DefaultPropertyListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IOMProperty {
    protected JComponent m_data;
    private boolean m_created;
    private boolean m_deleted;
    protected IOMPropertyValue m_currValue;
    protected IOMPropertyValue m_initValue;
    protected JComponent m_label;
    private EventListenerList m_listenerList = new EventListenerList();
    private final EventListenerList m_validateList = new EventListenerList();
    protected AbstractProperty m_metaProp;
    private int m_metaType;
    private int m_multi = 1;
    protected String m_name;
    protected CMetadata m_object;
    protected Property m_prop;
    protected String m_propName;
    protected String m_pTypeName;
    protected int m_required;
    protected TitledSeparator m_sep;
    protected int m_type;
    protected boolean m_useLabel;
    private boolean m_valid;
    protected List<IOMPropertyValue> m_values;
    protected int m_viewType;
    protected boolean m_visible;
    protected String m_finName;
    private PropertyType m_pType;
    private int m_verInfoMajor;
    private int m_verInfoMinor;
    private VersionOperations m_verInfoOperation;
    private VersionActions m_verInfoAction;
    private int m_objMajor;
    private int m_objMinor;
    private boolean m_hasVersionedData;
    protected static final WAdminResource m_tempBundle = new WAdminResource("com.sas.svcs.metadata.mgmt.impl.repository.data.ResourceTemplates.Resources");
    protected static final WAdminResource m_custBundle = new WAdminResource("com.sas.workspace.mgmt.visuals.customizers.iom.PropertyBundle");
    public static final int METATYPE_PROPERTY = 0;
    public static final int METATYPE_ATTRIBUTE = 1;
    public static final int METATYPE_ASSOCIATION = 2;
    protected static final int VERTICAL_GAP = 12;
    protected static final int HORIZONTAL_GAP = 12;
    protected static final int INDENT_GAP = 12;
    public static final int XMLTYPE_UNKNOWN = 0;
    public static final int XMLTYPE_ENUMERATION = 1;
    public static final int XMLTYPE_DEFAULTVALUE = 2;
    public static final int XMLTYPE_METADATAREQUEST = 3;
    public static final int XMLTYPE_CLASSPARAMETERS = 4;
    public static final int RESOURCETYPE_CUSTOMIZER = 0;
    public static final int RESOURCETYPE_TEMPLATE = 1;

    public IOMProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
        try {
            this.m_object = object;
            this.m_metaProp = metaProp;
            this.m_viewType = viewType;
            this.m_name = IOMProperty.getDisplayString(1, metaProp.getName());
            this.m_finName = IOMProperty.getFinishStringName(1, metaProp.getName());
            this.m_visible = metaProp.getIsVisible() != 0;
            this.m_label = new JLabel(this.m_name + ":");
            this.m_values = new Vector<IOMPropertyValue>();
            this.m_useLabel = true;
            this.m_valid = true;
            this.m_required = metaProp.getIsRequired();
            this.m_deleted = false;
            this.m_created = false;
            if (metaProp instanceof AssociationProperty) {
                this.m_metaType = 2;
            } else if (metaProp instanceof AttributeProperty) {
                this.m_metaType = 1;
            } else if (metaProp instanceof Property) {
                this.m_metaType = 0;
            }
            this.initialize();
            this.processProperites();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void addDivider() {
        this.addDivider(this.m_name);
    }

    public void addDivider(String name) {
        this.m_sep = new TitledSeparator(name);
    }

    public void addItemListener(ItemListener listener) {
        if (this.m_data instanceof JComboBox) {
            ((JComboBox)this.m_data).addItemListener(listener);
        } else if (this.m_data instanceof JCheckBox) {
            ((JCheckBox)this.m_data).addItemListener(listener);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void addPersistedPropertyEventListener(PersistedPropertyEventListener listener) {
        this.m_listenerList.add(PersistedPropertyEventListener.class, listener);
    }

    public void addPropertyToPanel(JPanel panel) {
        try {
            GridBagConstraints gbc;
            if (!this.m_visible) {
                return;
            }
            int gridx = 0;
            int gridy = IOMProperty.getNextComponentHorizontalGridValue(panel);
            GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
            if (this.m_sep != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = gridx;
                gbc.gridy = gridy++;
                gbc.anchor = 17;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.insets = new Insets(0, 0, 12, 12);
                gbLayout.setConstraints(this.m_sep, gbc);
                panel.add(this.m_sep);
            }
            switch (this.m_type) {
                case 4: 
                case 8: 
                case 12: 
                case 2003: {
                    if (this.m_useLabel) {
                        ((JLabel)this.m_label).setLabelFor(this.m_data);
                        IOMProperty.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                        gbc = new GridBagConstraints();
                        gbc.gridx = gridx++;
                        gbc.gridy = gridy;
                        gbc.anchor = 17;
                        gbc.insets = new Insets(0, 12, 12, 0);
                        gbLayout.setConstraints(this.m_label, gbc);
                        panel.add(this.m_label);
                    }
                    gbc = new GridBagConstraints();
                    gbc.gridx = gridx;
                    gbc.gridy = gridy;
                    gbc.anchor = 17;
                    gbc.weightx = 1.0;
                    gbc.fill = 2;
                    gbc.gridwidth = 0;
                    gbc.insets = new Insets(0, 12, 12, 12);
                    if (this.m_data instanceof WATextArea) {
                        JScrollPane scrPane = new JScrollPane(this.m_data);
                        scrPane.setPreferredSize(new Dimension(200, 45));
                        gbLayout.setConstraints(scrPane, gbc);
                        panel.add(scrPane);
                        break;
                    }
                    gbLayout.setConstraints(this.m_data, gbc);
                    panel.add(this.m_data);
                    break;
                }
                case -7: 
                case 16: {
                    IOMProperty.setMnemonic(this.m_data, 1, this.m_metaProp.getName());
                    gbc = new GridBagConstraints();
                    gbc.gridx = gridx;
                    gbc.gridy = gridy;
                    gbc.weightx = 1.0;
                    gbc.fill = 2;
                    gbc.gridwidth = 0;
                    gbc.insets = new Insets(0, 6, 12, 12);
                    gbLayout.setConstraints(this.m_data, gbc);
                    panel.add(this.m_data);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void addPropertyValidationEventListener(PropertyValidationEventListener listener) {
        this.m_validateList.add(PropertyValidationEventListener.class, listener);
    }

    public Property createNewProperty() {
        try {
            this.m_prop = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_object.getObjectStore(), null, this.m_name, "Property", this.m_object.getRepositoryID(), null);
            this.m_prop.setPropertyName(this.m_propName);
            switch (this.m_type) {
                case 4: 
                case 8: 
                case 12: {
                    ((JTextComponent)this.m_data).setText(this.m_currValue.toString());
                    this.m_prop.setDefaultValue(this.m_currValue.getMetaValue().toString());
                    this.m_prop.setOwningType(this.createPropertyType());
                    break;
                }
                case -7: 
                case 16: {
                    if (this.m_currValue.equals("True")) {
                        ((JCheckBox)this.m_data).setSelected(true);
                        this.m_prop.setDefaultValue("True");
                    } else {
                        ((JCheckBox)this.m_data).setSelected(false);
                        this.m_prop.setDefaultValue("False");
                    }
                    this.m_prop.setOwningType(this.createPropertyType());
                    break;
                }
                case 2003: {
                    if (this.m_data instanceof JComboBox) {
                        ((JComboBox)this.m_data).setSelectedItem(this.m_currValue);
                    }
                    this.m_prop.setDefaultValue(this.m_currValue.getMetaValue().toString());
                    this.m_prop.setOwningType(this.createPropertyType());
                }
            }
            this.m_prop.setIsExpert(this.m_metaProp.getIsExpert());
            this.m_prop.setIsLinked(this.m_metaProp.getIsLinked());
            this.m_prop.setIsRequired(this.m_metaProp.getIsRequired());
            this.m_prop.setIsUpdateable(this.m_metaProp.getIsUpdateable());
            this.m_prop.setIsVisible(this.m_metaProp.getIsVisible());
            if (this.m_deleted) {
                this.m_deleted = false;
            }
            this.m_created = true;
            return this.m_prop;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public static PropertyType createStringPropertyType(CMetadata object) {
        return IOMProperty._createPropertyType(object, "String", 12);
    }

    private PropertyType createPropertyType() {
        this.m_pType = IOMProperty._createPropertyType(this.m_object, this.m_pTypeName, this.m_type);
        return this.m_pType;
    }

    private static PropertyType _createPropertyType(CMetadata object, String name, int type) {
        try {
            PropertyType pType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)object.getObjectStore(), null, name, "PropertyType", object.getRepositoryID(), null);
            pType.setSQLType(type);
            return pType;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void deleteProperty() {
        this.fireDeletePropertyEvent(new PersistedPropertyEvent(this));
    }

    public void removePropertyFromStore() {
        try {
            ((MdObjectStore)this.m_object.getObjectStore()).removeElementFromStore((CMetadata)this.m_prop);
            this.m_prop = null;
            ((MdObjectStore)this.m_object.getObjectStore()).removeElementFromStore((CMetadata)this.m_pType);
            this.m_pType = null;
            this.m_deleted = true;
            this.m_created = false;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void fireDeletePropertyEvent(PersistedPropertyEvent evt) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PersistedPropertyEventListener.class) continue;
            ((PersistedPropertyEventListener)listeners[i + 1]).deleteProperty(evt);
        }
    }

    protected void fireReadPropertyEvent(PersistedPropertyEvent evt) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PersistedPropertyEventListener.class) continue;
            ((PersistedPropertyEventListener)listeners[i + 1]).readProperty(evt);
        }
    }

    protected void fireValidatePropertyEvent(PersistedPropertyEvent evt) {
        Object[] listeners = this.m_validateList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PropertyValidationEventListener.class) continue;
            ((PropertyValidationEventListener)listeners[i + 1]).validateProperty(evt);
        }
    }

    protected void fireWritePropertyEvent(PersistedPropertyEvent evt) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PersistedPropertyEventListener.class) continue;
            ((PersistedPropertyEventListener)listeners[i + 1]).writeProperty(evt);
        }
    }

    private List<Object> getConfigurationXMLTypes(Document xmlDoc) {
        Node node = xmlDoc.getChildNodes().item(0);
        Vector<Object> list = new Vector<Object>();
        if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("Configuration")) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String type = children.item(i).getNodeName();
                if (type.equalsIgnoreCase("Enumeration")) {
                    list.add(new Integer(1));
                } else if (type.equalsIgnoreCase("DefaultValue")) {
                    list.add(new Integer(2));
                } else if (type.equalsIgnoreCase("MetadataRequest")) {
                    list.add(new Integer(3));
                } else if (type.equalsIgnoreCase("ClassParameters")) {
                    list.add(new Integer(4));
                } else {
                    list.add(new Integer(0));
                }
                list.add(children.item(i));
            }
        }
        return list;
    }

    public JComponent getData() {
        return this.m_data;
    }

    public Object getDataValue() {
        switch (this.m_type) {
            case 4: 
            case 8: 
            case 12: {
                if (!(this.m_data instanceof JTextComponent)) break;
                boolean found = false;
                String text = ((JTextComponent)this.m_data).getText().trim();
                for (int i = 0; this.m_values != null && i < this.m_values.size(); ++i) {
                    if (!this.m_values.get(i).equals(text)) continue;
                    this.m_currValue = this.m_values.get(i);
                    found = true;
                }
                if (!found) {
                    this.m_currValue = new IOMPropertyValue(text);
                }
                if (this.m_type == 4 && text != null && text.length() > 0) {
                    Integer intValue = new Integer(text);
                    intValue = new Integer(intValue * this.m_multi);
                    this.m_currValue = new IOMPropertyValue(intValue.toString());
                }
                return this.m_currValue.getMetaValue();
            }
            case -7: 
            case 16: {
                if (((JCheckBox)this.m_data).isSelected()) {
                    return "True";
                }
                return "False";
            }
            case 2003: {
                if (!(this.m_data instanceof JComboBox)) break;
                Object selected = ((JComboBox)this.m_data).getSelectedItem();
                if (selected instanceof IOMPropertyValue) {
                    return ((IOMPropertyValue)selected).getMetaValue();
                }
                return selected;
            }
        }
        return null;
    }

    public static String getDisplayString(int resType, String value) {
        String display = IOMProperty.getStringFromBundle(resType, value);
        if (display == null) {
            return value;
        }
        display = Util.getLabelWithoutMnemonic((String)display);
        return display;
    }

    public void setEffectiveObjectVersion(int major, int minor) {
        this.m_objMajor = major;
        this.m_objMinor = minor;
    }

    public static String getFinishStringName(int resType, String value) {
        String display = IOMProperty.getStringFromBundle(resType, value);
        if (display == null) {
            return value;
        }
        display = Util.getDisplayLabel((String)display);
        return display;
    }

    private static GridBagConstraints getLastComponentRestraints(JPanel panel) {
        GridBagConstraints gbc = null;
        Component[] loaded = panel.getComponents();
        if (loaded.length != 0) {
            Component last = loaded[loaded.length - 1];
            gbc = ((GridBagLayout)panel.getLayout()).getConstraints(last);
        }
        return gbc;
    }

    public AbstractProperty getMetadataProperty() {
        return this.m_metaProp;
    }

    public int getMetadataPropertyType() {
        return this.m_metaType;
    }

    public static int getNextComponentHorizontalGridValue(JPanel panel) {
        GridBagConstraints gbc = IOMProperty.getLastComponentRestraints(panel);
        if (gbc == null) {
            return 0;
        }
        return gbc.gridy + 1;
    }

    public CMetadata getParentObject() {
        return this.m_object;
    }

    public int getPersistedPropertyEventListenerCount() {
        return this.m_listenerList.getListenerCount();
    }

    public Object[] getPersistedPropertyEventListenerList() {
        return this.m_listenerList.getListenerList();
    }

    public Property getProperty() {
        return this.m_prop;
    }

    public String getPropertyName() {
        return this.m_propName;
    }

    private static String getStringFromBundle(int resType, String key) {
        if (key != null && key.length() > 0 && key.indexOf(".xmlKey") > -1) {
            if (resType == 0) {
                return m_custBundle.getString(key);
            }
            if (resType == 1) {
                return m_tempBundle.getString(key);
            }
        }
        return null;
    }

    public boolean hasBeenCreated() {
        return this.m_created;
    }

    public boolean hasBeenDeleted() {
        return this.m_deleted;
    }

    protected void initialize() {
        try {
            String desc;
            boolean enabled = this.m_metaProp.getIsUpdateable() != 0;
            TextStore storedText = null;
            String defValue = "";
            if (this.m_metaProp instanceof Property) {
                Property prop = (Property)this.m_metaProp;
                this.m_propName = IOMProperty.getDisplayString(1, prop.getPropertyName());
                this.m_type = prop.getOwningType().getSQLType();
                this.m_pTypeName = prop.getOwningType().getName();
                storedText = (TextStore)prop.getOwningType().getStoredConfiguration();
                defValue = IOMProperty.getDisplayString(1, prop.getDefaultValue());
            } else if (this.m_metaProp instanceof AttributeProperty) {
                AttributeProperty attrProp = (AttributeProperty)this.m_metaProp;
                this.m_propName = IOMProperty.getDisplayString(1, attrProp.getPropertyName());
                this.m_type = attrProp.getOwningType().getSQLType();
                storedText = (TextStore)attrProp.getOwningType().getStoredConfiguration();
                defValue = IOMProperty.getDisplayString(1, attrProp.getDefaultValue());
            } else if (this.m_metaProp instanceof AssociationProperty) {
                AssociationProperty assocProp = (AssociationProperty)this.m_metaProp;
                this.m_propName = this.m_name;
                storedText = (TextStore)assocProp.getStoredConfiguration();
            }
            if (storedText != null) {
                this.m_values = this.processPropertyType(this.m_metaProp, storedText);
                for (int i = 0; i < this.m_values.size(); ++i) {
                    if (!this.m_values.get(i).equals(defValue)) continue;
                    this.m_currValue = this.m_values.get(i);
                    break;
                }
            }
            if (this.m_currValue == null) {
                this.m_currValue = new IOMPropertyValue(defValue);
            }
            this.m_initValue = this.m_currValue;
            this.processMultiplier();
            switch (this.m_type) {
                case 4: 
                case 8: 
                case 12: {
                    if (this.m_propName.equalsIgnoreCase("Command")) {
                        WATextArea data = new WATextArea(this.m_initValue.toString(), 3, 1);
                        data.setFont(new Font("Tahoma", 0, 11));
                        data.setLineWrap(true);
                        data.setWrapStyleWord(true);
                        this.m_data = data;
                    } else {
                        this.m_data = new WATextField(this.m_initValue.toString(), 1);
                    }
                    if (this.m_metaProp instanceof AttributeProperty) {
                        try {
                            String strMethod = "get" + ((AttributeProperty)this.m_metaProp).getPropertyName() + "MaxLength";
                            Object[] args = new Object[]{};
                            Class[] classes = new Class[]{};
                            Method method = this.m_object.getClass().getMethod(strMethod, classes);
                            try {
                                int maxLength = Integer.MAX_VALUE;
                                Object obj = method.invoke((Object)this.m_object, args);
                                if (obj instanceof Integer) {
                                    maxLength = (Integer)obj;
                                } else if (obj.getClass() == Integer.TYPE) {
                                    maxLength = Integer.valueOf(String.valueOf(obj));
                                }
                                if (this.m_data instanceof WATextField) {
                                    ((WATextField)this.m_data).setMaxCharacters(maxLength);
                                } else if (this.m_data instanceof WATextArea) {
                                    ((WATextArea)this.m_data).setMaxCharacters(maxLength);
                                }
                            }
                            catch (InvocationTargetException invocationTargetException) {
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        catch (NoSuchMethodException strMethod) {
                            // empty catch block
                        }
                    }
                    this.processValidator();
                    break;
                }
                case 2003: {
                    Vector<Object> values = new Vector<Object>();
                    for (int i = 0; i < this.m_values.size(); ++i) {
                        if (this.m_values.get(i).getMetaValue() instanceof String) {
                            values.add(this.m_values.get(i));
                            continue;
                        }
                        values.add(this.m_values.get(i).getMetaValue());
                    }
                    this.m_data = new JComboBox<Object>(values.toArray());
                    ((JComboBox)this.m_data).setRenderer(new MetadataObjectCellRenderer());
                    break;
                }
                case -7: 
                case 16: {
                    this.m_data = new JCheckBox(this.m_name);
                    ((JCheckBox)this.m_data).setSelected(this.m_initValue.equals("True"));
                    break;
                }
                case 1111: {
                    this.m_data = new WATextField();
                    this.m_visible = false;
                    break;
                }
                default: {
                    throw new IllegalPropertyTypeException();
                }
            }
            this.m_label.setEnabled(enabled);
            this.m_data.setEnabled(enabled);
            if (this.m_metaProp.getDesc().trim().length() > 0 && (desc = IOMProperty.getDisplayString(1, this.m_metaProp.getDesc())) != null) {
                this.m_data.setToolTipText(desc);
            }
            this.addPersistedPropertyEventListener(new DefaultPropertyListener());
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean isEnabled() {
        return this.m_data.isEnabled();
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    private String processDefaultValueXML(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int index = 0; index < children.getLength(); ++index) {
                    String value = this.processDefaultValueXML(children.item(index));
                    if (value == null) continue;
                    return value;
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equalsIgnoreCase("Value")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    return IOMProperty.getDisplayString(1, childNodeMap.getNamedItem("name").getNodeValue());
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int index = 0; index < children.getLength(); ++index) {
                    String value = this.processDefaultValueXML(children.item(index));
                    if (value == null) continue;
                    return value;
                }
                break;
            }
        }
        return null;
    }

    private void processEnumerationXML(Node node, List<IOMPropertyValue> valueList) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int index = 0; index < children.getLength(); ++index) {
                    this.processEnumerationXML(children.item(index), valueList);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equalsIgnoreCase("Value")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String versAttr = null;
                    String actAttr = null;
                    String userValue = "";
                    String nameAttr = childNodeMap.getNamedItem("name").getNodeValue();
                    Node subNode = childNodeMap.getNamedItem("version");
                    if (null != subNode) {
                        versAttr = subNode.getNodeValue();
                    }
                    if (null != (subNode = childNodeMap.getNamedItem("action"))) {
                        actAttr = subNode.getNodeValue();
                    }
                    if (versAttr != null) {
                        this.m_hasVersionedData = true;
                    }
                    NodeList children = node.getChildNodes();
                    for (int index = 0; index < children.getLength(); ++index) {
                        if (children.item(index).getNodeType() != 3) continue;
                        userValue = children.item(index).getNodeValue();
                    }
                    valueList.add(new IOMPropertyValue(IOMProperty.getDisplayString(1, userValue), IOMProperty.getDisplayString(1, nameAttr), versAttr, actAttr));
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int index = 0; index < children.getLength(); ++index) {
                    this.processEnumerationXML(children.item(index), valueList);
                }
                break;
            }
        }
    }

    private List<IOMPropertyValue> processMetadataRequestXML(String configXML) {
        try {
            String xmlReq = Server.getXMLTagStringValue(configXML, "MetadataRequest").trim();
            String reposID = "A0000001." + this.m_object.getRepositoryID();
            String type = Server.getXMLTagStringValue(xmlReq, "Type");
            String flags = Server.getXMLTagStringValue(xmlReq, "Flags");
            String options = Server.getXMLTagStringValue(xmlReq, "Options");
            List metaList = null;
            try {
                metaList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_object.getObjectStore(), reposID, type, Integer.parseInt(flags), options);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return null;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            Vector<IOMPropertyValue> valuesList = new Vector<IOMPropertyValue>();
            for (int i = 0; i < metaList.size(); ++i) {
                valuesList.add(new IOMPropertyValue(((RootImpl)metaList.get(i)).getName(), metaList.get(i)));
            }
            return valuesList;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private void processMultiplier() throws MdException, RemoteException {
        PropertyType ptype;
        switch (this.m_metaType) {
            case 1: {
                ptype = ((AttributeProperty)this.m_metaProp).getOwningType();
                break;
            }
            case 0: {
                ptype = ((Property)this.m_metaProp).getOwningType();
                break;
            }
            default: {
                return;
            }
        }
        if (ptype.getName().equals("Seconds")) {
            this.m_multi = 1000;
        } else if (ptype.getName().equals("Minutes")) {
            this.m_multi = 60000;
        }
        if (this.m_type == 4 && this.m_multi > 1) {
            this.m_currValue.m_userValue = Integer.toString(new Integer(this.m_currValue.m_userValue) / this.m_multi);
        }
    }

    private void processProperites() {
        String verInfo = null;
        boolean useReqVersion = false;
        try {
            AssociationList props = this.m_metaProp.getProperties();
            if (props.size() == 0) {
                return;
            }
            for (int i = 0; i < props.size(); ++i) {
                if (!((Property)props.get(i)).getPropertyName().equals("RequiredVersion")) continue;
                verInfo = ((Property)props.get(i)).getDefaultValue();
                useReqVersion = true;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        if (useReqVersion) {
            Pattern tokenRegEx = Pattern.compile("\\$");
            Pattern versionRegEx = Pattern.compile("VERSION(\\W*)(\\d)\\.(\\d)");
            Pattern actionRegEx = Pattern.compile("ACTION=(\\w*)");
            String[] keys = tokenRegEx.split(verInfo);
            for (int k = 0; k < keys.length; ++k) {
                Matcher matcher = versionRegEx.matcher(keys[k]);
                if (matcher.find()) {
                    this.m_verInfoOperation = VersionOperations.fromString(matcher.group(1));
                    this.m_verInfoMajor = Integer.parseInt(matcher.group(2));
                    this.m_verInfoMinor = Integer.parseInt(matcher.group(3));
                    continue;
                }
                matcher = actionRegEx.matcher(keys[k]);
                if (!matcher.find()) continue;
                this.m_verInfoAction = VersionActions.fromString(matcher.group(1));
            }
        }
    }

    private void processValidator() throws MdException, RemoteException {
        PropertyType ptype;
        switch (this.m_metaType) {
            case 1: {
                ptype = ((AttributeProperty)this.m_metaProp).getOwningType();
                break;
            }
            case 0: {
                ptype = ((Property)this.m_metaProp).getOwningType();
                break;
            }
            default: {
                return;
            }
        }
        if (ptype.getSQLType() == 4) {
            this.addPropertyValidationEventListener(new PropertyValidationEventListener(){

                @Override
                public void validateProperty(PersistedPropertyEvent evt) {
                    IOMProperty iomProp = evt.getProperty();
                    try {
                        Integer.parseInt(((JTextComponent)iomProp.m_data).getText());
                        iomProp.m_valid = true;
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(IOMProperty.this.m_data.getTopLevelAncestor(), MessageFormat.format(IOMProperty.getDisplayString(0, "PropertyValidator.Numeric.Error.Message.xmlKey.txt"), IOMProperty.this.m_name), IOMProperty.getDisplayString(0, "PropertyValidator.Numeric.Error.Title.xmlKey.txt"), 0);
                        iomProp.m_valid = false;
                    }
                }
            });
        } else if (ptype.getSQLType() == 8) {
            this.addPropertyValidationEventListener(new PropertyValidationEventListener(){

                @Override
                public void validateProperty(PersistedPropertyEvent evt) {
                    IOMProperty iomProp = evt.getProperty();
                    try {
                        Double.parseDouble(((JTextComponent)iomProp.m_data).getText());
                        iomProp.m_valid = true;
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(IOMProperty.this.m_data.getTopLevelAncestor(), MessageFormat.format(IOMProperty.getDisplayString(0, "PropertyValidator.Numeric.Error.Message.xmlKey.txt"), IOMProperty.this.m_name), IOMProperty.getDisplayString(0, "PropertyValidator.Numeric.Error.Title.xmlKey.txt"), 0);
                        iomProp.m_valid = false;
                    }
                }
            });
        }
        if (ptype.getName().equals("PositiveInt")) {
            this.addPropertyValidationEventListener(new PropertyValidationEventListener(){

                @Override
                public void validateProperty(PersistedPropertyEvent evt) {
                    IOMProperty iomProp = evt.getProperty();
                    if (!iomProp.m_valid) {
                        return;
                    }
                    if (Integer.parseInt(iomProp.getDataValue().toString()) < 0) {
                        JOptionPane.showMessageDialog(IOMProperty.this.m_data.getTopLevelAncestor(), MessageFormat.format(IOMProperty.getDisplayString(0, "PropertyValidator.PositiveInt.Error.Message.xmlKey.txt"), IOMProperty.this.m_name), IOMProperty.getDisplayString(0, "PropertyValidator.PositiveInt.Error.Title.xmlKey.txt"), 0);
                        iomProp.m_valid = false;
                    }
                }
            });
        }
    }

    public void processDataVersionAction() {
        try {
            if (this.m_objMajor == 0 || this.m_objMinor == 0) {
                if (!(this.m_object instanceof SoftwareComponent)) {
                    return;
                }
                this.m_objMajor = ((SoftwareComponent)this.m_object).getMajor();
                this.m_objMinor = ((SoftwareComponent)this.m_object).getMinor();
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return;
        }
        if (this.m_hasVersionedData) {
            block13: for (int i = 0; i < this.m_values.size(); ++i) {
                IOMPropertyValue propValue = this.m_values.get(i);
                if (propValue.m_verDataOperation == null) continue;
                boolean pass = false;
                switch (propValue.m_verDataOperation.ordinal()) {
                    case 0: {
                        if (this.m_objMajor != propValue.m_verDataMajor || this.m_objMinor != propValue.m_verDataMinor) break;
                        pass = true;
                        break;
                    }
                    case 3: {
                        if (this.m_objMajor > propValue.m_verDataMajor) {
                            pass = true;
                            break;
                        }
                        if (this.m_objMajor != propValue.m_verDataMajor || this.m_objMinor <= propValue.m_verDataMinor) break;
                        pass = true;
                        break;
                    }
                    case 2: {
                        if (this.m_objMajor > propValue.m_verDataMajor) {
                            pass = true;
                            break;
                        }
                        if (this.m_objMajor != propValue.m_verDataMajor || this.m_objMinor < propValue.m_verDataMinor) break;
                        pass = true;
                        break;
                    }
                    case 4: {
                        if (this.m_objMajor < propValue.m_verDataMajor) {
                            pass = true;
                            break;
                        }
                        if (this.m_objMajor != propValue.m_verDataMajor || this.m_objMinor >= propValue.m_verDataMinor) break;
                        pass = true;
                        break;
                    }
                    case 1: {
                        if (this.m_objMajor < propValue.m_verDataMajor) {
                            pass = true;
                            break;
                        }
                        if (this.m_objMajor != propValue.m_verDataMajor || this.m_objMinor > propValue.m_verDataMinor) break;
                        pass = true;
                    }
                }
                if (!pass) continue;
                switch (propValue.m_verDataAction.ordinal()) {
                    case 0: 
                    case 1: {
                        continue block13;
                    }
                    case 2: {
                        if (!(this.m_data instanceof JComboBox)) continue block13;
                        ((JComboBox)this.m_data).removeItem(propValue);
                    }
                }
            }
        }
    }

    public void processVersionAction() {
        if (this.m_verInfoAction != null) {
            try {
                if (this.m_objMajor == 0 || this.m_objMinor == 0) {
                    if (!(this.m_object instanceof SoftwareComponent)) {
                        return;
                    }
                    this.m_objMajor = ((SoftwareComponent)this.m_object).getMajor();
                    this.m_objMinor = ((SoftwareComponent)this.m_object).getMinor();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return;
            }
            boolean pass = false;
            switch (this.m_verInfoOperation.ordinal()) {
                case 0: {
                    if (this.m_objMajor != this.m_verInfoMajor || this.m_objMinor != this.m_verInfoMinor) break;
                    pass = true;
                    break;
                }
                case 3: {
                    if (this.m_objMajor > this.m_verInfoMajor) {
                        pass = true;
                        break;
                    }
                    if (this.m_objMajor != this.m_verInfoMajor || this.m_objMinor <= this.m_verInfoMinor) break;
                    pass = true;
                    break;
                }
                case 2: {
                    if (this.m_objMajor > this.m_verInfoMajor) {
                        pass = true;
                        break;
                    }
                    if (this.m_objMajor != this.m_verInfoMajor || this.m_objMinor < this.m_verInfoMinor) break;
                    pass = true;
                    break;
                }
                case 4: {
                    if (this.m_objMajor < this.m_verInfoMajor) {
                        pass = true;
                        break;
                    }
                    if (this.m_objMajor != this.m_verInfoMajor || this.m_objMinor >= this.m_verInfoMinor) break;
                    pass = true;
                    break;
                }
                case 1: {
                    if (this.m_objMajor < this.m_verInfoMajor) {
                        pass = true;
                        break;
                    }
                    if (this.m_objMajor != this.m_verInfoMajor || this.m_objMinor > this.m_verInfoMinor) break;
                    pass = true;
                }
            }
            if (pass) {
                switch (this.m_verInfoAction.ordinal()) {
                    case 0: {
                        this.setEnabled(false);
                        break;
                    }
                    case 1: {
                        this.setEnabled(true);
                        break;
                    }
                    case 2: {
                        this.setVisible(true);
                    }
                }
            }
        }
        if (this.m_hasVersionedData) {
            this.processDataVersionAction();
        }
    }

    private List<IOMPropertyValue> processPropertyType(AbstractProperty prop, TextStore storedText) throws MdException, RemoteException {
        Vector<IOMPropertyValue> values = new Vector<IOMPropertyValue>();
        if (prop instanceof AssociationProperty) {
            AssociationProperty assocProp = (AssociationProperty)prop;
            String noneString = IOMProperty.getDisplayString(1, "Server.Common.Property.Value.None.xmlKey.txt");
            if (assocProp.getMinimum() == 0) {
                values.add(new IOMPropertyValue(noneString, noneString));
            }
            if (this.m_required == 1) {
                this.addPropertyValidationEventListener(new PropertyValidationEventListener(){

                    @Override
                    public void validateProperty(PersistedPropertyEvent evt) {
                        IOMProperty iomProp = evt.getProperty();
                        String value = iomProp.getDataValue().toString();
                        if (iomProp.isEnabled() && value.equals(IOMProperty.getDisplayString(1, "Server.Common.Property.Value.None.xmlKey.txt"))) {
                            JOptionPane.showMessageDialog(IOMProperty.this.m_data.getTopLevelAncestor(), MessageFormat.format(IOMProperty.getDisplayString(0, "PropertyValidator.RequiredValue.Error.Message.xmlKey.txt"), IOMProperty.this.m_name), IOMProperty.getDisplayString(0, "PropertyValidator.RequiredValue.Error.Title.xmlKey.txt"), 0);
                            iomProp.m_valid = false;
                        } else {
                            iomProp.m_valid = true;
                        }
                    }
                });
            }
        }
        if (storedText.getTextRole().equalsIgnoreCase("config") && storedText.getTextType().equalsIgnoreCase("xml")) {
            Document xmlDoc = Workspace.getMdFactory().getOMIUtil().parseXML(storedText.getStoredText());
            List<Object> configs = this.getConfigurationXMLTypes(xmlDoc);
            switch ((Integer)configs.get(0)) {
                case 3: {
                    values.addAll(this.processMetadataRequestXML(storedText.getStoredText()));
                    this.m_type = 2003;
                    break;
                }
                case 1: {
                    Vector<IOMPropertyValue> valueList = new Vector<IOMPropertyValue>();
                    this.processEnumerationXML(xmlDoc, valueList);
                    values.addAll(valueList);
                    this.m_type = 2003;
                    break;
                }
                case 2: {
                    this.m_type = 12;
                    values.add(new IOMPropertyValue(this.processDefaultValueXML(xmlDoc)));
                    break;
                }
                default: {
                    this.m_type = 1111;
                }
            }
        }
        return values;
    }

    public void readProperty() {
        this.fireReadPropertyEvent(new PersistedPropertyEvent(this));
    }

    public void removeItemListener(ItemListener listener) {
        if (this.m_data instanceof JComboBox) {
            ((JComboBox)this.m_data).removeItemListener(listener);
        } else if (this.m_data instanceof JCheckBox) {
            ((JCheckBox)this.m_data).removeItemListener(listener);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removePersistedPropertyEventListener(PersistedPropertyEventListener listener) {
        this.m_listenerList.remove(PersistedPropertyEventListener.class, listener);
    }

    public void removeAllPersistedPropertyEventListeners() {
        this.m_listenerList = null;
        this.m_listenerList = new EventListenerList();
    }

    public void removePropertyFromPanel(JPanel panel) {
        if (!this.m_visible) {
            return;
        }
        if (this.m_sep != null) {
            panel.remove(this.m_sep);
        }
        switch (this.m_type) {
            case 4: 
            case 8: 
            case 12: 
            case 2003: {
                if (this.m_useLabel) {
                    panel.remove(this.m_label);
                }
            }
            case -7: 
            case 16: {
                panel.remove(this.m_data);
            }
        }
    }

    public void resetProperty() {
        switch (this.m_type) {
            case 4: 
            case 8: 
            case 12: {
                if (this.m_data instanceof JTextComponent) {
                    ((JTextComponent)this.m_data).setText(this.m_initValue.toString());
                }
            }
            case 2003: {
                if (!(this.m_data instanceof JComboBox)) break;
                ((JComboBox)this.m_data).setSelectedIndex(0);
                break;
            }
            case -7: 
            case 16: {
                ((JCheckBox)this.m_data).setSelected(this.m_initValue.equals("True"));
            }
        }
    }

    public void setDataColumns(int columns) {
        if (this.m_data instanceof WATextField) {
            ((WATextField)this.m_data).setColumns(columns);
        } else if (this.m_data instanceof WATextArea) {
            ((WATextArea)this.m_data).setColumns(columns);
        }
    }

    public void setEnabled(boolean enabled) {
        this.m_label.setEnabled(enabled);
        this.m_data.setEnabled(enabled);
    }

    public void setMinimumVersionInformation(int major, int minor) {
        this.m_objMajor = major;
        this.m_objMinor = minor;
    }

    public static void setMnemonic(JComponent comp, int resType, String key) {
        int mIndex;
        String value = IOMProperty.getStringFromBundle(resType, key);
        if (value != null && (mIndex = Util.getDisplayedMnemonicIndex((String)value)) > -1) {
            int mnem = Util.getDisplayedMnemonic((String)value);
            if (comp instanceof JLabel) {
                ((JLabel)comp).setDisplayedMnemonic(mnem);
                ((JLabel)comp).setDisplayedMnemonicIndex(mIndex);
            } else if (comp instanceof AbstractButton) {
                ((AbstractButton)comp).setMnemonic(mnem);
                ((AbstractButton)comp).setDisplayedMnemonicIndex(mIndex);
            } else if (comp instanceof CustomIOMServersLoginView) {
                ((CustomIOMServersLoginView)((Object)comp)).setMnemonic(mnem);
                ((CustomIOMServersLoginView)((Object)comp)).setDisplayedMnemonicIndex(mIndex);
            }
        }
    }

    public void setPreferredDataSize(Dimension size) {
        this.m_data.setPreferredSize(size);
    }

    public void setPreferredLabelSize(Dimension size) {
        if (this.m_label != null) {
            this.m_label.setPreferredSize(size);
        }
    }

    public void setPreferredDataWidth(int width) {
        this.m_data.setPreferredSize(new Dimension(width, this.m_data.getPreferredSize().height));
    }

    public void setProperty(Property prop) {
        this.m_prop = prop;
        try {
            String value = this.m_prop.getDefaultValue();
            IOMPropertyValue propValue = null;
            boolean found = false;
            for (int i = 0; this.m_values != null && i < this.m_values.size() && !found; ++i) {
                propValue = this.m_values.get(i);
                found = propValue.getMetaValue().equals(value);
            }
            if (found) {
                this.m_currValue = propValue;
                this.setPropertyValue(propValue);
            } else {
                this.setPropertyValue(value);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setPropertyValue(Object value) {
        if (this.m_metaType == 1 && value.toString().length() == 0) {
            value = this.m_initValue.getUserValue();
        }
        if (this.m_type == 4) {
            Integer intValue = new Integer(value.toString());
            value = Integer.toString(intValue / this.m_multi);
        }
        if (this.m_data instanceof JTextComponent) {
            ((JTextComponent)this.m_data).setText(value.toString());
            ((JTextComponent)this.m_data).setCaretPosition(0);
        } else if (this.m_data instanceof JComboBox) {
            ((JComboBox)this.m_data).setSelectedItem(value);
        } else if (this.m_data instanceof JCheckBox) {
            ((JCheckBox)this.m_data).setSelected(value.toString().equalsIgnoreCase("True"));
        }
    }

    public void setUseLabel(boolean use) {
        this.m_useLabel = use;
    }

    public void setValid(boolean valid) {
        this.m_valid = valid;
    }

    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public String toString() {
        if (!this.m_visible) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.m_finName);
        strBuffer.append("\n\t");
        if (this.m_data != null) {
            if (this.m_data instanceof JComboBox) {
                if (((JComboBox)this.m_data).getSelectedItem() != null) {
                    strBuffer.append(((JComboBox)this.m_data).getSelectedItem().toString());
                }
            } else if (this.m_data instanceof JCheckBox) {
                if (((JCheckBox)this.m_data).isSelected()) {
                    strBuffer.append(IOMProperty.getDisplayString(1, "Common.Property.Value.True.xmlKey.txt"));
                } else {
                    strBuffer.append(IOMProperty.getDisplayString(1, "Common.Property.Value.False.xmlKey.txt"));
                }
            } else if (this.m_data instanceof JTextComponent) {
                strBuffer.append(((JTextComponent)this.m_data).getText());
            }
        }
        strBuffer.append("\n");
        return strBuffer.toString();
    }

    protected void updateProperty() {
        try {
            Object value = this.getDataValue();
            if (this.m_prop == null) {
                boolean found = false;
                for (int i = 0; i < this.m_values.size() && !found; ++i) {
                    if (!this.m_values.get(i).equals(value)) continue;
                    this.m_currValue = this.m_values.get(i);
                    found = true;
                }
                if (!found) {
                    this.m_currValue.setUserValue(value.toString());
                }
            } else {
                String newValue;
                String currValue = this.m_prop.getDefaultValue();
                if (!currValue.equalsIgnoreCase(newValue = value instanceof IOMPropertyValue ? ((IOMPropertyValue)value).getMetaValue().toString() : value.toString())) {
                    this.m_prop.setDefaultValue(newValue);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void validateProperty() {
        this.fireValidatePropertyEvent(new PersistedPropertyEvent(this));
    }

    public void writeProperty() {
        this.updateProperty();
        if (this.m_required == 0) {
            try {
                if (this.m_currValue != null) {
                    if (this.m_prop == null && this.m_currValue.equals(this.m_initValue)) {
                        this.deleteProperty();
                        return;
                    }
                    if (this.m_prop != null && this.m_prop.getDefaultValue().equals(this.m_initValue.getMetaValue())) {
                        this.deleteProperty();
                        return;
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        this.fireWritePropertyEvent(new PersistedPropertyEvent(this));
    }

    public static interface PersistedPropertyEventListener
    extends EventListener {
        public void deleteProperty(PersistedPropertyEvent var1);

        public void readProperty(PersistedPropertyEvent var1);

        public void writeProperty(PersistedPropertyEvent var1);
    }

    public static interface PropertyValidationEventListener
    extends EventListener {
        public void validateProperty(PersistedPropertyEvent var1);
    }

    private class IOMPropertyValue {
        private Object m_metaValue;
        private String m_userValue;
        private int m_verDataMajor;
        private int m_verDataMinor;
        private VersionOperations m_verDataOperation;
        private VersionActions m_verDataAction;

        public IOMPropertyValue() {
            this("", null);
        }

        public IOMPropertyValue(String user) {
            this(user, null);
        }

        public IOMPropertyValue(String user, Object meta) {
            this(user, meta, null, null);
        }

        public IOMPropertyValue(String user, Object meta, String versAttr, String actAttr) {
            Pattern versionRegEx;
            Matcher matcher;
            this.m_userValue = user;
            this.m_metaValue = meta;
            if (versAttr != null && (matcher = (versionRegEx = Pattern.compile("(\\W*)(\\d)\\.(\\d)")).matcher(versAttr)).find()) {
                this.m_verDataOperation = VersionOperations.fromString(matcher.group(1));
                this.m_verDataMajor = Integer.parseInt(matcher.group(2));
                this.m_verDataMinor = Integer.parseInt(matcher.group(3));
                this.m_verDataAction = VersionActions.fromString(actAttr);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof IOMPropertyValue) {
                return super.equals(obj);
            }
            return this.m_metaValue != null && this.m_metaValue.equals(obj) || this.m_userValue.equals(obj);
        }

        public Object getMetaValue() {
            if (this.m_metaValue != null) {
                return this.m_metaValue;
            }
            return this.m_userValue;
        }

        public String getUserValue() {
            return this.m_userValue;
        }

        public void setMetaValue(Object value) {
            this.m_metaValue = value;
        }

        public void setUserValue(String value) {
            this.m_userValue = value;
        }

        public String toString() {
            try {
                if (this.m_metaValue == null && this.m_userValue == null) {
                    return "";
                }
                if (this.m_userValue == null) {
                    return ((RootImpl)this.m_metaValue).getName();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
            return this.m_userValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_metaValue == null ? 0 : this.m_metaValue.hashCode());
            result = 31 * result + (this.m_userValue == null ? 0 : this.m_userValue.hashCode());
            return result;
        }
    }

    public class PersistedPropertyEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final IOMProperty m_iomProp;

        public PersistedPropertyEvent(IOMProperty prop) {
            super(prop);
            this.m_iomProp = prop;
        }

        public IOMProperty getProperty() {
            return this.m_iomProp;
        }
    }

    public class IllegalPropertyTypeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public IllegalPropertyTypeException() {
        }

        public IllegalPropertyTypeException(String s) {
            super(s);
        }
    }

    static enum VersionOperations {
        EQUALS("="),
        LESSEQUALS("<="),
        GREATEREQUALS(">="),
        GREATER(">"),
        LESS("<");

        private String text;

        private VersionOperations(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static VersionOperations fromString(String text) {
            if (text != null) {
                for (VersionOperations x : VersionOperations.values()) {
                    if (!text.equalsIgnoreCase(x.getText())) continue;
                    return x;
                }
            }
            return null;
        }
    }

    static enum VersionActions {
        DISABLE("DISABLE"),
        ENABLE("ENABLE"),
        HIDE("HIDE");

        private String text;

        private VersionActions(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static VersionActions fromString(String text) {
            if (text != null) {
                for (VersionActions x : VersionActions.values()) {
                    if (!text.equalsIgnoreCase(x.getText())) continue;
                    return x;
                }
            }
            return null;
        }
    }
}

