/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.iom;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.customizers.iom.DefaultPropertyListener;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMCustomizer;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMProperty;
import com.sas.workspace.mgmt.visuals.customizers.iom.IOMPropertyList;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class FolderCustomizer
extends IOMCustomizer {
    private static final long serialVersionUID = 1L;
    private FolderLocationProperty m_propFold;

    public FolderCustomizer(Root root, List groupPropertiesList, int viewType) {
        super(root, groupPropertiesList, viewType);
    }

    @Override
    protected void initialize() {
        this.m_iomProps = new IOMPropertyList();
        for (int i = 0; i < this.m_propList.size(); ++i) {
            try {
                if (!(this.m_propList.get(i) instanceof Property) || !((Property)this.m_propList.get(i)).getPropertyName().equals("FolderLocation")) continue;
                this.m_propFold = new FolderLocationProperty((CMetadata)this.m_root, (AbstractProperty)this.m_propList.get(i), this.m_viewType);
                this.m_iomProps.add(this.m_propFold);
                continue;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected List getMessageQueues() {
        Vector list = new Vector();
        Container gparent = this.getParent().getParent();
        Component[] comps = gparent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof DualListSelector)) continue;
            DualListSelector dls = (DualListSelector)comps[i];
            ListModel model = dls.getTargetModel();
            for (int j = 0; j < model.getSize(); ++j) {
                list.add(model.getElementAt(j));
            }
            break;
        }
        return list;
    }

    public class FolderLocationProperty
    extends IOMProperty {
        JButton m_btnBrowse;
        Tree m_tree;
        PathUrl m_url;
        boolean m_newTree;
        boolean m_newMQFolder;
        boolean m_newSDFolder;

        private Tree createFolder(Root parent, String name) throws RemoteException, MdException {
            Tree tree = (Tree)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_object.getObjectStore(), null, name, "Tree", this.m_object.getRepositoryID(), null);
            tree.setTreeType("BIP Folder");
            tree.setPublicType("Folder");
            UsageVersion version = new UsageVersion(1, 0);
            tree.setUsageVersion(version.encode());
            if (parent instanceof Tree) {
                tree.setParentTree((Tree)parent);
            } else if (parent instanceof SoftwareComponent) {
                AssociationList comps = tree.getSoftwareComponents();
                comps.add((Object)parent);
                tree.setSoftwareComponents(comps);
            }
            return tree;
        }

        private String getRepositoryType() throws RemoteException, MdException {
            return Workspace.getMdFactory().getRepositoryUtil().getRepositoryType("A0000001." + this.m_object.getRepositoryID());
        }

        private Root getRootFolder() throws RemoteException, MdException {
            String type = this.getRepositoryType();
            int flags = 396;
            List objs = null;
            MdOMIUtil util = Workspace.getMdFactory().getOMIUtil();
            String reposID = "A0000001." + this.m_object.getRepositoryID();
            String template = "<XMLSelect search=\"*[@PublicType='RootFolder']\"/>";
            objs = util.getMetadataObjectsSubset(this.m_object.getObjectStore(), reposID, "SoftwareComponent", flags, template);
            if (objs != null && objs.size() > 0) {
                SoftwareComponent sc;
                SoftwareComponent retval = sc = (SoftwareComponent)objs.get(0);
                if (type.equalsIgnoreCase("CUSTOM")) {
                    AssociationList subtrees = sc.getSoftwareTrees();
                    for (int i = 0; i < subtrees.size(); ++i) {
                        Tree tree = (Tree)subtrees.get(i);
                        if (!tree.getRepositoryID().equals(this.m_object.getRepositoryID())) continue;
                        retval = tree;
                        break;
                    }
                }
                return retval;
            }
            return null;
        }

        private Tree getSubFolder(Root parent, String name) throws RemoteException, MdException {
            AssociationList subtrees = null;
            if (parent instanceof SoftwareComponent) {
                subtrees = ((SoftwareComponent)parent).getSoftwareTrees();
            } else if (parent instanceof Tree) {
                subtrees = ((Tree)parent).getSubTrees();
            }
            if (subtrees == null) {
                return null;
            }
            for (int i = 0; i < subtrees.size(); ++i) {
                if (!((Tree)subtrees.get(i)).getName().equals(name)) continue;
                return (Tree)subtrees.get(i);
            }
            return null;
        }

        private Tree getMessageQueueFolder() throws RemoteException, MdException {
            Root root = this.getRootFolder();
            Tree parent = this.getSubFolder(root, "Shared Data");
            if (null == parent) {
                parent = this.createFolder(root, "Shared Data");
            }
            this.m_newSDFolder = parent.isNewObject();
            Tree folder = this.getSubFolder((Root)parent, "Message Queues");
            if (null == folder) {
                folder = this.createFolder((Root)parent, "Message Queues");
            }
            this.m_newMQFolder = folder.isNewObject();
            return folder;
        }

        private String getFolderPath(Tree folder) throws RemoteException, MdException {
            StringBuffer path = new StringBuffer(folder.getName());
            for (Tree parent = folder.getParentTree(); parent != null; parent = parent.getParentTree()) {
                path.insert(0, parent.getName() + "/");
            }
            path.insert(0, "/");
            return path.toString();
        }

        public FolderLocationProperty(CMetadata object, AbstractProperty metaProp, int viewType) {
            super(object, metaProp, viewType);
            this.m_data.setEnabled(false);
            this.m_label.setEnabled(true);
            this.m_btnBrowse = WsUIUtilities.createTextButton((WsAbstractAction)new FolderLocationAction());
            this.addPropertyValidationEventListener(new IOMProperty.PropertyValidationEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void validateProperty(IOMProperty.PersistedPropertyEvent event) {
                    boolean ok = false;
                    try {
                        MdSecurityUtil secUtil = Workspace.getMdFactory().getSecurityUtil();
                        Tree folder = FolderLocationProperty.this.m_tree;
                        if (FolderLocationProperty.this.m_newTree) {
                            if (FolderLocationProperty.this.m_tree == null) {
                                FolderLocationProperty.this.m_tree = FolderLocationProperty.this.createFolder((Root)FolderLocationProperty.this.getMessageQueueFolder(), FolderCustomizer.this.m_root.getName());
                            }
                            if (FolderLocationProperty.this.m_newSDFolder) {
                                ok = true;
                            } else {
                                folder = FolderLocationProperty.this.m_tree.getParentTree();
                                if (FolderLocationProperty.this.m_newMQFolder) {
                                    folder = folder.getParentTree();
                                }
                            }
                        }
                        if (!ok) {
                            ok = secUtil.isFolderWriteAuthorized(folder.getFQID());
                        }
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                    catch (MdException ex) {
                        ok = false;
                    }
                    finally {
                        if (!ok) {
                            JOptionPane.showMessageDialog(FolderLocationProperty.this.m_data.getTopLevelAncestor(), IOMProperty.getDisplayString(0, "Folder.Access.Error.Message.xmlKey.txt"), IOMProperty.getDisplayString(0, "Folder.Access.Error.Title.xmlKey.txt"), 0);
                        }
                        event.getProperty().setValid(ok);
                    }
                }
            });
            this.addPersistedPropertyEventListener(new FolderLocationPropertyListener());
        }

        @Override
        public void addPropertyToPanel(JPanel panel) {
            try {
                if (!this.m_visible) {
                    return;
                }
                int gridx = 0;
                int gridy = FolderLocationProperty.getNextComponentHorizontalGridValue(panel);
                GridBagLayout gbLayout = (GridBagLayout)panel.getLayout();
                ((JLabel)this.m_label).setLabelFor(this.m_data);
                FolderLocationProperty.setMnemonic(this.m_label, 1, this.m_metaProp.getName());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.anchor = 17;
                gbc.insets = new Insets(12, 12, 12, 0);
                gbLayout.setConstraints(this.m_label, gbc);
                panel.add(this.m_label);
                gbc = new GridBagConstraints();
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.anchor = 17;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.insets = new Insets(12, 12, 12, 12);
                gbLayout.setConstraints(this.m_data, gbc);
                panel.add(this.m_data);
                gbc = new GridBagConstraints();
                gbc.gridx = gridx++;
                gbc.gridy = gridy;
                gbc.anchor = 17;
                gbc.insets = new Insets(12, 12, 12, 12);
                gbLayout.setConstraints(this.m_btnBrowse, gbc);
                panel.add(this.m_btnBrowse);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public class FolderLocationAction
        extends WsAbstractAction {
            private static final long serialVersionUID = 2258374313027733415L;

            public FolderLocationAction() {
                super(IOMProperty.m_tempBundle, "FolderLocation.Button.Name.xmlKey");
                FolderLocationProperty.this.m_newTree = false;
                FolderLocationProperty.this.m_newMQFolder = false;
                FolderLocationProperty.this.m_newSDFolder = false;
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    PathUrl url;
                    String path;
                    String initPath = path = FolderLocationProperty.super.getDataValue().toString();
                    if (FolderLocationProperty.this.m_newTree) {
                        path = path.substring(0, path.lastIndexOf(47));
                    }
                    if (FolderLocationProperty.this.m_newMQFolder) {
                        path = path.substring(0, path.lastIndexOf(47));
                    }
                    if ((url = WsMetadataUtil.promptForPathUrl((String)path, (boolean)false, null, (String)("A0000001." + FolderCustomizer.this.m_root.getRepositoryID()))) != null) {
                        FolderLocationProperty.super.setPropertyValue(url.getDisplayPath());
                        ServerInterface si = Workspace.getWorkspace().getUserContext().getAuthServer();
                        FolderInterface temp = (FolderInterface)si.getObjectByPath(url);
                        if (FolderLocationProperty.this.m_tree != null) {
                            if (!((Tree)temp.getRepositoryEntity()).getFQID().equals(FolderLocationProperty.this.m_tree.getFQID()) && FolderLocationProperty.this.m_newTree) {
                                FolderLocationProperty.this.m_tree.delete();
                                FolderLocationProperty.this.m_newTree = false;
                            }
                        } else if (FolderLocationProperty.this.m_newTree && !temp.getPath().equals(initPath)) {
                            FolderLocationProperty.this.m_newTree = false;
                        }
                        FolderLocationProperty.this.m_tree = (Tree)temp.getRepositoryEntity();
                    }
                }
                catch (ServiceException e1) {
                    return;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }

        public class FolderLocationPropertyListener
        extends DefaultPropertyListener {
            @Override
            public void readProperty(IOMProperty.PersistedPropertyEvent arg0) {
                try {
                    String foldPath = "";
                    Tree foldTree = WsMetadataUtil.getFolderForMetadata((Root)FolderCustomizer.this.m_root);
                    if (foldTree != null && !foldTree.getFQID().contains("$")) {
                        foldPath = WsMetadataUtil.getFolderLocationForMetadata((Root)FolderCustomizer.this.m_root);
                    }
                    if (foldPath.equals("")) {
                        Tree parent = FolderLocationProperty.this.getMessageQueueFolder();
                        String path = FolderLocationProperty.this.getFolderPath(parent) + "/" + FolderCustomizer.this.m_root.getName();
                        FolderLocationProperty.this.m_tree = FolderLocationProperty.this.getSubFolder((Root)parent, FolderCustomizer.this.m_root.getName());
                        if (FolderLocationProperty.this.m_tree == null || FolderLocationProperty.this.m_tree.getFQID().contains("$")) {
                            FolderLocationProperty.this.m_newTree = true;
                        }
                        FolderLocationProperty.this.setPropertyValue(path);
                    } else {
                        AssociationList trees = FolderCustomizer.this.m_root.getTrees();
                        for (int i = 0; i < trees.size(); ++i) {
                            Tree folder;
                            if (!(trees.get(i) instanceof Tree) || !(folder = (Tree)trees.get(i)).getPublicType().equals("Folder")) continue;
                            FolderLocationProperty.this.setPropertyValue(Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)FolderCustomizer.this.m_root.getObjectStore(), (PrimaryType)folder, false));
                            break;
                        }
                        FolderLocationProperty.this.m_url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)Workspace.getWorkspace().getUserContext().getAuthServer(), (String)(FolderLocationProperty.this.getDataValue().toString() + "(Folder)"));
                        FolderLocationProperty.this.m_tree = (Tree)Workspace.getWorkspace().getUserContext().getAuthServer().getObjectByPath(FolderLocationProperty.this.m_url).getRepositoryEntity();
                    }
                }
                catch (ServiceException e) {
                    Workspace.handleServiceException((ServiceException)e);
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
            }

            @Override
            public void writeProperty(IOMProperty.PersistedPropertyEvent arg0) {
                try {
                    this.updateTrees(FolderCustomizer.this.m_root, FolderLocationProperty.this.m_tree);
                    List queues = FolderCustomizer.this.getMessageQueues();
                    for (int i = 0; i < queues.size(); ++i) {
                        Transformation trans;
                        if (!(queues.get(i) instanceof Transformation) || !(trans = (Transformation)queues.get(i)).getTransformRole().equals("SASMessageQueue") && !trans.getTransformRole().equals("JMSDestination")) continue;
                        this.updateTrees((Root)queues.get(i), FolderLocationProperty.this.m_tree);
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
            }

            private void updateTrees(Root object, Tree foldTree) throws RemoteException, MdException {
                AssociationList trees = object.getTrees();
                boolean update = true;
                for (int i = 0; i < trees.size(); ++i) {
                    if (!(trees.get(i) instanceof Tree) || !((Tree)trees.get(i)).getPublicType().equals("Folder")) continue;
                    if (((Tree)trees.get(i)).getFQID().equalsIgnoreCase(foldTree.getFQID())) {
                        update = false;
                        break;
                    }
                    trees.remove(i);
                    break;
                }
                if (update) {
                    trees.add((Object)foldTree);
                    object.setTrees(trees);
                    if (FolderLocationProperty.this.m_newMQFolder && foldTree != null) {
                        String MQFolderPath = FolderLocationProperty.this.getFolderPath(FolderLocationProperty.this.getMessageQueueFolder());
                        String currPath = FolderLocationProperty.this.getFolderPath(foldTree);
                        if (!currPath.contains(MQFolderPath)) {
                            FolderLocationProperty.this.getMessageQueueFolder().delete();
                            FolderLocationProperty.this.m_newMQFolder = false;
                        }
                    }
                }
            }
        }
    }
}

