/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.hadoop;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstallLocPanel
extends WsDescriptionWizardTab {
    private SASClientConnection m_connection;
    private String m_strReposID;
    private List<Property> m_lstProperties;
    private int m_iViewType = -1;
    private String m_strName;
    private String m_strDefaultValue;
    private static final String INSTALL_PROPNAME = "INSTALL";
    private JLabel m_lblInstallLoc;
    private WATextField m_txtInstallLoc;
    protected static final WAdminResource m_bundle = new WAdminResource(InstallLocPanel.class);
    protected static final WAdminResource m_templBundle = new WAdminResource("com.sas.workspace.visuals.res.PropertyBundle");
    private static final long serialVersionUID = 1L;

    public InstallLocPanel(SASClientConnection connection, String reposID, List<Property> propertyList, int viewType) {
        this.m_connection = connection;
        this.m_strReposID = reposID;
        this.m_lstProperties = propertyList;
        this.m_iViewType = viewType;
        try {
            for (int index = 0; index < this.m_lstProperties.size(); ++index) {
                Property property = this.m_lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase(INSTALL_PROPNAME)) continue;
                this.m_strName = m_templBundle.getString(property.getName());
                this.m_strDefaultValue = property.getDefaultValue();
                break;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        if (this.m_strName == null && this.m_strDefaultValue == null) {
            this.m_strName = m_templBundle.getString("Connection.Hadoop.Property.InstallLocation.Desc.xmlKey.txt");
            this.m_strDefaultValue = "";
        }
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() {
        try {
            String strValue = this.m_txtInstallLoc.getText().trim();
            Property propPrototype = null;
            for (int index = 0; index < this.m_lstProperties.size(); ++index) {
                Property property = this.m_lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase(INSTALL_PROPNAME)) continue;
                propPrototype = property;
                break;
            }
            if (strValue.length() == 0) {
                AssociationList lstProperties = this.m_connection.getProperties();
                for (int index = 0; index < lstProperties.size(); ++index) {
                    Property property = (Property)lstProperties.get(index);
                    if (!property.getPropertyName().equalsIgnoreCase(INSTALL_PROPNAME)) continue;
                    this.m_connection.getProperties().remove((Object)property);
                    PrototypeUtil.deleteProperty(property);
                    break;
                }
                return;
            }
            boolean bPropertyFound = false;
            AssociationList lstProperties = this.m_connection.getProperties();
            for (int index = 0; index < lstProperties.size(); ++index) {
                Property property = (Property)lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase(INSTALL_PROPNAME)) continue;
                if (!strValue.equalsIgnoreCase(property.getDefaultValue())) {
                    property.setDefaultValue(strValue);
                }
                bPropertyFound = true;
                break;
            }
            if (!bPropertyFound) {
                Property property = PrototypeUtil.createProperty(propPrototype, (MdObjectStore)this.m_connection.getObjectStore(), this.m_strReposID);
                property.setDefaultValue(strValue);
                this.m_connection.getProperties().add((Object)property);
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void moveDataToView() {
        try {
            AssociationList lstProperties = this.m_connection.getProperties();
            for (int index = 0; index < lstProperties.size(); ++index) {
                Property property = (Property)lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase(INSTALL_PROPNAME)) continue;
                this.m_txtInstallLoc.setText(property.getDefaultValue());
                return;
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        if (this.m_iViewType == 0) {
            this.m_txtInstallLoc.setText(this.m_strDefaultValue);
        } else if (this.m_iViewType == 1) {
            this.m_txtInstallLoc.setText("");
        }
    }

    public String createFinishString() {
        if (this.m_txtInstallLoc.getText().trim().length() == 0) {
            return new String();
        }
        return this.m_strName + ":\n\t" + this.m_txtInstallLoc.getText().trim() + "\n";
    }

    protected void initialize() {
        this.m_lblInstallLoc = new JLabel(this.m_strName + ":");
        this.m_txtInstallLoc = new WATextField(20);
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_lblInstallLoc, gbc);
        this.add(this.m_lblInstallLoc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_txtInstallLoc, gbc);
        this.add((Component)this.m_txtInstallLoc);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

