/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.grid;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainDialog;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GridServerConnectionPanel
extends WsDescriptionWizardTab {
    TCPIPConnection m_connection;
    private List m_domainList;
    private AuthenticationDomain m_domain;
    private MdObjectStore m_objectStore = null;
    private JLabel m_lblAuthDomain;
    private JComboBox m_cbxAuthDomain;
    private JButton m_btnAuthDomain;
    private JLabel m_lblHost;
    private WATextField m_txtHost;
    private JLabel m_lblPort;
    private WATextField m_txtPort;
    private static final WAdminResource bundle = WAdminResource.getBundle(GridServerConnectionPanel.class);
    private static final long serialVersionUID = -830524542507057977L;

    public GridServerConnectionPanel(TCPIPConnection connection) {
        this.m_connection = connection;
        this.initialize();
        this.layoutWidgets();
    }

    public void populateStore() {
        int flags = 8456;
        try {
            this.m_domainList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_connection.getObjectStore(), this.getReposID(), "AuthenticationDomain", flags, "");
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void moveDataToView() throws RemoteException {
        try {
            this.m_cbxAuthDomain.addItem(bundle.getString("GridServerConnectionPanel.DefaultAuthDomain.txt"));
            this.m_cbxAuthDomain.setSelectedIndex(0);
            for (int domainIndex = 0; this.m_domainList != null && domainIndex < this.m_domainList.size(); ++domainIndex) {
                AuthenticationDomain domain = (AuthenticationDomain)this.m_domainList.get(domainIndex);
                this.m_cbxAuthDomain.addItem(domain);
            }
            try {
                if (this.m_connection.getDomain() != null) {
                    this.m_cbxAuthDomain.setSelectedItem(this.m_connection.getDomain());
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            this.m_connection.setApplicationProtocol(bundle.getString("GridServerConnectionPanel.ApplicationProtocol.txt"));
            this.m_connection.setCommunicationProtocol(bundle.getString("GridServerConnectionPanel.CommunicationProtocol.txt"));
            this.m_txtHost.setText(this.m_connection.getHostName());
            String strCurrentValue = String.valueOf(this.m_connection.getPort());
            this.m_txtPort.setText(strCurrentValue);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void moveDataToStore() throws RemoteException {
        this.setViewProperties();
    }

    public boolean validateData() {
        boolean bValidated = true;
        try {
            int port = Integer.valueOf(this.m_txtPort.getText().trim());
            if (port < 0 || port > 65535) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("GridServerConnectionPanel.Port.Integer.txt"), bundle.getString("Common.Error.txt"), 0);
                bValidated = false;
                return bValidated;
            }
            String host = this.m_txtHost.getText().trim();
            if (host.length() == 0) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("GridServerConnectionPanel.Host.Required.txt"), bundle.getString("Common.RequiredError.txt"), 0);
                bValidated = false;
                return bValidated;
            }
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("GridServerConnectionPanel.Port.Integer.txt"), bundle.getString("Common.Error.txt"), 0);
            bValidated = false;
            return bValidated;
        }
        return bValidated;
    }

    public String createFinishString() {
        String strFinish = "";
        strFinish = this.m_cbxAuthDomain.getSelectedItem().toString() == bundle.getString("GridServerConnectionPanel.DefaultAuthDomain.txt") || this.m_cbxAuthDomain.getSelectedItem().toString() == null ? bundle.getString("GridServerConnectionPanel.AuthenticationDomain.Label.txt") + "\n\t" + bundle.getString("GridServerConnectionPanel.DefaultAuthDomain.txt") + "\n" : bundle.getString("GridServerConnectionPanel.AuthenticationDomain.Label.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)((AuthenticationDomain)this.m_cbxAuthDomain.getSelectedItem())) + "\n";
        strFinish = strFinish + bundle.getString("GridServerConnectionPanel.GridServerAddress.Label.txt") + "\n\t" + this.m_txtHost.getText() + "\n";
        strFinish = strFinish + bundle.getString("GridServerConnectionPanel.GridserverPort.Label.txt") + "\n\t" + this.m_txtPort.getText() + "\n";
        return strFinish;
    }

    public void onNext() {
        this.setViewProperties();
    }

    public void onBack() {
        this.setViewProperties();
    }

    private void setViewProperties() {
        try {
            if (!this.m_cbxAuthDomain.getSelectedItem().toString().equalsIgnoreCase(bundle.getString("GridServerConnectionPanel.DefaultAuthDomain.txt")) && this.m_cbxAuthDomain.getSelectedItem().toString() != null) {
                this.m_connection.setDomain((AuthenticationDomain)this.m_cbxAuthDomain.getSelectedItem());
            } else {
                this.m_connection.setDomain(null);
            }
            if (this.m_cbxAuthDomain.getSelectedItem().toString() == null || this.m_cbxAuthDomain.getSelectedItem().toString() == bundle.getString("GridServerConnectionPanel.DefaultAuthDomain.txt")) {
                this.m_connection.setAuthenticationType(bundle.getString("GridServerConnectionPanel.AuthType1.txt"), 1);
            } else {
                this.m_connection.setAuthenticationType(bundle.getString("GridServerConnectionPanel.AuthType2.txt"), 1);
            }
            this.m_connection.setHostName(this.m_txtHost.getText().trim());
            this.m_connection.setPort(this.m_txtPort.getText().trim(), 1);
            this.m_connection.setApplicationProtocol(bundle.getString("GridServerConnectionPanel.ApplicationProtocol.txt"));
            this.m_connection.setCommunicationProtocol(bundle.getString("GridServerConnectionPanel.CommunicationProtocol.txt"));
            if (this.m_objectStore != null) {
                this.m_objectStore.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void onNewAuthDomain() {
        try {
            ViewListener viewListener = new ViewListener(this.m_cbxAuthDomain);
            Workspace.getMdFactory().addMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
            AuthenticationDomainDialog dialog = null;
            Container parent = this.getTopLevelAncestor();
            if (parent instanceof Dialog) {
                dialog = new AuthenticationDomainDialog((Dialog)parent, Workspace.getMdFactory().createObjectStore(), this.getReposID());
            } else if (parent instanceof Frame) {
                dialog = new AuthenticationDomainDialog((Frame)parent, Workspace.getMdFactory().createObjectStore(), this.getReposID());
            }
            if (dialog != null) {
                dialog.show();
                if (dialog.getReturnValue() == 2) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)viewListener);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    String getReposID() {
        try {
            return "A0000001." + this.m_connection.getFQID().substring(0, 8);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void initialize() {
        this.m_lblAuthDomain = new JLabel(bundle.getString("GridServerConnectionPanel.AuthenticationDomain.Label.txt"));
        this.m_cbxAuthDomain = new JComboBox();
        this.m_cbxAuthDomain.setRenderer(new MetadataObjectCellRenderer());
        this.m_btnAuthDomain = new JButton(bundle.getString("Common.New....txt"));
        this.m_btnAuthDomain.setMargin(new Insets(0, 4, 0, 4));
        this.m_btnAuthDomain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridServerConnectionPanel.this.onNewAuthDomain();
            }
        });
        this.m_lblHost = new JLabel(bundle.getString("GridServerConnectionPanel.GridServerAddress.Label.txt"));
        this.m_txtHost = new WATextField();
        this.m_lblPort = new JLabel(bundle.getString("GridServerConnectionPanel.GridserverPort.Label.txt"));
        this.m_txtPort = new WATextField();
    }

    public void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblAuthDomain, gbc);
        this.add(this.m_lblAuthDomain);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_cbxAuthDomain, gbc);
        this.add(this.m_cbxAuthDomain);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_btnAuthDomain, gbc);
        this.add(this.m_btnAuthDomain);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblHost, gbc);
        this.add(this.m_lblHost);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtHost, gbc);
        this.add((Component)this.m_txtHost);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblPort, gbc);
        this.add(this.m_lblPort);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtPort, gbc);
        this.add((Component)this.m_txtPort);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    protected class ViewListener
    implements MdObjectFactoryListener {
        protected JComboBox m_choice;

        public ViewListener(JComboBox choice) {
            this.m_choice = choice;
        }

        public void MdObjectCreated(MdEvent event, String strID) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(strID);
            this._onCreate(list);
        }

        public void MdObjectsCreated(MdEvent event, List idList) {
            this._onCreate(idList);
        }

        public void MdObjectDeleted(MdEvent event, String strID) {
        }

        protected void _onCreate(List idList) {
            try {
                boolean bProcessed = false;
                for (int i = 0; i < idList.size(); ++i) {
                    String strID = (String)idList.get(i);
                    CMetadata meta = Workspace.getMdFactory().getObject(strID);
                    if (!meta.getCMetadataType().equals("AuthenticationDomain")) continue;
                    Root root = (Root)meta;
                    this.m_choice.removeAllItems();
                    List itemsList = null;
                    int flags = 8456;
                    try {
                        itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(GridServerConnectionPanel.this.m_connection.getObjectStore(), GridServerConnectionPanel.this.getReposID(), "AuthenticationDomain", flags, "");
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        return;
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    for (int j = 0; itemsList != null && j < itemsList.size(); ++j) {
                        Root itemRoot = (Root)itemsList.get(j);
                        this.m_choice.addItem(itemRoot);
                        if (!itemRoot.getFQID().equals(root.getFQID())) continue;
                        this.m_choice.setSelectedItem(itemRoot);
                        bProcessed = true;
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)this);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

