/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers.dbms;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.TitledSeparator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SAPHANAServerPanel
extends WsDescriptionWizardTab {
    private SASClientConnection m_connection;
    private String m_strReposID;
    private JLabel m_lblServer;
    private WATextField m_txtServer;
    private JLabel m_lblDriver;
    private WATextField m_txtDriver;
    private JRadioButton m_rdoPort;
    private WATextField m_txtPort;
    private JRadioButton m_rdoInstance;
    private WATextField m_txtInstance;
    protected static final WAdminResource templBundle = new WAdminResource("com.sas.svcs.metadata.mgmt.impl.repository.data.ResourceTemplates.Resources");
    protected static final WAdminResource uigenBundle = new WAdminResource(PropertiesPropertyView.class);
    private static final long serialVersionUID = 1L;

    public SAPHANAServerPanel(SASClientConnection connection, String reposID) {
        this.m_connection = connection;
        this.m_strReposID = reposID;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        block23: {
            Object property;
            int index;
            AssociationList lstProperties;
            block24: {
                Property property22;
                block21: {
                    block22: {
                        Property prop;
                        lstProperties = this.m_connection.getProperties();
                        if (this.m_txtServer.getText().trim().length() > 0) {
                            boolean bServerPropFound = false;
                            for (Property property22 : lstProperties) {
                                if (!property22.getPropertyName().equalsIgnoreCase("SERVER")) continue;
                                if (!property22.getDefaultValue().equalsIgnoreCase(this.m_txtServer.getText().trim())) {
                                    property22.setDefaultValue(this.m_txtServer.getText().trim());
                                }
                                bServerPropFound = true;
                                break;
                            }
                            if (!bServerPropFound) {
                                prop = this.createProperty("Connection.DBMS.Property.SERVER.Name.xmlKey.txt", "SERVER", this.m_txtServer.getText().trim(), "12");
                                lstProperties.add(prop);
                            }
                        } else {
                            for (index = 0; index < lstProperties.size(); ++index) {
                                property = (Property)lstProperties.get(index);
                                if (!property.getPropertyName().equalsIgnoreCase("SERVER")) continue;
                                lstProperties.remove(property);
                                PrototypeUtil.deleteProperty((Property)property);
                                --index;
                            }
                        }
                        if (this.m_txtDriver.getText().trim().length() > 0) {
                            boolean bDriverPropFound = false;
                            for (Property property22 : lstProperties) {
                                if (!property22.getPropertyName().equalsIgnoreCase("DRIVER")) continue;
                                if (!property22.getDefaultValue().equalsIgnoreCase(this.m_txtDriver.getText().trim())) {
                                    property22.setDefaultValue(this.m_txtDriver.getText().trim());
                                }
                                bDriverPropFound = true;
                                break;
                            }
                            if (!bDriverPropFound) {
                                prop = this.createProperty("Connection.HANA.Property.DRIVER.Name.xmlKey.txt", "DRIVER", this.m_txtDriver.getText().trim(), "12");
                                lstProperties.add(prop);
                            }
                        } else {
                            for (index = 0; index < lstProperties.size(); ++index) {
                                property = (Property)lstProperties.get(index);
                                if (!property.getPropertyName().equalsIgnoreCase("DRIVER")) continue;
                                lstProperties.remove(property);
                                PrototypeUtil.deleteProperty((Property)property);
                                --index;
                            }
                        }
                        if (!this.m_rdoPort.isSelected()) break block21;
                        if (this.m_txtPort.getText().trim().length() <= 0) break block22;
                        boolean bPortPropFound = false;
                        for (int index2 = 0; index2 < lstProperties.size(); ++index2) {
                            property22 = (Property)lstProperties.get(index2);
                            if (property22.getPropertyName().equalsIgnoreCase("PORT")) {
                                if (!property22.getDefaultValue().equalsIgnoreCase(this.m_txtPort.getText().trim())) {
                                    property22.setDefaultValue(this.m_txtPort.getText().trim());
                                }
                                bPortPropFound = true;
                                if (this.m_txtPort.getText().trim().equalsIgnoreCase("30015")) {
                                    lstProperties.remove(property22);
                                    PrototypeUtil.deleteProperty(property22);
                                    --index2;
                                }
                            }
                            if (!property22.getPropertyName().equalsIgnoreCase("INSTANCE")) continue;
                            lstProperties.remove(property22);
                            PrototypeUtil.deleteProperty(property22);
                            --index2;
                        }
                        if (bPortPropFound || this.m_txtPort.getText().trim().equalsIgnoreCase("30015")) break block23;
                        Property prop2 = this.createProperty("Connection.DBMS.Property.NPORT.Name.xmlKey.txt", "PORT", this.m_txtPort.getText().trim(), "4");
                        lstProperties.add(prop2);
                        break block23;
                    }
                    for (index = 0; index < lstProperties.size(); ++index) {
                        property = (Property)lstProperties.get(index);
                        if (!property.getPropertyName().equalsIgnoreCase("PORT")) continue;
                        lstProperties.remove(property);
                        PrototypeUtil.deleteProperty((Property)property);
                        --index;
                    }
                    break block23;
                }
                if (!this.m_rdoInstance.isSelected()) break block23;
                if (this.m_txtInstance.getText().trim().length() <= 0) break block24;
                boolean bInstancePropFound = false;
                for (int index3 = 0; index3 < lstProperties.size(); ++index3) {
                    property22 = (Property)lstProperties.get(index3);
                    if (property22.getPropertyName().equalsIgnoreCase("INSTANCE")) {
                        if (!property22.getDefaultValue().equalsIgnoreCase(this.m_txtInstance.getText().trim())) {
                            property22.setDefaultValue(this.m_txtInstance.getText().trim());
                        }
                        bInstancePropFound = true;
                    }
                    if (!property22.getPropertyName().equalsIgnoreCase("PORT")) continue;
                    lstProperties.remove(property22);
                    PrototypeUtil.deleteProperty(property22);
                    --index3;
                }
                if (bInstancePropFound) break block23;
                Property prop = this.createProperty("Connection.HANA.Property.INSTANCE.Name.xmlKey.txt", "INSTANCE", this.m_txtInstance.getText().trim(), "4");
                lstProperties.add(prop);
                break block23;
            }
            for (index = 0; index < lstProperties.size(); ++index) {
                property = (Property)lstProperties.get(index);
                if (!property.getPropertyName().equalsIgnoreCase("INSTANCE")) continue;
                lstProperties.remove(property);
                PrototypeUtil.deleteProperty((Property)property);
                --index;
            }
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_txtPort.setText("30015");
        AssociationList lstProperties = this.m_connection.getProperties();
        for (Property property : lstProperties) {
            if (property.getPropertyName().equalsIgnoreCase("SERVER")) {
                this.m_txtServer.setText(property.getDefaultValue());
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("DRIVER")) {
                this.m_txtDriver.setText(property.getDefaultValue());
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("PORT")) {
                this.m_txtPort.setText(property.getDefaultValue());
                this.m_rdoPort.setSelected(true);
                continue;
            }
            if (!property.getPropertyName().equalsIgnoreCase("INSTANCE")) continue;
            this.m_txtInstance.setText(property.getDefaultValue());
            this.m_rdoInstance.setSelected(true);
        }
        this.enableComponent(this.m_rdoPort, (JComponent)this.m_txtPort);
        this.enableComponent(this.m_rdoInstance, (JComponent)this.m_txtInstance);
    }

    public boolean validateData() {
        if (this.m_txtServer.getText().trim().length() == 0) {
            String strMessage = uigenBundle.formatString("PropertiesPropertyView.FieldIsRequired.fmt.txt", (Object)templBundle.getString("Connection.DBMS.Property.SERVER.Name.xmlKey.txt"));
            String strTitle = uigenBundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            return false;
        }
        if (this.m_rdoPort.isSelected()) {
            if (this.m_txtPort.getText().trim().length() == 0) {
                String strMessage = uigenBundle.formatString("PropertiesPropertyView.FieldIsRequired.fmt.txt", (Object)templBundle.getString("Connection.DBMS.Property.NPORT.Name.xmlKey.txt"));
                String strTitle = uigenBundle.getString("Common.RequiredField.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
            try {
                Integer.parseInt(this.m_txtPort.getText().trim());
            }
            catch (NumberFormatException exc) {
                String strMessage = uigenBundle.formatString("PropertiesPropertyView.FieldIsNotInteger.fmt.txt", (Object)templBundle.getString("Connection.DBMS.Property.NPORT.Name.xmlKey.txt"));
                String strTitle = uigenBundle.getString("Common.InvalidValue.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
        }
        if (this.m_rdoInstance.isSelected()) {
            if (this.m_txtInstance.getText().trim().length() == 0) {
                String strMessage = uigenBundle.formatString("PropertiesPropertyView.FieldIsRequired.fmt.txt", (Object)templBundle.getString("Connection.HANA.Property.INSTANCE.Name.xmlKey.txt"));
                String strTitle = uigenBundle.getString("Common.RequiredField.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
            try {
                Integer.parseInt(this.m_txtInstance.getText().trim());
            }
            catch (NumberFormatException exc) {
                String strMessage = uigenBundle.formatString("PropertiesPropertyView.FieldIsNotInteger.fmt.txt", (Object)templBundle.getString("Connection.HANA.Property.INSTANCE.Name.xmlKey.txt"));
                String strTitle = uigenBundle.getString("Common.InvalidValue.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                return false;
            }
        }
        return true;
    }

    public String createFinishString() {
        String strFinish = "";
        try {
            AssociationList lstProperties = this.m_connection.getProperties();
            for (Property property : lstProperties) {
                if (!property.getPropertyName().equalsIgnoreCase("SERVER") && !property.getPropertyName().equalsIgnoreCase("DRIVER") && !property.getPropertyName().equalsIgnoreCase("PORT") && !property.getPropertyName().equalsIgnoreCase("INSTANCE")) continue;
                strFinish = strFinish + uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString(property.getName())) + "\n\t" + property.getDefaultValue() + "\n";
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return strFinish;
    }

    private Property createProperty(String name, String propertyName, String value, String sqlType) throws MdException, RemoteException {
        Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_connection.getObjectStore(), null, "Property", "Property", this.m_strReposID.substring(9));
        property.setName(name, 1);
        property.setPropertyName(propertyName, 1);
        property.setDelimiter("=", 1);
        property.setUseValueOnly("0", 1);
        property.setDefaultValue(value, 1);
        property.setSQLType(sqlType);
        return property;
    }

    protected void initialize() {
        this.setHelpProduct("templatedata");
        this.setHelpTopic("servwiz_3a_hanasrv");
        this.m_lblServer = new JLabel(uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString("Connection.DBMS.Property.SERVER.Name.xmlKey.txt")));
        this.m_txtServer = new WATextField(25);
        this.m_txtServer.setToolTipText(templBundle.getString("Connection.HANA.Property.SERVER.Desc.xmlKey.txt"));
        this.m_lblDriver = new JLabel(uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString("Connection.HANA.Property.DRIVER.Name.xmlKey.txt")));
        this.m_txtDriver = new WATextField();
        this.m_txtDriver.setToolTipText(templBundle.getString("Connection.HANA.Property.DRIVER.Desc.xmlKey.txt"));
        this.m_rdoPort = new JRadioButton(uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString("Connection.DBMS.Property.NPORT.Name.xmlKey.txt")));
        this.m_rdoPort.setSelected(true);
        this.m_txtPort = new WATextField();
        this.m_txtPort.setToolTipText(templBundle.getString("Connection.DBMS.Property.NPORT.Desc.xmlKey.txt"));
        this.m_rdoPort.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SAPHANAServerPanel.this.enableComponent(SAPHANAServerPanel.this.m_rdoPort, (JComponent)SAPHANAServerPanel.this.m_txtPort);
            }
        });
        this.m_rdoInstance = new JRadioButton(uigenBundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)templBundle.getString("Connection.HANA.Property.INSTANCE.Name.xmlKey.txt")));
        this.m_txtInstance = new WATextField();
        this.m_txtInstance.setToolTipText(templBundle.getString("Connection.HANA.Property.INSTANCE.Desc.xmlKey.txt"));
        this.m_rdoInstance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SAPHANAServerPanel.this.enableComponent(SAPHANAServerPanel.this.m_rdoInstance, (JComponent)SAPHANAServerPanel.this.m_txtInstance);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdoPort);
        buttonGroup.add(this.m_rdoInstance);
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblServer, gbc);
        this.add(this.m_lblServer);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtServer, gbc);
        this.add((Component)this.m_txtServer);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblDriver, gbc);
        this.add(this.m_lblDriver);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtDriver, gbc);
        this.add((Component)this.m_txtDriver);
        TitledSeparator separator = new TitledSeparator(templBundle.getString("Connection.HANA.PropertyGroup.PNUM.Name.xmlKey.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(separator, gbc);
        this.add(separator);
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int gy = 0;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = gy;
        c.anchor = 17;
        c.insets = new Insets(12, 24, 0, 0);
        gbl.setConstraints(this.m_rdoPort, c);
        panel.add(this.m_rdoPort);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = gy++;
        c.anchor = 13;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 0, 12);
        gbl.setConstraints((Component)this.m_txtPort, c);
        panel.add((Component)this.m_txtPort);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = gy;
        c.anchor = 17;
        c.insets = new Insets(12, 24, 12, 0);
        gbl.setConstraints(this.m_rdoInstance, c);
        panel.add(this.m_rdoInstance);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = gy;
        c.anchor = 13;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        gbl.setConstraints((Component)this.m_txtInstance, c);
        panel.add((Component)this.m_txtInstance);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gridBagLayout.setConstraints(panel, gbc);
        this.add(panel);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    private void enableComponent(JToggleButton source, JComponent target) {
        target.setEnabled(source.isSelected());
    }
}

