/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals.customizers;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TableSASConnectionPanel
extends WsDescriptionWizardTab {
    SASClientConnection m_connection;
    private boolean m_bIsTCPProtocol = true;
    private boolean m_bIsLOCALProtocol = true;
    private JLabel m_lblAppProtocol;
    private JComboBox m_cbxAppProtocol;
    private JLabel m_lblHost;
    private WATextField m_txtHost;
    private JLabel m_lblPort;
    private WATextField m_txtPort;
    private static final String DEFAULT_PORT = "2171";
    private static final WAdminResource bundle = WAdminResource.getBundle(TableSASConnectionPanel.class);
    private static final long serialVersionUID = -830524542507057977L;

    public TableSASConnectionPanel(SASClientConnection connection) {
        this.m_connection = connection;
        this.initialize();
        this.layoutWidgets();
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        try {
            this.m_cbxAppProtocol.removeAllItems();
            this.m_cbxAppProtocol.addItem("TCP");
            this.m_cbxAppProtocol.addItem("LOCAL");
            this.m_cbxAppProtocol.setSelectedIndex(1);
            if (this.m_connection.getCommunicationProtocol().length() > 0) {
                this.m_cbxAppProtocol.setSelectedItem(this.m_connection.getCommunicationProtocol());
            }
            this.m_txtHost.setText(this.m_connection.getRemoteAddress());
            if (this.m_bIsTCPProtocol) {
                String strCurrentValue = String.valueOf(this.m_connection.getPort());
                int valueState = this.m_connection.getPortState();
                if (valueState != 2 && strCurrentValue.equals("") || valueState == 0 && strCurrentValue.equals("0")) {
                    this.m_txtPort.setText(DEFAULT_PORT);
                } else {
                    this.m_txtPort.setText(strCurrentValue);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void moveDataToStore() {
        this.setViewProperties();
    }

    public boolean validateData() {
        boolean bValidated = true;
        if (this.m_txtHost.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("TableSASConnectionPanel.Host.Required.txt"), bundle.getString("Common.Error.txt"), 0);
            bValidated = false;
            return bValidated;
        }
        if (this.m_bIsTCPProtocol) {
            if (this.m_txtPort.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("TableSASConnectionPanel.Port.Required.txt"), bundle.getString("Common.Error.txt"), 0);
                bValidated = false;
                return bValidated;
            }
            try {
                int port = Integer.valueOf(this.m_txtPort.getText().trim());
                if (port < 0 || port > 65535) {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("TableSASConnectionPanel.Port.Integer.txt"), bundle.getString("Common.Error.txt"), 0);
                    bValidated = false;
                    return bValidated;
                }
            }
            catch (NumberFormatException exc) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), bundle.getString("TableSASConnectionPanel.Port.Integer.txt"), bundle.getString("Common.Error.txt"), 0);
                bValidated = false;
                return bValidated;
            }
        }
        return bValidated;
    }

    public String createFinishString() {
        String strFinish = Util.getDisplayLabel((String)bundle.getString("TableSASConnectionPanel.CommunicationProtocol.Label.txt")) + "\n\t" + (String)this.m_cbxAppProtocol.getSelectedItem() + "\n";
        strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("TableSASConnectionPanel.Host.Label.txt")) + "\n\t" + this.m_txtHost.getText() + "\n";
        if (this.m_bIsTCPProtocol) {
            strFinish = strFinish + Util.getDisplayLabel((String)bundle.getString("TableSASConnectionPanel.Port.Label.txt")) + "\n\t" + this.m_txtPort.getText() + "\n";
        }
        return strFinish;
    }

    public void onNext() {
        this.setViewProperties();
    }

    public void onBack() {
        this.setViewProperties();
    }

    private void setViewProperties() {
        block7: {
            try {
                this.m_connection.setApplicationProtocol("TKTS", 1);
                this.m_connection.setCommunicationProtocol((String)this.m_cbxAppProtocol.getSelectedItem(), 1);
                if (this.m_bIsLOCALProtocol) {
                    this.m_connection.setAuthenticationType("none", 1);
                } else {
                    this.m_connection.setAuthenticationType("Metadata", 1);
                }
                this.m_connection.setRemoteAddress(this.m_txtHost.getText().trim(), 1);
                if (!this.m_bIsTCPProtocol) break block7;
                try {
                    if (this.m_txtPort.getText().trim().length() > 0) {
                        this.m_connection.setPort(this.m_txtPort.getText().trim(), 1);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected void onAppProtocolChanged() {
        this.m_bIsTCPProtocol = ((String)this.m_cbxAppProtocol.getSelectedItem()).equalsIgnoreCase("TCP");
        this.m_bIsLOCALProtocol = ((String)this.m_cbxAppProtocol.getSelectedItem()).equalsIgnoreCase("LOCAL");
        if (this.m_bIsTCPProtocol) {
            this.m_txtPort.setText(DEFAULT_PORT);
        } else {
            this.m_txtPort.setText("");
        }
        this.removeAll();
        this.layoutWidgets();
        this.revalidate();
    }

    String getReposID() {
        try {
            return "A0000001." + this.m_connection.getFQID().substring(0, 8);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void initialize() {
        this.m_lblAppProtocol = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblAppProtocol, bundle.getString("TableSASConnectionPanel.CommunicationProtocol.Label.txt"));
        this.m_cbxAppProtocol = new JComboBox();
        this.m_lblAppProtocol.setLabelFor(this.m_cbxAppProtocol);
        this.m_cbxAppProtocol.setRenderer(new MetadataObjectCellRenderer());
        this.m_cbxAppProtocol.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TableSASConnectionPanel.this.onAppProtocolChanged();
            }
        });
        this.m_lblHost = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblHost, bundle.getString("TableSASConnectionPanel.Host.Label.txt"));
        this.m_txtHost = new WATextField();
        this.m_lblHost.setLabelFor((Component)this.m_txtHost);
        this.m_lblPort = new JLabel();
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblPort, bundle.getString("TableSASConnectionPanel.Port.Label.txt"));
        this.m_txtPort = new WATextField();
        this.m_lblPort.setLabelFor(this.m_lblHost);
    }

    public void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblAppProtocol, gbc);
        this.add(this.m_lblAppProtocol);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_cbxAppProtocol, gbc);
        this.add(this.m_cbxAppProtocol);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblHost, gbc);
        this.add(this.m_lblHost);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtHost, gbc);
        this.add((Component)this.m_txtHost);
        this.m_lblPort = new JLabel();
        if (this.m_bIsTCPProtocol) {
            MnemonicModel.setLabelTextAndMnemonic(this.m_lblPort, bundle.getString("TableSASConnectionPanel.Port.Label.txt"));
        } else {
            MnemonicModel.setLabelTextAndMnemonic(this.m_lblPort, MnemonicModel.getLabelWithoutMnemonic(bundle.getString("TableSASConnectionPanel.Port.Label.txt")));
        }
        this.m_lblPort.setLabelFor((Component)this.m_txtPort);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblPort, gbc);
        this.add(this.m_lblPort);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtPort, gbc);
        this.add((Component)this.m_txtPort);
        this.m_txtPort.setEditable(this.m_bIsTCPProtocol);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    protected class ViewListener
    implements MdObjectFactoryListener {
        protected JComboBox m_choice;

        public ViewListener(JComboBox choice) {
            this.m_choice = choice;
        }

        public void MdObjectCreated(MdEvent event, String strID) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(strID);
            this._onCreate(list);
        }

        public void MdObjectsCreated(MdEvent event, List idList) {
            this._onCreate(idList);
        }

        public void MdObjectDeleted(MdEvent event, String strID) {
        }

        protected void _onCreate(List idList) {
            try {
                boolean bProcessed = false;
                for (int i = 0; i < idList.size(); ++i) {
                    String strID = (String)idList.get(i);
                    CMetadata meta = Workspace.getMdFactory().getObject(strID);
                    if (!meta.getCMetadataType().equals("AuthenticationDomain")) continue;
                    Root root = (Root)meta;
                    this.m_choice.removeAllItems();
                    List itemsList = null;
                    int flags = 8456;
                    try {
                        itemsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(TableSASConnectionPanel.this.m_connection.getObjectStore(), TableSASConnectionPanel.this.getReposID(), "AuthenticationDomain", flags, "");
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        return;
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                    for (int j = 0; itemsList != null && j < itemsList.size(); ++j) {
                        Root itemRoot = (Root)itemsList.get(j);
                        this.m_choice.addItem(itemRoot);
                        if (!itemRoot.getFQID().equals(root.getFQID())) continue;
                        this.m_choice.setSelectedItem(itemRoot);
                        bProcessed = true;
                    }
                }
                if (bProcessed) {
                    Workspace.getMdFactory().removeMdObjectFactoryListener((MdObjectFactoryListener)this);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

