/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.MultiplePropertyView;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public class TransformationsPropertyView
extends MultiplePropertyView {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(TransformationsPropertyView.class);
    protected Server m_server;
    protected Transformation m_transformation;
    protected Prototype m_deployedComponentPrototype;
    protected Prototype m_transformationPrototype;
    protected List m_transformationsPrototypesList;
    protected List m_initProcessesList;
    protected List m_targetTransformationsList;

    public TransformationsPropertyView(Server server, int type) {
        super(type, bundle.getString("TransformationsPropertyView.Trans.txt"), bundle.getString("TransformationsPropertyView.TransProp.txt"));
        try {
            this.m_server = server;
            String strClassID = this.m_server.getDeployedComponent().getClassIdentifier();
            if (strClassID != null && this.m_server.getDeployedComponent().getClassIdentifier().equalsIgnoreCase("IOM Spawner")) {
                this.setName(bundle.getString("TransformationsPropertyView.Init.txt"));
                this.setDescription(bundle.getString("TransformationsPropertyView.Spawner.txt"));
            } else {
                this.setName(bundle.getString("TransformationsPropertyView.Workspaces.txt"));
                this.setDescription(bundle.getString("TransformationsPropertyView.LogServer.txt"));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            super.doDataExchange(bSaveToModel);
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_type == 0) {
                this.m_typeChoice.removeAllItems();
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                this.m_deployedComponentPrototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
                try {
                    AssociationList associationsList = this.m_deployedComponentPrototype.getAssociations();
                    for (int i = 0; i < associationsList.size(); ++i) {
                        AssociationProperty property = (AssociationProperty)associationsList.get(i);
                        if (!property.getAssociationName().equals("InitProcesses")) continue;
                        this.m_transformationsPrototypesList = property.getAssociatedPrototypes();
                        for (int j = 0; j < this.m_transformationsPrototypesList.size(); ++j) {
                            Prototype transformationPrototype = (Prototype)this.m_transformationsPrototypesList.get(j);
                            if (transformationPrototype == this.m_deployedComponentPrototype) continue;
                            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
                            int flags = 268;
                            transformationPrototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)transformationPrototype, new Vector(), new Vector(), strTemplate, flags);
                            this.m_typeChoice.addItem(transformationPrototype.getName());
                        }
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            if (this.m_type == 1) {
                try {
                    this.m_initProcessesList = this.m_server.getDeployedComponent().getInitProcesses();
                    for (int i = 0; i < this.m_initProcessesList.size(); ++i) {
                        Transformation transformation = (Transformation)this.m_initProcessesList.get(i);
                        Prototype transformPrototype = (Prototype)transformation.getUsingPrototype();
                        this.m_typeChoice.addItem(transformation.getName());
                        this.m_descText.setText(transformation.getDesc());
                        this.m_nameText.setText(transformPrototype.getName());
                        this.m_nameText.setEditable(false);
                        this.m_nameText.setBackground(this.getBackground());
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
        }
        return false;
    }

    @Override
    public void onRootTypeChanged() {
        try {
            String strType = "";
            if (this.m_typeChoice.getItemCount() == 0) {
                return;
            }
            strType = (String)this.m_typeChoice.getSelectedItem();
            if (this.m_type == 1) {
                try {
                    AssociationList initProcessesList = this.m_server.getDeployedComponent().getInitProcesses();
                    for (int i = 0; i < initProcessesList.size(); ++i) {
                        this.m_transformation = (Transformation)initProcessesList.get(i);
                        this.m_transformationPrototype = this.m_server.getTransformationPrototype(this.m_transformation, this.getTopLevelAncestor());
                        if (strType.equals(this.m_transformation.getName())) break;
                    }
                    this.m_descText.setText(this.m_transformation.getDesc());
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            if (this.m_type == 0) {
                for (int i = 0; i < this.m_transformationsPrototypesList.size(); ++i) {
                    this.m_transformationPrototype = (Prototype)this.m_transformationsPrototypesList.get(i);
                    if (strType.equals(this.m_transformationPrototype.getName())) break;
                }
                this.m_nameText.setText(this.m_server.getDeployedComponent().getName());
                this.m_nameText.setEditable(false);
                this.m_transformation = this.m_server.addTransformation();
            }
            super.setRoot((Root)this.m_transformation);
            super.setPrototype(this.m_transformationPrototype);
            super.onRootTypeChanged();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected void _setViewProperties() {
        try {
            this.m_transformation.setName(this.m_server.getDeployedComponent().getName(), 1);
            super._setViewProperties();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public void onNext() {
        try {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            parent.setCursor(Cursor.getPredefinedCursor(3));
            this.setConditionState("NEXT");
            try {
                AssociationList associationsList = this.m_transformationPrototype.getAssociations();
                for (int i = 0; i < associationsList.size(); ++i) {
                    AssociationProperty property = (AssociationProperty)associationsList.get(i);
                    if (!property.getAssociationName().equals("Groups")) continue;
                    this.setConditionState("GROUPS");
                    break;
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            this.m_transformation.setUsingPrototype((Root)this.m_transformationPrototype);
            Vector<Transformation> transformationsList = (Vector<Transformation>)parent.getWizardData("Transformations");
            if (transformationsList == null) {
                transformationsList = new Vector<Transformation>();
            }
            this._setViewProperties();
            super.onNext();
            if (!transformationsList.isEmpty()) {
                transformationsList.remove(0);
            }
            transformationsList.add(this.m_transformation);
            parent.replaceWizardData("Transformations", transformationsList);
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        List transformationsList = (List)parent.getWizardData("Transformations");
        if (transformationsList != null && !transformationsList.isEmpty()) {
            transformationsList.remove(transformationsList.size() - 1);
            parent.replaceWizardData("Transformations", (Object)transformationsList);
        }
        super.onBack();
    }
}

