/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SoftwarePropertyView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected int m_type;
    protected JLabel m_productNameLabel;
    protected JLabel m_productNameValue;
    protected JLabel m_softwareVersionLabel;
    protected JLabel m_softwareVersionValue;
    protected JLabel m_majorLabel;
    protected JLabel m_majorValue;
    protected JLabel m_minorLabel;
    protected JLabel m_minorValue;
    protected JLabel m_vendorLabel;
    protected JLabel m_vendorValue;
    protected JLabel m_specVersionLabel;
    protected JLabel m_specVersionValue;
    protected JLabel m_specVendorLabel;
    protected JLabel m_specVendorValue;
    protected JLabel m_vendorIDLabel;
    protected JLabel m_vendorIDValue;
    protected JSeparator m_separator;
    private static final WAdminResource bundle = WAdminResource.getBundle(SoftwarePropertyView.class);

    public SoftwarePropertyView(Server server, int type) {
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                SoftwareComponent softwareComponent = this.m_server.getDeployedComponent().getDescriptiveComponent();
                this.m_productNameValue.setText(softwareComponent.getProductName());
                this.m_softwareVersionValue.setText(softwareComponent.getSoftwareVersion());
                this.m_majorValue.setText(String.valueOf(softwareComponent.getMajor()));
                this.m_minorValue.setText(String.valueOf(softwareComponent.getMinor()));
                this.m_vendorValue.setText(softwareComponent.getVendor());
                this.m_specVersionValue.setText(softwareComponent.getSpecVersion());
                this.m_specVendorValue.setText(softwareComponent.getSpecVendor());
                this.m_vendorIDValue.setText(softwareComponent.getVendorIdentifier());
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    protected void _initialize() {
        this.setName(bundle.getString("SoftwarePropertyView.TabName.txt"));
        this.m_productNameLabel = new JLabel(bundle.getString("SoftwarePropertyView.ProductName.txt"));
        this.m_productNameValue = new JLabel();
        this.m_softwareVersionLabel = new JLabel(bundle.getString("SoftwarePropertyView.SoftwareVersion.txt"));
        this.m_softwareVersionValue = new JLabel();
        this.m_majorLabel = new JLabel(bundle.getString("SoftwarePropertyView.Major.txt"));
        this.m_majorValue = new JLabel();
        this.m_minorLabel = new JLabel(bundle.getString("SoftwarePropertyView.Minor.txt"));
        this.m_minorValue = new JLabel();
        this.m_vendorLabel = new JLabel(bundle.getString("SoftwarePropertyView.Vendor.txt"));
        this.m_vendorValue = new JLabel();
        this.m_specVersionLabel = new JLabel(bundle.getString("SoftwarePropertyView.SpecVersion.txt"));
        this.m_specVersionValue = new JLabel();
        this.m_specVendorLabel = new JLabel(bundle.getString("SoftwarePropertyView.SpecVendor.txt"));
        this.m_specVendorValue = new JLabel();
        this.m_vendorIDLabel = new JLabel(bundle.getString("SoftwarePropertyView.VendorID.txt"));
        this.m_vendorIDValue = new JLabel();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_productNameLabel, gbc);
        this.add(this.m_productNameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_productNameValue, gbc);
        this.add(this.m_productNameValue);
        this.m_separator = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_separator, gbc);
        this.add(this.m_separator);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_softwareVersionLabel, gbc);
        this.add(this.m_softwareVersionLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_softwareVersionValue, gbc);
        this.add(this.m_softwareVersionValue);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_majorLabel, gbc);
        this.add(this.m_majorLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_majorValue, gbc);
        this.add(this.m_majorValue);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_minorLabel, gbc);
        this.add(this.m_minorLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_minorValue, gbc);
        this.add(this.m_minorValue);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_vendorLabel, gbc);
        this.add(this.m_vendorLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_vendorValue, gbc);
        this.add(this.m_vendorValue);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_specVersionLabel, gbc);
        this.add(this.m_specVersionLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_specVersionValue, gbc);
        this.add(this.m_specVersionValue);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_specVendorLabel, gbc);
        this.add(this.m_specVendorLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_specVendorValue, gbc);
        this.add(this.m_specVendorValue);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gridBagLayout.setConstraints(this.m_vendorIDLabel, gbc);
        this.add(this.m_vendorIDLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(this.m_vendorIDValue, gbc);
        this.add(this.m_vendorIDValue);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(46, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

