/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class SinglePropertyView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected Root m_root;
    protected Prototype m_prototype;
    protected int m_type;
    protected String m_strViewName;
    protected String m_strTopTitle;
    protected WATextArea m_titleText;
    protected PropertiesPropertyView m_view;

    public SinglePropertyView(int type, String strViewName, String strTopTitle) {
        this.m_type = type;
        this.m_strViewName = strViewName;
        this.m_strTopTitle = strTopTitle;
        this._initialize();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_type == 1) {
                this._setViewProperties();
            }
        } else {
            this.removeAll();
            this._layoutWidgets();
            this.revalidate();
            if (this.m_view instanceof PropertiesPropertyView) {
                this.m_view.doDataExchange(false);
            }
        }
        return false;
    }

    public boolean validateData() {
        return this.m_view.validateData();
    }

    protected void _setViewProperties() {
        try {
            this.m_view.setViewProperties();
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        if (this.m_view instanceof PropertiesPropertyView) {
            this.m_view.onNext();
        }
    }

    public void onBack() {
        if (this.m_view instanceof PropertiesPropertyView) {
            this.m_view.onBack();
        }
    }

    public String createFinishString() {
        return this.m_view.createFinishString();
    }

    public Component getDefaultFocusComponent() {
        Component comp = null;
        if (this.m_view instanceof PropertiesPropertyView) {
            comp = this.m_view.getDefaultFocusComponent();
        }
        return comp;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_view instanceof PropertiesPropertyView) {
            this.m_view.saveSettingsAndCleanUp();
        }
    }

    protected void _initialize() {
        this.setName(this.m_strViewName);
        if (this.m_type == 0) {
            this.m_titleText = new WATextArea(this.m_strTopTitle);
            this.m_titleText.setEditable(false);
            this.m_titleText.setLineWrap(true);
            this.m_titleText.setWrapStyleWord(true);
            this.m_titleText.setBorder(null);
            this.m_titleText.setBackground(this.getBackground());
        }
    }

    protected void _layoutWidgets() {
        GridBagConstraints gbc;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        if (this.m_type == 0) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints((Component)this.m_titleText, gbc);
            this.add((Component)this.m_titleText);
        }
        PropertyGroup group = null;
        try {
            group = this.m_prototype.getPrimaryPropertyGroup();
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        Hashtable propertiesTable = null;
        if (this.m_type == 0) {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            propertiesTable = (Hashtable)parent.getWizardData("Properties");
        }
        this.m_view = new PropertiesPropertyView(this.m_root, group, this.m_type, propertiesTable, this.m_prototype);
        try {
            AssociationList extensionList = group.getExtensions();
            for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                Extension extension = (Extension)extensionList.get(extIndex);
                if (extension.getName().equalsIgnoreCase("HelpSet")) {
                    String strHelpSet = extension.getValue();
                    this.setHelpProduct(strHelpSet);
                }
                if (!extension.getName().equalsIgnoreCase("HelpTopicSimple")) continue;
                String strHelpTopic = extension.getValue();
                this.setHelpTopic(strHelpTopic);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 0, 0, 12);
        gridBagLayout.setConstraints((Component)((Object)this.m_view), gbc);
        this.add((Component)((Object)this.m_view));
    }
}

