/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ServerPropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Prototype m_serverPrototype;
    protected int m_type;
    protected JPanel m_view;
    protected SASClientConnection m_sasConnection;
    protected TCPIPConnection m_tcpConnection;
    protected COMConnection m_comConnection;
    private static final WAdminResource bundle = WAdminResource.getBundle(ServerPropertyView.class);

    public ServerPropertyView(Server server, int type) {
        super(bundle.getString("ServerPropertyView.WizardTitle.txt"));
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets(false);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return false;
    }

    public void moveDataToStore() {
        if (this.m_type == 1 && this.m_view instanceof PropertiesPropertyView) {
            try {
                ((PropertiesPropertyView)((Object)this.m_view)).setViewProperties();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            this._setViewProperties();
        }
    }

    public void populateStore() {
        if (this.m_type == 1) {
            try {
                if (this.m_serverPrototype == null) {
                    this.m_serverPrototype = this.m_server.getDeployedComponentPrototype(this.getTopLevelAncestor());
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    public void moveDataToView() {
        try {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                this.m_serverPrototype = this.m_server.getDeployedComponent() instanceof ServerContext ? (Prototype)parent.getWizardData("ServerContextPrototype") : (Prototype)parent.getWizardData("DeployedComponentPrototype");
                Connection connection = (Connection)parent.getWizardData("Connection");
                if (connection != null) {
                    Map deletedObjectsMap = ((MdObjectStore)connection.getObjectStore()).getDeletedObjects();
                    if (deletedObjectsMap.containsKey(connection.getFQID())) {
                        this.m_sasConnection = null;
                        this.m_tcpConnection = null;
                        this.m_comConnection = null;
                    } else {
                        if (connection instanceof SASClientConnection) {
                            this.m_sasConnection = (SASClientConnection)connection;
                        }
                        if (connection instanceof TCPIPConnection) {
                            this.m_tcpConnection = (TCPIPConnection)connection;
                        }
                        if (connection instanceof COMConnection) {
                            this.m_comConnection = (COMConnection)connection;
                        }
                    }
                }
            }
            if (this.m_type == 1) {
                try {
                    if (this.m_serverPrototype == null) {
                        this.m_serverPrototype = this.m_server.getDeployedComponentPrototype(this.getTopLevelAncestor(), true);
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            this.removeAll();
            this._layoutWidgets(true);
            this.revalidate();
            if (this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).doDataExchange(false);
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public boolean validateData() {
        if (this.m_view instanceof PropertiesPropertyView) {
            return ((PropertiesPropertyView)((Object)this.m_view)).validateData();
        }
        return true;
    }

    protected void _setViewProperties() {
        try {
            ServerComponent serverComponent = (ServerComponent)this.m_server.getDeployedComponent();
            if (serverComponent.getClassIdentifier().equals("IOM Spawner") && serverComponent.getAssociatedMachine() != null) {
                String strMachineName = serverComponent.getAssociatedMachine().getName();
                AssociationList connectionList = serverComponent.getSourceConnections();
                for (int connIndex = 0; connIndex < connectionList.size(); ++connIndex) {
                    COMConnection comConn;
                    TCPIPConnection tcpConn;
                    Connection conn = (Connection)connectionList.get(connIndex);
                    if (conn instanceof TCPIPConnection && !(tcpConn = (TCPIPConnection)conn).getHostName().equals(strMachineName)) {
                        tcpConn.setHostName(strMachineName, 1);
                    }
                    if (!(conn instanceof COMConnection) || (comConn = (COMConnection)conn).getHostName().equals(strMachineName)) continue;
                    comConn.setHostName(strMachineName, 1);
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNext() {
        block51: {
            try {
                Server childServer;
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                if (this.m_view instanceof PropertiesPropertyView) {
                    ((PropertiesPropertyView)((Object)this.m_view)).onNext();
                }
                this._setViewProperties();
                this.m_server.getDeployedComponent().setUsingPrototype((Root)this.m_serverPrototype);
                this.setConditionState("NEXT");
                if (this.m_server.getDeployedComponent() instanceof ServerContext) {
                    parent.replaceWizardData("ServerContext", (Object)this.m_server.getDeployedComponent());
                } else {
                    parent.replaceWizardData("DeployedComponent", (Object)this.m_server.getDeployedComponent());
                }
                if (this.m_serverPrototype.getMetadataType().equals("ServerContext")) {
                    this.setConditionState("APPSERVER");
                    Server childServer2 = (Server)parent.getWizardData("ChildServer");
                    if (childServer2 != null) {
                        MdObjectStore store = childServer2.getStore();
                        ServerComponent sc = (ServerComponent)childServer2.getDeployedComponent();
                        Map deletedObjectsMap = store.getDeletedObjects();
                        if (deletedObjectsMap.containsKey(sc.getFQID())) {
                            store.restoreObject(sc.getFQID());
                        }
                    }
                    return;
                }
                ServerContext serverContext = (ServerContext)parent.getWizardData("ServerContext");
                if (!(this.m_serverPrototype.getMetadataType().equals("ServerComponent") && serverContext != null || (childServer = (Server)parent.getWizardData("ChildServer")) == null)) {
                    MdObjectStore store = childServer.getStore();
                    ServerComponent sc = (ServerComponent)childServer.getDeployedComponent();
                    try {
                        Vector<Object> objectsToRemoveList = new Vector<Object>();
                        objectsToRemoveList.add(sc);
                        AssociationList propList = sc.getProperties();
                        for (int propIndex = 0; propIndex < propList.size(); ++propIndex) {
                            Property prop = (Property)propList.get(propIndex);
                            objectsToRemoveList.add(prop);
                            PropertyType propType = prop.getOwningType();
                            if (propType == null) continue;
                            objectsToRemoveList.add(propType);
                            TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                            if (propTypeText == null) continue;
                            objectsToRemoveList.add(propTypeText);
                        }
                        AssociationList scConnList = sc.getSourceConnections();
                        for (int connIndex = 0; connIndex < scConnList.size(); ++connIndex) {
                            Connection scConn = (Connection)scConnList.get(connIndex);
                            objectsToRemoveList.add(scConn);
                            AssociationList connPropList = scConn.getProperties();
                            for (int propIndex = 0; propIndex < connPropList.size(); ++propIndex) {
                                Property prop = (Property)connPropList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                        }
                        AssociationList scInitList = sc.getInitProcesses();
                        for (int initIndex = 0; initIndex < scInitList.size(); ++initIndex) {
                            Transformation scTransform = (Transformation)scInitList.get(initIndex);
                            objectsToRemoveList.add(scTransform);
                            AssociationList tranPropList = scTransform.getProperties();
                            for (int propIndex = 0; propIndex < tranPropList.size(); ++propIndex) {
                                Property prop = (Property)tranPropList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                        }
                        AssociationList scServiceTypesList = sc.getServiceTypes();
                        for (int sTypeIndex = 0; sTypeIndex < scServiceTypesList.size(); ++sTypeIndex) {
                            ServiceType sType = (ServiceType)scServiceTypesList.get(sTypeIndex);
                            objectsToRemoveList.add(sType);
                        }
                        store.removeObjectsFromStore(objectsToRemoveList);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                ServerComponent serverComponent = (ServerComponent)parent.getWizardData("DeployedComponent");
                List logicalServerList = (List)parent.getWizardData("LogicalServersList");
                if (logicalServerList != null) {
                    LogicalServer logicalServer = (LogicalServer)logicalServerList.get(0);
                    try {
                        AssociationList usingComponentsList = logicalServer.getUsingComponents();
                        if (!usingComponentsList.contains(serverComponent)) {
                            logicalServer.getUsingComponents().add((Object)serverComponent);
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                try {
                    AssociationList associationsList = this.m_serverPrototype.getAssociations();
                    block20: for (int i = 0; i < associationsList.size(); ++i) {
                        Hashtable pTable;
                        AssociationProperty property = (AssociationProperty)associationsList.get(i);
                        if (!property.getAssociationName().equals("SourceConnections")) continue;
                        AssociationList assocPrototypesList = property.getAssociatedPrototypes();
                        if (assocPrototypesList.size() > 2) {
                            this.setConditionState("CONNECTIONTYPE");
                            break;
                        }
                        this.setConditionState("CONNECTION");
                        Vector<Prototype> connectionPrototypeList = new Vector<Prototype>();
                        for (int cpIndex = 0; cpIndex < assocPrototypesList.size(); ++cpIndex) {
                            Prototype connPrototype = (Prototype)assocPrototypesList.get(cpIndex);
                            if (connPrototype == this.m_serverPrototype) continue;
                            connectionPrototypeList.add(connPrototype);
                        }
                        Prototype connectionPrototype = (Prototype)connectionPrototypeList.get(0);
                        parent.replaceWizardData("ConnectionPrototype", (Object)connectionPrototype);
                        Server server = (Server)parent.getWizardData("Server");
                        if (connectionPrototype.getMetadataType().equals("SASClientConnection")) {
                            if (this.m_sasConnection == null) {
                                this.m_sasConnection = (SASClientConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "SASClientConnection", "SASClientConnection", server.getContext().substring(9), null);
                            }
                            this.m_sasConnection.setUsingPrototype((Root)connectionPrototype);
                        }
                        if (connectionPrototype.getMetadataType().equals("TCPIPConnection")) {
                            if (this.m_tcpConnection == null) {
                                this.m_tcpConnection = (TCPIPConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "TCPIPConnection", "TCPIPConnection", server.getContext().substring(9), null);
                            }
                            this.m_tcpConnection.setUsingPrototype((Root)connectionPrototype);
                        }
                        if (connectionPrototype.getMetadataType().equals("COMConnection")) {
                            if (this.m_comConnection == null) {
                                this.m_comConnection = (COMConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "COMConnection", "COMConnection", server.getContext().substring(9), null);
                            }
                            this.m_comConnection.setUsingPrototype((Root)connectionPrototype);
                        }
                        if (this.m_sasConnection != null) {
                            parent.replaceWizardData("Connection", (Object)this.m_sasConnection);
                        }
                        if (this.m_tcpConnection != null) {
                            parent.replaceWizardData("Connection", (Object)this.m_tcpConnection);
                        }
                        if (this.m_comConnection != null) {
                            parent.replaceWizardData("Connection", (Object)this.m_comConnection);
                        }
                        if ((pTable = (Hashtable)parent.getWizardData("Properties")) == null) continue;
                        Enumeration e = pTable.keys();
                        while (e.hasMoreElements()) {
                            Object key = e.nextElement();
                            if (!(key instanceof Connection)) continue;
                            Connection ptConn = (Connection)key;
                            Hashtable[] connTableArray = (Hashtable[])pTable.remove(ptConn);
                            pTable.put(parent.getWizardData("Connection"), connTableArray);
                            if (ptConn.getSource() == null) {
                                Vector<Connection> objectsToRemoveList = new Vector<Connection>();
                                objectsToRemoveList.add(ptConn);
                                ((MdObjectStore)((Connection)key).getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                            }
                            parent.replaceWizardData("Properties", (Object)pTable);
                            continue block20;
                        }
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
                if (this.m_server.getDeployedComponent().getClassIdentifier().equals("IOM Spawner")) {
                    Map deletedObjectsMap;
                    Transformation transformation = (Transformation)parent.getWizardData("Transformation");
                    if (transformation != null && (deletedObjectsMap = ((MdObjectStore)transformation.getObjectStore()).getDeletedObjects()).containsKey(transformation.getFQID())) {
                        transformation = null;
                    }
                    if (transformation == null) {
                        transformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "Initialization", "Transformation", this.m_server.getContext().substring(9), null);
                        transformation.setTransformRole("Initialization", 1);
                    }
                    parent.replaceWizardData("Transformation", (Object)transformation);
                    try {
                        AssociationList associationsList = this.m_serverPrototype.getAssociations();
                        for (int i = 0; i < associationsList.size(); ++i) {
                            AssociationProperty property = (AssociationProperty)associationsList.get(i);
                            if (!property.getAssociationName().equals("InitProcesses")) continue;
                            Vector<Prototype> transformPrototypeList = new Vector<Prototype>();
                            AssociationList assocPrototypesList = property.getAssociatedPrototypes();
                            for (int tpIndex = 0; tpIndex < assocPrototypesList.size(); ++tpIndex) {
                                Prototype tranPrototype = (Prototype)assocPrototypesList.get(tpIndex);
                                if (tranPrototype == this.m_serverPrototype) continue;
                                transformPrototypeList.add(tranPrototype);
                            }
                            Prototype transformPrototype = (Prototype)transformPrototypeList.get(0);
                            parent.replaceWizardData("TransformationPrototype", (Object)transformPrototype);
                            break;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    this.setConditionState("SPAWNERINIT");
                    break block51;
                }
                if (this.m_server.getDeployedComponent().getClassIdentifier().equals("Connect Spawner")) {
                    this.setConditionState("CONNECTSPAWNERSERVERS");
                }
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).onBack();
        }
        this._setViewProperties();
        if (this.m_server.getDeployedComponent() instanceof ServerContext) {
            parent.replaceWizardData("ServerContext", (Object)this.m_server.getDeployedComponent());
        } else {
            parent.replaceWizardData("DeployedComponent", (Object)this.m_server.getDeployedComponent());
        }
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_view instanceof PropertiesPropertyView) {
            strFinish = strFinish + ((PropertiesPropertyView)((Object)this.m_view)).createFinishString();
        }
        return strFinish;
    }

    public Component getDefaultFocusComponent() {
        Component comp = null;
        if (this.m_view instanceof PropertiesPropertyView) {
            comp = ((PropertiesPropertyView)((Object)this.m_view)).getDefaultFocusComponent();
        }
        return comp;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).saveSettingsAndCleanUp();
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("ServerPropertyView.TabName.txt"));
    }

    protected void _layoutWidgets(boolean bShowErrorMessage) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        PropertyGroup group = null;
        try {
            if (this.m_serverPrototype != null) {
                group = this.m_serverPrototype.getPrimaryPropertyGroup();
            }
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        if (group != null) {
            Hashtable propertiesTable = null;
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                propertiesTable = (Hashtable)parent.getWizardData("Properties");
            }
            this.m_view = new PropertiesPropertyView((Root)this.m_server.getDeployedComponent(), group, this.m_type, propertiesTable, this.m_serverPrototype);
            try {
                AssociationList extensionList = group.getExtensions();
                for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                    Extension extension = (Extension)extensionList.get(extIndex);
                    if (extension.getName().equalsIgnoreCase("HelpSet")) {
                        String strHelpSet = extension.getValue();
                        this.setHelpProduct(strHelpSet);
                    }
                    if (!extension.getName().equalsIgnoreCase("HelpTopicSimple")) continue;
                    String strHelpTopic = extension.getValue();
                    this.setHelpTopic(strHelpTopic);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            ((PropertiesPropertyView)((Object)this.m_view)).setMinimumViewHeight(300);
        } else {
            this.m_view = new JPanel();
            this.m_view.setPreferredSize(new Dimension(475, 300));
            if (bShowErrorMessage) {
                this.m_view.add(new JLabel(bundle.getString("Common.UnableToShowProperties.txt")));
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 0, 0, 12);
        gridBagLayout.setConstraints(this.m_view, gbc);
        this.add(this.m_view);
    }
}

