/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.ConnectionPropertyView;
import com.sas.workspace.mgmt.visuals.ConnectionTypeView;
import com.sas.workspace.mgmt.visuals.GeneralPropertyView;
import com.sas.workspace.mgmt.visuals.OLAPSchemaView;
import com.sas.workspace.mgmt.visuals.SASAppServerTypeView;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerPropertyView;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ServerInstanceWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Server m_childServer;
    protected LogicalServer m_logicalServer;
    protected ServerContext m_serverContext;
    protected JFrame m_frame;
    protected Dialog m_dialog;
    protected Component m_component;
    protected String m_strContext;
    protected String m_strTitle;
    protected MdObjectStore m_objectStore = null;
    protected SASAppServerTypeView m_appTab;
    protected boolean m_bShowWizard = true;
    private static final WAdminResource bundle = WAdminResource.getBundle(ServerInstanceWizard.class);

    public ServerInstanceWizard(JFrame frame, String strContext, LogicalServer logicalServer) {
        super((Frame)frame, true);
        try {
            String strTitle;
            LogicalServer tempLogicalServer;
            this.setHelpProduct("newserver");
            Object storedata = this.getWizardData("OBJECTSTORE");
            Boolean bDisposeStore = new Boolean(false);
            this.replaceWizardData("DisposeStore", bDisposeStore);
            if (storedata instanceof MdObjectStore) {
                this.m_objectStore = (MdObjectStore)storedata;
                this.m_objectStore.setIsObjectCopiedFromParentOnCreation(false);
            }
            this.m_logicalServer = tempLogicalServer = (LogicalServer)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, logicalServer.getName(), logicalServer.getCMetadataType(), logicalServer.getId(), null);
            this.m_server = new Server(this.m_objectStore, strContext, (DeployedComponent)tempLogicalServer);
            this.m_childServer = new Server(this.m_objectStore, strContext);
            this.m_server.setParentComponent(frame);
            this.m_component = frame;
            this.m_strContext = strContext;
            this.m_strTitle = strTitle = bundle.getString("ServerWizard.Title.txt");
            WATransitionWizardModel model = new WATransitionWizardModel();
            this.setWizardModel((WAWizardModel)model);
            this.addWizardTabs(model, strTitle);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public Root getMetadataObject() {
        return (Root)this.getWizardData("DeployedComponent");
    }

    public String getTitle() {
        return this.m_strTitle;
    }

    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    protected void addWizardTabs(WATransitionWizardModel model, String strTitle) {
        this.setTitle(strTitle);
        GeneralPropertyView generalTab = new GeneralPropertyView(this.m_childServer, 0);
        this.addTab(strTitle, "General", (WAPropertyTab)generalTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        ServerPropertyView propertyTab = new ServerPropertyView(this.m_childServer, 0);
        this.addTab(strTitle, "Server", (WAPropertyTab)propertyTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
        ConnectionTypeView connTypeTab = new ConnectionTypeView();
        this.addTab(strTitle, "ConnectionType", (WAPropertyTab)connTypeTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        ConnectionPropertyView connectionTab = new ConnectionPropertyView(0);
        this.addTab(strTitle, "Connection", (WAPropertyTab)connectionTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        try {
            if (this.m_logicalServer.getUsedByComponents().size() > 0) {
                Server server = new Server((MdObjectStore)this.m_logicalServer.getObjectStore(), this.m_childServer.getContext(), (DeployedComponent)this.m_logicalServer.getUsedByComponents().get(0));
                OLAPSchemaView olapTab = new OLAPSchemaView(server, 0);
                this.addTab(strTitle, "OLAPSchema", (WAPropertyTab)olapTab, bundle.getString("Common.PropertiesTab.image"), bundle.getImageIcon("Common.PropertiesTab.image"));
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        WizardFinishTab finishTab = new WizardFinishTab(bundle.getString("ServerWizard.DefinitionSuccess.txt"));
        finishTab.setHelpProduct("newserver");
        finishTab.setHelpTopic("servwiz_6");
        this.addTab(strTitle, "Completion", (WAPropertyTab)finishTab, bundle.getString("Common.FinishTab.image"), bundle.getImageIcon("Common.FinishTab.image"));
        String[][] transitions = new String[][]{{"General", "NEXT", "Connection"}, {"General", "SERVER", "Server"}, {"Server", "NEXT", "Completion"}, {"Server", "CONNECTION", "Connection"}, {"Server", "CONNECTIONTYPE", "ConnectionType"}, {"ConnectionType", "NEXT", "Connection"}, {"Connection", "NEXT", "Completion"}, {"Connection", "OLAPSCHEMA", "OLAPSchema"}, {"OLAPSchema", "NEXT", "Completion"}};
        model.addTransitions(transitions);
        this.addWizardData("Server", this.m_server);
        this.addWizardData("LogicalServer", this.m_logicalServer);
        try {
            Prototype logicalServerPrototype = this.m_server.getDeployedComponentPrototype((Component)((Object)this));
            AssociationList associationsList = logicalServerPrototype.getAssociations();
            block6: for (int assocIndex = 0; assocIndex < associationsList.size(); ++assocIndex) {
                AssociationProperty ap = (AssociationProperty)associationsList.get(assocIndex);
                if (!ap.getAssociationName().equals("UsedByComponents")) continue;
                AssociationList assocPrototypesList = ap.getAssociatedPrototypes();
                for (int apIndex = 0; apIndex < assocPrototypesList.size(); ++apIndex) {
                    Prototype p = (Prototype)assocPrototypesList.get(apIndex);
                    if (p == logicalServerPrototype) continue;
                    this.addWizardData("DeployedComponentPrototype", p);
                    continue block6;
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public boolean onCompletion() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ServerComponent serverComponent = (ServerComponent)this.getWizardData("DeployedComponent");
        try {
            this.m_server.getDeployedComponent().getUsingComponents().add((Object)serverComponent);
            this.m_server.getDeployedComponent().getUsingPrototypes().removeAllElements();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        try {
            this.m_server.persist();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return super.onFinish();
    }

    protected boolean onFinish() {
        this.dispose();
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt"), bundle.getString("WriteMetadataProgressIndicator.Msg.Title"));
        cOnCompletionRunnable ocr = this.createOnCompletionRunnable();
        request.execute((Runnable)ocr);
        return ocr.getReturnValue();
    }

    protected cOnCompletionRunnable createOnCompletionRunnable() {
        return new cOnCompletionRunnable();
    }

    protected class cOnCompletionRunnable
    implements Runnable {
        boolean returnValue = false;

        @Override
        public synchronized void run() {
            this.returnValue = ServerInstanceWizard.this.onCompletion();
        }

        public synchronized boolean getReturnValue() {
            return this.returnValue;
        }
    }
}

