/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.PrototypeProperty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.SortUtil;
import com.sas.workspace.mgmt.visuals.EditLibraryPathDialog;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import com.sas.workspace.mgmt.visuals.NewLibraryPathDialog;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SASLibraryPanel
extends WsDescriptionWizardTab {
    private Library m_library;
    private Prototype m_libraryPrototype;
    private Prototype m_serverPrototype;
    private int m_type;
    private JLabel m_lblLibref;
    private WATextField m_txtLibref;
    private JLabel m_lblEngine;
    private WAComboBox m_cbxEngine;
    private WATextField m_txtEngine;
    private JCheckBox m_chkEnableDAV;
    private JLabel m_lblServer;
    private WAComboBox m_cbxServer;
    private JLabel m_lblPath;
    private DualListSelector m_lstPath;
    private JButton m_btnNew;
    private JButton m_btnEdit;
    private JButton m_btnDelete;
    protected Component m_defaultFocusComponent;
    private List globalDirectoryList;
    private List scheduledToBeDeletedDirectoryList;
    private List newDirectoryList;
    private boolean m_bShowDAV = false;
    private String m_strDefaultEngine = "";
    private static final long serialVersionUID = -5377087641438303451L;
    protected static final WAdminResource bundle = new WAdminResource(SASLibraryPanel.class);

    public SASLibraryPanel(SASLibrary library, String reposID, int type) {
        try {
            this.m_library = new Library(reposID, (DeployedDataPackage)library, (MdObjectStore)library.getObjectStore());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        this.m_type = type;
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() {
        if (this.m_type == 1) {
            this.setViewProperties();
        }
    }

    public void populateStore() {
        if (this.m_type == 0) {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.m_libraryPrototype = (Prototype)parent.getWizardData("DeployedDataPackagePrototype");
        }
        if (this.m_type == 1) {
            try {
                if (this.m_libraryPrototype == null) {
                    this.m_libraryPrototype = this.m_library.getDeployedDataPackagePrototype(this.getTopLevelAncestor());
                }
            }
            catch (MdException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
    }

    public void moveDataToView() {
        try {
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                this.m_libraryPrototype = (Prototype)parent.getWizardData("DeployedDataPackagePrototype");
            }
            if (this.m_type == 1 && this.m_libraryPrototype == null) {
                this.m_libraryPrototype = this.m_library.getDeployedDataPackagePrototype(this.getTopLevelAncestor(), true);
            }
            this.m_txtLibref.setText(((SASLibrary)this.m_library.getDeployedDataPackage()).getLibref());
            AssociationList prototypePropertiesList = this.m_libraryPrototype.getPrototypeProperties();
            for (int ppIndex = 0; ppIndex < prototypePropertiesList.size(); ++ppIndex) {
                AttributeProperty ap;
                PrototypeProperty pp = (PrototypeProperty)prototypePropertiesList.get(ppIndex);
                if (!(pp instanceof AttributeProperty) || !(ap = (AttributeProperty)pp).getPropertyName().equalsIgnoreCase("Engine")) continue;
                this.m_strDefaultEngine = ap.getDefaultValue();
                PropertyType type = ap.getOwningType();
                TextStore text = (TextStore)type.getStoredConfiguration();
                if (text == null) break;
                String strStoredText = text.getStoredText();
                Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strStoredText);
                Vector engineList = new Vector();
                this.getEngines(doc, engineList);
                this.m_cbxEngine.removeAllItems();
                this.m_cbxEngine.addItems(engineList);
                break;
            }
            if (this.m_strDefaultEngine.equalsIgnoreCase("BASE")) {
                this.m_bShowDAV = true;
                this.m_cbxEngine.setSelectedItem((Object)((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine());
                this.m_cbxServer.removeAllItems();
                this.m_cbxServer.addItem((Object)bundle.getString("Common.SelectOne.txt"));
                String strTemplate = "<TEMPLATES><ServerComponent><DataPackages/></ServerComponent><Directory><Properties/></Directory></TEMPLATES>";
                String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06'][DataPackages/Directory/Properties/Property[@PropertyName='SupportsWebDAV' AND @DefaultValue='1']]\"/>";
                String strOptions = strTemplate + strSelect;
                int flags = 8604;
                List webDAVServersList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getDeployedDataPackage().getObjectStore(), this.m_library.getContext(), "ServerComponent", flags, strOptions);
                this.m_cbxServer.addItems(webDAVServersList);
                AssociationList usingPackagesList = ((SASLibrary)this.m_library.getDeployedDataPackage()).getUsingPackages();
                for (int packIndex = 0; packIndex < usingPackagesList.size(); ++packIndex) {
                    Directory directory;
                    DeployedDataPackage ddp = (DeployedDataPackage)usingPackagesList.get(packIndex);
                    if (!(ddp instanceof Directory) || !this.supportsWebDAV(directory = (Directory)ddp)) continue;
                    boolean bServerSelected = false;
                    AssociationList deployedComponentsList = directory.getDeployedComponents();
                    for (int dcIndex = 0; dcIndex < deployedComponentsList.size(); ++dcIndex) {
                        DeployedComponent dc = (DeployedComponent)deployedComponentsList.get(dcIndex);
                        if (!(dc instanceof ServerComponent)) continue;
                        this.m_cbxServer.setSelectedItem((Object)dc);
                        this.m_chkEnableDAV.setSelected(true);
                        bServerSelected = true;
                        break;
                    }
                    if (!bServerSelected) {
                        continue;
                    }
                    break;
                }
            } else {
                String strEngine = ((SASLibrary)this.m_library.getDeployedDataPackage()).getEngine();
                if (strEngine.length() == 0) {
                    strEngine = this.m_strDefaultEngine;
                }
                this.m_txtEngine.setText(strEngine);
                if (this.m_strDefaultEngine.trim().length() == 0) {
                    this.m_txtEngine.setEnabled(true);
                }
            }
            this.removeAll();
            this.layoutWidgets();
            this.revalidate();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        this.onEnableDAV();
    }

    private boolean supportsWebDAV(Directory directory) {
        boolean bSupportsWebDAV = false;
        try {
            AssociationList propertiesList = directory.getProperties();
            for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
                Property property = (Property)propertiesList.get(propIndex);
                if (!property.getPropertyName().equalsIgnoreCase("SupportsWebDAV")) continue;
                bSupportsWebDAV = true;
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return bSupportsWebDAV;
    }

    private boolean isHTTPBasePath(Directory directory) {
        boolean bIsHTTPBasePath = false;
        try {
            AssociationList propertiesList = directory.getProperties();
            for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
                Property property = (Property)propertiesList.get(propIndex);
                if (!property.getPropertyName().equalsIgnoreCase("HttpServerBasePath")) continue;
                bIsHTTPBasePath = true;
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return bIsHTTPBasePath;
    }

    private void getEngines(Node node, List engineList) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.getEngines(children.item(childIndex), engineList);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Value")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String item = childNodeMap.getNamedItem("name").getNodeValue();
                    engineList.add(item);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.getEngines(children.item(childIndex), engineList);
                }
                break;
            }
        }
    }

    public boolean validateData() {
        boolean bValidated = true;
        String strLibrefValue = this.m_txtLibref.getText();
        if (strLibrefValue.trim().length() == 0) {
            bValidated = false;
            String strMessage = bundle.getString("SASLibraryPanel.Libref.Required.txt");
            String strTitle = bundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            this.setDefaultFocusComponent((Component)this.m_txtLibref);
            return bValidated;
        }
        if (strLibrefValue.trim().length() > 8) {
            bValidated = false;
            String strMessage = bundle.getString("PropertiesPropertyView.Libref.EightCharsOrLess.txt");
            String strTitle = bundle.getString("PropertiesPropertyView.Libref.Title.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            this.setDefaultFocusComponent((Component)this.m_txtLibref);
            return bValidated;
        }
        char[] valueCharArray = strLibrefValue.trim().toCharArray();
        if (!this._isLibrefChar(valueCharArray[0], true)) {
            bValidated = false;
            String strMessage = bundle.getString("PropertiesPropertyView.Libref.FirstCharacter.txt");
            String strTitle = bundle.getString("PropertiesPropertyView.Libref.Title.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            this.setDefaultFocusComponent((Component)this.m_txtLibref);
            return bValidated;
        }
        for (int charIndex = 0; charIndex < valueCharArray.length; ++charIndex) {
            char valueChar = valueCharArray[charIndex];
            if (Character.isSpaceChar(valueChar)) {
                bValidated = false;
                String strMessage = bundle.getString("PropertiesPropertyView.Libref.NoSpaces.txt");
                String strTitle = bundle.getString("PropertiesPropertyView.Libref.Title.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
                this.setDefaultFocusComponent((Component)this.m_txtLibref);
                return bValidated;
            }
            if (this._isLibrefChar(valueChar, false)) continue;
            bValidated = false;
            String strMessage = bundle.getString("PropertiesPropertyView.Libref.RestOfCharacters.txt");
            String strTitle = bundle.getString("PropertiesPropertyView.Libref.Title.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            this.setDefaultFocusComponent((Component)this.m_txtLibref);
            return bValidated;
        }
        if (this.m_cbxEngine.getSelectedItem() == null && this.m_txtEngine.getText().trim().length() == 0) {
            bValidated = false;
            String strMessage = bundle.getString("SASLibraryPanel.Engine.Required.txt");
            String strTitle = bundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            if (this.m_bShowDAV) {
                this.setDefaultFocusComponent((Component)this.m_cbxEngine);
            } else {
                this.setDefaultFocusComponent((Component)this.m_txtEngine);
            }
            return bValidated;
        }
        if (this.m_chkEnableDAV.isSelected() && this.m_cbxServer.getSelectedItem() instanceof String && ((String)this.m_cbxServer.getSelectedItem()).equals(bundle.getString("Common.SelectOne.txt"))) {
            bValidated = false;
            String strMessage = bundle.getString("SASLibraryPanel.Server.Required.txt");
            String strTitle = bundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            this.setDefaultFocusComponent((Component)this.m_cbxServer);
            return bValidated;
        }
        if (this.m_strDefaultEngine.length() > 0 && this.m_lstPath.getTargetModel().getSize() == 0) {
            bValidated = false;
            String strMessage = bundle.getString("SASLibraryPanel.Path.Required.txt");
            String strTitle = bundle.getString("Common.RequiredField.txt");
            MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)0);
            if (this.m_lstPath.getModel().getSize() > 0) {
                this.setDefaultFocusComponent(this.m_lstPath.getSourceComponent());
            } else {
                this.setDefaultFocusComponent(this.m_btnNew);
            }
            return bValidated;
        }
        return bValidated;
    }

    public void setViewProperties() {
        try {
            Directory dir;
            ((SASLibrary)this.m_library.getDeployedDataPackage()).setLibref(this.m_txtLibref.getText().trim());
            if (this.m_strDefaultEngine.equalsIgnoreCase("BASE")) {
                ((SASLibrary)this.m_library.getDeployedDataPackage()).setEngine((String)this.m_cbxEngine.getSelectedItem());
            } else {
                ((SASLibrary)this.m_library.getDeployedDataPackage()).setEngine(this.m_txtEngine.getText().trim());
            }
            ((SASLibrary)this.m_library.getDeployedDataPackage()).setPublicType("Library");
            ((SASLibrary)this.m_library.getDeployedDataPackage()).setUsageVersion(new UsageVersion(1, 0).encode());
            Vector sourceDataList = new Vector();
            ListModel sourceListModel = this.m_lstPath.getModel();
            for (int sIndex = 0; sIndex < sourceListModel.getSize(); ++sIndex) {
                sourceDataList.add(sourceListModel.getElementAt(sIndex));
            }
            Vector targetDataList = new Vector();
            ListModel targetListModel = this.m_lstPath.getTargetModel();
            for (int tIndex = 0; tIndex < targetListModel.getSize(); ++tIndex) {
                targetDataList.add(targetListModel.getElementAt(tIndex));
            }
            Vector previousLibraryUsingPackagesList = new Vector(((SASLibrary)this.m_library.getDeployedDataPackage()).getUsingPackages());
            Vector<Directory> pathsToBeAssignedToLibraryList = new Vector<Directory>(1);
            Map deletedObjectsMap = this.m_library.getStore().getDeletedObjects();
            for (int tdIndex = 0; tdIndex < targetDataList.size(); ++tdIndex) {
                dir = (Directory)targetDataList.get(tdIndex);
                if (!(previousLibraryUsingPackagesList.contains(dir) || this.m_chkEnableDAV.isSelected() && !deletedObjectsMap.containsKey(dir.getFQID()) || dir.getId().indexOf(36) != -1 && !deletedObjectsMap.containsKey(dir.getFQID()))) {
                    Directory newDir = (Directory)Workspace.getMdFactory().createComplexMetadataObject(this.m_library.getStore(), (MdStore)null, bundle.getString("SASLibraryPanel.DirectoryObject.PathObjectName.notrans"), "Directory", this.m_library.getDeployedDataPackage().getRepositoryID());
                    String dirName = dir.getDirectoryName();
                    newDir.setDirectoryName(dirName);
                    newDir.setDirectoryRole(bundle.getString("SASLibraryPanel.DirectoryObject.LibraryPathDirectoryRole.notrans"));
                    newDir.setUsageVersion(new UsageVersion(1, 0).encode());
                    Workspace.getDefaultLogger().debug((Object)("setDirectoryName '" + dirName + "' performed on new Directory ('" + newDir + "', " + newDir.getFQID() + ")"));
                    this.newDirectoryList.add(newDir);
                    targetDataList.add(tdIndex, newDir);
                    targetDataList.remove(dir);
                    dir = newDir;
                    DefaultListModel targetModel = new DefaultListModel();
                    for (int index = 0; index < targetDataList.size(); ++index) {
                        targetModel.add(index, targetDataList.get(index));
                    }
                    targetListModel = null;
                    this.m_lstPath.setTargetModel(targetModel);
                }
                pathsToBeAssignedToLibraryList.add(dir);
                Workspace.getDefaultLogger().debug((Object)("assigned Directory '" + MetadataObjectCellRenderer.getDisplayName((Root)dir) + "' ('" + dir + "', " + dir.getFQID() + ") to library '" + this.m_library.getDeployedDataPackage().getName() + "'"));
            }
            for (int otdIndex = 0; otdIndex < previousLibraryUsingPackagesList.size(); ++otdIndex) {
                dir = (Directory)previousLibraryUsingPackagesList.get(otdIndex);
                if (targetDataList.contains(dir) || this.isHTTPBasePath(dir)) continue;
                this.removeDir(dir);
            }
            ((SASLibrary)this.m_library.getDeployedDataPackage()).getUsingPackages().removeAllElements();
            ((SASLibrary)this.m_library.getDeployedDataPackage()).getUsingPackages().addAll(pathsToBeAssignedToLibraryList);
            for (int sdIndex = 0; sdIndex < sourceDataList.size(); ++sdIndex) {
                dir = (Directory)sourceDataList.get(sdIndex);
                if (dir.getId().indexOf(36) == -1) continue;
                this.removeDir(dir);
            }
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Accessing");
        }
    }

    public void onNext() {
        this.setViewProperties();
    }

    public void onBack() {
        this.setViewProperties();
    }

    public String createFinishString() {
        String strFinish = "";
        try {
            AssociationList usingPackagesList;
            SASLibrary library = (SASLibrary)this.m_library.getDeployedDataPackage();
            strFinish = bundle.getString("SASLibraryPanel.Libref.txt") + "\n\t" + library.getLibref() + "\n";
            strFinish = strFinish + bundle.getString("SASLibraryPanel.Engine.txt") + "\n\t" + library.getEngine() + "\n";
            if (this.m_chkEnableDAV.isSelected() && this.m_cbxServer.getSelectedItem() instanceof ServerComponent) {
                strFinish = strFinish + bundle.getString("SASLibraryPanel.Server.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)((ServerComponent)this.m_cbxServer.getSelectedItem())) + "\n";
            }
            if ((usingPackagesList = library.getUsingPackages()).size() > 0) {
                strFinish = strFinish + bundle.getString("SASLibraryPanel.Path.txt") + "\n\t";
                for (int upIndex = 0; upIndex < usingPackagesList.size(); ++upIndex) {
                    Directory dir = (Directory)usingPackagesList.get(upIndex);
                    strFinish = strFinish + MetadataObjectCellRenderer.getDisplayName((Root)dir);
                    strFinish = upIndex < usingPackagesList.size() - 1 ? strFinish + ",\n\t" : strFinish + "\n";
                }
            }
            if (this.m_strDefaultEngine.trim().length() > 0) {
                AssociationList propertiesList = library.getProperties();
                for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
                    Property property = (Property)propertiesList.get(propIndex);
                    strFinish = strFinish + bundle.formatString("PropertiesPropertyView.LabelColon.fmt", (Object)PrototypeUtil.getDisplayString(property.getName())) + "\n\t";
                    strFinish = strFinish + property.getDefaultValue() + "\n";
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return strFinish;
    }

    protected void onEnableDAV() {
        this.m_cbxServer.setEnabled(this.m_chkEnableDAV.isSelected());
        this.m_btnNew.setEnabled(true);
        if (this.m_chkEnableDAV.isSelected()) {
            this.setViewProperties();
            if (this.m_cbxServer.getSelectedItem() instanceof String && ((String)this.m_cbxServer.getSelectedItem()).equals(bundle.getString("Common.SelectOne.txt"))) {
                DefaultListModel sourceModel = new DefaultListModel();
                this.m_lstPath.setModel(sourceModel);
                DefaultListModel targetModel = new DefaultListModel();
                this.m_lstPath.setTargetModel(targetModel);
                this.m_btnNew.setEnabled(false);
            } else {
                this.onServerChanged();
            }
        } else {
            List<Directory> sourceDataList = new Vector();
            Vector targetDataList = new Vector();
            try {
                AssociationList currentDirectories = ((SASLibrary)this.m_library.getDeployedDataPackage()).getUsingPackages();
                for (int currIndex = 0; currIndex < currentDirectories.size(); ++currIndex) {
                    targetDataList.add(currentDirectories.get(currIndex));
                }
                Vector directoriesList = new Vector(this.globalDirectoryList);
                directoriesList.addAll(this.newDirectoryList);
                Map deletedObjectsMap = this.m_library.getStore().getDeletedObjects();
                for (int dirIndex = 0; dirIndex < directoriesList.size(); ++dirIndex) {
                    Directory directory = (Directory)directoriesList.get(dirIndex);
                    if (deletedObjectsMap.containsKey(directory.getFQID()) && !this.scheduledToBeDeletedDirectoryList.contains(directory)) {
                        directoriesList.remove(directory);
                        --dirIndex;
                        break;
                    }
                    if (sourceDataList.contains(directory) || targetDataList.contains(directory)) continue;
                    sourceDataList.add(directory);
                }
                for (int tIndex = 0; tIndex < targetDataList.size(); ++tIndex) {
                    Directory dir = (Directory)targetDataList.get(tIndex);
                    if (!this.isHTTPBasePath(dir)) continue;
                    targetDataList.remove(dir);
                    --tIndex;
                }
                Vector<String> targetNameList = new Vector<String>();
                for (int t = 0; t < targetDataList.size(); ++t) {
                    targetNameList.add(MetadataObjectCellRenderer.getDisplayName((Root)((Directory)targetDataList.get(t))));
                }
                Vector<String> sourceNameList = new Vector<String>();
                for (int i = 0; i < sourceDataList.size(); ++i) {
                    Directory dir = (Directory)sourceDataList.get(i);
                    String displayName = MetadataObjectCellRenderer.getDisplayName((Root)dir);
                    if (!sourceNameList.contains(displayName) && !targetNameList.contains(displayName)) {
                        sourceNameList.add(displayName);
                        continue;
                    }
                    sourceDataList.remove(i);
                    --i;
                }
            }
            catch (RemoteException rex) {
                String msg = rex.getLocalizedMessage();
                Workspace.getDefaultLogger().error((Object)msg);
                MessageUtil.displayMessage((String)msg, (int)0);
            }
            catch (MdException mdex) {
                Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
                MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
            }
            List sortedSourceDataList = SortUtil.sortAscending(sourceDataList);
            if (sortedSourceDataList != null) {
                sourceDataList = sortedSourceDataList;
            }
            DefaultListModel sourceModel = new DefaultListModel();
            for (int index = 0; index < sourceDataList.size(); ++index) {
                sourceModel.add(index, sourceDataList.get(index));
            }
            this.m_lstPath.setModel(sourceModel);
            DefaultListModel targetModel = new DefaultListModel();
            for (int index = 0; index < targetDataList.size(); ++index) {
                targetModel.add(index, targetDataList.get(index));
            }
            this.m_lstPath.setTargetModel(targetModel);
        }
    }

    protected void onServerChanged() {
        if (this.m_cbxServer.getModel().getSize() == 0 || this.m_cbxServer.getSelectedItem() instanceof String && ((String)this.m_cbxServer.getSelectedItem()).equals(bundle.getString("Common.SelectOne.txt"))) {
            return;
        }
        DefaultListModel sourceModel = new DefaultListModel();
        this.m_lstPath.setModel(sourceModel);
        List<Directory> sourceDataList = new Vector();
        DefaultListModel targetModel = new DefaultListModel();
        this.m_lstPath.setTargetModel(targetModel);
        Vector targetDataList = new Vector();
        this.m_btnNew.setEnabled(false);
        ServerComponent serverComponent = (ServerComponent)this.m_cbxServer.getSelectedItem();
        Server server = new Server(this.m_library.getStore(), this.m_library.getContext(), (DeployedComponent)serverComponent);
        try {
            int index;
            this.m_serverPrototype = server.getDeployedComponentPrototype(this.getTopLevelAncestor());
            try {
                AssociationList currentDirectories = ((SASLibrary)this.m_library.getDeployedDataPackage()).getUsingPackages();
                for (int currIndex = 0; currIndex < currentDirectories.size(); ++currIndex) {
                    targetDataList.add(currentDirectories.get(currIndex));
                }
            }
            catch (MdException mdex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Accessing");
            }
            AssociationList dataPackagesList = serverComponent.getDataPackages();
            for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                Directory directory;
                DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                if (!(ddp instanceof Directory) || !this.supportsWebDAV(directory = (Directory)ddp)) continue;
                if (!sourceDataList.contains(directory)) {
                    sourceDataList.add(directory);
                }
                if (!((SASLibrary)this.m_library.getDeployedDataPackage()).getUsingPackages().contains((Object)directory)) continue;
                sourceDataList.remove(directory);
                if (targetDataList.contains(directory)) continue;
                targetDataList.add(directory);
            }
            for (int tIndex = 0; tIndex < targetDataList.size(); ++tIndex) {
                Directory dir = (Directory)targetDataList.get(tIndex);
                if (this.isHTTPBasePath(dir)) continue;
                targetDataList.remove(dir);
                --tIndex;
            }
            List sortedSourceDataList = SortUtil.sortAscending(sourceDataList);
            if (sortedSourceDataList != null) {
                sourceDataList = sortedSourceDataList;
            }
            sourceModel = new DefaultListModel();
            for (index = 0; index < sourceDataList.size(); ++index) {
                sourceModel.add(index, sourceDataList.get(index));
            }
            this.m_lstPath.setModel(sourceModel);
            targetModel = new DefaultListModel();
            for (index = 0; index < targetDataList.size(); ++index) {
                targetModel.add(index, targetDataList.get(index));
            }
            this.m_lstPath.setTargetModel(targetModel);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    protected void onListSelectionChanged() {
        Object[] selectedValuesArray = new Object[]{};
        JList sourceList = (JList)this.m_lstPath.getSourceComponent();
        JList targetList = (JList)this.m_lstPath.getTargetComponent();
        ListModel sourceListModel = this.m_lstPath.getModel();
        ListModel targetListModel = this.m_lstPath.getTargetModel();
        int sourceIndex = sourceList.getSelectedIndex();
        int targetIndex = targetList.getSelectedIndex();
        try {
            if (sourceIndex != -1 && sourceListModel.getSize() > 0) {
                selectedValuesArray = sourceList.getSelectedValues();
            }
            if (targetIndex != -1 && targetListModel.getSize() > 0) {
                selectedValuesArray = targetList.getSelectedValues();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.m_btnEdit.setEnabled(selectedValuesArray.length == 1 && !this.m_chkEnableDAV.isSelected());
        this.m_btnDelete.setEnabled(selectedValuesArray.length >= 1 && !this.m_chkEnableDAV.isSelected());
    }

    protected void onNew() {
        NewLibraryPathDialog dialog = new NewLibraryPathDialog((Dialog)this.getTopLevelAncestor(), this.m_library);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            ListModel sourceListModel = this.m_lstPath.getModel();
            Vector sourceDataList = new Vector();
            for (int i = 0; i < sourceListModel.getSize(); ++i) {
                Object object = sourceListModel.getElementAt(i);
                sourceDataList.add(object);
            }
            ListModel targetListModel = this.m_lstPath.getTargetModel();
            Vector targetDataList = new Vector();
            for (int i = 0; i < targetListModel.getSize(); ++i) {
                Object object = targetListModel.getElementAt(i);
                targetDataList.add(object);
            }
            List newPathList = dialog.getPaths();
            for (int count = 0; count < newPathList.size(); ++count) {
                JList list;
                String strRootName;
                Root root;
                int i;
                String newPath = (String)newPathList.get(count);
                boolean found = false;
                for (i = 0; i < sourceDataList.size(); ++i) {
                    root = (Root)sourceDataList.get(i);
                    strRootName = MetadataObjectCellRenderer.getDisplayName(root);
                    if (!strRootName.equalsIgnoreCase(newPath)) continue;
                    MessageUtil.displayMessage((String)bundle.formatString("SASLibraryPanel.ItemNotAdded.fmt.txt", (Object)newPath), (String)bundle.getString("SASLibraryPanel.ItemNotAddedTitle.txt"), (int)2);
                    list = (JList)this.m_lstPath.getSourceComponent();
                    list.setSelectedValue(root, true);
                    found = true;
                    break;
                }
                if (!found) {
                    for (i = 0; i < targetDataList.size(); ++i) {
                        root = (Root)targetDataList.get(i);
                        strRootName = MetadataObjectCellRenderer.getDisplayName(root);
                        if (!strRootName.equalsIgnoreCase(newPath)) continue;
                        MessageUtil.displayMessage((String)bundle.formatString("SASLibraryPanel.ItemNotAdded.fmt.txt", (Object)newPath), (String)bundle.getString("SASLibraryPanel.ItemNotAddedTitle.txt"), (int)2);
                        list = (JList)this.m_lstPath.getTargetComponent();
                        list.setSelectedValue(root, true);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                try {
                    Directory newDir = (Directory)Workspace.getMdFactory().createComplexMetadataObject(this.m_library.getStore(), (MdStore)null, bundle.getString("SASLibraryPanel.DirectoryObject.PathObjectName.notrans"), "Directory", this.m_library.getDeployedDataPackage().getRepositoryID());
                    newDir.setDirectoryName(newPath);
                    Workspace.getDefaultLogger().debug((Object)("setDirectoryName '" + newPath + "' performed on new Directory ('" + newDir + "', " + newDir.getFQID() + ")"));
                    newDir.setDirectoryRole(bundle.getString("SASLibraryPanel.DirectoryObject.LibraryPathDirectoryRole.notrans"));
                    targetDataList.add(newDir);
                    this.newDirectoryList.add(newDir);
                    DefaultListModel targetModel = new DefaultListModel();
                    for (int index = 0; index < targetDataList.size(); ++index) {
                        targetModel.add(index, targetDataList.get(index));
                    }
                    this.m_lstPath.setTargetModel(targetModel);
                    continue;
                }
                catch (RemoteException re) {
                    String msg = re.getLocalizedMessage();
                    Workspace.getDefaultLogger().error((Object)msg);
                    MessageUtil.displayMessage((String)msg, (int)0);
                }
            }
        }
    }

    protected void onNewDialogGenerated() {
        Prototype prototype = this.m_libraryPrototype;
        String strAssociationName = "UsingPackages";
        if (this.m_chkEnableDAV.isSelected() && this.m_cbxServer.getSelectedItem() instanceof ServerComponent) {
            prototype = this.m_serverPrototype;
            strAssociationName = "DataPackages";
        }
        try {
            PropertyGroup group = prototype.getPrimaryPropertyGroup();
            AssociationList prototypePropertiesList = prototype.getPrototypeProperties();
            for (int ppIndex = 0; ppIndex < prototypePropertiesList.size(); ++ppIndex) {
                AssociationProperty ap;
                PrototypeProperty pp = (PrototypeProperty)prototypePropertiesList.get(ppIndex);
                if (!(pp instanceof AssociationProperty) || !(ap = (AssociationProperty)pp).getAssociationName().equalsIgnoreCase(strAssociationName)) continue;
                String strStoredText = ((TextStore)ap.getStoredConfiguration()).getStoredText();
                strStoredText = this.addOverridingProperties(strStoredText, "ClassParameters");
                AssociationList scList = ap.getCustomizers();
                PropertiesPropertyView view = new PropertiesPropertyView((Root)this.m_library.getDeployedDataPackage(), group, this.m_type, prototype);
                this.add((Component)((Object)view));
                view.onNew((JComponent)this.m_lstPath, ap, strStoredText, (List)scList, (Root)this.m_library.getDeployedDataPackage(), (JPanel)((Object)view));
                this.remove((Component)((Object)view));
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    protected void onEdit() {
        JList sourceList = (JList)this.m_lstPath.getSourceComponent();
        JList targetList = (JList)this.m_lstPath.getTargetComponent();
        ListModel sourceListModel = this.m_lstPath.getModel();
        ListModel targetListModel = this.m_lstPath.getTargetModel();
        Directory dir = null;
        if (sourceList.getSelectedIndex() != -1 && sourceListModel.getSize() > 0) {
            dir = (Directory)sourceList.getSelectedValue();
        }
        if (targetList.getSelectedIndex() != -1 && targetListModel.getSize() > 0) {
            dir = (Directory)targetList.getSelectedValue();
        }
        if (dir != null) {
            try {
                Directory directory = null;
                Map deletedObjectsMap = this.m_library.getStore().getDeletedObjects();
                if (deletedObjectsMap.containsKey(dir.getFQID())) {
                    directory = dir;
                } else {
                    directory = dir;
                    String strTemplate = "<TEMPLATES><Directory><UsedByPackages/><Files/></Directory></TEMPLATES>";
                    int flags = 24845;
                    directory = (Directory)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)directory, new Vector(), new Vector(), strTemplate, flags);
                }
                int numPackages = directory.getUsedByPackages().size();
                if (numPackages == 1 && !((SASLibrary)directory.getUsedByPackages().get(0)).getFQID().equals(this.m_library.getDeployedDataPackage().getFQID()) || numPackages > 1 || directory.getFiles().size() > 0) {
                    Object[] options = new Object[]{MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")), MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.No.txt"))};
                    String strMessage = bundle.getString("PropertiesPropertyView.EditWarning.txt");
                    String strTitle = bundle.getString("Common.Warning.txt");
                    int returnValue = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), strMessage, strTitle, -1, 2, null, options, options[1]);
                    if (returnValue != 0) {
                        return;
                    }
                }
                String path = dir.getDirectoryName();
                EditLibraryPathDialog dialog = new EditLibraryPathDialog((Dialog)this.getTopLevelAncestor(), path);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    Object object;
                    int i;
                    String newPath = dialog.getPath();
                    if (newPath.equalsIgnoreCase(path)) {
                        return;
                    }
                    Vector dataList = new Vector();
                    for (i = 0; i < sourceListModel.getSize(); ++i) {
                        object = sourceListModel.getElementAt(i);
                        dataList.add(object);
                    }
                    for (i = 0; i < targetListModel.getSize(); ++i) {
                        object = targetListModel.getElementAt(i);
                        dataList.add(object);
                    }
                    for (i = 0; i < dataList.size(); ++i) {
                        Root root = (Root)dataList.get(i);
                        String strRootName = MetadataObjectCellRenderer.getDisplayName(root);
                        if (!strRootName.equalsIgnoreCase(newPath)) continue;
                        MessageUtil.displayMessage((String)bundle.formatString("SASLibraryPanel.ItemNotAdded.fmt.txt", (Object)newPath), (String)bundle.getString("SASLibraryPanel.ItemNotAddedTitle.txt"), (int)2);
                        return;
                    }
                    dir.setDirectoryName(newPath);
                    Workspace.getDefaultLogger().debug((Object)("setDirectoryName '" + newPath + "' performed on existing Directory ('" + dir + "', " + dir.getFQID() + ")"));
                    this.m_lstPath.repaint();
                    this.m_lstPath.invalidate();
                    this.m_lstPath.revalidate();
                }
            }
            catch (MdException mdex) {
                Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
                MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
                return;
            }
            catch (RemoteException re) {
                String msg = re.getLocalizedMessage();
                Workspace.getDefaultLogger().error((Object)msg);
                MessageUtil.displayMessage((String)msg, (int)0);
                return;
            }
        }
    }

    protected void onEditDialogGenerated() {
        Prototype prototype = this.m_libraryPrototype;
        String strAssociationName = "UsingPackages";
        if (this.m_chkEnableDAV.isSelected() && this.m_cbxServer.getSelectedItem() instanceof ServerComponent) {
            prototype = this.m_serverPrototype;
            strAssociationName = "DataPackages";
        }
        try {
            PropertyGroup group = prototype.getPrimaryPropertyGroup();
            AssociationList prototypePropertiesList = prototype.getPrototypeProperties();
            for (int ppIndex = 0; ppIndex < prototypePropertiesList.size(); ++ppIndex) {
                AssociationProperty ap;
                PrototypeProperty pp = (PrototypeProperty)prototypePropertiesList.get(ppIndex);
                if (!(pp instanceof AssociationProperty) || !(ap = (AssociationProperty)pp).getAssociationName().equalsIgnoreCase(strAssociationName)) continue;
                String strStoredText = ((TextStore)ap.getStoredConfiguration()).getStoredText();
                strStoredText = this.addOverridingProperties(strStoredText, "EditClassParameters");
                AssociationList scList = ap.getCustomizers();
                PropertiesPropertyView view = new PropertiesPropertyView((Root)this.m_library.getDeployedDataPackage(), group, this.m_type, prototype);
                this.add((Component)((Object)view));
                view.onEdit((JComponent)this.m_lstPath, ap, strStoredText, (List)scList, (JPanel)((Object)view));
                this.remove((Component)((Object)view));
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    protected void onDelete() {
        Prototype prototype = this.m_libraryPrototype;
        if (this.m_chkEnableDAV.isSelected() && this.m_cbxServer.getSelectedItem() instanceof ServerComponent) {
            prototype = this.m_serverPrototype;
        }
        try {
            PropertyGroup group = prototype.getPrimaryPropertyGroup();
            PropertiesPropertyView view = new PropertiesPropertyView((Root)this.m_library.getDeployedDataPackage(), group, this.m_type, prototype);
            this.add((Component)((Object)view));
            view.onDelete((JComponent)this.m_lstPath, (JPanel)((Object)view));
            this.remove((Component)((Object)view));
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    protected void onAdvanced() {
        try {
            PropertyGroup group = this.m_libraryPrototype.getPrimaryPropertyGroup();
            AssociationList subgroupsList = group.getSubpropertyGroups();
            for (int sgIndex = 0; sgIndex < subgroupsList.size(); ++sgIndex) {
                PropertyGroup subgroup = (PropertyGroup)subgroupsList.get(sgIndex);
                if (PrototypeUtil.isGroupEntirelyExpert(subgroup)) continue;
                subgroupsList.remove(subgroup);
                --sgIndex;
            }
            PropertiesPropertyView view = new PropertiesPropertyView((Root)this.m_library.getDeployedDataPackage(), group, this.m_type, this.m_libraryPrototype);
            this.add((Component)((Object)view));
            view.onAdvanced((List)subgroupsList);
            this.remove((Component)((Object)view));
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public Component getDefaultFocusComponent() {
        return this.m_defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component component) {
        this.m_defaultFocusComponent = component;
        component.requestFocusInWindow();
    }

    private boolean _isLibrefChar(char ch, boolean bIsFirstChar) {
        String strChar = String.valueOf(ch);
        Byte byteChar = new Byte(strChar.getBytes()[0]);
        int asciiValue = byteChar.intValue();
        boolean bIsLibrefChar = false;
        if (asciiValue >= 65 && asciiValue <= 90) {
            bIsLibrefChar = true;
        } else if (asciiValue >= 97 && asciiValue <= 122) {
            bIsLibrefChar = true;
        } else if (asciiValue == 95) {
            bIsLibrefChar = true;
        } else if (asciiValue >= 48 && asciiValue <= 57 && !bIsFirstChar) {
            bIsLibrefChar = true;
        }
        return bIsLibrefChar;
    }

    private String addOverridingProperties(String strStoredText, String strElementName) {
        String strAppendedText = strStoredText;
        try {
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strStoredText);
            String strNodeText = "<Parm Name=\"_Properties_\" ><MetadataType><Type Name=\"Directory\" ><Properties><Property PropertyName=\"SupportsWebDAV\" IsUpdateable=\"0\" DefaultValue=\"1\" /></Properties></Type></MetadataType></Parm>";
            Document newDoc = Workspace.getMdFactory().getOMIUtil().parseXML(strNodeText);
            Element element = newDoc.getDocumentElement();
            Node node = doc.importNode(element, true);
            this.addNode(doc, node, strElementName);
            strAppendedText = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return strAppendedText;
    }

    private void addNode(Node node, Node nodeToAdd, String strElementName) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.addNode(children.item(childIndex), nodeToAdd, strElementName);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equalsIgnoreCase(strElementName)) {
                    if (strElementName.equalsIgnoreCase("ClassParameters")) {
                        node.appendChild(nodeToAdd);
                        break;
                    }
                    if (!strElementName.equalsIgnoreCase("EditClassParameters")) break;
                    Node removedNode = null;
                    NodeList childNodeList = node.getChildNodes();
                    for (int childNodeIndex = childNodeList.getLength() - 1; childNodeIndex >= 0; --childNodeIndex) {
                        Node childNode = childNodeList.item(childNodeIndex);
                        if (childNode.getNodeType() != 1) continue;
                        removedNode = node.removeChild(childNode);
                        break;
                    }
                    node.appendChild(nodeToAdd);
                    if (removedNode == null) break;
                    node.appendChild(removedNode);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.addNode(children.item(childIndex), nodeToAdd, strElementName);
                }
                break;
            }
        }
    }

    private List populateDirectoryList() {
        List dirList = new Vector();
        try {
            String strTemplate = "<TEMPLATES><Directory><UsedByPackages/><Files/></Directory></TEMPLATES>";
            String strSelect = "<XMLSELECT search=\"*[@DirectoryRole='" + bundle.getString("SASLibraryPanel.DirectoryObject.LibraryPathDirectoryRole.notrans") + "']\"/>";
            String strOptions = strTemplate + strSelect;
            int flags = 8604;
            dirList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_library.getDeployedDataPackage().getObjectStore(), this.m_library.getContext(), "Directory", flags, strOptions);
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            Workspace.getDefaultLogger().error((Object)msg);
            MessageUtil.displayMessage((String)msg, (int)0);
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
        }
        return dirList;
    }

    private void removeDir(Directory dir) {
        try {
            MdObjectStore oStore = (MdObjectStore)this.m_library.getDeployedDataPackage().getObjectStore();
            if (dir.getId().indexOf(36) != -1) {
                Vector<Object> objectsToRemoveList = new Vector<Object>();
                objectsToRemoveList.add(dir);
                AssociationList propList = dir.getProperties();
                for (int propIndex = 0; propIndex < propList.size(); ++propIndex) {
                    Property prop = (Property)propList.get(propIndex);
                    objectsToRemoveList.add(prop);
                    PropertyType propType = prop.getOwningType();
                    if (propType == null) continue;
                    objectsToRemoveList.add(propType);
                    TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                    if (propTypeText == null) continue;
                    objectsToRemoveList.add(propTypeText);
                }
                oStore.removeObjectsFromStore(objectsToRemoveList);
                Workspace.getDefaultLogger().debug((Object)("removed Directory '" + MetadataObjectCellRenderer.getDisplayName((Root)dir) + "' ('" + dir + "', " + dir.getFQID() + ") and its properties from objectStore"));
            } else {
                String strTemplate = "<TEMPLATES><" + dir.getCMetadataType() + "><Properties/></" + dir.getCMetadataType() + "><Property><Customizers/><Extensions/><OwningType/><StoredConfiguration/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
                oStore.removeObjectFromStore((CMetadata)dir, strTemplate);
                Workspace.getDefaultLogger().debug((Object)("removed Directory '" + MetadataObjectCellRenderer.getDisplayName((Root)dir) + "' ('" + dir + "', " + dir.getFQID() + ") and its properties from objectStore"));
            }
            this.scheduledToBeDeletedDirectoryList.add(dir);
        }
        catch (MdException mdex) {
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
        }
        catch (RemoteException rex) {
            Workspace.getDefaultLogger().error((Object)rex.getLocalizedMessage());
        }
    }

    protected void initialize() {
        try {
            this.m_lblLibref = new JLabel(bundle.getString("SASLibraryPanel.Libref.txt"));
            this.m_txtLibref = new WATextField();
            this.m_lblLibref.setLabelFor((Component)this.m_txtLibref);
            this.m_txtLibref.setMaxCharacters(((SASLibrary)this.m_library.getDeployedDataPackage()).getLibrefMaxLength());
            this.m_lblEngine = new JLabel(bundle.getString("SASLibraryPanel.Engine.txt"));
            this.m_txtEngine = new WATextField();
            this.m_txtEngine.setEnabled(false);
            this.m_cbxEngine = new WAComboBox();
            this.m_chkEnableDAV = new JCheckBox(bundle.getString("SASLibraryPanel.EnableDAV.txt"));
            this.m_chkEnableDAV.setSelected(false);
            this.m_chkEnableDAV.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SASLibraryPanel.this.onEnableDAV();
                }
            });
            this.m_lblServer = new JLabel(bundle.getString("SASLibraryPanel.Server.txt"));
            this.m_cbxServer = new WAComboBox();
            this.m_lblServer.setLabelFor((Component)this.m_cbxServer);
            this.m_cbxServer.setRenderer((ListCellRenderer)new MetadataObjectCellRenderer());
            this.m_cbxServer.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    SASLibraryPanel.this.onServerChanged();
                }
            });
            this.m_lblPath = new JLabel(bundle.getString("SASLibraryPanel.Path.txt"));
            this.m_lstPath = new DualListSelector();
            this.m_lblPath.setLabelFor((Component)this.m_lstPath);
            ((JList)this.m_lstPath.getSourceComponent()).setFixedCellHeight(this.getFontMetrics(this.getFont()).getHeight());
            ((JList)this.m_lstPath.getTargetComponent()).setFixedCellHeight(this.getFontMetrics(this.getFont()).getHeight());
            this.m_lstPath.setSourceCellRenderer((ListCellRenderer)new MetadataObjectCellRenderer());
            this.m_lstPath.setTargetCellRenderer((ListCellRenderer)new MetadataObjectCellRenderer());
            this.m_lstPath.setSourceLabel(bundle.getString("PropertiesPropertyView.Label.AvailableItems.txt"));
            this.m_lstPath.setTargetLabel(bundle.getString("PropertiesPropertyView.Label.SelectedItems.txt"));
            this.m_lstPath.getSourceComponent().getAccessibleContext().setAccessibleName(bundle.getString("SASLibraryPanel.Label.AvailableItemsAccessibilityLabel.txt"));
            this.m_lstPath.getTargetComponent().getAccessibleContext().setAccessibleName(bundle.getString("SASLibraryPanel.Label.SelectedItemsAccessibilityLabel.txt"));
            ((JList)this.m_lstPath.getSourceComponent()).addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    SASLibraryPanel.this.onListSelectionChanged();
                }
            });
            ((JList)this.m_lstPath.getTargetComponent()).addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    SASLibraryPanel.this.onListSelectionChanged();
                }
            });
            this.m_lstPath.setTargetControlsVisible(true);
            Dimension newDim = new Dimension(250, 122);
            this.m_lstPath.setPreferredSize(newDim);
            this.m_lstPath.setMinimumSize(newDim);
            this.m_btnNew = new JButton();
            MnemonicModel.setButtonTextAndMnemonic(this.m_btnNew, bundle.getString("Common.New....txt"));
            this.m_btnNew.setEnabled(false);
            this.m_btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (SASLibraryPanel.this.m_chkEnableDAV.isSelected()) {
                        SASLibraryPanel.this.onNewDialogGenerated();
                    } else {
                        SASLibraryPanel.this.onNew();
                    }
                }
            });
            this.m_btnEdit = new JButton(bundle.getString("Common.Edit....txt"));
            this.m_btnEdit.setEnabled(false);
            this.m_btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (SASLibraryPanel.this.m_chkEnableDAV.isSelected()) {
                        SASLibraryPanel.this.onEditDialogGenerated();
                    } else {
                        SASLibraryPanel.this.onEdit();
                    }
                }
            });
            this.m_btnDelete = new JButton(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Delete.txt")));
            this.m_btnDelete.setEnabled(false);
            this.m_btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SASLibraryPanel.this.onDelete();
                }
            });
            this.globalDirectoryList = this.populateDirectoryList();
            this.newDirectoryList = new Vector();
            this.scheduledToBeDeletedDirectoryList = new Vector();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(6, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblLibref, gbc);
        this.add(this.m_lblLibref);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtLibref, gbc);
        this.add((Component)this.m_txtLibref);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblEngine, gbc);
        this.add(this.m_lblEngine);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        if (this.m_bShowDAV) {
            gridBagLayout.setConstraints((Component)this.m_cbxEngine, gbc);
            this.add((Component)this.m_cbxEngine);
            this.m_lblEngine.setLabelFor((Component)this.m_cbxEngine);
        } else {
            gridBagLayout.setConstraints((Component)this.m_txtEngine, gbc);
            this.add((Component)this.m_txtEngine);
            this.m_lblEngine.setLabelFor((Component)this.m_txtEngine);
        }
        ++gridy;
        if (this.m_bShowDAV) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(20, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_chkEnableDAV, gbc);
            this.add(this.m_chkEnableDAV);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.insets = new Insets(6, 27, 0, 0);
            gridBagLayout.setConstraints(this.m_lblServer, gbc);
            this.add(this.m_lblServer);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(6, 12, 0, 12);
            gridBagLayout.setConstraints((Component)this.m_cbxServer, gbc);
            this.add((Component)this.m_cbxServer);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.insets = new Insets(20, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblPath, gbc);
        this.add(this.m_lblPath);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(20, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_lstPath, gbc);
        this.add((Component)this.m_lstPath);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 0));
        buttonPanel.add(this.m_btnNew);
        buttonPanel.add(this.m_btnEdit);
        buttonPanel.add(this.m_btnDelete);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(buttonPanel, gbc);
        this.add(buttonPanel);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

