/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import com.sas.workspace.visuals.PrototypeSelector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SASAppServerTypeView
extends WsDescriptionWizardTab {
    protected Server m_server;
    protected LogicalServer m_logicalServer;
    protected ServiceType m_serviceType;
    protected int m_type;
    protected PrototypeSelector m_selector;
    protected JTree m_tree;
    protected JScrollPane m_treePane;
    protected Vector m_dataList;
    protected boolean m_bTreeBuilt = false;
    protected Prototype m_prototype;
    protected List m_displayedPrototypeList;
    protected Prototype m_serverComponentPrototype;
    protected String m_strClassID;
    protected List m_prototypesList;
    protected HashMap m_nameIDMap;
    protected MdObjectStore m_store;
    private static final long serialVersionUID = 8625364806496377354L;
    protected static final WAdminResource bundle = new WAdminResource(SASAppServerTypeView.class);

    public SASAppServerTypeView(Server server, int type) {
        super(bundle.getString("SASAppServerTypeView.WizardTitle.txt"));
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public SASAppServerTypeView(Server server, int type, MdObjectStore oStore) {
        super(bundle.getString("SASAppServerTypeView.WizardTitle.txt"));
        this.m_server = server;
        this.m_type = type;
        this.m_store = oStore;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
                if (this.m_type == 0) {
                    Map deletedObjectsMap;
                    WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                    this.m_prototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
                    this._buildTree();
                    if (this.m_logicalServer != null && (deletedObjectsMap = ((MdObjectStore)this.m_logicalServer.getObjectStore()).getDeletedObjects()).containsKey(this.m_logicalServer.getFQID())) {
                        this.m_logicalServer = null;
                    }
                }
                if (this.m_type == 1) {
                    try {
                        this.m_prototype = this.m_server.getDeployedComponentPrototype(this.getTopLevelAncestor());
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                this.m_tree.setSelectionRow(0);
                this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
            }
            return false;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return false;
        }
    }

    public boolean validateData() {
        boolean bValid = false;
        Object nodeType = this.m_tree.getLastSelectedPathComponent();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeType;
        if (node != null) {
            bValid = node.isLeaf();
        }
        if (!bValid) {
            Container parent = this.getTopLevelAncestor();
            JOptionPane.showMessageDialog(parent, bundle.getString("ServerTypePropertyView.TypeRequired.Server.txt"), bundle.getString("Common.RequiredField.txt"), 0);
        }
        return bValid;
    }

    public void onNext() {
        try {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            boolean b_usingBatchServer = false;
            Vector<String> namesList = new Vector<String>();
            TreePath[] pathArray = this.m_tree.getSelectionPaths();
            for (int i = 0; pathArray != null && i < pathArray.length; ++i) {
                TreePath path = pathArray[i];
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!node.isLeaf()) continue;
                namesList.add(node.toString());
            }
            Vector<LogicalServer> logicalServerList = new Vector<LogicalServer>();
            for (int i = 0; i < namesList.size(); ++i) {
                Server childServer;
                String strName = (String)namesList.get(i);
                ServerContext serverContext = (ServerContext)this.m_server.getDeployedComponent();
                if (this.m_logicalServer == null) {
                    this.m_logicalServer = (LogicalServer)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, serverContext.getName() + " - " + bundle.formatString("SASAppServerTypeView.LogicalServerIdentifierName.Logical.fmt.txt", (Object)strName), "LogicalServer", this.m_server.getContext().substring(9), null);
                }
                this.m_logicalServer.setName(serverContext.getName() + " - " + bundle.formatString("SASAppServerTypeView.LogicalServerIdentifierName.Logical.fmt.txt", (Object)strName), 1);
                this.m_logicalServer.setClassIdentifier((String)this.m_nameIDMap.get(strName), 1);
                for (int j = 0; j < this.m_displayedPrototypeList.size(); ++j) {
                    Prototype prototype = (Prototype)this.m_displayedPrototypeList.get(j);
                    if (!PrototypeUtil.getDisplayString(prototype.getName(), prototype).equals(strName)) continue;
                    try {
                        Server logServer = new Server((MdObjectStore)this.m_logicalServer.getObjectStore(), this.m_server.getContext(), (DeployedComponent)this.m_logicalServer);
                        Prototype logPrototype = logServer.getDeployedComponentPrototype(this.getTopLevelAncestor());
                        this.m_logicalServer.setUsingPrototype((Root)logPrototype);
                        ServerWizard.setDefaultLogicalServerProperties(this.m_logicalServer, logPrototype, this.m_server.getContext());
                        parent.replaceWizardData("LogicalServer", (Object)this.m_logicalServer);
                        parent.addWizardData("DeployedComponentPrototype", (Object)prototype);
                        AssociationList propertiesList = prototype.getPrototypeProperties();
                        for (int pIndex = 0; pIndex < propertiesList.size(); ++pIndex) {
                            String strClassID;
                            AttributeProperty ap;
                            AbstractProperty property = (AbstractProperty)propertiesList.get(pIndex);
                            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) continue;
                            this.m_strClassID = strClassID = ap.getDefaultValue();
                            break;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    this.m_serverComponentPrototype = prototype;
                    break;
                }
                if ((childServer = (Server)parent.getWizardData("ChildServer")) != null) {
                    MdObjectStore store = childServer.getStore();
                    ServerComponent sc = (ServerComponent)childServer.getDeployedComponent();
                    Map deletedObjectsMap = store.getDeletedObjects();
                    if (deletedObjectsMap.containsKey(sc.getFQID())) {
                        sc = (ServerComponent)Workspace.getMdFactory().createComplexMetadataObject(store, null, bundle.getString("Server.ServerIdentifierName.Server.txt"), "ServerComponent", childServer.getContext().substring(9), null);
                        childServer.setDeployedComponent((DeployedComponent)sc);
                    }
                }
                if (this.m_strClassID != null && (this.m_strClassID.equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c") || this.m_strClassID.equalsIgnoreCase("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8") || this.m_strClassID.equalsIgnoreCase("0069e914-b58c-4094-a686-a87df433ec4b") || this.m_strClassID.equalsIgnoreCase("a1ff485f-9e44-4c82-90b5-062916cfa9b9") || this.m_strClassID.equalsIgnoreCase("D7E796B4-654C-4ab3-B690-657EE79309FB"))) {
                    b_usingBatchServer = true;
                    Server server = (Server)parent.getWizardData("Server");
                    Vector<DeployedComponent> dcsToRemoveList = new Vector<DeployedComponent>();
                    dcsToRemoveList.add(childServer.getDeployedComponent());
                    for (int dcIndex = 0; dcIndex < dcsToRemoveList.size(); ++dcIndex) {
                        DeployedComponent dc = (DeployedComponent)dcsToRemoveList.get(dcIndex);
                        ServerComponent sc = (ServerComponent)dc;
                        try {
                            Vector<Object> objectsToRemoveList = new Vector<Object>();
                            AssociationList propList = sc.getProperties();
                            for (int propIndex = 0; propIndex < propList.size(); ++propIndex) {
                                Property prop = (Property)propList.get(propIndex);
                                objectsToRemoveList.add(prop);
                                PropertyType propType = prop.getOwningType();
                                if (propType == null) continue;
                                objectsToRemoveList.add(propType);
                                TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                if (propTypeText == null) continue;
                                objectsToRemoveList.add(propTypeText);
                            }
                            AssociationList scServiceTypesList = sc.getServiceTypes();
                            for (int sTypeIndex = 0; sTypeIndex < scServiceTypesList.size(); ++sTypeIndex) {
                                ServiceType sType = (ServiceType)scServiceTypesList.get(sTypeIndex);
                                objectsToRemoveList.add(sType);
                            }
                            ((MdObjectStore)dc.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                            continue;
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            continue;
                        }
                        catch (RemoteException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (this.m_serverComponentPrototype != null) {
                        childServer.getDeployedComponent().setName(server.getDeployedComponent().getName() + " - " + PrototypeUtil.getDisplayString(this.m_serverComponentPrototype.getName(), this.m_serverComponentPrototype), 1);
                    }
                }
                if (this.m_serviceType == null && !b_usingBatchServer) {
                    this.m_serviceType = (ServiceType)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "Logical IOM Server", "ServiceType", this.m_server.getContext().substring(9), null);
                }
                if (strName.equals(bundle.getString("Common.ServerType.SASCONNECT.txt"))) {
                    this.m_serviceType.setName("Logical SAS CONNECT Server", 1);
                }
                try {
                    if (!b_usingBatchServer) {
                        this.m_logicalServer.getServiceTypes().add((Object)this.m_serviceType);
                    }
                    this.m_logicalServer.getUsedByComponents().add((Object)serverContext);
                    this.m_logicalServer.getUsingComponents().add((Object)childServer.getDeployedComponent());
                    logicalServerList.add(this.m_logicalServer);
                    continue;
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    continue;
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            parent.addWizardData("LogicalServersList", logicalServerList);
            parent.addWizardData("ServerTypesList", namesList);
            this.setConditionState("NEXT");
            if (b_usingBatchServer) {
                this.setConditionState("BATCH");
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onBack() {
        this.m_dataList.removeAllElements();
    }

    protected void _buildTree() {
        try {
            if (this.m_bTreeBuilt) {
                return;
            }
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.m_prototypesList = this.m_server.getLogicalServerComponentPrototypes((Component)parent);
            Vector<Prototype> defaultPrototypesList = new Vector<Prototype>();
            Locale locale = Locale.getDefault();
            Component comp = this.m_server.getParentComponent();
            boolean bIOMserver = false;
            boolean bConnServer = false;
            boolean bMetaServer = false;
            for (int i = 0; i < this.m_prototypesList.size(); ++i) {
                String strClassID;
                AttributeProperty ap;
                AbstractProperty property;
                Prototype prototype;
                boolean bPrototypeFound;
                block58: {
                    bPrototypeFound = false;
                    prototype = (Prototype)this.m_prototypesList.get(i);
                    try {
                        String localeValue;
                        Extension extension;
                        int extIndex;
                        AssociationList extensionList = prototype.getExtensions();
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (!localeValue.equalsIgnoreCase("Generic")) break;
                            defaultPrototypesList.add(prototype);
                            bPrototypeFound = true;
                            break;
                        }
                        if (bPrototypeFound) break block58;
                        for (extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                            extension = (Extension)extensionList.get(extIndex);
                            if (!extension.getName().equals("Locale")) continue;
                            localeValue = extension.getValue();
                            if (localeValue.equalsIgnoreCase("Generic")) {
                                bPrototypeFound = true;
                            }
                            break;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        return;
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                if (!bPrototypeFound) continue;
                List lstAppServerComponentClassIDs = (List)parent.getWizardData("AppServerComponentClassIDs");
                if (lstAppServerComponentClassIDs != null) {
                    try {
                        AssociationList propertiesList = prototype.getPrototypeProperties();
                        boolean bPropertyFound = false;
                        for (int pIndex = 0; pIndex < propertiesList.size(); ++pIndex) {
                            property = (AbstractProperty)propertiesList.get(pIndex);
                            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) continue;
                            strClassID = ap.getDefaultValue();
                            if (lstAppServerComponentClassIDs.contains(strClassID)) break;
                            bPropertyFound = true;
                            break;
                        }
                        if (bPropertyFound) {
                            continue;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                if (!bIOMserver) {
                    if (comp instanceof ServerWizard) {
                        ServerWizard p_Serverwizard = (ServerWizard)((Object)comp);
                        Server parentServer = p_Serverwizard.m_server;
                        if (parentServer.getDeployedComponent().getClassIdentifier().equalsIgnoreCase("IOM Spawner") || Server.isIOMServer(parentServer.getDeployedComponent())) {
                            bIOMserver = true;
                        } else if (parentServer.getDeployedComponent().getClassIdentifier().equalsIgnoreCase("Connect Spawner") || this.m_server.getDeployedComponent().getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) {
                            bConnServer = true;
                        }
                    } else if (comp instanceof LibraryWizard) {
                        LibraryWizard wizard = (LibraryWizard)((Object)comp);
                        Library parentLib = wizard.m_library;
                        if (((SASLibrary)parentLib.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOIME")) {
                            bMetaServer = true;
                        }
                    } else if (comp instanceof WAPropertyDialog) {
                        SASLibrary parentLib;
                        WAPropertyDialog propDialog = (WAPropertyDialog)comp;
                        if (propDialog.getMetadataObject() instanceof ServerComponent) {
                            ServerComponent parentComp = (ServerComponent)propDialog.getMetadataObject();
                            if (parentComp.getClassIdentifier().equalsIgnoreCase("IOM Spawner") || Server.isIOMServer((DeployedComponent)parentComp)) {
                                bIOMserver = true;
                            } else if (parentComp.getClassIdentifier().equalsIgnoreCase("Connect Spawner") || parentComp.getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) {
                                bConnServer = true;
                            }
                        }
                        if (propDialog.getMetadataObject() instanceof SASLibrary && (parentLib = (SASLibrary)propDialog.getMetadataObject()).getEngine().equalsIgnoreCase("SASIOIME")) {
                            bMetaServer = true;
                        }
                        if (propDialog.getMetadataObject() instanceof DatabaseSchema) {
                            DatabaseSchema schema = (DatabaseSchema)propDialog.getMetadataObject();
                            try {
                                if (((ServerComponent)schema.getDeployedComponents().get(0)).getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
                                    bMetaServer = true;
                                }
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            }
                            catch (RemoteException exc) {
                                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                            }
                        }
                    }
                }
                if (bMetaServer) {
                    try {
                        AssociationList propertiesList = prototype.getPrototypeProperties();
                        boolean bPropertyFound = false;
                        for (int pIndex = 0; pIndex < propertiesList.size(); ++pIndex) {
                            property = (AbstractProperty)propertiesList.get(pIndex);
                            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) continue;
                            strClassID = ap.getDefaultValue();
                            if (strClassID.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) break;
                            bPropertyFound = true;
                            break;
                        }
                        if (bPropertyFound) {
                            continue;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                if (bIOMserver) {
                    try {
                        AssociationList propertiesList = prototype.getPrototypeProperties();
                        boolean bPropertyFound = false;
                        for (int pIndex = 0; pIndex < propertiesList.size(); ++pIndex) {
                            property = (AbstractProperty)propertiesList.get(pIndex);
                            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) continue;
                            strClassID = ap.getDefaultValue();
                            if (!strClassID.equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c") && !strClassID.equalsIgnoreCase("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8") && !strClassID.equalsIgnoreCase("0069e914-b58c-4094-a686-a87df433ec4b") && !strClassID.equalsIgnoreCase("a1ff485f-9e44-4c82-90b5-062916cfa9b9") && !strClassID.equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06") && !strClassID.equalsIgnoreCase("D7E796B4-654C-4ab3-B690-657EE79309FB") && !strClassID.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836") && !strClassID.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) break;
                            bPropertyFound = true;
                            break;
                        }
                        if (bPropertyFound) {
                            continue;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                if (bConnServer) {
                    try {
                        AssociationList propertiesList = prototype.getPrototypeProperties();
                        boolean bPropertyFound = false;
                        for (int pIndex = 0; pIndex < propertiesList.size(); ++pIndex) {
                            property = (AbstractProperty)propertiesList.get(pIndex);
                            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) continue;
                            strClassID = ap.getDefaultValue();
                            if (strClassID.equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) break;
                            bPropertyFound = true;
                            break;
                        }
                        if (bPropertyFound) {
                            continue;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                }
                this.m_dataList.add(PrototypeUtil.getDisplayString(prototype.getName(), prototype));
                this.m_displayedPrototypeList.add(prototype);
                this._addPrototypeToTree(prototype);
            }
            if (this.m_dataList.isEmpty() && !locale.equals(PrototypeUtil.getLocale("en_US"))) {
                for (int dpIndex = 0; dpIndex < defaultPrototypesList.size(); ++dpIndex) {
                    Prototype dPrototype = (Prototype)defaultPrototypesList.get(dpIndex);
                    this.m_dataList.add(PrototypeUtil.getDisplayString(dPrototype.getName(), dPrototype));
                    this.m_displayedPrototypeList.add(dPrototype);
                    this._addPrototypeToTree(dPrototype);
                }
            }
            this.m_bTreeBuilt = true;
            int rowCount = 0;
            while (rowCount != this.m_tree.getRowCount()) {
                for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
                    this.m_tree.expandRow(i);
                }
                rowCount = this.m_tree.getRowCount();
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void _addPrototypeToTree(Prototype prototype) {
        try {
            String strName = PrototypeUtil.getDisplayString(prototype.getName(), prototype);
            String strDesc = PrototypeUtil.getDisplayString(prototype.getDesc(), prototype);
            this.m_selector.buildTree(strName, strDesc);
            AssociationList propertiesList = prototype.getPrototypeProperties();
            for (int j = 0; j < propertiesList.size(); ++j) {
                AttributeProperty ap;
                AbstractProperty property = (AbstractProperty)propertiesList.get(j);
                if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ClassIdentifier")) continue;
                if (!this.m_nameIDMap.containsKey(strName)) {
                    this.m_nameIDMap.put(strName, ap.getDefaultValue());
                }
                break;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            return;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void _initialize() {
        this.setHelpProduct("newserver");
        this.setHelpTopic("servwiz_4");
        this.m_nameIDMap = new HashMap();
        this.m_dataList = new Vector();
        this.m_displayedPrototypeList = new Vector();
        this.m_selector = this.m_store != null ? new PrototypeSelector(bundle.getString("Common.ServerCategory.SASApplicationServers.txt"), this.m_store) : new PrototypeSelector(bundle.getString("Common.ServerCategory.SASApplicationServers.txt"));
        this.m_tree = this.m_selector.getTree();
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_treePane = new JScrollPane(this.m_tree, 20, 30);
        this.m_treePane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_treePane.setMinimumSize(new Dimension(400, 350));
        this.m_treePane.setPreferredSize(new Dimension(400, 350));
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_treePane, gbc);
        this.add(this.m_treePane);
    }
}

