/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsTable;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainsTableModel;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RmvAuthDomainTableAction
extends AbstractAction
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(RmvAuthDomainTableAction.class);
    protected int m_rmvsCompleted = 0;
    protected AuthenticationDomainsTableModel m_authDomainTableModel = null;
    protected WsTable m_table = null;
    protected ISecurity_1_1 m_iSecurity;

    public RmvAuthDomainTableAction(WsTable table, ISecurity_1_1 iSecurity) {
        this.m_table = table;
        this.m_authDomainTableModel = (AuthenticationDomainsTableModel)((Object)this.m_table.getModel());
        this.m_iSecurity = iSecurity;
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.enableBasedOnSelection(this.m_table.getSelectionModel());
        MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("RmvAuthDomainTableAction.Name.txt"), null, null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int i;
        String prompt;
        int response;
        int index;
        if (this.m_table.getSelectedRowCount() < 1) {
            return;
        }
        String msgTitle = bundle.getString("RmvAuthDomainsTableAction.ConfirmationTitle.txt");
        boolean hasLogins = false;
        boolean hasServerConnections = false;
        int[] slctRows = this.m_table.getSelectedRows();
        for (int i2 = 0; i2 < slctRows.length; ++i2) {
            index = this.m_table.convertRowIndexToModel(slctRows[i2]);
            AuthenticationDomain domain = this.m_authDomainTableModel.getObjectAt(index);
            if (this.haveAssociationsInDomain(domain, "Logins")) {
                hasLogins = true;
            }
            if (this.haveAssociationsInDomain(domain, "Connections")) {
                hasServerConnections = true;
            }
            if (hasLogins && hasServerConnections) break;
        }
        if (hasLogins || hasServerConnections ? (hasLogins && hasServerConnections ? (response = MessageUtil.displayMessage((String)(prompt = bundle.getString("RmvAuthDomainsTableAction.DeleteDomains.LoginsAndServersDefined.ConfirmationPrompt.txt")), (String)msgTitle, (int)2, (int)0)) == 1 : (hasLogins ? (response = MessageUtil.displayMessage((String)(prompt = bundle.getString("RmvAuthDomainsTableAction.DeleteDomains.LoginsDefined.ConfirmationPrompt.txt")), (String)msgTitle, (int)2, (int)0)) == 1 : hasServerConnections && (response = MessageUtil.displayMessage((String)(prompt = bundle.getString("RmvAuthDomainsTableAction.DeleteDomains.ServerDefined.ConfirmationPrompt.txt")), (String)msgTitle, (int)2, (int)0)) == 1)) : (response = MessageUtil.displayMessage((String)(prompt = bundle.getString("RmvAuthDomainsTableAction.ConfirmationPrompt.txt")), (String)msgTitle, (int)2, (int)0)) != 0) {
            return;
        }
        ArrayList<Integer> indcList = new ArrayList<Integer>(slctRows.length);
        for (i = 0; i < slctRows.length; ++i) {
            index = this.m_table.convertRowIndexToModel(slctRows[i]);
            indcList.add(new Integer(index));
        }
        Collections.sort(indcList);
        for (i = indcList.size() - 1; i >= 0; --i) {
            int modelIndx = (Integer)indcList.get(i);
            this.m_authDomainTableModel.removeTableItem(modelIndx);
        }
    }

    protected void enableBasedOnSelection(ListSelectionModel lsm) {
        if (lsm.isSelectionEmpty()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        this.enableBasedOnSelection(lsm);
    }

    public boolean haveAssociationsInDomain(AuthenticationDomain domain, String associationType) {
        VariableArray2dOfStringHolder iAssociatedObjects = new VariableArray2dOfStringHolder();
        StringBuffer templateBuf = new StringBuffer("<GetMetadataObjects><Reposid>A0000001.");
        try {
            templateBuf.append(domain.getFQID().substring(0, 8));
            templateBuf.append("</Reposid>");
            templateBuf.append("<Type>AuthenticationDomain</Type>");
            templateBuf.append("<Objects/>");
            templateBuf.append("<NS>SAS</NS>");
            templateBuf.append("<Flags>");
            templateBuf.append(388);
            templateBuf.append("</Flags>");
            templateBuf.append("<Options>");
            templateBuf.append("<XMLSelect search=\"*[@Id='");
            templateBuf.append(domain.getFQID());
            templateBuf.append("']\"/>");
            templateBuf.append("<Templates>");
            templateBuf.append("<AuthenticationDomain id=\"\" Name=\"\" >");
            templateBuf.append("<" + associationType + "/>");
            templateBuf.append("</AuthenticationDomain>");
            templateBuf.append("</Templates>");
            templateBuf.append("</Options>");
            templateBuf.append("</GetMetadataObjects>");
            String resTemp = templateBuf.toString();
            System.out.println(resTemp);
            this.m_iSecurity.GetAuthorizations("getCountNoSecurity", "", resTemp, associationType, iAssociatedObjects);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (iAssociatedObjects.value != null) {
            int numOfAssociatedObjs = Integer.valueOf(iAssociatedObjects.value[0][1]);
            return numOfAssociatedObjs > 0;
        }
        return false;
    }
}

