/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.Tree;
import com.sas.util.Comparator;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class OLAPSchemaSharedDimensionsTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private OLAPSchema currentOLAPSchema;
    private WsTable sharedDimensionsTable;
    private SharedDimenionsTableModel sharedDimensionsModel;
    private List sharedDimensionsList;
    private static final WAdminResource bundle = new WAdminResource(OLAPSchemaSharedDimensionsTab.class);

    public OLAPSchemaSharedDimensionsTab(CMetadata olapSchema) {
        super(bundle.getString("OLAPSchemaCubeListTab.instruct.txt"));
        this.currentOLAPSchema = (OLAPSchema)olapSchema;
        this.setHelpProduct("olapschemawiz");
        this.setHelpTopic("prop_schema_shared_dim");
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.sharedDimensionsList = null;
            try {
                this.sharedDimensionsList = this.currentOLAPSchema.getDimensions();
                Collections.sort(this.sharedDimensionsList, new ComparableSharedDimension());
                this.sharedDimensionsModel.setSharedDimensions(this.sharedDimensionsList);
                this.sharedDimensionsModel.moveDataToModel();
            }
            catch (MdException MdError) {
                MessageUtil.displayMetadataExceptionMessage((MdException)MdError, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        return true;
    }

    private void _layoutWidgets() {
        this.sharedDimensionsModel = new SharedDimenionsTableModel();
        this.sharedDimensionsTable = new WsTable((WsAbstractTableModel)this.sharedDimensionsModel);
        JLabel nameLabel = new JLabel(bundle.getString("OLAPSchemaSharedDimensionsTab.Label.txt"));
        JScrollPane sharedDimensionsView = new JScrollPane((Component)this.sharedDimensionsTable);
        this.setLayout(new GridBagLayout());
        this.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(sharedDimensionsView, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public class ComparableSharedDimension
    implements Comparator {
        private String name;

        public String toString() {
            return this.name;
        }

        public int compare(Object first, Object second) {
            return first.toString().compareToIgnoreCase(second.toString());
        }
    }

    public class SharedDimenionsTableModel
    extends WsAbstractTableModel {
        private static final int TOTAL_COLS = 2;
        private static final int TOTAL_HIDDEN_COLS = 0;
        private static final int NAME = 0;
        private static final int LOCATION = 1;
        private List sharedDimensions;
        private ArrayList alRow;

        public SharedDimenionsTableModel() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("OLAPSchemaSharedDimensionsTab.name.txt"), 150, 100);
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("OLAPSchemaSharedDimensionsTab.location.txt"), 250, 256);
            this.m_aColumns[1].setEditable(false);
        }

        public int getColumnCount() {
            return 2;
        }

        public int getHiddenColumnCount() {
            return 0;
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public void setSharedDimensions(List sharedDimensionsList) {
            this.sharedDimensions = sharedDimensionsList;
        }

        public void moveDataToModel() throws MdException, RemoteException {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = this.sharedDimensions.size();
            for (int i = 0; i < nRows; ++i) {
                SharedDimension sharedDimension = (SharedDimension)this.sharedDimensions.get(i);
                this.alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                this.alRow.add(0, sharedDimension.getName());
                AssociationList trees = sharedDimension.getTrees();
                if (trees != null) {
                    Tree oTree = (Tree)sharedDimension.getTrees().get(0);
                    String sPath = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)oTree.getObjectStore(), (PrimaryType)oTree, false);
                    this.alRow.add(1, sPath);
                }
                this.m_lData.add(this.alRow);
            }
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }
    }
}

