/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.session.SessionContextInterface;
import com.sas.svcs.metadata.mgmt.client.CustomRepository;
import com.sas.svcs.metadata.mgmt.client.FoundationRepository;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.ProjectRepository;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.client.RepositoryCreationResult;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.Repository;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WizardTabInfo;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.mgmt.visuals.ActionLogger;
import com.sas.workspace.mgmt.visuals.BasicPathOptionsTab;
import com.sas.workspace.mgmt.visuals.GeneralRepositoryPropertyView;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewReposWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected GeneralRepositoryPropertyView nameDescTab = null;
    protected BasicPathOptionsTab pathOptionsTab = null;
    protected WizardFinishTab summaryTab = null;
    protected WizardTabInfo lastTabInfo = null;
    protected WizardTabInfo pathTabInfo = null;
    private static WAdminResource bundle = WAdminResource.getBundle(NewReposWizard.class);
    protected static String defaultTitle = bundle.getString("NewReposWizard.DefaultTitle.txt");
    protected static String nameDescTabTitle = bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Title.txt");
    protected static String pathTabTitle = bundle.getString("NewReposWizard.BasicPathOptionsTab.Title.txt");
    protected static String summaryTabTitle = bundle.getString("NewReposWizard.SummaryTab.Title.txt");
    protected IOMI m_omiConnection;
    protected String m_serverName;
    protected IServer m_server;
    protected com.sas.svcs.metadata.mgmt.client.Repository m_newRepos = null;
    protected Frame m_frame;
    protected String m_type;
    protected String m_repName;
    protected String m_repDesc;
    protected String m_repPath;
    protected String m_repOptions;
    protected String m_repEngine;
    protected boolean m_UserAllowedToCreate = true;
    protected static SessionContextInterface _session = null;
    MetadataRepositoryService repositoryService = null;
    protected Vector m_dependencyList = null;
    protected static OpRequestUI m_pIndicator;
    protected static boolean _initResult;
    List<Logger> _loggers = null;
    private static final String MGMTSVCS_PACKAGE = "com.sas.svcs.metadata.mgmt";

    public NewReposWizard(Frame frame, String title, IOMI omiConnection, IServer server, String serverName, MetadataRepositoryService repositoryService) {
        super(frame, title, true);
        this.setHelpProduct("newrepository");
        this.m_omiConnection = omiConnection;
        this.m_serverName = serverName;
        this.m_server = server;
        this.repositoryService = repositoryService;
        this._initialize();
    }

    public NewReposWizard(Frame frame, IOMI omiConnection, IServer server, String serverName, MetadataRepositoryService repositoryService) {
        this(frame, defaultTitle, omiConnection, server, serverName, repositoryService);
    }

    protected void _initialize() {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        WATransitionWizardModel model = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)model);
        this.nameDescTab = new GeneralRepositoryPropertyView(this.m_omiConnection, 0);
        this.pathOptionsTab = new BasicPathOptionsTab(this.m_serverName);
        this.summaryTab = new WizardFinishTab(bundle.getString("NewReposWizard.SummaryTab.txt"));
        this.nameDescTab.setHelpTopic("reposinfo_2");
        this.pathOptionsTab.setHelpTopic("reposdsources_3");
        this.summaryTab.setHelpProduct("newrepository");
        this.summaryTab.setHelpTopic("cursets_6");
        this.addTab(nameDescTabTitle, "NameDescTab", (WAPropertyTab)this.nameDescTab, "NameDescImage", bundle.getImageIcon("Common.NameDescriptionTab.image"), false);
        this.pathTabInfo = this.addTab(pathTabTitle, "BaseEngineTab", (WAPropertyTab)this.pathOptionsTab, "PathOptionsImage", bundle.getImageIcon("NewReposWizard.PathOptionsTab.image"), false);
        this.lastTabInfo = this.addTab(summaryTabTitle, "SummaryTab", (WAPropertyTab)this.summaryTab, "FinishTab", bundle.getImageIcon("Common.FinishTab.image"), true);
        String[][] Transitions = new String[][]{{"NameDescTab", "NEXT", "BaseEngineTab"}, {"BaseEngineTab", "NEXT", "SummaryTab"}};
        model.addTransitions(Transitions);
        this.addWizardData("Access", bundle.getString("NewReposWizard.RepositoryAccess.Full.txt"));
        this.addWizardData("Name", null);
        this.addWizardData("Description", null);
        this.addWizardData("Engine", null);
        this.addWizardData("Path", null);
        this.addWizardData("Options", null);
        this.addWizardData("Readonly", null);
        this.addWizardData("Server", this.m_serverName);
        this.addWizardData("Connection", this.m_omiConnection);
        this.addWizardData("ChangeManaged", "No");
        this.addWizardData("IdentityForProject", null);
        this.addWizardData("StoreUserDefinitions", null);
        this.addWizardData("PathToUserRootFolder", null);
        this.addWizardData("CreateReposPath", "No");
        String reposType = this.determineRepositoryType();
        try {
            this.m_UserAllowedToCreate = NewReposWizard.isAuthorized(Workspace.getMdFactory(), reposType);
            if (!this.m_UserAllowedToCreate) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.UserNotAuthorized.Error.txt"), (int)0, (int)-1);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0, (int)-1);
            this.m_UserAllowedToCreate = false;
        }
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void onBack() {
        super.onBack();
    }

    protected boolean onFinish() {
        try {
            if (!super.onFinish()) {
                return false;
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            this._loggers = new ArrayList<Logger>();
            this._loggers.add(LogManager.getLogger((String)MGMTSVCS_PACKAGE));
            ActionLogger creationLogger = new ActionLogger("CreateRepository", this._loggers);
            creationLogger.setTimestampsEnabled(true);
            creationLogger.setLogLevel(Level.INFO);
            try {
                creationLogger.open();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.m_type = (String)this.getWizardData("Type");
            if ("Foundation".equalsIgnoreCase(this.m_type)) {
                this.m_newRepos = new FoundationRepository();
            } else if ("Custom".equalsIgnoreCase(this.m_type)) {
                this.m_newRepos = new CustomRepository();
            } else if ("Project".equalsIgnoreCase(this.m_type)) {
                this.m_newRepos = new ProjectRepository();
            }
            if (this.m_newRepos == null) {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                return false;
            }
            this.m_repName = (String)this.getWizardData("Name");
            this.m_repDesc = (String)this.getWizardData("Description");
            this.m_repOptions = (String)this.getWizardData("Options");
            this.m_repEngine = (String)this.getWizardData("Engine");
            this.m_repPath = (String)this.getWizardData("Path");
            this.m_newRepos.setName(this.m_repName);
            this.m_newRepos.setDescription(this.m_repDesc);
            if (this.m_repEngine.equals(bundle.getString("NewReposWizard.GeneralRepositoryPropertyView.Default.txt"))) {
                this.m_newRepos.setEngine("");
            } else {
                this.m_newRepos.setEngine(this.m_repEngine);
            }
            this.m_newRepos.setPath(this.m_repPath);
            this.m_newRepos.setOptions(this.m_repOptions);
            String createDir = (String)this.getWizardData("CreateReposPath");
            String changeManaged = (String)this.getWizardData("ChangeManaged");
            ReturnCode rc = new ReturnCode();
            try {
                String wizardAccess = (String)this.getWizardData("Access");
                if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.Admin.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.ADMIN);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ADMIN);
                } else if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.Full.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.ONLINE);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ONLINE);
                } else if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.None.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.OFFLINE);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ADMIN);
                } else if (wizardAccess.equals(bundle.getString("NewReposWizard.RepositoryAccess.Readonly.txt"))) {
                    this.m_newRepos.setRegisteredAccess(Repository.Access.READONLY);
                    this.m_newRepos.setEffectiveAccess(Repository.Access.ADMIN);
                }
                boolean isChangeMgmt = false;
                if (changeManaged.equalsIgnoreCase("Yes")) {
                    isChangeMgmt = true;
                }
                if (this.m_newRepos instanceof FoundationRepository) {
                    ((FoundationRepository)this.m_newRepos).setChangeManaged(isChangeMgmt);
                } else if (this.m_newRepos instanceof CustomRepository) {
                    ((CustomRepository)this.m_newRepos).setChangeManaged(isChangeMgmt);
                }
                if (createDir.equalsIgnoreCase("Yes")) {
                    this.m_newRepos.setCreateRepositoryPath(true);
                }
                OpRequestUI progressIndicator = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("NewReposWizard.Exec.Desc.txt"), bundle.getString("NewReposWizard.Exec.Title.txt"), bundle.getString("NewReposWizard.Exec.Cancel.txt"));
                progressIndicator.setDelayBeforeProgressCancelDialog(300);
                Dimension indicatorSize = new Dimension(320, 15);
                progressIndicator.setMessagePreferredSize(indicatorSize);
                progressIndicator.execute((Runnable)new ReposCreationRunnable(this.m_newRepos, rc));
                String error = rc.getErrorMessage();
                if (error != null) {
                    throw new Exception(error);
                }
            }
            catch (Exception e) {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                this.showDetailsMessageDialog(creationLogger, rc);
                creationLogger.close();
                creationLogger.deleteLogFile();
                return true;
            }
            MdObjectStore oStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
            if (oStore != null) {
                oStore.dispose();
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            this.showDetailsMessageDialog(creationLogger, rc);
            creationLogger.close();
            creationLogger.deleteLogFile();
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return true;
        }
    }

    protected void showDetailsMessageDialog(ActionLogger creationLogger, ReturnCode rc) {
        int type;
        String msg;
        int status = rc.getReturnCode();
        if (status == 0) {
            msg = bundle.getString("NewReposWizard.RepositoryCreation.txt");
            type = 1;
        } else {
            msg = bundle.getString("NewReposWizard.RepositoryCreation.Error.txt");
            type = 0;
        }
        WATextArea textArea = new WATextArea();
        textArea.setEditable(false);
        textArea.setAutoSelect(false);
        textArea.setMargin(new Insets(5, 5, 5, 5));
        textArea.setBehavior(0);
        Font fnt = textArea.getFont();
        fnt = new Font("Courier", fnt.getStyle(), fnt.getSize());
        textArea.setFont(fnt);
        JScrollPane scrollPane = new JScrollPane((Component)textArea);
        scrollPane.setPreferredSize(new Dimension(600, 350));
        try {
            String details = NewReposWizard.readFile(creationLogger.getLogFileName());
            textArea.setText(details);
            textArea.setCaretPosition(details.length());
        }
        catch (IOException e) {
            textArea.setText(bundle.formatString("NewReposWizard.ReadLogFileFail.txt", (Object)e.getMessage()));
        }
        MessageUtil.displayDetailsMessage((String)msg, (String)bundle.getString("NewReposWizard.DefaultTitle.txt"), (int)type, (int)-1, (JComponent)scrollPane);
    }

    public static String readFile(String fileName) throws IOException {
        String in;
        String newLine = "\n";
        File file = new File(fileName);
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringBuffer sb = new StringBuffer();
        while ((in = br.readLine()) != null) {
            sb.append(in);
            sb.append("\n");
        }
        br.close();
        return sb.toString();
    }

    protected boolean onCancel() {
        boolean brc = super.onCancel();
        try {
            MdObjectStore oStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
            if (oStore != null) {
                oStore.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return brc;
    }

    public boolean validateData() {
        return true;
    }

    public com.sas.svcs.metadata.mgmt.client.Repository getRepository() {
        if (this.m_newRepos != null && this.m_newRepos.getId() != "A0000001.A0000001") {
            return this.m_newRepos;
        }
        return null;
    }

    public void show() {
        if (!this.m_UserAllowedToCreate) {
            return;
        }
        super.show();
    }

    protected String determineRepositoryType() {
        String reposType = null;
        com.sas.svcs.metadata.mgmt.client.Repository foundation = this.repositoryService.getFoundationRepository();
        if (foundation == null) {
            this.addWizardData("Type", "Foundation");
            reposType = "Foundation";
        } else {
            this.addWizardData("Type", "Custom");
            reposType = "Custom";
        }
        return reposType;
    }

    public static boolean getInitializeResult() {
        return _initResult;
    }

    private static boolean isAuthorized(MdFactory m_Factory, String repositoryType) throws Exception {
        RepositoryUtil.ConnectedIdentityInfo connUserInfo = null;
        try {
            connUserInfo = new RepositoryUtil.ConnectedIdentityInfo(m_Factory);
        }
        catch (Exception e) {
            throw new Exception(bundle.getString("NewReposWizard.UnableToDetermineAdminPermission.Error.txt"));
        }
        if (connUserInfo.m_UserClass.indexOf("Unrestricted") != -1) {
            if (connUserInfo.m_UnrestrictedSource != null) {
                if (connUserInfo.m_UnrestrictedSource.indexOf("ConfigFile") != -1) {
                    return true;
                }
                return !repositoryType.equalsIgnoreCase("Foundation");
            }
            return true;
        }
        if (repositoryType.equalsIgnoreCase("Foundation")) {
            return false;
        }
        if (connUserInfo.m_Name.equalsIgnoreCase("Public") && connUserInfo.m_Type.equalsIgnoreCase("IdentityGroup")) {
            throw new Exception(bundle.getString("NewReposWizard.PublicUserNotAuthorizedToInitialize.Error.txt"));
        }
        if (connUserInfo.m_UserClass.indexOf("Administrator") == -1 && connUserInfo.m_UserClass.indexOf("Operator") == -1) {
            return false;
        }
        RepositoryUtil.isConnectedUserAuthorizedOnBIPService(m_Factory);
        return true;
    }

    @Deprecated
    public static boolean initializeRepository(MdFactory m_Factory, Repository repos, SessionContextInterface session) {
        return false;
    }

    static {
        _initResult = true;
    }

    class ReturnCode {
        public static final int ERROR = 8;
        public static final int SUCCESS = 0;
        private int _rc = 0;
        private String _errorMessage;

        ReturnCode() {
        }

        public int getReturnCode() {
            return this._rc;
        }

        public void setReturnCode(int rc) {
            this._rc |= rc;
        }

        public void setErrorMessage(String msg) {
            this._errorMessage = msg;
        }

        public String getErrorMessage() {
            return this._errorMessage;
        }
    }

    protected class ReposCreationRunnable
    implements Runnable {
        protected com.sas.svcs.metadata.mgmt.client.Repository repos;
        protected ReturnCode rc;

        public ReposCreationRunnable(com.sas.svcs.metadata.mgmt.client.Repository repos, ReturnCode rc) {
            this.repos = repos;
            this.rc = rc;
        }

        @Override
        public void run() {
            try {
                RepositoryCreationResult result = NewReposWizard.this.repositoryService.createRepository(this.repos);
                if (result.getStatus() == Operation.Status.ERROR || result.getErrorMessage() != null) {
                    if (result.getErrorMessage() != null) {
                        this.rc.setErrorMessage(result.getErrorMessage());
                    }
                    this.rc.setReturnCode(8);
                } else {
                    this.rc.setReturnCode(0);
                }
                NewReposWizard.this.m_newRepos = result.getRepository();
            }
            catch (Exception e) {
                this.rc.setErrorMessage(e.getMessage());
                this.rc.setReturnCode(8);
            }
        }
    }
}

