/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class MultiplePropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Root m_root;
    protected int m_type;
    protected String m_strViewName;
    protected JLabel m_nameLabel;
    protected JTextField m_nameText;
    protected JLabel m_descLabel;
    protected JTextField m_descText;
    protected JLabel m_typeLabel;
    protected JComboBox m_typeChoice;
    protected JSeparator m_separator;
    protected JPanel m_lowerPanel;
    protected JPanel m_eaterPanel;
    protected Prototype m_prototype;
    protected List m_prototypesList;
    protected List m_rootList;
    private static final WAdminResource bundle = WAdminResource.getBundle(MultiplePropertyView.class);

    public MultiplePropertyView(int type, String strViewName, String strTopTitle) {
        super(strTopTitle);
        this.m_type = type;
        this.m_strViewName = strViewName;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_type == 1) {
                this._setViewProperties();
            }
        } else if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_lowerPanel)).doDataExchange(false);
        }
        return false;
    }

    public boolean validateData() {
        if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            return ((PropertiesPropertyView)((Object)this.m_lowerPanel)).validateData();
        }
        return true;
    }

    protected void _setViewProperties() {
        try {
            ((PropertiesPropertyView)((Object)this.m_lowerPanel)).setViewProperties();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_lowerPanel)).onNext();
        }
        parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void onBack() {
        if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_lowerPanel)).onBack();
        }
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            strFinish = strFinish + ((PropertiesPropertyView)((Object)this.m_lowerPanel)).createFinishString();
        }
        return strFinish;
    }

    public Component getDefaultFocusComponent() {
        Component comp = null;
        if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            comp = ((PropertiesPropertyView)((Object)this.m_lowerPanel)).getDefaultFocusComponent();
        }
        return comp;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_lowerPanel)).saveSettingsAndCleanUp();
        }
    }

    public void onRootTypeChanged() {
        this.removeAll();
        this._layoutWidgets();
        this.revalidate();
    }

    public void setRoot(Root root) {
        this.m_root = root;
    }

    public void setPrototype(Prototype prototype) {
        this.m_prototype = prototype;
    }

    protected void _initialize() {
        this.setName(this.m_strViewName);
        this.m_typeLabel = new JLabel(bundle.getString("MultiplePropertyView.TypeLabel.txt"));
        this.m_typeChoice = new JComboBox();
        this.m_typeChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                MultiplePropertyView.this.onRootTypeChanged();
            }
        });
        this.m_nameLabel = new JLabel(bundle.getString("GeneralPropertyView.Name.txt"));
        this.m_nameText = new JTextField();
        this.m_descLabel = new JLabel(bundle.getString("GeneralPropertyView.Description.txt"));
        this.m_descText = new JTextField();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        this.m_lowerPanel = this._layoutPropertiesWidgets();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 0, 0, 12);
        gridBagLayout.setConstraints(this.m_lowerPanel, gbc);
        this.add(this.m_lowerPanel);
    }

    protected JPanel _layoutPropertiesWidgets() {
        if (this.m_root == null || this.m_prototype == null) {
            JPanel panel = new JPanel();
            panel.setPreferredSize(new Dimension(475, 300));
            return panel;
        }
        PropertiesPropertyView view = null;
        try {
            PropertyGroup group = this.m_prototype.getPrimaryPropertyGroup();
            Hashtable propertiesTable = null;
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                propertiesTable = (Hashtable)parent.getWizardData("Properties");
            }
            view = new PropertiesPropertyView(this.m_root, group, this.m_type, propertiesTable, this.m_prototype);
            try {
                AssociationList extensionList = group.getExtensions();
                for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                    Extension extension = (Extension)extensionList.get(extIndex);
                    if (extension.getName().equalsIgnoreCase("HelpSet")) {
                        String strHelpSet = extension.getValue();
                        this.setHelpProduct(strHelpSet);
                    }
                    if (!extension.getName().equalsIgnoreCase("HelpTopicSimple")) continue;
                    String strHelpTopic = extension.getValue();
                    this.setHelpTopic(strHelpTopic);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            view.setMinimumViewHeight(250);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            JPanel panel = new JPanel();
            panel.setPreferredSize(new Dimension(475, 300));
            return panel;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return view;
    }
}

