/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASFileRef;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.DBMSLibnamePropertyView;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class MetadataObjectCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(DBMSLibnamePropertyView.class);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof String && ((String)value).toString().equals("None")) {
            this.setText(bundle.getString("Common.None.txt"));
        }
        if (value instanceof Root) {
            this.setText(MetadataObjectCellRenderer.getDisplayName((Root)value));
        }
        return comp;
    }

    public static String getDisplayName(Root root) {
        try {
            String strDisplayName = root.getName();
            if (root instanceof Login) {
                strDisplayName = ((Login)root).getUserID();
                try {
                    AuthenticationDomain domain = ((Login)root).getDomain();
                    if (domain != null) {
                        strDisplayName = bundle.formatString("MetadataObjectCellRenderer.DomainQualifiedUserID.fmt.txt", (Object)domain.getName(), (Object)strDisplayName);
                    }
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            if (root instanceof Directory) {
                strDisplayName = ((Directory)root).getDirectoryName();
            }
            if (root instanceof File) {
                strDisplayName = ((File)root).getFileName();
            }
            if (root instanceof SASFileRef) {
                strDisplayName = ((SASFileRef)root).getFileref();
            }
            if (root instanceof Identity && ((Identity)root).getDisplayName().length() > 0) {
                strDisplayName = ((Identity)root).getDisplayName();
            }
            return strDisplayName;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }
}

