/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainMgmtDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import org.omg.CORBA.Object;

public class ManageAuthDomainsAction
extends AbstractAction {
    private static final long serialVersionUID = -2652695246900713578L;
    protected static WAdminResource bundle = new WAdminResource(ManageAuthDomainsAction.class);
    private String m_reposID;
    public static final String UNRESTRICTED = "Unrestricted";
    public static final String USER_GROUP_ADMINISTRATOR = "IdentityAdmin";
    public static final String ADMINISTRATOR = "Administrator";

    public ManageAuthDomainsAction(String reposID) {
        this.m_reposID = reposID;
        MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("ManageAuthDomainsAction.Name.txt"), null, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MdObjectStore domainsObjStore = null;
        try {
            domainsObjStore = Workspace.getMdFactory().createObjectStore();
        }
        catch (RemoteException e2) {
            Workspace.handleRemoteException((RemoteException)e2);
            return;
        }
        try {
            AuthenticationDomainMgmtDialog propdlg = new AuthenticationDomainMgmtDialog((Frame)Workspace.getWorkspace(), domainsObjStore, this.m_reposID);
            propdlg.pack();
            propdlg.setResizable(true);
            propdlg.setVisible(true);
            if (propdlg.getReturnValue() == 1) {
                domainsObjStore.updatedMetadataAll();
            }
            domainsObjStore.dispose();
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (MdException e2) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e2, (String)"Writing");
        }
    }

    public static boolean isCurrentUserALlowedToManageDomains(ISecurity_1_1 iSecurity) {
        VariableArray2dOfStringHolder returnInfo = new VariableArray2dOfStringHolder();
        String[][] parms = new String[][]{};
        try {
            iSecurity.GetInfo("GetIdentityInfo", "", parms, returnInfo);
            for (int i = 0; i < returnInfo.value.length; ++i) {
                String userClasses;
                if (!returnInfo.value[i][0].trim().equalsIgnoreCase("UserClass") || (userClasses = returnInfo.value[i][1].trim()).indexOf(UNRESTRICTED) == -1 && userClasses.indexOf(USER_GROUP_ADMINISTRATOR) == -1) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCurrentUserALlowedToManageDomains() {
        VariableArray2dOfStringHolder returnInfo = new VariableArray2dOfStringHolder();
        String[][] parms = new String[][]{};
        ISecurity_1_1 iSecurity = null;
        try {
            IOMI iOmi = Workspace.getWorkspace().getCMRHandle();
            if (iOmi == null) {
                boolean bl = false;
                return bl;
            }
            iSecurity = ISecurity_1_1Helper.narrow((Object)iOmi);
            iSecurity.GetInfo("GetIdentityInfo", "", parms, returnInfo);
            for (int i = 0; i < returnInfo.value.length; ++i) {
                String userClassString;
                if (!returnInfo.value[i][0].trim().equalsIgnoreCase("UserClass") || (userClassString = returnInfo.value[i][1].trim()).indexOf(UNRESTRICTED) == -1 && userClassString.indexOf(USER_GROUP_ADMINISTRATOR) == -1) continue;
                boolean e = true;
                return e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (iSecurity != null) {
                try {
                    Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)iSecurity);
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
                catch (MdException e) {
                    MessageUtil.displayMessage((String)e.getMessage(), (int)0);
                }
            }
        }
        return false;
    }
}

