/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.LoginSearchModel;
import com.sas.workspace.mgmt.MetadataSearchEvent;
import com.sas.workspace.mgmt.MetadataSearchListener;
import com.sas.workspace.mgmt.MetadataSearchOperator;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LoginSearchPanel
extends WAPanel
implements MetadataSearchListener {
    private static final long serialVersionUID = 1L;
    LoginSearchModel m_model = null;
    private JLabel m_lblCurrentLogin;
    private WATextField m_txtCurrentLogin;
    private JPanel m_pnlMode;
    protected JRadioButton m_rdoSearch;
    protected JRadioButton m_rdoViewAll;
    private JLabel m_lblAuthDomain;
    private WATextField m_txtAuthDomain;
    private JComboBox m_cbxAuthDomain;
    private JLabel m_lblUserID;
    private JComboBox m_cbxUserIDOperator;
    private WATextField m_txtUserID;
    protected JButton m_btnSearchNow;
    private JLabel m_lblLoginResults;
    protected WATextArea m_txtLoginResults;
    protected Vector m_loginDataList;
    protected JList m_lstLoginResults;
    protected JScrollPane m_sclLoginResults;
    private JLabel m_lblSelectedLogin;
    private WATextField m_txtSelectedLogin;
    protected OpRequestUI m_request;
    protected static WAdminResource m_bundle = WAdminResource.getBundle(LoginSearchPanel.class);

    public LoginSearchPanel(LoginSearchModel model) {
        this.m_model = model;
        this.m_model.addMetadataSearchListener(this);
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToView() {
        try {
            this.m_txtCurrentLogin.setText(m_bundle.getString("Common.None.txt"));
            if (this.m_model.getUserID() != null) {
                String strTemplate = "<TEMPLATES><Login><Domain/></Login></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"Login[@UserID='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(this.m_model.getUserID()) + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                try {
                    List loginList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_model.getObjectStore(), this.m_model.getRepositoryID(), "Login", flags, strOptions, false);
                    if (loginList.size() > 0) {
                        Login login = (Login)loginList.get(0);
                        String strUserID = login.getUserID();
                        String strDomain = "";
                        if (login.getDomain() != null) {
                            strDomain = login.getDomain().getName();
                        }
                        LoginSearchModel loginSearchModel = this.m_model;
                        Objects.requireNonNull(loginSearchModel);
                        LoginSearchModel.LoginDomainPair pair = loginSearchModel.new LoginSearchModel.LoginDomainPair(strUserID, strDomain);
                        this.m_txtCurrentLogin.setText(this.getLoginDomainDisplayName(pair));
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            if (this.m_model.getAuthDomain() != null) {
                this.m_txtAuthDomain.setText(this.m_model.getAuthDomain().getName());
            } else {
                this.m_cbxAuthDomain.addItem(" ");
                this.m_cbxAuthDomain.addItem("None");
                try {
                    int flags = 8472;
                    List domainList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_model.getObjectStore(), this.m_model.getRepositoryID(), "AuthenticationDomain", flags, "", false);
                    if (domainList != null) {
                        for (int domainIndex = 0; domainIndex < domainList.size(); ++domainIndex) {
                            this.m_cbxAuthDomain.addItem(domainList.get(domainIndex));
                        }
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            this.m_cbxUserIDOperator.addItem(m_bundle.getString("LoginSearchPanel.ConditionalOperator.Contains.txt").toUpperCase());
            this.m_cbxUserIDOperator.addItem(m_bundle.getString("LoginSearchPanel.ConditionalOperator.Equals.txt").toUpperCase());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    protected void onSearchMode() {
        if (this.m_model.getAuthDomain() == null) {
            this.m_cbxAuthDomain.setEnabled(true);
        }
        this.m_cbxUserIDOperator.setEnabled(true);
        this.m_txtUserID.setEnabled(true);
        this.setSearchButtonState();
    }

    protected void onViewAllMode() {
        if (this.m_cbxAuthDomain.getItemCount() > 0) {
            this.m_cbxAuthDomain.setEnabled(false);
        }
        this.m_cbxUserIDOperator.setEnabled(false);
        this.m_txtUserID.setEnabled(false);
        this.m_btnSearchNow.setEnabled(false);
        if (this.m_cbxAuthDomain.getItemCount() > 0) {
            this.m_model.setAuthDomain(null);
            this.m_model.setNoAssociatedAuthDomain(false);
        }
        this.m_model.setUserID(null);
        cSearch search = this.createSearchRunnable();
        this.m_request.execute((Runnable)search);
    }

    protected void onAuthDomainChanged() {
        this.setSearchButtonState();
    }

    protected void onUserIDTextChanged() {
        this.setSearchButtonState();
    }

    private void setSearchButtonState() {
        boolean bEnabled = this.m_btnSearchNow.isEnabled();
        bEnabled = this.m_cbxAuthDomain.getItemCount() > 0 && (!(this.m_cbxAuthDomain.getSelectedItem() instanceof String) || !((String)this.m_cbxAuthDomain.getSelectedItem()).equalsIgnoreCase(" ")) || this.m_txtUserID.getText().trim().length() > 0;
        this.m_btnSearchNow.setEnabled(bEnabled);
    }

    protected void onSearchNow() {
        if (this.m_cbxAuthDomain.getItemCount() > 0) {
            this.m_model.setNoAssociatedAuthDomain(false);
            if (this.m_cbxAuthDomain.getSelectedItem() instanceof AuthenticationDomain) {
                this.m_model.setAuthDomain((AuthenticationDomain)this.m_cbxAuthDomain.getSelectedItem());
            } else if (this.m_cbxAuthDomain.getSelectedItem() instanceof String) {
                if (((String)this.m_cbxAuthDomain.getSelectedItem()).equalsIgnoreCase("None")) {
                    this.m_model.setNoAssociatedAuthDomain(true);
                    this.m_model.setAuthDomain(null);
                } else if (((String)this.m_cbxAuthDomain.getSelectedItem()).equalsIgnoreCase(" ")) {
                    this.m_model.setAuthDomain(null);
                }
            }
        }
        if (((String)this.m_cbxUserIDOperator.getSelectedItem()).equalsIgnoreCase(m_bundle.getString("LoginSearchPanel.ConditionalOperator.Contains.txt"))) {
            this.m_model.setUserIDOperator(MetadataSearchOperator.COND_CONTAINS);
        }
        if (((String)this.m_cbxUserIDOperator.getSelectedItem()).equalsIgnoreCase(m_bundle.getString("LoginSearchPanel.ConditionalOperator.Equals.txt"))) {
            this.m_model.setUserIDOperator(MetadataSearchOperator.COND_EQUALS);
        }
        this.m_model.setUserID(this.m_txtUserID.getText());
        cSearch search = this.createSearchRunnable();
        this.m_request.execute((Runnable)search);
    }

    @Override
    public void processResults(MetadataSearchEvent event) {
        switch (event.getType()) {
            case 0: {
                SwingUtilities.invokeLater(new ResultsUpdater(event.getResults()));
                break;
            }
            case 1: {
                SwingUtilities.invokeLater(new ExecutionUpdater(event.getMessage()));
                break;
            }
            case 2: {
                SwingUtilities.invokeLater(new ErrorUpdater(event.getMessage()));
                break;
            }
        }
    }

    protected void onLoginSelect() {
        this.m_lstLoginResults.ensureIndexIsVisible(this.m_lstLoginResults.getSelectedIndex());
        this.m_txtSelectedLogin.setText("");
        LoginSearchModel.LoginDomainPair pair = (LoginSearchModel.LoginDomainPair)this.m_lstLoginResults.getSelectedValue();
        if (pair != null) {
            this.m_txtSelectedLogin.setText(this.getLoginDomainDisplayName(pair));
        }
    }

    public boolean validateData() {
        boolean bValid = true;
        LoginSearchModel.LoginDomainPair selectedPair = (LoginSearchModel.LoginDomainPair)this.m_lstLoginResults.getSelectedValue();
        if (selectedPair == null) {
            Container parent = this.getTopLevelAncestor();
            JOptionPane.showMessageDialog(parent, m_bundle.getString("LoginSearchPanel.SelectLogin.txt"), m_bundle.getString("Common.Error.txt"), 0);
            bValid = false;
        }
        return bValid;
    }

    public void moveDataToStore() {
        LoginSearchModel.LoginDomainPair selectedPair = (LoginSearchModel.LoginDomainPair)this.m_lstLoginResults.getSelectedValue();
        Vector<LoginSearchModel.LoginDomainPair> resultsList = new Vector<LoginSearchModel.LoginDomainPair>();
        if (selectedPair != null) {
            resultsList.add(selectedPair);
            this.m_model.setResults(resultsList);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_model.removeMetadataSearchListener(this);
    }

    protected String getLoginDomainDisplayName(LoginSearchModel.LoginDomainPair pair) {
        return pair.toString();
    }

    protected void initialize() {
        this.setHelpProduct("templatedata");
        this.setHelpTopic("login_search");
        this.m_request = new OpRequestUI((Component)((Object)this));
        this.m_request.setProgressShownOnStatusBar(false);
        this.m_request.setTitle(m_bundle.getString("LoginSearchPanel.ProgressIndicator.Title.txt"));
        this.m_lblCurrentLogin = new JLabel(m_bundle.getString("LoginSearchPanel.Label.CurrentLogin.txt"));
        this.m_txtCurrentLogin = new WATextField(20);
        this.m_txtCurrentLogin.setBehavior(1);
        this.m_txtCurrentLogin.setBorder(BorderFactory.createEmptyBorder());
        this.m_pnlMode = new JPanel();
        this.m_pnlMode.setBorder(BorderFactory.createEtchedBorder());
        String strSearch = m_bundle.getString("LoginSearchPanel.Radio.Search.txt");
        this.m_rdoSearch = new JRadioButton(MnemonicModel.getLabelWithoutMnemonic(strSearch));
        MnemonicModel.setButtonTextAndMnemonic(this.m_rdoSearch, strSearch);
        this.m_rdoSearch.setSelected(true);
        this.m_rdoSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LoginSearchPanel.this.m_rdoSearch.isSelected()) {
                    LoginSearchPanel.this.onSearchMode();
                }
            }
        });
        String strViewAll = m_bundle.getString("LoginSearchPanel.Radio.ViewAll.txt");
        this.m_rdoViewAll = new JRadioButton(MnemonicModel.getLabelWithoutMnemonic(strViewAll));
        MnemonicModel.setButtonTextAndMnemonic(this.m_rdoViewAll, strViewAll);
        this.m_rdoViewAll.setSelected(false);
        this.m_rdoViewAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LoginSearchPanel.this.m_rdoViewAll.isSelected()) {
                    LoginSearchPanel.this.onViewAllMode();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_rdoSearch);
        group.add(this.m_rdoViewAll);
        String strAuthDomain = m_bundle.getString("LoginSearchPanel.Label.AuthDomain.txt");
        String strAuthDomainNoMnem = m_bundle.getString("LoginSearchPanel.Label.AuthDomainNoMnem.txt");
        this.m_lblAuthDomain = this.m_model.getAuthDomain() == null ? new JLabel(MnemonicModel.getLabelWithoutMnemonic(strAuthDomain)) : new JLabel(MnemonicModel.getLabelWithoutMnemonic(strAuthDomainNoMnem));
        this.m_txtAuthDomain = new WATextField(20);
        this.m_txtAuthDomain.setBehavior(1);
        this.m_txtAuthDomain.setBorder(BorderFactory.createEmptyBorder());
        this.m_cbxAuthDomain = new JComboBox();
        this.m_cbxAuthDomain.setRenderer(new MetadataObjectCellRenderer());
        this.m_cbxAuthDomain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LoginSearchPanel.this.onAuthDomainChanged();
            }
        });
        this.m_lblAuthDomain.setLabelFor(this.m_cbxAuthDomain);
        if (this.m_model.getAuthDomain() == null) {
            MnemonicModel.setLabelTextAndMnemonic(this.m_lblAuthDomain, strAuthDomain);
        }
        String strUserID = m_bundle.getString("LoginSearchPanel.Label.UserID.txt");
        this.m_lblUserID = new JLabel(MnemonicModel.getLabelWithoutMnemonic(strUserID));
        this.m_cbxUserIDOperator = new JComboBox();
        this.m_txtUserID = new WATextField(25);
        this.m_txtUserID.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
                LoginSearchPanel.this.onUserIDTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                LoginSearchPanel.this.onUserIDTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                LoginSearchPanel.this.onUserIDTextChanged();
            }
        });
        this.m_lblUserID.setLabelFor((Component)this.m_txtUserID);
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblUserID, strUserID);
        String strSearchNow = m_bundle.getString("LoginSearchPanel.Button.SearchNow.txt");
        this.m_btnSearchNow = new JButton(MnemonicModel.getLabelWithoutMnemonic(strSearchNow));
        this.m_btnSearchNow.setEnabled(false);
        MnemonicModel.setButtonTextAndMnemonic(this.m_btnSearchNow, strSearchNow);
        if (this.m_model.getAuthDomain() != null) {
            this.m_btnSearchNow.setMargin(new Insets(0, 4, 0, 4));
        }
        this.m_btnSearchNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginSearchPanel.this.onSearchNow();
            }
        });
        this.m_txtUserID.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "search");
        this.m_txtUserID.getActionMap().put("search", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginSearchPanel.this.onSearchNow();
            }
        });
        this.m_cbxAuthDomain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "search");
        this.m_cbxAuthDomain.getActionMap().put("search", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginSearchPanel.this.onSearchNow();
            }
        });
        String strInitText = m_bundle.getString("LoginSearchPanel.LoginResults.InitText.fmt.txt");
        if (this.m_model.getAuthDomain() != null) {
            strInitText = m_bundle.getString("LoginSearchPanel.LoginResults.InitTextAuth.fmt.txt");
        }
        this.m_txtLoginResults = new WATextArea(strInitText);
        this.m_txtLoginResults.setBehavior(1);
        this.m_txtLoginResults.setLineWrap(true);
        this.m_txtLoginResults.setWrapStyleWord(true);
        this.m_loginDataList = new Vector();
        String strLoginResults = m_bundle.getString("LoginSearchPanel.Label.LoginResults.txt");
        this.m_lblLoginResults = new JLabel(MnemonicModel.getLabelWithoutMnemonic(strLoginResults));
        this.m_lstLoginResults = new JList(this.m_loginDataList);
        this.m_lstLoginResults.setCellRenderer(new LoginDomainCellRenderer());
        this.m_lblLoginResults.setLabelFor(this.m_lstLoginResults);
        MnemonicModel.setLabelTextAndMnemonic(this.m_lblLoginResults, strLoginResults);
        this.m_lstLoginResults.setSelectionMode(1);
        this.m_lstLoginResults.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LoginSearchPanel.this.onLoginSelect();
            }
        });
        this.m_lstLoginResults.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                switch (evt.getKeyCode()) {
                    case 32: {
                        if (!evt.isControlDown()) break;
                        LoginSearchPanel.this.m_lstLoginResults.clearSelection();
                        break;
                    }
                }
            }
        });
        this.m_lstLoginResults.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                if (LoginSearchPanel.this.m_lstLoginResults.getSelectedIndex() < 0) {
                    LoginSearchPanel.this.m_lstLoginResults.setSelectedIndex(0);
                }
            }
        });
        this.m_sclLoginResults = new JScrollPane((Component)this.m_txtLoginResults, 20, 30);
        this.m_sclLoginResults.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_sclLoginResults.setPreferredSize(new Dimension(315, 120));
        this.m_sclLoginResults.getViewport().setBackground(this.m_lstLoginResults.getBackground());
        this.m_lblSelectedLogin = new JLabel(m_bundle.getString("LoginSearchPanel.Label.SelectedLogin.txt"));
        this.m_txtSelectedLogin = new WATextField(20);
        this.m_txtSelectedLogin.setBehavior(1);
        this.m_txtSelectedLogin.setBackground(this.m_lstLoginResults.getBackground());
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblCurrentLogin, gbc);
        this.add(this.m_lblCurrentLogin);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtCurrentLogin, gbc);
        this.add((Component)this.m_txtCurrentLogin);
        GridBagLayout gbl = new GridBagLayout();
        this.m_pnlMode.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 10;
        c.weightx = 0.1;
        c.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(this.m_rdoSearch, c);
        this.m_pnlMode.add(this.m_rdoSearch);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.anchor = 10;
        c.weightx = 0.1;
        c.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(this.m_rdoViewAll, c);
        this.m_pnlMode.add(this.m_rdoViewAll);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_pnlMode, gbc);
        this.add(this.m_pnlMode);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblAuthDomain, gbc);
        this.add(this.m_lblAuthDomain);
        if (this.m_model.getAuthDomain() == null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints(this.m_cbxAuthDomain, gbc);
            this.add(this.m_cbxAuthDomain);
            this.m_cbxAuthDomain.setNextFocusableComponent(this.m_cbxUserIDOperator);
        } else {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints((Component)this.m_txtAuthDomain, gbc);
            this.add((Component)this.m_txtAuthDomain);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = ++gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_lblUserID, gbc);
        this.add(this.m_lblUserID);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.weightx = 0.2;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_cbxUserIDOperator, gbc);
        this.add(this.m_cbxUserIDOperator);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints((Component)this.m_txtUserID, gbc);
        this.add((Component)this.m_txtUserID);
        this.m_txtUserID.setNextFocusableComponent((Component)this.m_btnSearchNow);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = gridy - 1;
        gbc.gridheight = 2;
        gbc.anchor = 10;
        if (this.m_model.getAuthDomain() != null) {
            gbc.gridy = gridy;
            gbc.gridheight = 1;
            gbc.anchor = 17;
        }
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_btnSearchNow, gbc);
        this.add(this.m_btnSearchNow);
        this.m_btnSearchNow.setNextFocusableComponent((Component)this.m_txtLoginResults);
        ++gridy;
        JSeparator separator1 = new JSeparator();
        separator1.setMinimumSize(new Dimension(315, 2));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(separator1, gbc);
        this.add(separator1);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 2, 0);
        gridBagLayout.setConstraints(this.m_lblLoginResults, gbc);
        this.add(this.m_lblLoginResults);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_sclLoginResults, gbc);
        this.add(this.m_sclLoginResults);
        JSeparator separator2 = new JSeparator();
        separator2.setMinimumSize(new Dimension(315, 2));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(separator2, gbc);
        this.add(separator2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gridBagLayout.setConstraints(this.m_lblSelectedLogin, gbc);
        this.add(this.m_lblSelectedLogin);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints((Component)this.m_txtSelectedLogin, gbc);
        this.add((Component)this.m_txtSelectedLogin);
    }

    protected cSearch createSearchRunnable() {
        return new cSearch();
    }

    protected class cSearch
    implements Runnable {
        @Override
        public synchronized void run() {
            LoginSearchPanel.this.m_model.search();
        }
    }

    private class ResultsUpdater
    implements Runnable {
        private List m_resultsList;

        public ResultsUpdater(List results) {
            this.m_resultsList = results;
        }

        @Override
        public void run() {
            if (this.m_resultsList.size() > 0) {
                List sortedResultsList = this.m_resultsList;
                LoginSearchPanel.this.m_loginDataList.clear();
                LoginSearchPanel.this.m_loginDataList.addAll(sortedResultsList);
                LoginSearchPanel.this.m_lstLoginResults.setListData(LoginSearchPanel.this.m_loginDataList);
                if (LoginSearchPanel.this.m_sclLoginResults.getViewport().getView() != LoginSearchPanel.this.m_lstLoginResults) {
                    LoginSearchPanel.this.m_sclLoginResults.setViewportView(LoginSearchPanel.this.m_lstLoginResults);
                    LoginSearchPanel.this.m_btnSearchNow.setNextFocusableComponent(LoginSearchPanel.this.m_lstLoginResults);
                }
            } else {
                LoginSearchPanel.this.m_txtLoginResults.setText(m_bundle.getString("LoginSearchPanel.LoginResults.NoResults.txt"));
                if (LoginSearchPanel.this.m_sclLoginResults.getViewport().getView() != LoginSearchPanel.this.m_txtLoginResults) {
                    LoginSearchPanel.this.m_sclLoginResults.setViewportView((Component)LoginSearchPanel.this.m_txtLoginResults);
                    LoginSearchPanel.this.m_btnSearchNow.setNextFocusableComponent((Component)LoginSearchPanel.this.m_txtLoginResults);
                }
            }
        }
    }

    private class ExecutionUpdater
    implements Runnable {
        private String m_strMessage;

        public ExecutionUpdater(String message) {
            this.m_strMessage = message;
        }

        @Override
        public void run() {
            LoginSearchPanel.this.m_request.setMessage(this.m_strMessage);
        }
    }

    private class ErrorUpdater
    implements Runnable {
        private String m_strMessage;

        public ErrorUpdater(String message) {
            this.m_strMessage = message;
        }

        @Override
        public void run() {
            MessageUtil.displayMessage((String)this.m_strMessage, (int)0);
        }
    }

    class LoginDomainCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        LoginDomainCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof LoginSearchModel.LoginDomainPair) {
                LoginSearchModel.LoginDomainPair pair = (LoginSearchModel.LoginDomainPair)value;
                this.setText(LoginSearchPanel.this.getLoginDomainDisplayName(pair));
            }
            return comp;
        }
    }
}

