/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    protected Login m_login;
    protected List m_loginList;
    protected Component m_component;
    protected String m_strContext;
    protected MdObjectStore m_objectStore;
    protected AuthenticationDomain m_domain;
    protected JLabel m_usernameLabel;
    protected JTextField m_usernameText;
    protected JLabel m_passwordLabel;
    protected JPasswordField m_passwordText;
    private static final WAdminResource bundle = WAdminResource.getBundle(LoginDialog.class);

    public LoginDialog(Frame frame, MdObjectStore objectStore, String strContext) {
        this(frame, objectStore, strContext, null);
    }

    public LoginDialog(Frame frame, MdObjectStore objectStore, String strContext, AuthenticationDomain domain) {
        super(frame, bundle.getString("LoginDialog.Title.txt"), true);
        this._init(frame, objectStore, strContext, domain);
    }

    public LoginDialog(Dialog dialog, MdObjectStore objectStore, String strContext) {
        this(dialog, objectStore, strContext, null);
    }

    public LoginDialog(Dialog dialog, MdObjectStore objectStore, String strContext, AuthenticationDomain domain) {
        super(dialog, bundle.getString("LoginDialog.Title.txt"), true);
        this._init(dialog, objectStore, strContext, domain);
    }

    protected void _init(Component component, MdObjectStore objectStore, String strContext, AuthenticationDomain domain) {
        this.m_component = component;
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this.m_domain = domain;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (bSaveToModel) {
                this.m_login = (Login)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, this.m_usernameText.getText().trim(), "Login", this.m_strContext.substring(9));
                this.m_login.setUserID(this.m_usernameText.getText().trim());
                this.m_login.setPassword(String.valueOf(this.m_passwordText.getPassword()).trim());
                try {
                    this.m_login.updateMetadataAll();
                    this.m_objectStore.dispose();
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            } else {
                try {
                    String strSelect = this.m_domain != null ? "<XMLSELECT search=\"*[Domain/AuthenticationDomain[@Name='" + this.m_domain.getName() + "']]\"/>" : "";
                    int flags = 8584;
                    this.m_loginList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.m_strContext, "Login", flags, strSelect);
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean validateData() {
        try {
            boolean bValid = true;
            if (this.m_usernameText.getText().trim().length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("LoginDialog.UsernameRequired.txt"), (String)bundle.getString("Common.Error.txt"), (int)0);
                bValid = false;
                return bValid;
            }
            for (int i = 0; i < this.m_loginList.size(); ++i) {
                Login login = (Login)this.m_loginList.get(i);
                if (!login.getName().equalsIgnoreCase(this.m_usernameText.getText().trim())) continue;
                MessageUtil.displayMessage((String)bundle.getString("LoginDialog.UsernameExistsError.txt"), (String)bundle.getString("Common.Error.txt"), (int)0);
                bValid = false;
                break;
            }
            return bValid;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public Login getLogin() {
        return this.m_login;
    }

    public Root getMetadataObject() {
        return this.m_login;
    }

    protected void _initialize() {
        this.setHelpProduct("templatedata");
        this.setHelpTopic("newlogin");
        this.m_usernameLabel = new JLabel(bundle.getString("LoginDialog.Username.txt"));
        this.m_usernameText = new JTextField(15);
        this.m_passwordLabel = new JLabel(bundle.getString("LoginDialog.Password.txt"));
        this.m_passwordText = new JPasswordField();
    }

    protected void _layoutWidgets() {
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_usernameLabel, gbc);
        panel.add(this.m_usernameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_usernameText, gbc);
        panel.add(this.m_usernameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 12, 0);
        gridBagLayout.setConstraints(this.m_passwordLabel, gbc);
        panel.add(this.m_passwordLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(this.m_passwordText, gbc);
        panel.add(this.m_passwordText);
        this.getContentPane().add(panel);
    }
}

