/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.Library;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LibraryUsesView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected Library m_library;
    protected int m_type;
    protected WATextArea m_titleText;
    protected JList m_list;
    protected JScrollPane m_listPane;
    protected Vector m_dataList;
    protected WATextArea m_descText;
    protected List m_packagesList;
    private static final WAdminResource bundle = WAdminResource.getBundle(LibraryUsesView.class);

    public LibraryUsesView(Library library, int type) {
        this.m_library = library;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            String strDeployedDataPackageTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"DeployedDataPackage");
            String strDatabaseSchemaTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"DatabaseSchema");
            String strDirectoryTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"Directory");
            String strOLAPSchemaTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"OLAPSchema");
            String strSASCatalogTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"SASCatalog");
            String strSASLibraryTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"SASLibrary");
            String strTablePackageTemplate = bundle.formatString("LibraryAliasForView.DeployedDataPackage.Template.fmt.notrans", (Object)"RelationalSchema");
            int flags = 8460;
            try {
                List deployedDataPackageList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "DeployedDataPackage", flags, strDeployedDataPackageTemplate);
                List databaseSchemaList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "DatabaseSchema", flags, strDatabaseSchemaTemplate);
                List directoryList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "Directory", flags, strDirectoryTemplate);
                List olapSchemaList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "OLAPSchema", flags, strOLAPSchemaTemplate);
                List sasCatalogList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "SASCatalog", flags, strSASCatalogTemplate);
                List sasLibraryList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "SASLibrary", flags, strSASLibraryTemplate);
                List tablePackageList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_library.getStore(), this.m_library.getContext(), "RelationalSchema", flags, strTablePackageTemplate);
                this.m_packagesList = new Vector();
                this.m_packagesList.addAll(deployedDataPackageList);
                this.m_packagesList.addAll(databaseSchemaList);
                this.m_packagesList.addAll(directoryList);
                this.m_packagesList.addAll(olapSchemaList);
                this.m_packagesList.addAll(sasCatalogList);
                this.m_packagesList.addAll(sasLibraryList);
                this.m_packagesList.addAll(tablePackageList);
                for (int i = 0; i < this.m_packagesList.size(); ++i) {
                    DeployedDataPackage ddp = (DeployedDataPackage)this.m_packagesList.get(i);
                    this.m_dataList.add(ddp.getName());
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
            this.m_list.setListData(this.m_dataList);
            if (!this.m_dataList.isEmpty()) {
                this.m_list.setSelectedIndex(0);
            }
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public void onListSelectionChanged() {
        try {
            String strServer = "";
            if (this.m_list.getModel().getSize() > 0) {
                strServer = (String)this.m_list.getSelectedValue();
            }
            DeployedDataPackage ddp = null;
            for (int i = 0; i < this.m_packagesList.size() && !(ddp = (DeployedDataPackage)this.m_packagesList.get(i)).getName().equals(strServer); ++i) {
            }
            this.m_descText.setText(ddp != null ? ddp.getDesc() : "");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onNext() {
        try {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            Object[] selectedValuesArray = this.m_list.getSelectedValues();
            block2: for (int i = 0; i < selectedValuesArray.length; ++i) {
                String strServer = (String)selectedValuesArray[i];
                for (int j = 0; j < this.m_packagesList.size(); ++j) {
                    DeployedDataPackage ddp = (DeployedDataPackage)this.m_packagesList.get(j);
                    if (!ddp.getName().equals(strServer)) continue;
                    this.m_library.aliasFor(ddp);
                    continue block2;
                }
            }
            parent.replaceWizardData("DeployedDataPackage", (Object)this.m_library.getDeployedDataPackage());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onBack() {
        this.m_dataList.removeAllElements();
    }

    public void onFinish() {
    }

    protected void _initialize() {
        this.m_titleText = new WATextArea(bundle.getString("LibraryUsesView.Title.txt"));
        this.m_titleText.setEditable(false);
        this.m_titleText.setLineWrap(true);
        this.m_titleText.setWrapStyleWord(true);
        this.m_titleText.setBorder(null);
        this.m_titleText.setBackground(this.getBackground());
        this.m_dataList = new Vector();
        this.m_list = new JList(this.m_dataList);
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                LibraryUsesView.this.onListSelectionChanged();
            }
        });
        this.m_listPane = new JScrollPane(this.m_list, 22, 30);
        this.m_listPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_listPane.setMinimumSize(new Dimension(400, 350));
        this.m_listPane.setPreferredSize(new Dimension(400, 350));
        this.m_descText = new WATextArea();
        this.m_descText.setEditable(false);
        this.m_descText.setLineWrap(true);
        this.m_descText.setWrapStyleWord(true);
        this.m_descText.setBorder(null);
        this.m_descText.setBackground(this.getBackground());
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_titleText, gbc);
        this.add((Component)this.m_titleText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_listPane, gbc);
        this.add(this.m_listPane);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_descText, gbc);
        this.add((Component)this.m_descText);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

