/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.LoginSearchModel;
import com.sas.workspace.mgmt.SortUtil;
import com.sas.workspace.mgmt.visuals.LoginSearchPanel;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IOMServersLoginView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected ServerComponent m_serverComponent;
    protected List m_loginList;
    private Login m_currentLogin;
    private Login m_selectedLogin;
    protected JLabel m_loginLabel;
    protected JComboBox m_loginChoice;
    private static final WAdminResource bundle = WAdminResource.getBundle(IOMServersLoginView.class);

    public IOMServersLoginView(ServerComponent serverComponent) {
        this.m_serverComponent = serverComponent;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (bSaveToModel) {
                this._setViewProperties();
            } else {
                Vector<String> mruList = new Vector<String>(3);
                for (int index = 1; index < 4; ++index) {
                    String strMruDomain = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Domain." + String.valueOf(index));
                    String strMruLogin = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Login." + String.valueOf(index));
                    if (strMruDomain.length() <= 0 || strMruLogin.length() <= 0) continue;
                    mruList.add(strMruDomain);
                    mruList.add(strMruLogin);
                }
                String strTemplate = "<TEMPLATES><Login><Domain/></Login></TEMPLATES>";
                for (int mruIndex = 0; mruIndex < mruList.size(); mruIndex += 2) {
                    String strDomain = ((String)mruList.get(mruIndex)).trim();
                    String strLogin = (String)mruList.get(mruIndex + 1);
                    String strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "'][Domain/AuthenticationDomain[@Name='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strDomain) + "']]\" />";
                    if (strDomain.length() == 0) {
                        strXMLSelect = "<XMLSELECT search=\"Login[@UserId='" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLogin) + "']\" />";
                    }
                    int flags = 8604;
                    String strOptions = strTemplate + strXMLSelect;
                    try {
                        List loginList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_serverComponent.getObjectStore(), "A0000001." + this.m_serverComponent.getFQID().substring(0, 8), "Login", flags, strOptions);
                        for (int loginIndex = 0; loginIndex < loginList.size(); ++loginIndex) {
                            Login login = (Login)loginList.get(loginIndex);
                            if (this.m_loginList.contains(login)) continue;
                            this.m_loginList.add(login);
                        }
                        continue;
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                        continue;
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
                this.populateLogins();
                try {
                    AssociationList transformList = this.m_serverComponent.getInitProcesses();
                    block11: for (int transformIndex = 0; transformIndex < transformList.size(); ++transformIndex) {
                        Transformation transform = (Transformation)transformList.get(transformIndex);
                        if (!transform.getTransformRole().equals("Initialization")) continue;
                        AssociationList loginList = transform.getTransformationSources();
                        for (int loginIndex = 0; loginIndex < loginList.size(); ++loginIndex) {
                            Root root = (Root)loginList.get(loginIndex);
                            if (!(root instanceof Login)) continue;
                            Login login = (Login)root;
                            if (!this.m_loginList.contains(login)) {
                                this.m_loginList.add(login);
                                this.populateLogins();
                            }
                            this.m_loginChoice.setSelectedItem(login);
                            this.m_currentLogin = login;
                            continue block11;
                        }
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    return false;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    protected void onMoreLogins(ItemEvent evt) {
        try {
            String strObj;
            if (evt.getStateChange() != 1) {
                return;
            }
            Object obj = evt.getItem();
            if (obj instanceof String && (strObj = (String)obj).equalsIgnoreCase(bundle.getString("LoginSearchPanel.MoreLogins.txt"))) {
                LoginSearchModel model = new LoginSearchModel(Workspace.getWorkspace().getCMRHandle(), (MdObjectStore)this.m_serverComponent.getObjectStore(), "A0000001." + this.m_serverComponent.getFQID().substring(0, 8));
                if (this.m_currentLogin != null) {
                    model.setUserID(this.m_currentLogin.getUserID());
                }
                LoginSearchPanel panel = new LoginSearchPanel(model);
                Container parent = this.getTopLevelAncestor();
                WAStandardDialog dialog = null;
                if (parent instanceof JFrame) {
                    dialog = new WAStandardDialog((Frame)((JFrame)parent));
                }
                if (parent instanceof Dialog) {
                    dialog = new WAStandardDialog((Dialog)parent);
                }
                dialog.setModal(true);
                dialog.setTitle(bundle.getString("LoginSearchPanel.Title.txt"));
                dialog.setMainPanel((WAPanel)panel);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    List resultsList = model.getResults();
                    if (resultsList.size() > 0) {
                        Login resultLogin = (Login)resultsList.get(0);
                        if (resultLogin != this.m_currentLogin && !this.m_loginList.contains(resultLogin)) {
                            this.m_loginList.add(resultLogin);
                            this.populateLogins();
                        }
                        this.m_loginChoice.setSelectedItem(resultLogin);
                    }
                } else if (this.m_currentLogin != null) {
                    this.m_loginChoice.setSelectedItem(this.m_currentLogin);
                } else {
                    this.m_loginChoice.setSelectedIndex(0);
                }
                model.dispose();
                model = null;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void populateLogins() {
        this.m_loginChoice.removeAllItems();
        this.m_loginChoice.addItem("None");
        this.m_loginList = SortUtil.sortAscending(this.m_loginList);
        if (this.m_loginList != null) {
            for (int i = 0; i < this.m_loginList.size(); ++i) {
                Login login = (Login)this.m_loginList.get(i);
                this.m_loginChoice.addItem(login);
            }
        }
        this.m_loginChoice.addItem(bundle.getString("LoginSearchPanel.MoreLogins.txt"));
    }

    public boolean validateData() {
        boolean bValid = true;
        return bValid;
    }

    protected void _setViewProperties() {
        try {
            Root root;
            int tsIndex;
            AssociationList transformSourcesList;
            Transformation transformation = null;
            AssociationList transformList = this.m_serverComponent.getInitProcesses();
            for (int transformIndex = 0; transformIndex < transformList.size(); ++transformIndex) {
                Transformation transform = (Transformation)transformList.get(transformIndex);
                if (!transform.getTransformRole().equals("Initialization")) continue;
                transformation = transform;
                break;
            }
            if (transformation == null) {
                transformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_serverComponent.getObjectStore(), null, "Initialization", "Transformation", this.m_serverComponent.getFQID().substring(0, 8));
                transformation.setTransformRole("Initialization", 1);
                transformList.add(transformation);
            }
            Login login = null;
            if (this.m_loginChoice.getSelectedItem() instanceof Login) {
                this.m_selectedLogin = login = (Login)this.m_loginChoice.getSelectedItem();
            }
            if (login == null) {
                transformSourcesList = transformation.getTransformationSources();
                for (tsIndex = 0; tsIndex < transformSourcesList.size(); ++tsIndex) {
                    root = (Root)transformSourcesList.get(tsIndex);
                    if (!(root instanceof Login)) continue;
                    transformSourcesList.remove(root);
                    --tsIndex;
                }
            }
            if (login != null && !transformation.getTransformationSources().contains((Object)login)) {
                transformSourcesList = transformation.getTransformationSources();
                for (tsIndex = 0; tsIndex < transformSourcesList.size(); ++tsIndex) {
                    root = (Root)transformSourcesList.get(tsIndex);
                    if (!(root instanceof Login)) continue;
                    transformSourcesList.remove(root);
                    --tsIndex;
                }
                transformSourcesList.add(login);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        this._setViewProperties();
    }

    public void onBack() {
        this._setViewProperties();
    }

    public String createFinishString() {
        String strFinish = "";
        if (this.m_loginChoice.getSelectedItem() instanceof Login) {
            strFinish = strFinish + bundle.getString("IOMServersLoginView.LoginLabel.txt") + "\n\t" + MetadataObjectCellRenderer.getDisplayName((Root)this.m_loginChoice.getSelectedItem()) + "\n";
        }
        return strFinish;
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_selectedLogin == null || this.m_currentLogin == this.m_selectedLogin) {
            return;
        }
        Workspace.getWorkspace().getWorkspaceFile().removeProperty("IOMServersLogin.MRU.Domain.3");
        Workspace.getWorkspace().getWorkspaceFile().removeProperty("IOMServersLogin.MRU.Login.3");
        String strDomainMRU2 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Domain.2");
        String strLoginMRU2 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Login.2");
        if (strDomainMRU2.length() > 0 && strLoginMRU2.length() > 0) {
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("IOMServersLogin.MRU.Domain.3", strDomainMRU2);
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("IOMServersLogin.MRU.Login.3", strLoginMRU2);
        }
        String strDomainMRU1 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Domain.1");
        String strLoginMRU1 = Workspace.getWorkspace().getWorkspaceFile().getPropertyString("IOMServersLogin.MRU.Login.1");
        if (strDomainMRU1.length() > 0 && strLoginMRU1.length() > 0) {
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("IOMServersLogin.MRU.Domain.2", strDomainMRU1);
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("IOMServersLogin.MRU.Login.2", strLoginMRU1);
        }
        try {
            if (this.m_selectedLogin.getDomain() != null) {
                Workspace.getWorkspace().getWorkspaceFile().setPropertyString("IOMServersLogin.MRU.Domain.1", this.m_selectedLogin.getDomain().getName());
            } else {
                Workspace.getWorkspace().getWorkspaceFile().setPropertyString("IOMServersLogin.MRU.Domain.1", " ");
            }
            Workspace.getWorkspace().getWorkspaceFile().setPropertyString("IOMServersLogin.MRU.Login.1", this.m_selectedLogin.getUserID());
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        Workspace.getWorkspace().getWorkspaceFile().saveExisting();
    }

    protected void _initialize() {
        this.setName(bundle.getString("IOMServersLoginView.TabName.txt"));
        this.setHelpProduct("templatedata");
        this.setHelpTopic("ws_inittab");
        this.m_loginLabel = new JLabel(bundle.getString("IOMServersLoginView.LoginLabel.txt"));
        this.m_loginChoice = new JComboBox();
        this.m_loginChoice.setRenderer(new MetadataObjectCellRenderer());
        this.m_loginChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IOMServersLoginView.this.onMoreLogins(evt);
            }
        });
        this.m_loginList = new Vector();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_loginLabel, gbc);
        this.add(this.m_loginLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_loginChoice, gbc);
        this.add(this.m_loginChoice);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

