/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.MnemonicModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GenericNameAndSaveTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected String m_suggestedName;
    protected JLabel m_nameLabel;
    protected JTextField m_nameField;
    protected JCheckBox m_runCheckBox;
    protected String m_runInfo;
    protected WATextArea m_runMessageArea;
    protected static final WAdminResource bundle = new WAdminResource(GenericNameAndSaveTab.class);

    public GenericNameAndSaveTab(String title, String description, String suggestedName, String runInfo) {
        super(description);
        this.setName(title);
        this.m_suggestedName = suggestedName;
        this.m_runInfo = runInfo;
        this._initialize();
        this._layoutWidgets();
    }

    protected void _initialize() {
        String labelText = bundle.getString("GenericNameAndSave.JobName.txt");
        this.m_nameLabel = new JLabel(MnemonicModel.getLabelWithoutMnemonic(labelText));
        MnemonicModel.setLabelTextAndMnemonic(this.m_nameLabel, labelText);
        this.m_nameField = new JTextField(20);
        this.m_nameLabel.setLabelFor(this.m_nameField);
        if (this.m_suggestedName != null) {
            this.m_nameField.setText(this.m_suggestedName);
        }
        String checkBoxText = bundle.getString("GenericNameAndSave.RunJobNow.txt");
        this.m_runCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic((String)checkBoxText));
        MnemonicModel.setButtonTextAndMnemonic(this.m_runCheckBox, checkBoxText);
        this.m_runMessageArea = new WATextArea();
        if (this.m_runInfo != null) {
            this.m_runMessageArea.setText(this.m_runInfo);
        }
        this.m_runMessageArea.setBehavior(1);
        this.m_runMessageArea.setFocusable(false);
        this.m_runMessageArea.setAutoSelect(false);
        this.m_runMessageArea.setPreferredSize(new Dimension(300, 75));
        this.m_runMessageArea.setMinimumSize(new Dimension(300, 50));
        this.m_runMessageArea.setBackground(this.getBackground());
        this.m_runMessageArea.setLineWrap(true);
        this.m_runMessageArea.setWrapStyleWord(true);
    }

    protected void _layoutWidgets() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        GridBagLayout gblRunPanel = new GridBagLayout();
        JPanel runPanel = new JPanel();
        runPanel.setLayout(gblRunPanel);
        GridBagLayout gblNamePanel = new GridBagLayout();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(gblNamePanel);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 10);
        gblNamePanel.setConstraints(this.m_nameLabel, gbc);
        namePanel.add(this.m_nameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gblNamePanel.setConstraints(this.m_nameField, gbc);
        namePanel.add(this.m_nameField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 0, 0);
        gblRunPanel.setConstraints(this.m_runCheckBox, gbc);
        runPanel.add(this.m_runCheckBox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gblRunPanel.setConstraints((Component)this.m_runMessageArea, gbc);
        runPanel.add((Component)this.m_runMessageArea);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbl.setConstraints(namePanel, gbc);
        this.add(namePanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbl.setConstraints(runPanel, gbc);
        this.add(runPanel);
    }

    public void onNext() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        wizard.replaceWizardData("JobName", (Object)this.m_nameField.getText());
        if (this.m_runCheckBox.isSelected()) {
            wizard.replaceWizardData("RunJobNow", (Object)"true");
        } else {
            wizard.replaceWizardData("RunJobNow", (Object)"false");
        }
    }

    public boolean validateData() {
        if (this.m_nameField.getText().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("GenericNameAndSave.Error.txt"));
            return false;
        }
        return true;
    }

    public String createFinishString() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        String jobName = (String)wizard.getWizardData("JobName");
        String execution = (String)wizard.getWizardData("RunJobNow");
        StringBuffer finishString = new StringBuffer("");
        finishString.append(MnemonicModel.getLabelWithoutMnemonic(bundle.getString("GenericNameAndSave.JobName.txt")));
        finishString.append("\n    ");
        finishString.append(jobName);
        finishString.append("\n\n");
        finishString.append(bundle.getString("GenericNameAndSave.RunNow.txt"));
        finishString.append("\n    ");
        finishString.append(execution);
        return finishString.toString();
    }
}

