/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.ConnectionFailedException;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerConnectionInterface;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ConnectionsPropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Connection m_connection;
    protected AuthenticationDomain m_domain;
    protected int m_type;
    protected JLabel m_connNameLabel;
    protected JTextField m_connNameText;
    protected JLabel m_connDescLabel;
    protected JTextField m_connDescText;
    protected JLabel m_typeLabel;
    protected JComboBox m_typeChoice;
    protected JSeparator m_separator;
    protected JPanel m_lowerPanel;
    protected JButton m_testButton;
    protected JPanel m_eaterPanel;
    protected Prototype m_deployedComponentPrototype;
    protected Prototype m_connectionPrototype;
    protected List m_connectionsPrototypesList;
    protected List m_sourceConnectionsList;
    protected List m_providerConnectionsList;
    protected boolean m_bShowTest = false;
    protected boolean m_bShowConnectionType = false;
    private static final WAdminResource bundle = WAdminResource.getBundle(ConnectionsPropertyView.class);

    public ConnectionsPropertyView(Server server, int type) {
        super(bundle.getString("ConnectionsPropertyView.WizardTitle.txt"));
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_type == 1) {
                this._setViewProperties();
            }
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_type == 0) {
                this.m_typeChoice.removeAllItems();
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                this.m_deployedComponentPrototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
                try {
                    AssociationList associationsList = this.m_deployedComponentPrototype.getAssociations();
                    for (int i = 0; i < associationsList.size(); ++i) {
                        AssociationProperty property = (AssociationProperty)associationsList.get(i);
                        if (!property.getAssociationName().equals("SourceConnections")) continue;
                        this.m_connectionsPrototypesList = property.getAssociatedPrototypes();
                        if (this.m_connectionsPrototypesList.size() > 2) {
                            this.m_bShowConnectionType = true;
                        }
                        for (int j = 0; j < this.m_connectionsPrototypesList.size(); ++j) {
                            Prototype connectionPrototype = (Prototype)this.m_connectionsPrototypesList.get(j);
                            if (connectionPrototype == this.m_deployedComponentPrototype) continue;
                            String strTemplate = bundle.getString("Prototype.Template.All.notrans");
                            int flags = 268;
                            connectionPrototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)connectionPrototype, new Vector(), new Vector(), strTemplate, flags);
                            this.m_typeChoice.addItem(connectionPrototype.getName());
                        }
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            if (this.m_type == 1) {
                try {
                    this.m_sourceConnectionsList = this.m_server.getDeployedComponent().getSourceConnections();
                    for (int i = 0; i < this.m_sourceConnectionsList.size(); ++i) {
                        Connection connection = (Connection)this.m_sourceConnectionsList.get(i);
                        Prototype connPrototype = this.m_server.getConnectionPrototype(connection, this.getTopLevelAncestor());
                        if (connPrototype == null) continue;
                        this.m_typeChoice.addItem(connection.getName());
                        this.m_connDescText.setText(connection.getDesc());
                        this.m_connNameText.setText(connPrototype.getName());
                        this.m_connNameText.setEditable(false);
                        this.m_connNameText.setBackground(this.getBackground());
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
        }
        return false;
    }

    public boolean validateData() {
        if (this.m_lowerPanel instanceof PropertiesPropertyView) {
            return ((PropertiesPropertyView)((Object)this.m_lowerPanel)).validateData();
        }
        return true;
    }

    protected void _setViewProperties() {
        try {
            this.m_connection.setName(bundle.getString("ConnectionPropertyView.ConnectionLabel.txt") + " " + this.m_server.getDeployedComponent().getName(), 1);
            ((PropertiesPropertyView)((Object)this.m_lowerPanel)).setViewProperties();
            if (this.m_connection.getAuthenticationType() != null && this.m_connection.getAuthenticationType().equalsIgnoreCase("none") && this.m_connection.getDomain() != null) {
                this.m_connection.getDomains().removeAllElements();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.setCursor(Cursor.getPredefinedCursor(3));
        this._setViewProperties();
        try {
            this.m_connection.setUsingPrototype((Root)this.m_connectionPrototype);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        Vector<Connection> sourceConnectionsList = (Vector<Connection>)parent.getWizardData("SourceConnections");
        if (sourceConnectionsList == null) {
            sourceConnectionsList = new Vector<Connection>();
        }
        this.setConditionState("NEXT");
        try {
            String strClassID;
            AssociationList associationsList = this.m_deployedComponentPrototype.getAssociations();
            for (int i = 0; i < associationsList.size(); ++i) {
                AssociationProperty property = (AssociationProperty)associationsList.get(i);
                if (!property.getAssociationName().equals("InitProcesses") || !(this.m_server.getDeployedComponent() instanceof LogicalServer)) continue;
                this.setConditionState("TRANSFORMATIONS");
                break;
            }
            if ((strClassID = this.m_server.getDeployedComponent().getClassIdentifier()) != null && this.m_server.getDeployedComponent().getClassIdentifier().equalsIgnoreCase("IOM Spawner")) {
                this.setConditionState("TRANSFORMATIONS");
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        if (!sourceConnectionsList.isEmpty()) {
            sourceConnectionsList.remove(0);
        }
        sourceConnectionsList.add(this.m_connection);
        parent.replaceWizardData("SourceConnections", sourceConnectionsList);
        parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        List sourceConnectionsList = (List)parent.getWizardData("SourceConnections");
        if (sourceConnectionsList != null && !sourceConnectionsList.isEmpty()) {
            sourceConnectionsList.remove(sourceConnectionsList.size() - 1);
            parent.replaceWizardData("SourceConnections", (Object)sourceConnectionsList);
        }
    }

    public String createFinishString() {
        String strFinish = bundle.getString("ConnectionPropertyView.ConnectionLabel.txt") + "\n\t" + this.m_connNameText.getText() + "\n\n";
        return strFinish;
    }

    public void onConnectionTypeChanged() {
        try {
            String strType = "";
            if (this.m_typeChoice.getItemCount() == 0) {
                return;
            }
            strType = (String)this.m_typeChoice.getSelectedItem();
            if (this.m_type == 1) {
                try {
                    AssociationList connectionsList = this.m_server.getDeployedComponent().getSourceConnections();
                    for (int i = 0; i < connectionsList.size(); ++i) {
                        this.m_connection = (Connection)connectionsList.get(i);
                        if (strType.equals(this.m_connection.getName())) break;
                    }
                    this.m_connectionPrototype = this.m_server.getConnectionPrototype(this.m_connection, this.getTopLevelAncestor());
                    this.m_connDescText.setText(this.m_connection.getDesc());
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            if (this.m_type == 0) {
                for (int i = 0; i < this.m_connectionsPrototypesList.size(); ++i) {
                    this.m_connectionPrototype = (Prototype)this.m_connectionsPrototypesList.get(i);
                    if (strType.equals(this.m_connectionPrototype.getName())) break;
                }
                this.m_connNameText.setText(bundle.getString("ConnectionPropertyView.ConnectionLabel.txt") + " " + this.m_server.getDeployedComponent().getName());
                if (this.m_connectionPrototype.getMetadataType().equals("SASClientConnection")) {
                    this.m_connection = this.m_server.addSASClientConnection();
                }
                if (this.m_connectionPrototype.getMetadataType().equals("TCPIPConnection")) {
                    this.m_connection = this.m_server.addTCPIPConnection();
                }
                if (this.m_connectionPrototype.getMetadataType().equals("COMConnection")) {
                    this.m_connection = this.m_server.addCOMConnection();
                }
                if (this.m_connectionPrototype.getMetadataType().equals("OpenClientConnection")) {
                    this.m_connection = this.m_server.addOpenClientConnection();
                }
                if (this.m_connectionPrototype.getMetadataType().equals("Connection")) {
                    this.m_connection = this.m_server.addConnection();
                }
            }
            this.m_bShowTest = this.m_server.canTestConnection(this.m_connectionPrototype);
            this.removeAll();
            this._layoutWidgets();
            this.revalidate();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onTestConnection() {
        Container parent = this.getTopLevelAncestor();
        this._setViewProperties();
        boolean bSuccess = false;
        String strFailMessage = bundle.getString("Common.Connection.UnableToTest.txt");
        ServerConnectionInterface serverConnection = this.m_server.getServerConnection(this.m_connection);
        if (serverConnection != null) {
            serverConnection.setParentComponent(parent);
            try {
                bSuccess = serverConnection.testConnection(this.m_connection);
            }
            catch (ConnectionFailedException exc) {
                strFailMessage = exc.getMessage();
            }
        }
        if (bSuccess) {
            JOptionPane.showMessageDialog(parent, bundle.getString("Common.Connection.TestSuccess.txt"), bundle.getString("Common.Connection.Test.txt"), 1);
        } else {
            JOptionPane.showMessageDialog(parent, strFailMessage, bundle.getString("Common.Connection.Test.txt"), 0);
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("ConnectionsPropertyView.TabName.txt"));
        this.m_typeLabel = new JLabel(bundle.getString("ConnectionsPropertyView.ConnectionType.txt"));
        this.m_typeChoice = new JComboBox();
        this.m_typeChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ConnectionsPropertyView.this.onConnectionTypeChanged();
            }
        });
        this.m_connNameLabel = new JLabel(bundle.getString("ConnectionsPropertyView.ConnectionName.txt"));
        this.m_connNameText = new JTextField();
        this.m_connDescLabel = new JLabel(bundle.getString("ConnectionsPropertyView.ConnectionDescription.txt"));
        this.m_connDescText = new JTextField();
        this.m_testButton = new JButton(bundle.getString("ConnectionPropertyView.TestConnectionLabel.txt"));
        this.m_testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConnectionsPropertyView.this.onTestConnection();
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagConstraints gbc;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        if (this.m_type == 0 && this.m_bShowConnectionType) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints(this.m_typeLabel, gbc);
            this.add(this.m_typeLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_typeChoice, gbc);
            this.add(this.m_typeChoice);
            this.m_separator = new JSeparator();
            this.m_separator.setMinimumSize(new Dimension(315, 2));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_separator, gbc);
            this.add(this.m_separator);
        }
        if (this.m_type == 1 && this.m_bShowConnectionType) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints(this.m_connNameLabel, gbc);
            this.add(this.m_connNameLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_typeChoice, gbc);
            this.add(this.m_typeChoice);
            this.m_separator = new JSeparator();
            this.m_separator.setMinimumSize(new Dimension(315, 2));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_separator, gbc);
            this.add(this.m_separator);
        }
        this.m_lowerPanel = this._layoutPropertiesWidgets();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 0, 0, 12);
        gridBagLayout.setConstraints(this.m_lowerPanel, gbc);
        this.add(this.m_lowerPanel);
        if (this.m_bShowTest) {
            this.m_separator = new JSeparator();
            this.m_separator.setMinimumSize(new Dimension(315, 2));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_separator, gbc);
            this.add(this.m_separator);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.anchor = 13;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_testButton, gbc);
            this.add(this.m_testButton);
        }
        this.m_eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(this.m_eaterPanel, gbc);
        this.add(this.m_eaterPanel);
    }

    protected JPanel _layoutPropertiesWidgets() {
        if (this.m_connection == null || this.m_connectionPrototype == null) {
            JPanel panel = new JPanel();
            panel.setPreferredSize(new Dimension(475, 300));
            return panel;
        }
        PropertiesPropertyView view = null;
        try {
            view = new PropertiesPropertyView((Root)this.m_connection, this.m_connectionPrototype.getPrimaryPropertyGroup(), this.m_type, this.m_connectionPrototype);
            view.doDataExchange(false);
            view.setMinimumViewHeight(250);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            JPanel panel = new JPanel();
            panel.setMinimumSize(new Dimension(475, 300));
            return panel;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        return view;
    }
}

