/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.ConnectionFailedException;
import com.sas.workspace.mgmt.visuals.ConnectionWizard;
import com.sas.workspace.mgmt.visuals.PropertiesPropertyView;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerConnectionInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ConnectionPropertyView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Connection m_connection;
    protected SASClientConnection m_sasConnection;
    protected TCPIPConnection m_tcpConnection;
    protected COMConnection m_comConnection;
    protected Prototype m_connectionPrototype;
    protected int m_type;
    protected JPanel m_view;
    protected JSeparator m_separator;
    protected JButton m_testButton;
    private static final WAdminResource bundle = WAdminResource.getBundle(ConnectionPropertyView.class);

    public ConnectionPropertyView(int type) {
        this(null, type);
    }

    public ConnectionPropertyView(Connection connection, int type) {
        super(bundle.getString("ConnectionPropertyView.Title.txt"));
        this.m_connection = connection;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets(false);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_type == 1 && this.m_view instanceof PropertiesPropertyView) {
                try {
                    ((PropertiesPropertyView)((Object)this.m_view)).setViewProperties();
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
                this._setViewProperties();
            }
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            ServerComponent serverComponent = null;
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                serverComponent = (ServerComponent)parent.getWizardData("DeployedComponent");
                this.m_connection = (Connection)parent.getWizardData("Connection");
                this.m_connectionPrototype = (Prototype)parent.getWizardData("ConnectionPrototype");
            }
            if (this.m_type == 1) {
                try {
                    serverComponent = (ServerComponent)this.m_connection.getSource();
                    Server server = new Server((MdObjectStore)serverComponent.getObjectStore(), "A0000001." + serverComponent.getFQID().substring(0, 8), (DeployedComponent)serverComponent);
                    this.m_connectionPrototype = server.getConnectionPrototype(this.m_connection, this.getTopLevelAncestor());
                    if (this.m_connectionPrototype == null) {
                        System.out.println(bundle.formatString("ConnectionPropertyView.NoApplicationProtocol.LogMessage.fmt.txt", (Object)new Date(System.currentTimeMillis()), (Object)this.m_connection.getName()));
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            this.removeAll();
            this._layoutWidgets(true);
            this.revalidate();
            if (this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).doDataExchange(false);
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
        }
        return false;
    }

    public boolean validateData() {
        if (this.m_view instanceof PropertiesPropertyView) {
            return ((PropertiesPropertyView)((Object)this.m_view)).validateData();
        }
        return true;
    }

    protected void _setViewProperties() {
        try {
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                ServerComponent serverComponent = (ServerComponent)parent.getWizardData("DeployedComponent");
                String strConnectionName = (String)parent.getWizardData("ConnectionName");
                String strConnectionDesc = (String)parent.getWizardData("ConnectionDesc");
                if (strConnectionName == null) {
                    this.m_connection.setName(bundle.getString("ConnectionPropertyView.ConnectionName.notrans") + " " + serverComponent.getName(), 1);
                } else {
                    this.m_connection.setName(strConnectionName, 1);
                }
                if (strConnectionDesc != null) {
                    this.m_connection.setDesc(strConnectionDesc, 1);
                }
            }
            if (this.m_type == 1) {
                ServerComponent serverComponent = (ServerComponent)this.m_connection.getSource();
                Server childServer = new Server((MdObjectStore)serverComponent.getObjectStore(), "A0000001." + serverComponent.getFQID().substring(0, 8), (DeployedComponent)serverComponent);
                Machine machine = childServer.getMachine(this.m_connection);
                if (serverComponent.getAssociatedMachine() != machine) {
                    serverComponent.setAssociatedMachine(machine);
                }
            }
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onNext() {
        try {
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            if (this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).onNext();
            }
            this._setViewProperties();
            ServerComponent serverComponent = (ServerComponent)parent.getWizardData("DeployedComponent");
            try {
                AssociationList sourceConnectionsList = serverComponent.getSourceConnections();
                if (!sourceConnectionsList.contains(this.m_connection)) {
                    serverComponent.getSourceConnections().add((Object)this.m_connection);
                }
                String strHostName = "";
                if (this.m_connection instanceof TCPIPConnection) {
                    strHostName = ((TCPIPConnection)this.m_connection).getHostName();
                } else if (this.m_connection instanceof SASClientConnection) {
                    strHostName = ((SASClientConnection)this.m_connection).getRemoteAddress();
                } else if (this.m_connection instanceof COMConnection) {
                    strHostName = ((COMConnection)this.m_connection).getHostName();
                }
                if (strHostName.length() > 0) {
                    Machine previousMachine = serverComponent.getAssociatedMachine();
                    if (previousMachine != null) {
                        Vector<Machine> objectsToRemoveList = new Vector<Machine>();
                        if (previousMachine.getId().indexOf(36) != -1) {
                            objectsToRemoveList.add(previousMachine);
                            ((MdObjectStore)serverComponent.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                        }
                    }
                    Server server = (Server)parent.getWizardData("Server");
                    Server childServer = new Server(server.getStore(), server.getContext(), (DeployedComponent)serverComponent);
                    serverComponent.setAssociatedMachine(childServer.getMachine(this.m_connection));
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            parent.replaceWizardData("DeployedComponent", (Object)serverComponent);
            parent.replaceWizardData("Connection", (Object)this.m_connection);
            this.setConditionState("NEXT");
            if (serverComponent.getClassIdentifier().equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) {
                boolean bIsLoadBalanced = false;
                LogicalServer logicalServer = (LogicalServer)parent.getWizardData("LogicalServer");
                AssociationList initProcessesList = logicalServer.getInitProcesses();
                int iSize = initProcessesList.size();
                for (int ipIndex = 0; ipIndex < iSize; ++ipIndex) {
                    Transformation transformation = (Transformation)initProcessesList.get(ipIndex);
                    if (!transformation.getTransformRole().equals("Load Balancing")) continue;
                    bIsLoadBalanced = true;
                    break;
                }
                if (!bIsLoadBalanced) {
                    this.setConditionState("OLAPSCHEMA");
                }
            }
            if (serverComponent.getClassIdentifier().equalsIgnoreCase("SASIOLA")) {
                this.setConditionState("AUTHORIZATION");
            }
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public void onBack() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).onBack();
        }
        this._setViewProperties();
        parent.replaceWizardData("Connection", (Object)this.m_connection);
    }

    public String createFinishString() {
        try {
            String strFinish = "";
            Container parent = this.getTopLevelAncestor();
            if (!(parent instanceof ConnectionWizard)) {
                strFinish = bundle.getString("ConnectionPropertyView.ConnectionLabel.txt") + "\n\t" + this.m_connection.getName() + "\n";
            }
            if (this.m_view instanceof PropertiesPropertyView) {
                strFinish = strFinish + ((PropertiesPropertyView)((Object)this.m_view)).createFinishString();
            }
            return strFinish;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public Component getDefaultFocusComponent() {
        Component comp = null;
        if (this.m_view instanceof PropertiesPropertyView) {
            comp = ((PropertiesPropertyView)((Object)this.m_view)).getDefaultFocusComponent();
        }
        return comp;
    }

    public void onTestConnection() {
        Container parent = this.getTopLevelAncestor();
        try {
            ((PropertiesPropertyView)((Object)this.m_view)).setViewProperties();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        this._setViewProperties();
        boolean bSuccess = false;
        String strFailMessage = bundle.getString("Common.Connection.UnableToTest.txt");
        ServerConnectionInterface serverConnection = null;
        try {
            ServerComponent serverComponent = (ServerComponent)this.m_connection.getSource();
            Server server = new Server((MdObjectStore)serverComponent.getObjectStore(), "A0000001." + serverComponent.getFQID().substring(0, 8), (DeployedComponent)serverComponent);
            serverConnection = server.getServerConnection(this.m_connection);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        if (serverConnection != null) {
            serverConnection.setParentComponent(parent);
            try {
                bSuccess = serverConnection.testConnection(this.m_connection);
            }
            catch (ConnectionFailedException exc) {
                strFailMessage = exc.getMessage();
            }
        }
        if (bSuccess) {
            JOptionPane.showMessageDialog(parent, bundle.getString("Common.Connection.TestSuccess.txt"), bundle.getString("Common.Connection.Test.txt"), 1);
        } else {
            MessageUtil.displayMessage((String)strFailMessage, (String)bundle.getString("Common.Connection.Test.txt"), (int)0);
        }
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_view instanceof PropertiesPropertyView) {
            ((PropertiesPropertyView)((Object)this.m_view)).saveSettingsAndCleanUp();
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("Common.TabTitle.Options.txt"));
        this.m_testButton = new JButton(bundle.getString("ConnectionPropertyView.TestConnectionLabel.txt"));
        this.m_testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConnectionPropertyView.this.onTestConnection();
            }
        });
    }

    protected void _layoutWidgets(boolean bShowErrorMessage) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        PropertyGroup group = null;
        try {
            if (this.m_connectionPrototype != null) {
                group = this.m_connectionPrototype.getPrimaryPropertyGroup();
            }
        }
        catch (MdException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        if (group != null) {
            Hashtable<Connection, Hashtable[]> propertiesTable = null;
            if (this.m_type == 0) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                propertiesTable = (Hashtable<Connection, Hashtable[]>)parent.getWizardData("Properties");
            }
            if (this.m_type == 1) {
                try {
                    ServerComponent serverComponent = (ServerComponent)this.m_connection.getSource();
                    if (serverComponent.getClassIdentifier().equals("IOM Spawner")) {
                        Hashtable<String, String> valueTable = new Hashtable<String, String>();
                        valueTable.put("PropertyName", "HostName");
                        valueTable.put("MetadataType", "Connection");
                        valueTable.put("IsUpdateable", "0");
                        propertiesTable = new Hashtable<Connection, Hashtable[]>();
                        Hashtable[] tableArray = new Hashtable[]{valueTable};
                        propertiesTable.put(this.m_connection, tableArray);
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            if (this.m_view != null && this.m_view instanceof PropertiesPropertyView) {
                ((PropertiesPropertyView)((Object)this.m_view)).saveSettingsAndCleanUp();
            }
            this.m_view = new PropertiesPropertyView((Root)this.m_connection, group, this.m_type, propertiesTable, this.m_connectionPrototype);
            try {
                AssociationList extensionList = group.getExtensions();
                for (int extIndex = 0; extIndex < extensionList.size(); ++extIndex) {
                    Extension extension = (Extension)extensionList.get(extIndex);
                    if (extension.getName().equalsIgnoreCase("HelpSet")) {
                        String strHelpSet = extension.getValue();
                        this.setHelpProduct(strHelpSet);
                    }
                    if (!extension.getName().equalsIgnoreCase("HelpTopicSimple")) continue;
                    String strHelpTopic = extension.getValue();
                    this.setHelpTopic(strHelpTopic);
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
            ((PropertiesPropertyView)((Object)this.m_view)).setMinimumViewHeight(300);
        } else {
            this.m_view = new JPanel();
            this.m_view.setPreferredSize(new Dimension(475, 300));
            if (bShowErrorMessage) {
                this.m_view.add(new JLabel(bundle.getString("Common.UnableToShowProperties.ViewLog.txt")));
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 0, 0, 12);
        gridBagLayout.setConstraints(this.m_view, gbc);
        this.add(this.m_view);
    }
}

