/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.util.Names;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.BrowserUtil;
import com.sas.workspace.mgmt.MetadataServerUtil;
import com.sas.workspace.mgmt.MnemonicModel;
import com.sas.workspace.mgmt.visuals.NewProjectReposWizard;
import com.sas.workspace.mgmt.visuals.NewReposWizard;
import com.sas.workspace.mgmt.visuals.RegisterReposWizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class BasicPathOptionsTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected static final boolean STORE_USER_DEFINITIONS = false;
    protected static final boolean USER_FOLDER_LOCATIONS = false;
    protected static final String forwardSlash = "/";
    protected String m_serverName;
    protected WAWizardDialog wizard = null;
    protected JPanel blankPanel;
    protected JLabel engineLabel;
    protected WATextField engineField;
    protected JLabel pathLabel = null;
    protected WATextField pathField = null;
    protected JFileChooser pathDialog = null;
    protected JButton pathButton = null;
    protected JLabel optionsLabel = null;
    protected WATextArea optionsField = null;
    protected JScrollPane optionsPane = null;
    protected JLabel accessLabel;
    protected JComboBox accessMode;
    protected String[] accessModes;
    protected JLabel folderLabel = null;
    protected WATextField folderPolicy = null;
    protected JCheckBox changeManaged;
    protected JCheckBox userPolicy;
    protected String repositoryType;
    protected boolean m_isLocalMetadataServer = false;
    private static String currentReposName = null;
    WsAppServer m_appServer = null;
    private static final String FOUNDATION = "Foundation";
    private static final String CUSTOM = "Custom";
    private static final String PROJECT = "Project";
    private static WAdminResource bundle = WAdminResource.getBundle(BasicPathOptionsTab.class);

    public BasicPathOptionsTab(String serverName) {
        super(bundle.getString("NewReposWizard.BasicPathOptionsTab.Help.SetupOne.txt"));
        this.m_serverName = serverName;
        this._initialize();
        this._layoutWidgets();
    }

    protected void _initialize() {
        this.engineLabel = new JLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.Engine.txt"));
        MnemonicModel.setLabelTextAndMnemonic(this.engineLabel, bundle.getString("NewReposWizard.BasicPathOptionsTab.Engine.txt"));
        this.engineField = new WATextField();
        this.engineLabel.setLabelFor((Component)this.engineField);
        this.engineField.setEditable(false);
        this.engineField.setText(bundle.getString("NewReposWizard.BasicPathOptionsTab.Base.notrans"));
        this.pathLabel = new JLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.ReposPath.txt"));
        MnemonicModel.setLabelTextAndMnemonic(this.pathLabel, bundle.getString("NewReposWizard.BasicPathOptionsTab.ReposPath.txt"));
        this.pathField = new WATextField(20);
        this.pathLabel.setLabelFor((Component)this.pathField);
        this.pathField.requestFocus();
        this.pathField.setToolTipText(bundle.getString("NewReposWizard.PathFieldToolTip"));
        this.pathDialog = new JFileChooser();
        this.pathDialog.setDialogTitle(bundle.getString("NewReposWizard.BasicPathOptionsTab.ReposPathDialog.Title.txt"));
        this.pathDialog.setFileSelectionMode(1);
        this.pathDialog.setApproveButtonText(bundle.getString("NewReposWizard.BasicPathOptionsTab.Button.txt"));
        this.pathButton = new JButton(bundle.getString("NewReposWizard.BasicPathOptionsTab.Browse.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.pathButton, bundle.getString("NewReposWizard.BasicPathOptionsTab.Browse.txt"));
        this.pathButton.setBorderPainted(true);
        this.pathButton.setToolTipText(bundle.getString("NewReposWizard.ReposPathBrowseToolTip"));
        this.optionsLabel = new JLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.Options.txt"));
        MnemonicModel.setLabelTextAndMnemonic(this.optionsLabel, bundle.getString("NewReposWizard.BasicPathOptionsTab.Options.txt"));
        this.optionsField = new WATextArea();
        this.optionsField.setFont(this.optionsLabel.getFont());
        this.optionsField.setLineWrap(true);
        this.optionsField.setWrapStyleWord(true);
        this.optionsField.setRows(3);
        this.optionsField.setMaxCharacters(1024);
        this.optionsLabel.setLabelFor((Component)this.optionsField);
        this.optionsField.setToolTipText(bundle.getString("NewReposWizard.OptionsFieldToolTip"));
        this.optionsPane = new JScrollPane((Component)this.optionsField);
        this.accessLabel = new JLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.Access.txt"));
        MnemonicModel.setLabelTextAndMnemonic(this.accessLabel, bundle.getString("NewReposWizard.BasicPathOptionsTab.Access.txt"));
        this.userPolicy = new JCheckBox(bundle.getString("NewReposWizard.BasicPathOptionsTab.UserPolicy.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.userPolicy, bundle.getString("NewReposWizard.BasicPathOptionsTab.UserPolicy.txt"));
        this.userPolicy.setVisible(false);
        this.userPolicy.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (BasicPathOptionsTab.this.getUserPolicy()) {
                    BasicPathOptionsTab.this.folderPolicy.setEditable(false);
                    BasicPathOptionsTab.this.folderPolicy.setEnabled(true);
                } else {
                    BasicPathOptionsTab.this.folderPolicy.setText("");
                    BasicPathOptionsTab.this.folderPolicy.setEditable(false);
                    BasicPathOptionsTab.this.folderPolicy.setEnabled(false);
                }
            }
        });
        this.folderLabel = new JLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.FolderPolicy.txt"));
        MnemonicModel.setLabelTextAndMnemonic(this.folderLabel, bundle.getString("NewReposWizard.BasicPathOptionsTab.FolderPolicy.txt"));
        this.folderPolicy = new WATextField(20);
        this.folderPolicy.setToolTipText(bundle.getString("NewReposWizard.FolderPolicyToolTip"));
        this.blankPanel = new JPanel();
        this.blankPanel.setForeground(this.blankPanel.getBackground());
        this.blankPanel.setBorder(BorderFactory.createEmptyBorder());
        this.changeManaged = new JCheckBox(bundle.getString("NewReposWizard.BasicPathOptionsTab.ChangeManaged.txt"));
        MnemonicModel.setButtonTextAndMnemonic(this.changeManaged, bundle.getString("NewReposWizard.BasicPathOptionsTab.ChangeManaged.txt"));
    }

    protected void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.engineLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.engineField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.pathLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.pathField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.pathButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.optionsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.optionsPane, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public String getEngine() {
        String returnString = this.engineField.getText();
        return returnString;
    }

    public boolean getChangeManaged() {
        return this.changeManaged.isSelected();
    }

    public boolean getUserPolicy() {
        return this.userPolicy.isSelected();
    }

    public String getPath() {
        return this.pathField.getText();
    }

    public String getFolderPolicy() {
        return this.folderPolicy.getText();
    }

    public void putPath(String pathinfo) {
        this.pathField.setText(pathinfo);
    }

    public void putFolderPolicy(String location) {
        this.folderPolicy.setText(location);
    }

    public String getOptions() {
        return this.optionsField.getText();
    }

    protected void _initReposLocalBrowseButton(ActionEvent e) {
        boolean browseEnabled = false;
        if (this.m_isLocalMetadataServer) {
            browseEnabled = true;
        }
        if (!this.pathField.isEnabled()) {
            browseEnabled = false;
        }
        this.pathButton.setEnabled(browseEnabled);
        if (browseEnabled) {
            File userDir;
            String serverDir = null;
            String pathValue = this.pathField.getText();
            try {
                serverDir = this.getCurrentServerDirectory(Workspace.getMdFactory());
                if (serverDir == null) {
                    serverDir = System.getProperty("user.dir");
                }
            }
            catch (MdException mdException) {
                // empty catch block
            }
            if (pathValue != null && pathValue.length() > 0 && (userDir = new File(pathValue)).isAbsolute()) {
                serverDir = pathValue;
            }
            File dir = new File(serverDir);
            this.pathDialog.setCurrentDirectory(dir);
            int returnVal = this.pathDialog.showDialog((Component)e.getSource(), null);
            if (returnVal == 0) {
                File f = this.pathDialog.getSelectedFile();
                String strFile = f.getPath();
                this.putPath(strFile);
            }
        }
    }

    protected void _initReposRemoteBrowseButton() {
        LogicalServer lServer = null;
        ServerContext sContext = null;
        this.m_appServer = null;
        try {
            MdObjectStore m_objectStore = (MdObjectStore)this.wizard.getWizardData("OBJECTSTORE");
            sContext = MetadataServerUtil.getDefaultServerContext(Workspace.getMdFactory(), m_objectStore);
            if (sContext != null) {
                lServer = MetadataServerUtil.getLogicalMetadataServerFromServerContext(Workspace.getMdFactory(), sContext);
                this.m_appServer = WsAppServer.createAppServer((ServerContext)sContext);
                this.m_appServer.open();
            }
        }
        catch (WsAppServerFailException e) {
            try {
                Workspace.getMdFactory().getUtil().printOutputln(bundle.getString("NewReposWizard.BasicPathOptionsTab.ApplicationServerError.txt") + e.getMessage() + "\n");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.m_appServer.dispose();
            this.m_appServer = null;
        }
        catch (MdException e) {
            try {
                Workspace.getMdFactory().getUtil().printOutputln("Getting Logical MetadataServer from Server Context" + sContext.getName() + "  " + sContext.getFQID() + ":\n" + e.getMessage());
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (this.m_appServer == null) {
            MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.BasicPathOptionsTab.BrowseDisabledWarning.txt"), (int)2, (int)-1);
            this.pathButton.setEnabled(false);
            return;
        }
        BrowserUtil m_browser = new BrowserUtil(this.m_appServer, BrowserUtil.DIRECTORIES);
        try {
            String strFile;
            File userDir;
            String pathValue;
            String serverDir;
            block25: {
                serverDir = null;
                pathValue = this.pathField.getText();
                try {
                    serverDir = this.getCurrentServerDirectory(Workspace.getMdFactory());
                    if (serverDir == null) {
                        serverDir = System.getProperty("user.dir");
                    } else if (lServer != null) {
                        serverDir = serverDir + forwardSlash;
                    }
                }
                catch (MdException me) {
                    MessageUtil.displayMessage((String)bundle.getString(me.getMessage()), (int)0, (int)-1);
                    if (serverDir != null) break block25;
                    serverDir = System.getProperty("user.dir");
                }
            }
            if (pathValue != null && pathValue.length() > 0 && (userDir = new File(pathValue)).isAbsolute()) {
                serverDir = pathValue;
            }
            if ((strFile = m_browser.showBrowser(bundle.getString("NewReposWizard.BasicPathOptionsTab.BrowseTitle.txt"), serverDir)) == null || strFile == "") {
                if (pathValue != null && pathValue.length() > 0) {
                    this.putPath(pathValue);
                } else {
                    this.putPath(serverDir);
                }
            } else {
                this.putPath(strFile);
            }
        }
        catch (WsAppServerFailException w) {
            MessageUtil.displayMessage((String)w.getMessage(), (int)0, (int)-1);
            try {
                Workspace.getMdFactory().getUtil().printOutputln(bundle.getString("NewReposWizard.BasicPathOptionsTab.ApplicationServerError.txt") + w.getMessage() + "\n");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.pathButton.setEnabled(false);
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            parent.dispose();
        }
        catch (GenericError g) {
            MessageUtil.displayMessage((String)g.getMessage(), (int)0, (int)-1);
            this.pathButton.setEnabled(false);
        }
        this.m_appServer.dispose();
        this.m_appServer = null;
    }

    protected boolean isMetadataServerLocal() {
        boolean localServer = false;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String localHostName = localHost.getHostName();
            if (this.m_serverName != null) {
                int indexOfDot = this.m_serverName.indexOf(46);
                if (indexOfDot != -1) {
                    this.m_serverName = this.m_serverName.substring(0, indexOfDot);
                }
                localServer = localHostName.equalsIgnoreCase(this.m_serverName) || this.m_serverName.equalsIgnoreCase("localhost");
            }
        }
        catch (UnknownHostException ue) {
            localServer = false;
        }
        return localServer;
    }

    protected void _initReposBrowseButton() {
        this.wizard = (WAWizardDialog)this.getTopLevelAncestor();
        this.pathButton.setEnabled(true);
        this.m_isLocalMetadataServer = this.isMetadataServerLocal();
        String reposType = (String)this.wizard.getWizardData("Type");
        if (!this.m_isLocalMetadataServer && reposType.equalsIgnoreCase(FOUNDATION)) {
            this.pathButton.setEnabled(false);
        } else {
            this.pathButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BasicPathOptionsTab.this.m_isLocalMetadataServer) {
                        BasicPathOptionsTab.this._initReposLocalBrowseButton(e);
                    } else {
                        BasicPathOptionsTab.this._initReposRemoteBrowseButton();
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateData() {
        java.lang.Object typeObj;
        String path = this.getPath();
        String engine = this.engineField.getText();
        if (path.length() == 0 && engine.equals(bundle.getString("NewReposWizard.BasicPathOptionsTab.Base.notrans"))) {
            MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.BasicPathOptionsTab.ReposPathError.Path.txt"), (String)bundle.getString("NewReposWizard.ValidationError.Title.txt"), (int)0);
            return false;
        }
        String existingReposId = null;
        try {
            existingReposId = this.doesRepositoryExistAtPath(Workspace.getMdFactory());
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getMessage(), (String)bundle.getString("NewReposWizard.BasicPathOptionsTab.RepositoryExistsCheck.Label.txt"), (int)0);
            return false;
        }
        if (this.wizard instanceof RegisterReposWizard) {
            if (existingReposId == null) {
                MessageUtil.displayMessage((String)bundle.getString("RegisterReposWizard.BasicPathOptionsTab.Repository.NotFound.Error.txt"), (int)0);
                return false;
            }
        } else if ((this.wizard instanceof NewReposWizard || this.wizard instanceof NewProjectReposWizard) && existingReposId != null) {
            if (!existingReposId.equalsIgnoreCase("unknownpath")) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.BasicPathOptionsTab.RepositoryExists.Error.txt"), (int)0);
                return false;
            }
            int rc = MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.BasicPathOptionsTab.InvalidPath.Warning.txt"), (int)3, (int)0);
            if (rc != 0) {
                this.wizard.replaceWizardData("CreateReposPath", (java.lang.Object)"No");
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.BasicPathOptionsTab.InvalidPath.Error.txt"), (int)0);
                return false;
            }
            this.wizard.replaceWizardData("CreateReposPath", (java.lang.Object)"Yes");
        }
        if ((typeObj = this.wizard.getWizardData("Type")) != null) {
            String access;
            java.lang.Object accessObj;
            String type = (String)typeObj;
            if (type.equalsIgnoreCase(FOUNDATION) && (accessObj = this.wizard.getWizardData("Access")) != null && ((access = (String)accessObj).equalsIgnoreCase(bundle.getString("NewReposWizard.RepositoryAccess.Admin.txt")) || access.equalsIgnoreCase(bundle.getString("NewReposWizard.RepositoryAccess.None.txt")))) {
                MessageUtil.displayMessage((String)bundle.getString("NewReposWizard.BasicPathOptionsTab.Error.Access.txt"), (String)bundle.getString("NewReposWizard.ValidationError.Title.txt"), (int)0);
                return false;
            }
            this.setConditionState("NEXT");
        }
        return true;
    }

    public void onBack() {
        ActionListener[] alist = this.pathButton.getActionListeners();
        for (int i = 0; i < alist.length; ++i) {
            this.pathButton.removeActionListener(alist[i]);
        }
        currentReposName = (String)this.wizard.getWizardData("Name");
    }

    public void onNext() {
        this.wizard.replaceWizardData("Path", (java.lang.Object)this.getPath());
        this.wizard.replaceWizardData("Options", (java.lang.Object)this.getOptions());
        this.wizard.replaceWizardData("Engine", (java.lang.Object)this.getEngine());
        this.wizard.replaceWizardData("ReadOnly", (java.lang.Object)"false");
        if (this.getChangeManaged()) {
            String reposType = (String)this.wizard.getWizardData("Type");
            if (reposType.equalsIgnoreCase(PROJECT)) {
                this.wizard.replaceWizardData("ChangeManaged", (java.lang.Object)"No");
            } else {
                this.wizard.replaceWizardData("ChangeManaged", (java.lang.Object)"Yes");
            }
        } else {
            this.wizard.replaceWizardData("ChangeManaged", (java.lang.Object)"No");
        }
        this.wizard.replaceWizardData("StoreUserDefinitions", (java.lang.Object)(this.getUserPolicy() ? "Y" : "N"));
        this.wizard.replaceWizardData("PathToUserRootFolder", (java.lang.Object)this.getFolderPolicy());
    }

    protected void updatePaths() {
        String validName;
        String reposType = (String)this.wizard.getWizardData("Type");
        String pathReposText = this.pathField.getText();
        String pathUsersText = this.folderPolicy.getText();
        String repName = (String)this.wizard.getWizardData("Name");
        if (pathReposText == null || pathReposText.length() == 0) {
            validName = Names.mapNameToFilesystem((String)repName, (int)0, (String)this.getDefaultRepositoryDirectoryName(), (String)"");
            this.pathField.setText(validName);
        } else if (currentReposName != null && !currentReposName.equalsIgnoreCase(repName)) {
            validName = Names.mapNameToFilesystem((String)repName, (int)0, (String)this.getDefaultRepositoryDirectoryName(), (String)"");
            this.pathField.setText(validName);
        }
        if (reposType.equalsIgnoreCase(FOUNDATION)) {
            if (this.getUserPolicy() && (pathUsersText == null || pathUsersText.length() == 0)) {
                this.folderPolicy.setText(forwardSlash + bundle.getString("Common.DefaultFolderPolicy.txt"));
            }
        } else {
            String folderPath = this.folderPolicy.getText();
            if ((folderPath = folderPath.substring(folderPath.indexOf(forwardSlash) + 1, folderPath.length())).equals(bundle.getString("Common.DefaultFolderPolicy.txt"))) {
                this.folderPolicy.setText("");
            }
        }
    }

    private String getDefaultRepositoryDirectoryName() {
        String reposDir = null;
        try {
            MdObjectStore m_objectStore = (MdObjectStore)this.wizard.getWizardData("OBJECTSTORE");
            ServerContext sContext = MetadataServerUtil.getDefaultServerContext(Workspace.getMdFactory(), m_objectStore);
            if (sContext != null) {
                LogicalServer lServer = MetadataServerUtil.getLogicalMetadataServerFromServerContext(Workspace.getMdFactory(), sContext);
                reposDir = this.getRepositoryDirectoryConfigProperty((SoftwareComponent)lServer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (reposDir == null) {
            reposDir = bundle.getString("NewReposWizard.BasicPathOptionsTab.DefaultReposDirectory.notrans");
        }
        return reposDir;
    }

    private String getRepositoryDirectoryConfigProperty(SoftwareComponent scomp) throws Exception {
        String name = null;
        HashMap publicProperties = new HashMap();
        HashMap privateProperties = new HashMap();
        ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)scomp, publicProperties, privateProperties);
        if (privateProperties != null && privateProperties.size() > 0) {
            Set ks = privateProperties.keySet();
            for (String propName : ks) {
                if (!propName.equalsIgnoreCase("iomsrv.metadatasrv.repository.dir")) continue;
                name = (String)privateProperties.get(propName);
                break;
            }
        }
        return name;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.wizard = (WAWizardDialog)this.getTopLevelAncestor();
            this._initReposBrowseButton();
            this.repositoryType = (String)this.wizard.getWizardData("Type");
            if (this.repositoryType != null) {
                int n = 4;
                double w = 1.0;
                if (this.repositoryType.equalsIgnoreCase(FOUNDATION) || this.repositoryType.equalsIgnoreCase(CUSTOM)) {
                    boolean initializePolicies = false;
                    if (this.repositoryType.equalsIgnoreCase(FOUNDATION)) {
                        this.accessModes = new String[2];
                        this.accessModes[0] = bundle.getString("NewReposWizard.RepositoryAccess.Full.txt");
                        this.accessModes[1] = bundle.getString("NewReposWizard.RepositoryAccess.Readonly.txt");
                        this.accessMode = new JComboBox<String>(this.accessModes);
                        this.accessMode.setToolTipText(bundle.getString("NewReposWizard.AccessFieldToolTip"));
                        this.accessMode.addItemListener(new accessModeListener());
                        this.accessLabel.setLabelFor(this.accessMode);
                        initializePolicies = true;
                    } else {
                        this.accessModes = new String[4];
                        this.accessModes[0] = bundle.getString("NewReposWizard.RepositoryAccess.Full.txt");
                        this.accessModes[1] = bundle.getString("NewReposWizard.RepositoryAccess.Readonly.txt");
                        this.accessModes[2] = bundle.getString("NewReposWizard.RepositoryAccess.Admin.txt");
                        this.accessModes[3] = bundle.getString("NewReposWizard.RepositoryAccess.None.txt");
                        this.accessMode = new JComboBox<String>(this.accessModes);
                        this.accessMode.setToolTipText(bundle.getString("NewReposWizard.AccessFieldToolTip"));
                        this.accessMode.addItemListener(new accessModeListener());
                        this.accessLabel.setLabelFor(this.accessMode);
                    }
                    this.add(this.accessLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
                    this.add(this.accessMode, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
                    this.add(this.userPolicy, new GridBagConstraints(0, n++, 2, 1, w, w, 16, 2, new Insets(5, 5, 5, 0), 0, 0));
                    this.add(this.folderLabel, new GridBagConstraints(0, n++, 3, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
                    this.add((Component)this.folderPolicy, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
                    if (this.repositoryType.equalsIgnoreCase(FOUNDATION)) {
                        if (this.repositoryType.equalsIgnoreCase(FOUNDATION) && initializePolicies) {
                            this.folderPolicy.setText(forwardSlash + bundle.getString("Common.DefaultFolderPolicy.txt"));
                        }
                        this.folderPolicy.setEditable(false);
                        this.folderPolicy.setEnabled(true);
                    } else {
                        this.folderPolicy.setText("");
                        this.folderPolicy.setEditable(false);
                        this.folderPolicy.setEnabled(false);
                    }
                    this.userPolicy.setSelected(this.repositoryType.equalsIgnoreCase(FOUNDATION) && initializePolicies);
                    this.folderLabel.setVisible(this.repositoryType.equalsIgnoreCase(FOUNDATION));
                    this.folderPolicy.setVisible(this.repositoryType.equalsIgnoreCase(FOUNDATION));
                    w = 0.0;
                } else {
                    this.accessModes = new String[4];
                    this.accessModes[0] = bundle.getString("NewReposWizard.RepositoryAccess.Full.txt");
                    this.accessModes[1] = bundle.getString("NewReposWizard.RepositoryAccess.Readonly.txt");
                    this.accessModes[2] = bundle.getString("NewReposWizard.RepositoryAccess.Admin.txt");
                    this.accessModes[3] = bundle.getString("NewReposWizard.RepositoryAccess.None.txt");
                    this.accessMode = new JComboBox<String>(this.accessModes);
                    this.accessMode.setToolTipText(bundle.getString("NewReposWizard.AccessFieldToolTip"));
                    this.accessMode.addItemListener(new accessModeListener());
                    this.accessLabel.setLabelFor(this.accessMode);
                    this.add(this.accessLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
                    this.add(this.accessMode, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
                    this.remove(this.userPolicy);
                    this.remove(this.folderLabel);
                    this.remove((Component)this.folderPolicy);
                }
                this.add(this.blankPanel, new GridBagConstraints(0, n++, 3, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
                if (this.repositoryType.equalsIgnoreCase(FOUNDATION) || this.repositoryType.equalsIgnoreCase(CUSTOM)) {
                    this.add(this.changeManaged, new GridBagConstraints(0, n, 3, 1, w, w, 16, 2, new Insets(5, 5, 5, 0), 0, 0));
                    this.changeManaged.setSelected(true);
                } else {
                    this.changeManaged.setSelected(false);
                    this.remove(this.changeManaged);
                }
                java.lang.Object access = this.wizard.getWizardData("Access");
                if (access.equals(bundle.getString("NewReposWizard.RepositoryAccess.Full.txt"))) {
                    this.accessMode.setSelectedIndex(0);
                } else if (access.equals(bundle.getString("NewReposWizard.RepositoryAccess.Readonly.txt"))) {
                    this.accessMode.setSelectedIndex(1);
                } else if (access.equals(bundle.getString("NewReposWizard.RepositoryAccess.Admin.txt"))) {
                    this.accessMode.setSelectedIndex(2);
                } else if (access.equals(bundle.getString("NewReposWizard.RepositoryAccess.None.txt"))) {
                    this.accessMode.setSelectedIndex(3);
                }
            }
            this.updatePaths();
        }
        return true;
    }

    public String createFinishString() {
        StringBuffer finishString = new StringBuffer("");
        finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.Engine.txt")) + "\n   ");
        finishString.append((String)this.wizard.getWizardData("Engine"));
        finishString.append("\n\n");
        finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.ReposPath.txt")) + "\n   ");
        finishString.append((String)this.wizard.getWizardData("Path"));
        finishString.append("\n\n");
        finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.Access.txt")) + "\n   ");
        finishString.append((String)this.wizard.getWizardData("Access"));
        finishString.append("\n\n");
        String options = (String)this.wizard.getWizardData("Options");
        if (options != null) {
            finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("NewReposWizard.BasicPathOptionsTab.Options.txt")) + "\n   ");
            finishString.append(options);
            finishString.append("\n\n");
        }
        this.repositoryType = (String)this.wizard.getWizardData("Type");
        if (this.repositoryType != null && (this.repositoryType.equalsIgnoreCase(FOUNDATION) || this.repositoryType.equalsIgnoreCase(CUSTOM))) {
            finishString.append(bundle.getString("NewReposWizard.ChangeManaged.txt") + "\n   ");
            if (this.getChangeManaged()) {
                finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("Common.Yes.txt")));
            } else {
                finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("Common.No.txt")));
            }
            finishString.append("\n\n");
            finishString.append(bundle.getString("NewReposWizard.BasicPathOptionsTab.UserPolicy.Name.txt") + "\n   ");
            if (this.getUserPolicy()) {
                finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("Common.Yes.txt")));
            } else {
                finishString.append(MnemonicModel.getDisplayLabel(bundle.getString("Common.No.txt")));
            }
            finishString.append("\n\n");
            finishString.append(bundle.getString("NewReposWizard.BasicPathOptionsTab.FolderPolicy.Name.txt") + "\n   ");
            finishString.append(this.getFolderPolicy());
            finishString.append("\n\n");
        }
        return finishString.toString();
    }

    private String doesRepositoryExistAtPath(MdFactory factory) throws MdException {
        String reposID;
        block13: {
            reposID = null;
            String exists = null;
            IServer serverConn = null;
            try {
                serverConn = this.MakeIServerConnection(factory.getConnection().getCMRHandle());
            }
            catch (RemoteException re) {
                throw new MdException((Throwable)re);
            }
            if (serverConn == null) {
                return null;
            }
            StringHolder output = new StringHolder();
            String path = this.getPath();
            try {
                path = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(this.getPath());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            String engine = this.getEngine();
            String options = this.getOptions();
            String input = "<ReposId Path=\"" + path + "\" Engine=\"" + engine + "\" Options=\"" + options + "\"/>";
            try {
                serverConn.Status(input, output, "");
                String outputStr = output.value;
                int beginReposIdIndex = outputStr.lastIndexOf("ReposId=");
                if (beginReposIdIndex == -1) {
                    return null;
                }
                int beginQuoteIndex = beginReposIdIndex + 8;
                int endQuoteIndex = outputStr.indexOf(34, beginQuoteIndex + 1);
                if (endQuoteIndex - beginQuoteIndex > 1) {
                    reposID = outputStr.substring(beginQuoteIndex + 1, endQuoteIndex);
                    break block13;
                }
                if (this.wizard instanceof RegisterReposWizard) {
                    return null;
                }
                int beginExistsIndex = outputStr.indexOf("Exists=");
                if (beginExistsIndex == -1) {
                    return null;
                }
                beginQuoteIndex = beginExistsIndex + 7;
                endQuoteIndex = outputStr.indexOf(34, beginQuoteIndex + 1);
                if (endQuoteIndex - beginQuoteIndex > 1) {
                    exists = outputStr.substring(beginQuoteIndex + 1, endQuoteIndex);
                    if (!exists.equalsIgnoreCase("No")) {
                        return null;
                    }
                    reposID = "unknownpath";
                    break block13;
                }
                return null;
            }
            catch (Exception e) {
                throw new MdException(bundle.getString("NewReposWizard.BasicPathOptionsTab.RepositoryExistsCheck.Exception.txt"));
            }
        }
        return reposID;
    }

    private IServer MakeIServerConnection(IOMI OMRConnection) throws MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                IServer iServer = IServerHelper.narrow((Object)obj);
                if (iServer != null) {
                    return iServer;
                }
                throw new MdException(bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + "UNKNOWN");
            }
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        return null;
    }

    private String getCurrentServerDirectory(MdFactory factory) throws MdException {
        String serverPath = null;
        IServer serverConn = null;
        try {
            serverConn = this.MakeIServerConnection(factory.getConnection().getCMRHandle());
        }
        catch (RemoteException re) {
            throw new MdException((Throwable)re);
        }
        if (serverConn == null) {
            return null;
        }
        StringHolder output = new StringHolder();
        String input = "<OMA SERVERSTARTPATH=\"\" />";
        try {
            serverConn.Status(input, output, "");
            String outputStr = output.value;
            int beginPathIndex = outputStr.lastIndexOf("SERVERSTARTPATH=");
            if (beginPathIndex == -1) {
                return null;
            }
            int beginQuoteIndex = beginPathIndex + 16;
            int endQuoteIndex = outputStr.indexOf(34, beginQuoteIndex + 1);
            if (endQuoteIndex - beginQuoteIndex <= 1) {
                return null;
            }
            serverPath = outputStr.substring(beginQuoteIndex + 1, endQuoteIndex);
        }
        catch (Exception e) {
            throw new MdException(bundle.getString("NewReposWizard.BasicPathOptionsTab.RepositoryExistsCheck.Exception.txt"));
        }
        return serverPath;
    }

    public class accessModeListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                int selectedAccessMode = BasicPathOptionsTab.this.accessMode.getSelectedIndex();
                switch (selectedAccessMode) {
                    case 0: {
                        BasicPathOptionsTab.this.wizard.replaceWizardData("Access", (java.lang.Object)bundle.getString("NewReposWizard.RepositoryAccess.Full.txt"));
                        break;
                    }
                    case 1: {
                        BasicPathOptionsTab.this.wizard.replaceWizardData("Access", (java.lang.Object)bundle.getString("NewReposWizard.RepositoryAccess.Readonly.txt"));
                        break;
                    }
                    case 2: {
                        BasicPathOptionsTab.this.wizard.replaceWizardData("Access", (java.lang.Object)bundle.getString("NewReposWizard.RepositoryAccess.Admin.txt"));
                        break;
                    }
                    case 3: {
                        BasicPathOptionsTab.this.wizard.replaceWizardData("Access", (java.lang.Object)bundle.getString("NewReposWizard.RepositoryAccess.None.txt"));
                    }
                }
            }
        }
    }
}

