/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.visuals.Resources;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;

public class AuthorizationView
extends WsDescriptionWizardTab {
    private Server m_server;
    private Library m_library;
    private List<SortableIdentity> m_lstUsers;
    private List<SortableIdentity> m_lstGroups;
    private List<SortableIdentity> m_lstIdentities;
    private List<SortableIdentity> m_lstDefaults;
    private WATextArea m_txtHeader;
    private JCheckBox m_chkUsers;
    private JCheckBox m_chkGroups;
    private DualListSelector m_selIdentities;
    private static final WAdminResource bundle = WAdminResource.getBundle(AuthorizationView.class);
    private static final long serialVersionUID = 5580862725692365381L;

    public AuthorizationView(Server server) {
        super(bundle.getString("AuthorizationView.TabName.txt"));
        this.m_server = server;
        this.initialize();
        this.layoutWidgets();
    }

    public AuthorizationView(Library library) {
        super(bundle.getString("AuthorizationView.TabName.txt"));
        this.m_library = library;
        this.initialize();
        this.layoutWidgets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdministerPermission(String fqid) {
        ISecurityAdmin admin = null;
        try {
            WAWizardDialog dialog = (WAWizardDialog)this.getTopLevelAncestor();
            List lstWizardData = (List)dialog.getWizardData("Identities");
            String[][] ary2dAuths = new String[lstWizardData.size()][];
            for (int tIndex = 0; tIndex < lstWizardData.size(); ++tIndex) {
                SortableIdentity identity = (SortableIdentity)lstWizardData.get(tIndex);
                String[] aryAuth = new String[]{identity.getIdentity().getCMetadataType(), identity.getIdentity().getName(), "G", "Administer", ""};
                ary2dAuths[tIndex] = aryAuth;
            }
            String resource = new String();
            if (this.m_server != null) {
                resource = "OMSOBJ:" + this.m_server.getDeployedComponent().getCMetadataType() + "/" + fqid;
            }
            if (this.m_library != null) {
                resource = "OMSOBJ:" + this.m_library.getDeployedDataPackage().getCMetadataType() + "/" + fqid;
            }
            IOMI iOMI = Workspace.getWorkspace().getCMRHandle();
            admin = ISecurityAdminHelper.narrow((Object)Workspace.getMdFactory().getConnection().MakeISecurityConnection(iOMI));
            admin.SetAuthorizationsOnObj("", resource, 0, ary2dAuths);
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((java.lang.Object)exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((java.lang.Object)exc.getLocalizedMessage());
        }
        catch (UserException exc) {
            Workspace.getDefaultLogger().error((java.lang.Object)exc.getLocalizedMessage());
        }
        finally {
            if (admin != null) {
                admin._release();
            }
        }
    }

    public void populateStore() {
        try {
            MdStore store = null;
            String strReposID = null;
            this.m_lstUsers = new ArrayList<SortableIdentity>();
            this.m_lstGroups = new ArrayList<SortableIdentity>();
            this.m_lstDefaults = new ArrayList<SortableIdentity>();
            if (this.m_server != null) {
                store = this.m_server.getDeployedComponent().getObjectStore();
                strReposID = this.m_server.getContext();
            }
            if (this.m_library != null) {
                store = this.m_library.getDeployedDataPackage().getObjectStore();
                strReposID = this.m_library.getContext();
            }
            int flags = 8472;
            List lstIdentities = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(store, strReposID, "Identity", flags, "");
            for (int idIndex = 0; idIndex < lstIdentities.size(); ++idIndex) {
                Identity identity = (Identity)lstIdentities.get(idIndex);
                SortableIdentity idSortable = new SortableIdentity(identity);
                if (identity.getPublicType().equalsIgnoreCase("User")) {
                    this.m_lstUsers.add(idSortable);
                    continue;
                }
                if (!identity.getPublicType().equalsIgnoreCase("UserGroup")) continue;
                this.m_lstGroups.add(idSortable);
                if (identity.getName().equalsIgnoreCase("Visual Analytics Data Administrators")) {
                    this.m_lstDefaults.add(idSortable);
                }
                if (this.m_library == null || !identity.getName().equalsIgnoreCase("Visual Data Builder Administrators")) continue;
                this.m_lstDefaults.add(idSortable);
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((java.lang.Object)exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            Workspace.getDefaultLogger().error((java.lang.Object)exc.getLocalizedMessage());
        }
    }

    public void moveDataToView() {
        SortableIdentity tdid;
        int tdIndex;
        boolean bFound;
        int sdIndex;
        this.m_lstIdentities = new ArrayList<SortableIdentity>();
        if (this.m_chkUsers.isSelected()) {
            this.m_lstIdentities.addAll(this.m_lstUsers);
        }
        if (this.m_chkGroups.isSelected()) {
            this.m_lstIdentities.addAll(this.m_lstGroups);
        }
        Collections.sort(this.m_lstIdentities);
        ArrayList<SortableIdentity> lstSourceData = new ArrayList<SortableIdentity>();
        ArrayList<SortableIdentity> lstTargetData = new ArrayList<SortableIdentity>();
        lstSourceData.addAll(this.m_lstIdentities);
        WAWizardDialog dialog = (WAWizardDialog)this.getTopLevelAncestor();
        List lstWizardData = (List)dialog.getWizardData("Identities");
        if (lstWizardData != null) {
            for (int wdIndex = 0; wdIndex < lstWizardData.size(); ++wdIndex) {
                SortableIdentity wdid = (SortableIdentity)lstWizardData.get(wdIndex);
                for (sdIndex = 0; sdIndex < lstSourceData.size(); ++sdIndex) {
                    SortableIdentity sdid = (SortableIdentity)lstSourceData.get(sdIndex);
                    if (!sdid.getDisplayName().equalsIgnoreCase(wdid.getDisplayName())) continue;
                    lstSourceData.remove(sdid);
                    break;
                }
                bFound = false;
                for (tdIndex = 0; tdIndex < lstTargetData.size(); ++tdIndex) {
                    tdid = (SortableIdentity)lstTargetData.get(tdIndex);
                    if (!tdid.getDisplayName().equalsIgnoreCase(wdid.getDisplayName())) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                lstTargetData.add(wdid);
            }
        } else if (this.m_chkGroups.isSelected()) {
            for (int dIndex = 0; dIndex < this.m_lstDefaults.size(); ++dIndex) {
                SortableIdentity did = this.m_lstDefaults.get(dIndex);
                for (sdIndex = 0; sdIndex < lstSourceData.size(); ++sdIndex) {
                    SortableIdentity sdid = (SortableIdentity)lstSourceData.get(sdIndex);
                    if (!sdid.getDisplayName().equalsIgnoreCase(did.getDisplayName())) continue;
                    lstSourceData.remove(sdid);
                    break;
                }
                bFound = false;
                for (tdIndex = 0; tdIndex < lstTargetData.size(); ++tdIndex) {
                    tdid = (SortableIdentity)lstTargetData.get(tdIndex);
                    if (!tdid.getDisplayName().equalsIgnoreCase(did.getDisplayName())) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                lstTargetData.add(did);
            }
        }
        DefaultListModel mdlSource = new DefaultListModel();
        for (int index = 0; index < lstSourceData.size(); ++index) {
            mdlSource.add(index, lstSourceData.get(index));
        }
        this.m_selIdentities.setModel(mdlSource);
        DefaultListModel mdlTarget = new DefaultListModel();
        for (int index = 0; index < lstTargetData.size(); ++index) {
            mdlTarget.add(index, lstTargetData.get(index));
        }
        this.m_selIdentities.setTargetModel(mdlTarget);
    }

    protected void onEnableIdentities() {
        ArrayList<SortableIdentity> lstSourceData = new ArrayList<SortableIdentity>();
        ListModel mdlTarget = this.m_selIdentities.getTargetModel();
        ArrayList<SortableIdentity> lstTargetData = new ArrayList<SortableIdentity>();
        for (int tIndex = 0; tIndex < mdlTarget.getSize(); ++tIndex) {
            lstTargetData.add((SortableIdentity)mdlTarget.getElementAt(tIndex));
        }
        if (this.m_chkUsers.isSelected()) {
            lstSourceData.addAll(this.m_lstUsers);
        }
        if (this.m_chkGroups.isSelected()) {
            lstSourceData.addAll(this.m_lstGroups);
        }
        Collections.sort(lstSourceData);
        if (this.m_chkGroups.isSelected()) {
            lstSourceData.removeAll(lstTargetData);
        }
        DefaultListModel mdlSource = new DefaultListModel();
        for (int index = 0; index < lstSourceData.size(); ++index) {
            mdlSource.add(index, lstSourceData.get(index));
        }
        this.m_selIdentities.setModel(mdlSource);
    }

    public String createFinishString() {
        String strFinish = bundle.getString("AuthorizationView.Label.Finish.txt") + "\n\t";
        ListModel mdlTarget = this.m_selIdentities.getTargetModel();
        ArrayList<SortableIdentity> lstTargetData = new ArrayList<SortableIdentity>();
        for (int tIndex = 0; tIndex < mdlTarget.getSize(); ++tIndex) {
            lstTargetData.add((SortableIdentity)mdlTarget.getElementAt(tIndex));
        }
        for (int index = 0; index < lstTargetData.size(); ++index) {
            SortableIdentity id = (SortableIdentity)lstTargetData.get(index);
            strFinish = strFinish + id.getDisplayName();
            if (index < 0 || index >= lstTargetData.size() - 1) continue;
            strFinish = strFinish + ",\n\t";
        }
        strFinish = strFinish + "\n";
        return strFinish;
    }

    public void onBack() {
        this.saveWizardData();
    }

    public void onNext() {
        this.saveWizardData();
    }

    private void saveWizardData() {
        WAWizardDialog dialog = (WAWizardDialog)this.getTopLevelAncestor();
        ListModel mdlTarget = this.m_selIdentities.getTargetModel();
        ArrayList<SortableIdentity> lstTargetData = new ArrayList<SortableIdentity>();
        for (int tIndex = 0; tIndex < mdlTarget.getSize(); ++tIndex) {
            lstTargetData.add((SortableIdentity)mdlTarget.getElementAt(tIndex));
        }
        dialog.replaceWizardData("Identities", lstTargetData);
    }

    protected void initialize() {
        if (this.m_server != null) {
            this.setHelpProduct("newserver");
            this.setHelpTopic("servwiz_auth");
        } else if (this.m_library != null) {
            this.setHelpProduct("newlibrary");
            this.setHelpTopic("libwiz_auth");
        }
        Font labelFont = UIManager.getFont("Label.font");
        this.m_txtHeader = new WATextArea();
        this.m_txtHeader.setLineWrap(true);
        this.m_txtHeader.setWrapStyleWord(true);
        if (this.m_server != null) {
            this.m_txtHeader.setText(bundle.getString("AuthorizationView.Header.Server.txt"));
        } else if (this.m_library != null) {
            this.m_txtHeader.setText(bundle.getString("AuthorizationView.Header.Library.txt"));
        }
        this.m_txtHeader.setFont(labelFont);
        this.m_txtHeader.setBackground(this.getBackground());
        this.m_txtHeader.setBehavior(1);
        this.m_chkUsers = new JCheckBox(bundle.getString("AuthorizationView.Label.ShowUsers.txt"));
        this.m_chkUsers.setSelected(false);
        this.m_chkUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AuthorizationView.this.onEnableIdentities();
            }
        });
        this.m_chkGroups = new JCheckBox(bundle.getString("AuthorizationView.Label.ShowGroups.txt"));
        this.m_chkGroups.setSelected(true);
        this.m_chkGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AuthorizationView.this.onEnableIdentities();
            }
        });
        this.m_selIdentities = new DualListSelector();
        this.m_selIdentities.setPreferredSize(new Dimension(650, 300));
        this.m_selIdentities.setSourceCellRenderer((ListCellRenderer)new IdentityCellRenderer());
        this.m_selIdentities.setTargetCellRenderer((ListCellRenderer)new IdentityCellRenderer());
        ((JList)this.m_selIdentities.getSourceComponent()).setFixedCellHeight(this.getFontMetrics(this.getFont()).getHeight());
        ((JList)this.m_selIdentities.getSourceComponent()).setFixedCellHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.m_selIdentities.setSourceLabel(bundle.getString("AuthorizationView.Label.Available.txt"));
        this.m_selIdentities.setTargetLabel(bundle.getString("AuthorizationView.Label.Selected.txt"));
    }

    protected void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_txtHeader, gbc);
        this.add((Component)this.m_txtHeader);
        FlowLayout lytFlow = new FlowLayout(0, 0, 0);
        JPanel pnlShow = new JPanel(lytFlow);
        pnlShow.add(this.m_chkUsers);
        pnlShow.add(this.m_chkGroups);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(pnlShow, gbc);
        this.add(pnlShow);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints((Component)this.m_selIdentities, gbc);
        this.add((Component)this.m_selIdentities);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        }
        return false;
    }

    protected class SortableIdentity
    implements Comparable<java.lang.Object> {
        private Identity m_identity;

        public SortableIdentity(Identity identity) {
            this.m_identity = identity;
        }

        public Identity getIdentity() {
            return this.m_identity;
        }

        public String getDisplayName() {
            try {
                if (this.m_identity.getDisplayName().trim().length() == 0) {
                    return this.m_identity.getName();
                }
                return this.m_identity.getDisplayName();
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((java.lang.Object)exc.getLocalizedMessage());
                return super.toString();
            }
        }

        @Override
        public int compareTo(java.lang.Object o) {
            return this.getDisplayName().compareToIgnoreCase(((SortableIdentity)o).getDisplayName());
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private class IdentityCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private IdentityCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, java.lang.Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            try {
                if (value instanceof SortableIdentity) {
                    SortableIdentity id = (SortableIdentity)value;
                    if (id.getIdentity().getPublicType().equalsIgnoreCase("User")) {
                        ((JLabel)comp).setIcon(Resources.getImageIcon((String)bundle.getString("AuthirizationView.Icon.User.image"), (int)16));
                    } else if (id.getIdentity().getPublicType().equalsIgnoreCase("UserGroup")) {
                        ((JLabel)comp).setIcon(Resources.getImageIcon((String)bundle.getString("AuthirizationView.Icon.Group.image"), (int)16));
                    }
                    ((JLabel)comp).setText(((SortableIdentity)value).getDisplayName());
                }
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((java.lang.Object)exc.getLocalizedMessage());
            }
            return comp;
        }
    }
}

