/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainDialog;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthenticationDomainsTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int NAME_COLUMN = 0;
    public static final int DESC_COLUMN = 1;
    public static final int OUTBOUNDONLY_COLUMN = 2;
    public static final int TRUSTED_COLUMN = 3;
    protected MdObjectStore m_objectStore;
    private List m_domainList;
    protected static WAdminResource bundle = new WAdminResource(AuthenticationDomainsTableModel.class);
    protected boolean m_bModelObjChanged = false;
    protected boolean m_bContentsChanged = false;
    protected ArrayList m_rmvdTableItems = new ArrayList(4);
    private String m_reposID;
    protected Boolean m_model16OrLater;

    public AuthenticationDomainsTableModel(String reposID, MdObjectStore objectStore) {
        this.m_reposID = reposID;
        this.m_objectStore = objectStore;
        this.m_domainList = new ArrayList();
        this.m_model16OrLater = AuthenticationDomainDialog.getModelVersion().compareToIgnoreCase("16") >= 0;
        this.m_aColumns = this.m_model16OrLater != false ? new WsAbstractTableColumn[4] : new WsAbstractTableColumn[2];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("AuthDomain.Label.Name.txt"), 200);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("AuthDomain.Label.Desc.txt"), 200);
        if (this.m_model16OrLater.booleanValue()) {
            this.m_aColumns[2] = new WsBooleanTableColumn(2, bundle.getString("AuthDomain.OutboundOnly.Label.txt"), 150);
            this.m_aColumns[3] = new WsBooleanTableColumn(3, bundle.getString("AuthDomain.TrustedOnly.Label.txt"), 150);
        }
    }

    protected List buildTableItems(List domains) {
        ArrayList<AuthenticationDomain> tItems = new ArrayList<AuthenticationDomain>();
        try {
            for (int i = 0; i < domains.size(); ++i) {
                AuthenticationDomain domain = (AuthenticationDomain)domains.get(i);
                tItems.add(domain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tItems;
    }

    public void setItemList(Collection rowItems) {
        this.clear();
        this.m_lData.addAll(rowItems);
        this.fireTableModelPopulated();
    }

    public void refreshModelData() {
        int flags = 8456;
        try {
            this.m_domainList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.m_reposID, "AuthenticationDomain", flags, "");
        }
        catch (MdException e) {
            e.printStackTrace();
            this.m_domainList = new ArrayList();
        }
        catch (RemoteException re) {
            this.m_domainList = new ArrayList();
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        this.setItemList(this.buildTableItems(this.m_domainList));
        this.setModelObjChanged(false);
        this.setContentsChanged(false);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            Object retval = "";
            if (rowIndex < this.m_lData.size()) {
                AuthenticationDomain tableItem = (AuthenticationDomain)this.m_lData.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        try {
                            retval = tableItem.getName() == null ? "" : tableItem.getName();
                        }
                        catch (RemoteException re) {
                            retval = "";
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                        }
                        break;
                    }
                    case 1: {
                        retval = tableItem.getDesc() == null ? "" : tableItem.getDesc();
                        break;
                    }
                    case 2: {
                        retval = tableItem.getOutboundOnly() != 0;
                        break;
                    }
                    case 3: {
                        retval = tableItem.getTrustedOnly() != 0;
                        break;
                    }
                    default: {
                        retval = "";
                    }
                }
            }
            return retval;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public boolean containsMetaObj(CMetadata matchTarget) {
        try {
            boolean retval = false;
            for (int i = 0; i < this.m_lData.size(); ++i) {
                AuthenticationDomain currAuthenticationDomain = (AuthenticationDomain)this.m_lData.get(i);
                if (currAuthenticationDomain.getFQID().compareTo(matchTarget.getFQID()) != 0) continue;
                retval = true;
                break;
            }
            return retval;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public List getDomainList() {
        return this.m_domainList;
    }

    public boolean containsDomainName(String domainName) {
        if (domainName == null) {
            return false;
        }
        try {
            for (int index = 0; index < this.m_domainList.size(); ++index) {
                AuthenticationDomain authDomain = (AuthenticationDomain)this.m_domainList.get(index);
                if (authDomain == null || !authDomain.getName().equalsIgnoreCase(domainName)) continue;
                return true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    public boolean addAuthenticationDomain(AuthenticationDomain domain) {
        if (domain == null || this.containsMetaObj((CMetadata)domain)) {
            return false;
        }
        this.m_lData.add(domain);
        try {
            if (!this.containsDomainName(domain.getName())) {
                this.m_domainList.add(domain);
            }
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        this.setContentsChanged(true);
        this.fireTableRowsInserted(this.m_lData.size() - 1, this.m_lData.size() - 1);
        return true;
    }

    public boolean removeTableItem(int row) {
        this.m_rmvdTableItems.add(this.m_lData.get(row));
        if (this.m_lData.remove(row) != null) {
            this.setContentsChanged(true);
            this.fireTableRowsDeleted(row, row);
            return true;
        }
        return false;
    }

    public void clearRmvdTableItems() {
        this.m_rmvdTableItems.clear();
    }

    public List getRmvdTableItems() {
        return this.m_rmvdTableItems;
    }

    public AuthenticationDomain getObjectAt(int index) {
        return (AuthenticationDomain)this.m_lData.get(index);
    }

    public void setModelObjChanged(boolean bChanged) {
        this.m_bModelObjChanged = bChanged;
    }

    public boolean hasModelObjChanged() {
        return this.m_bModelObjChanged;
    }

    public void setContentsChanged(boolean bChanged) {
        this.m_bContentsChanged = bChanged;
    }

    public boolean haveContentsChanged() {
        return this.m_bContentsChanged;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }
}

