/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.mgmt.MnemonicModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthenticationDomainDialog
extends WAStandardDialog
implements ItemListener {
    protected AuthenticationDomain m_domain;
    public static final int NEW = 0;
    public static final int EDIT = 1;
    protected int m_mode = 0;
    protected List m_domainList;
    protected Component m_component;
    protected String m_strContext;
    protected MdObjectStore m_objectStore;
    protected JLabel m_nameLabel;
    protected JTextField m_nameText;
    protected JLabel m_descLabel;
    protected JTextField m_descText;
    protected JCheckBox m_outBoundOnlyBox;
    protected JCheckBox m_trustedOnlyBox;
    protected Boolean m_isUserAdmin = false;
    protected Boolean m_modelOlderThan16;
    private static final WAdminResource bundle = WAdminResource.getBundle(AuthenticationDomainDialog.class);
    private static final long serialVersionUID = 1L;

    public AuthenticationDomainDialog(Frame frame, MdObjectStore objectStore, String strContext) {
        this(frame, objectStore, strContext, null, null);
    }

    public AuthenticationDomainDialog(Dialog dialog, MdObjectStore objectStore, String strContext) {
        super(dialog, bundle.getString("AuthenticationDomainDialog.Title.txt"), true);
        this.m_component = dialog;
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this.m_mode = 0;
        this._initialize();
        this._layoutWidgets();
    }

    public AuthenticationDomainDialog(Frame frame, MdObjectStore objectStore, String strContext, AuthenticationDomain domain, List domainList) {
        super(frame, bundle.getString("AuthenticationDomainDialog.Title.txt"), true);
        this.m_component = frame;
        this.m_objectStore = objectStore;
        this.m_strContext = strContext;
        this.m_domainList = domainList;
        this.m_domain = domain;
        this.m_mode = domain == null ? 0 : 1;
        this._initialize();
        this._layoutWidgets();
    }

    protected boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_mode == 0) {
                return this.createDomain();
            }
            if (this.m_mode == 1) {
                try {
                    this.m_domain.setName(this.m_nameText.getText().trim());
                    this.m_domain.setDesc(this.m_descText.getText().trim());
                    if (!this.m_modelOlderThan16.booleanValue()) {
                        int outBoundOnly = this.m_outBoundOnlyBox.isSelected() ? 1 : 0;
                        this.m_domain.setOutboundOnly(outBoundOnly);
                        int trustedOnly = this.m_trustedOnlyBox.isSelected() ? 1 : 0;
                        this.m_domain.setTrustedOnly(trustedOnly);
                        if (this.m_outBoundOnlyBox.isSelected() || this.m_trustedOnlyBox.isSelected()) {
                            this.m_domain.setUsageVersion(1010000.0);
                        } else {
                            this.m_domain.setUsageVersion(1000000.0);
                        }
                    }
                    this.m_domain.updateMetadataAll();
                    return true;
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    return false;
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    return false;
                }
            }
        } else {
            if (this.m_domainList == null) {
                try {
                    int flags = 8456;
                    this.m_domainList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_objectStore, this.m_strContext, "AuthenticationDomain", flags, "");
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                    return false;
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    return false;
                }
            }
            if (this.m_mode == 1) {
                try {
                    this.m_nameText.setText(this.m_domain.getName());
                    this.m_descText.setText(this.m_domain.getDesc());
                    if (!this.m_modelOlderThan16.booleanValue()) {
                        Boolean outBoundOnly = this.m_domain.getOutboundOnly() == 1;
                        this.m_outBoundOnlyBox.setSelected(outBoundOnly);
                        Boolean trustedOnly = this.m_domain.getTrustedOnly() == 1;
                        this.m_trustedOnlyBox.setSelected(trustedOnly);
                    }
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    return false;
                }
            }
        }
        return true;
    }

    private boolean createDomain() {
        try {
            String strReposType = WsRepositoryUtil.getRepositoryType((MdFactory)Workspace.getMdFactory(), (String)this.m_strContext);
            if (!strReposType.equalsIgnoreCase("FOUNDATION")) {
                String strTitle;
                Object[] options = new Object[]{MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")), MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.No.txt"))};
                String strMessage = bundle.getString("AuthenticationDomainDialog.DomainInFoundationMessage.txt");
                int returnValue = JOptionPane.showOptionDialog((Component)((Object)this), strMessage, strTitle = MnemonicModel.getLabelWithoutMnemonic(bundle.getString("Common.Warning.txt")), -1, 2, null, options, options[1]);
                if (returnValue != 0) {
                    return false;
                }
            }
            this.m_domain = (AuthenticationDomain)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, this.m_nameText.getText().trim(), "AuthenticationDomain", this.m_strContext.substring(9));
            this.m_domain.setDesc(this.m_descText.getText().trim());
            this.m_domain.setPublicType("AuthenticationDomain");
            this.m_domain.setUsageVersion(1000000.0);
            if (!this.m_modelOlderThan16.booleanValue()) {
                int outBoundOnly = this.m_outBoundOnlyBox.isSelected() ? 1 : 0;
                this.m_domain.setOutboundOnly(outBoundOnly);
                int trustedOnly = this.m_trustedOnlyBox.isSelected() ? 1 : 0;
                this.m_domain.setTrustedOnly(trustedOnly);
                if (this.m_outBoundOnlyBox.isSelected() || this.m_trustedOnlyBox.isSelected()) {
                    this.m_domain.setUsageVersion(1010000.0);
                }
            }
            this.m_domain.updateMetadataAll();
            return true;
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            return false;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return false;
        }
    }

    protected boolean validateData() {
        try {
            String msgTitle;
            String prompt;
            int response;
            if (this.m_nameText.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.m_component, bundle.getString("GeneralPropertyView.NameFieldRequired.txt"), bundle.getString("Common.RequiredField.txt"), 0);
                return false;
            }
            if (this.m_mode == 1 && this.m_domain.getName().equalsIgnoreCase(this.m_nameText.getText().trim())) {
                return true;
            }
            if (this.m_mode == 1 && (response = MessageUtil.displayMessage((String)(prompt = bundle.getString("AuthenticationDomainDialog.ConfirmationPrompt.txt")), (String)(msgTitle = bundle.getString("AuthenticationDomainDialog.ConfirmationTitle.txt")), (int)3, (int)0)) == 1) {
                return false;
            }
            for (int i = 0; i < this.m_domainList.size(); ++i) {
                AuthenticationDomain domain = (AuthenticationDomain)this.m_domainList.get(i);
                if (!domain.getName().equalsIgnoreCase(this.m_nameText.getText().trim())) continue;
                JOptionPane.showMessageDialog(this.m_component, bundle.getString("AuthenticationDomainDialog.NameExistsError.txt"), bundle.getString("Common.Error.txt"), 0);
                return false;
            }
            return true;
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return false;
        }
    }

    public AuthenticationDomain getAuthenticationDomain() {
        return this.m_domain;
    }

    public Root getMetadataObject() {
        return this.m_domain;
    }

    protected void _initialize() {
        this.setHelpProduct("templatedata");
        if (this.m_mode == 0) {
            this.setHelpTopic("new_authdomain");
        } else if (this.m_mode == 1) {
            this.setHelpTopic("edit_authdomain");
        }
        this.m_nameLabel = new JLabel(bundle.getString("AuthenticationDomainDialog.Name.txt"));
        this.m_nameText = new JTextField(25);
        this.m_descLabel = new JLabel(bundle.getString("AuthenticationDomainDialog.Description.txt"));
        this.m_descText = new JTextField(25);
        this.m_outBoundOnlyBox = new JCheckBox(bundle.getString("AuthenticationDomainDialog.OutBoundOnly.txt"));
        this.m_outBoundOnlyBox.addItemListener(this);
        this.m_trustedOnlyBox = new JCheckBox(bundle.getString("AuthenticationDomainDialog.TrustedOnly.txt"));
        this.m_trustedOnlyBox.addItemListener(this);
        this.m_trustedOnlyBox.setEnabled(false);
        this.m_isUserAdmin = this.isUserAdministrator();
        this.setResizable(true);
    }

    protected void _layoutWidgets() {
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 10, 0, 0);
        gridBagLayout.setConstraints(this.m_nameLabel, gbc);
        panel.add(this.m_nameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 10, 0, 12);
        gridBagLayout.setConstraints(this.m_nameText, gbc);
        panel.add(this.m_nameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 10, 12, 0);
        gridBagLayout.setConstraints(this.m_descLabel, gbc);
        panel.add(this.m_descLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 10, 12, 12);
        gridBagLayout.setConstraints(this.m_descText, gbc);
        panel.add(this.m_descText);
        JPanel checkBoxPanel = new JPanel(new FlowLayout(0));
        checkBoxPanel.add(this.m_outBoundOnlyBox);
        checkBoxPanel.add(this.m_trustedOnlyBox);
        this.m_trustedOnlyBox.setEnabled(this.m_outBoundOnlyBox.isSelected());
        this.m_outBoundOnlyBox.setEnabled(this.m_isUserAdmin);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)panel, "Center");
        contentPanel.add((Component)checkBoxPanel, "South");
        this.getContentPane().add(contentPanel);
        String modelVersion = AuthenticationDomainDialog.getModelVersion();
        this.m_modelOlderThan16 = modelVersion.compareToIgnoreCase("16") < 0;
        checkBoxPanel.setVisible(this.m_modelOlderThan16 == false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable item = e.getItemSelectable();
        this.m_trustedOnlyBox.setEnabled(this.m_outBoundOnlyBox.isSelected());
        if (!this.m_outBoundOnlyBox.isSelected()) {
            this.m_trustedOnlyBox.setSelected(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isUserAdministrator() {
        boolean bl;
        IOMI iOmi = Workspace.getWorkspace().getCMRHandle();
        ISecurity_1_1 iSecurity = null;
        if (iOmi == null) return false;
        VariableArray2dOfStringHolder returnInfo = new VariableArray2dOfStringHolder();
        String[][] parms = new String[][]{};
        try {
            iSecurity = Workspace.getMdFactory().getConnection().MakeISecurityConnection(iOmi);
            iSecurity.GetInfo("GetIdentityInfo", "", parms, returnInfo);
            for (int i = 0; i < returnInfo.value.length; ++i) {
                String userClasses;
                if (!returnInfo.value[i][0].trim().equalsIgnoreCase("UserClass") || (userClasses = returnInfo.value[i][1].trim()).indexOf("Unrestricted") == -1 && userClasses.indexOf("IdentityAdmin") == -1) continue;
                bl = true;
            }
        }
        catch (Exception e) {
            try {
                MessageUtil.displayMessage((String)e.getMessage(), (int)0);
            }
            catch (Throwable throwable) {
                AuthenticationDomainDialog.closeISecurityConnection(iSecurity);
                throw throwable;
            }
            AuthenticationDomainDialog.closeISecurityConnection((ISecurity)iSecurity);
            return false;
        }
        AuthenticationDomainDialog.closeISecurityConnection((ISecurity)iSecurity);
        return false;
        AuthenticationDomainDialog.closeISecurityConnection((ISecurity)iSecurity);
        return bl;
    }

    public static String getModelVersion() {
        String serverStatusOptions = "<ModelVersion/>";
        StringHolder serverStatusResponse = new StringHolder();
        IOMI iOmi = Workspace.getWorkspace().getCMRHandle();
        MdOMRConnection mworkspace = null;
        IServer iserver = null;
        try {
            mworkspace = Workspace.getMdFactory().getConnection();
            iserver = mworkspace.MakeIServerConnection(iOmi);
            iserver.Status("<ModelVersion/>", serverStatusResponse, "");
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML("<metadata>" + serverStatusResponse.value + "</metadata>");
            NodeList nodeList = doc.getElementsByTagName("ModelVersion");
            Node node = nodeList.item(0);
            NodeList childList = node.getChildNodes();
            Node childNode = childList.item(0);
            String modelVersion = "";
            if (childNode != null) {
                modelVersion = childNode.getNodeValue();
            }
            return modelVersion;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static void closeISecurityConnection(ISecurity secureConnection) {
        try {
            secureConnection._release();
            secureConnection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

