/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_ALREADY_EXISTS;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.SecurityRuleScheme;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.TypeDefinition;
import com.sas.metadata.tools.appmeta.ApplicationMetadataUtility2;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.mgmt.IdentityReposPair;
import com.sas.workspace.mgmt.visuals.NewReposWizard;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepositoryUtil {
    public static final int GRANT = 1;
    public static final int DENY = 2;
    public static final int GRANTandDENY = 3;
    public static final String[] PERMISSION_NAMES = new String[]{"ReadMetadata", "WriteMetadata", "CheckInMetadata", "Read", "Write", "Administer", "Create", "Delete", "Execute", "WriteMemberMetadata", "Create Table", "Drop Table", "Alter Table", "Select", "Insert", "Update", "References"};
    public static final int READ_METADATA_POS = 0;
    public static final int WRITE_METADATA_POS = 1;
    public static final int CHECKIN_METADATA_POS = 2;
    public static final int READ_POS = 3;
    public static final int WRITE_POS = 4;
    public static final int ADMINISTER_POS = 5;
    public static final int CREATE_POS = 6;
    public static final int DELETE_POS = 7;
    public static final int EXECUTE_POS = 8;
    public static final int WRITE_MEMBER_METADATA_POS = 9;
    public static final int CREATE_TABLE_POS = 10;
    public static final int DROP_TABLE_POS = 11;
    public static final int ALTER_TABLE_POS = 12;
    public static final int SELECT_POS = 13;
    public static final int INSERT_POS = 14;
    public static final int UPDATE_POS = 15;
    public static final int REFERENCES_POS = 16;
    public static final int MAX_NUM_DEFAULT_PERMISSIONS = 17;
    public static final int NONE = 0;
    public static final String USER_FOLDER_SEPARATOR = "/";
    public static final int[][] NUM_PERMISSIONS_FOR_RELEASE = new int[][]{{9200, 17}, {9130, 8}, {9120, 8}};
    public static final String CURRENT_RELEASE = "9.3.0";
    public static final String CURRENT_FIXPACK = "24";
    protected static final String REPOSITORY_MANAGER_ID = "A0000001.A0000001";
    public static final String BIPSERVICE_CLASSID = "E5F27790-2149-11D6-8828-AA0004006D06";
    public static final int OLDEST_REPOSITORY_VERSION_SUPPORTED = 6;
    private static WAdminResource bundle = WAdminResource.getBundle(NewReposWizard.class);
    private static WAdminResource bundle2 = WAdminResource.getBundle(RepositoryUtil.class);
    private static Map _fileList = null;
    private static SessionContextInterface _session = null;
    private static DocumentBuilderFactory documentFactory = null;
    private static ApplicationMetadataUtility2 _amu = null;

    public static int setChangeManaged(MdFactory m_Factory, String strReposId) throws Exception {
        int rc = 0;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        StringBuffer inXMLBuffer = new StringBuffer("<Group Name=\"ChangeManagement\"/>");
        if (WsRepositoryUtil.isChangeManagedRepository((MdFactory)m_Factory, (String)strReposId)) {
            return rc;
        }
        StringHolder outXML = new StringHolder();
        String inXML = inXMLBuffer.toString();
        rc = omiConnection.AddMetadata(inXML, strReposId, outXML, "SAS", 0x10000000, "");
        return rc;
    }

    public static boolean removeChangeManaged(MdFactory m_Factory, String strReposId) throws Exception {
        StringHolder outXML;
        MdObjectStore store = m_Factory.createObjectStore();
        String strSelect = "<XMLSELECT Search=\"@Name='ChangeManagement'\"/>";
        int flags = 392;
        List groupList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Group", flags, strSelect, false);
        if (groupList == null || groupList.size() == 0) {
            store.dispose();
            return true;
        }
        Group grp = (Group)groupList.get(0);
        String inXML = "";
        inXML = "<Group ID=\"" + grp.getFQID() + "\" />";
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        int rc = omiConnection.DeleteMetadata(inXML, outXML = new StringHolder(), "SAS", 0x10000000, "");
        if (rc != 0) {
            store.dispose();
            return false;
        }
        store.dispose();
        return true;
    }

    public static void createBIPTree(MdFactory m_Factory, String strReposId) throws Exception {
        if (WsRepositoryUtil.BIPTreeExists((MdFactory)m_Factory, (String)strReposId)) {
            return;
        }
        String userFolder = bundle.getString("Common.DefaultFolderPolicy.txt");
        String scDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.BIPService.Description.txt"));
        String prodDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ProductFolder.Description.txt"));
        String sharedDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SharedDataFolder.Description.txt"));
        String userDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.UserFolder.Description.txt"));
        String systemDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SystemFolder.Description.txt"));
        String adminDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.AdministrationFolder.Description.txt"));
        String appsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ApplicationsFolder.Description.txt"));
        String typesDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.TypesFolder.Description.txt"));
        String servDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ServicesFolder.Description.txt"));
        String pubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.PublishingFolder.Description.txt"));
        String channelsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ChannelsFolder.Description.txt"));
        String subsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SubscribersFolder.Description.txt"));
        String contentsubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ContentsFolder.Description.txt"));
        String eventsubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.EventsFolder.Description.txt"));
        String secLibFolderDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SecuredLibrariesFolder.Description.txt"));
        StringBuffer inXMLBuffer = new StringBuffer();
        inXMLBuffer.append("<SoftwareComponent Name=\"BIP Service\" Desc=\"" + scDesc + "\" ClassIdentifier=\"E5F27790-2149-11D6-8828-AA0004006D06\" IsLicensed=\"0\" Major=\"9\" Minor=\"2\" ProductName=\"SAS\" Platform=\"Java\" PublicType=\"RootFolder\" UsageVersion=\"1000000.0\" >");
        inXMLBuffer.append("<SoftwareTrees>");
        inXMLBuffer.append("<Tree Name=\"Products\" Desc=\"" + prodDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/> ");
        inXMLBuffer.append("<Tree Name=\"Shared Data\" Desc=\"" + sharedDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"" + userFolder + "\" Desc=\"" + userDesc + "\" TreeType=\"System\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"System\" Desc=\"" + systemDesc + "\" TreeType=\"System\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Administration\" Desc=\"" + adminDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Applications\" Desc=\"" + appsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Types\" Desc=\"" + typesDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Services\" Desc=\"" + servDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Secured Libraries\" Desc=\"" + secLibFolderDesc + "\" TreeType=\"System\" PublicType=\"Folder.SecuredData\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Publishing\" Desc=\"" + pubsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Channels\" Desc=\"" + channelsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Subscribers\" Desc=\"" + subsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Content Subscribers\" Desc=\"" + contentsubsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Event Subscribers\" Desc=\"" + eventsubsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SoftwareTrees>");
        inXMLBuffer.append("</SoftwareComponent>");
        String inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        m_Factory.getOMIUtil().addMetadata(inXML, strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length()), outXML, 0x10000000);
        String outXMLString = "<dummy>" + outXML.value + "</dummy>";
        Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            String strResourceId;
            String strName;
            NamedNodeMap nodeMap;
            Node currentNode;
            String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
            IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
            ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
            if (iSecAdmin == null) {
                throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error8.txt"));
            }
            Element replyRoot = mainDoc.getDocumentElement();
            NodeList nodeList = replyRoot.getElementsByTagName("Tree");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                nodeMap = currentNode.getAttributes();
                strName = nodeMap.getNamedItem("Name").getNodeValue();
                if (!strName.equals(userFolder) && !strName.equals("System")) continue;
                strResourceId = "OMSOBJ:Tree/" + nodeMap.getNamedItem("Id").getNodeValue();
                iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
            }
            NodeList nodeList2 = replyRoot.getElementsByTagName("SoftwareComponent");
            currentNode = nodeList2.item(0);
            nodeMap = currentNode.getAttributes();
            strName = nodeMap.getNamedItem("Name").getNodeValue();
            if (strName.equals("BIP Service")) {
                strResourceId = "OMSOBJ:SoftwareComponent/" + nodeMap.getNamedItem("Id").getNodeValue();
                iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
            }
        }
    }

    public static void upgradeBIPTree(MdFactory m_Factory, Repository repos) throws Exception {
        String strReposId = repos.getFQID();
        MdObjectStore store = m_Factory.createObjectStore();
        boolean bUsersFolderCreated = false;
        boolean bSystemFolderCreated = false;
        String strSelect = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
        String strTemplate = "<Templates><SoftwareComponent Name=\"\"><SoftwareTrees/></SoftwareComponent></Templates>";
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        List comps = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "SoftwareComponent", flags, strOptions, false);
        SoftwareComponent sc = null;
        if (comps.size() != 1) {
            return;
        }
        sc = (SoftwareComponent)comps.get(0);
        Vector trees = new Vector(sc.getSoftwareTrees());
        ArrayList<String> TreeNamesList = new ArrayList<String>();
        Tree IntTechTree = null;
        Tree UsersTree = null;
        Tree SystemTree = null;
        for (int i = 0; i < trees.size(); ++i) {
            Tree tree = (Tree)trees.get(i);
            TreeNamesList.add(tree.getName());
            if (tree.getName().equalsIgnoreCase("Integration Technologies")) {
                IntTechTree = tree;
            }
            if (!tree.getName().equalsIgnoreCase("System")) continue;
            SystemTree = tree;
        }
        String usersFolder = bundle.getString("Common.DefaultFolderPolicy.txt");
        if (!TreeNamesList.contains(usersFolder)) {
            String userDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.UserFolder.Description.txt"));
            UsersTree = RepositoryUtil.createRootTreeNode(m_Factory, store, strReposId, usersFolder, userDesc, "System", sc);
            bUsersFolderCreated = true;
        }
        if (!TreeNamesList.contains("Products")) {
            String prodDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ProductFolder.Description.txt"));
            RepositoryUtil.createRootTreeNode(m_Factory, store, strReposId, "Products", prodDesc, null, sc);
        }
        if (!TreeNamesList.contains("Shared Data")) {
            String sharedDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SharedDataFolder.Description.txt"));
            RepositoryUtil.createRootTreeNode(m_Factory, store, strReposId, "Shared Data", sharedDesc, null, sc);
        }
        if (SystemTree == null) {
            String systemDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SystemFolder.Description.txt"));
            SystemTree = RepositoryUtil.createRootTreeNode(m_Factory, store, strReposId, "System", systemDesc, "System", sc);
            bSystemFolderCreated = true;
            String adminDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.AdministrationFolder.Description.txt"));
            RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Administration", adminDesc, SystemTree);
            String appsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ApplicationsFolder.Description.txt"));
            RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Applications", appsDesc, SystemTree);
            String typesDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.TypesFolder.Description.txt"));
            RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Types", typesDesc, SystemTree);
            String servDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ServicesFolder.Description.txt"));
            RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Services", servDesc, SystemTree);
            if (IntTechTree != null) {
                RepositoryUtil.reparentIntTechTree(IntTechTree, SystemTree);
            } else {
                String pubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.PublishingFolder.Description.txt"));
                Tree PubsTree = RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Publishing", pubsDesc, SystemTree);
                String channelsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ChannelsFolder.Description.txt"));
                RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Channels", channelsDesc, PubsTree);
                String subsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SubscribersFolder.Description.txt"));
                Tree SubsTree = RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Subscribers", subsDesc, PubsTree);
                String contentsubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ContentsFolder.Description.txt"));
                RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Content Subscribers", contentsubsDesc, SubsTree);
                String eventsubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.EventsFolder.Description.txt"));
                RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Event Subscribers", eventsubsDesc, SubsTree);
            }
        } else {
            Vector SystemSubTrees = new Vector(SystemTree.getSubTrees());
            int subTreeCount = SystemSubTrees.size();
            boolean administrationFound = false;
            boolean applicationsFound = false;
            boolean typesFound = false;
            boolean pubsFound = false;
            boolean servicesFound = false;
            Tree pubsTree = null;
            for (int a = 0; a < subTreeCount; ++a) {
                Tree tree = (Tree)SystemSubTrees.get(a);
                if (tree.getName().equalsIgnoreCase("Administration")) {
                    administrationFound = true;
                }
                if (tree.getName().equalsIgnoreCase("Applications")) {
                    applicationsFound = true;
                }
                if (tree.getName().equalsIgnoreCase("Types")) {
                    typesFound = true;
                }
                if (tree.getName().equalsIgnoreCase("Services")) {
                    servicesFound = true;
                }
                if (!tree.getName().equalsIgnoreCase("Publishing")) continue;
                pubsFound = true;
                pubsTree = tree;
            }
            if (!administrationFound) {
                String adminDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.AdministrationFolder.Description.txt"));
                RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Administration", adminDesc, SystemTree);
            }
            if (!applicationsFound) {
                String appsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ApplicationsFolder.Description.txt"));
                RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Applications", appsDesc, SystemTree);
            }
            if (!typesFound) {
                String typesDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.TypesFolder.Description.txt"));
                RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Types", typesDesc, SystemTree);
            }
            if (!servicesFound) {
                String servDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ServicesFolder.Description.txt"));
                RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Services", servDesc, SystemTree);
            }
            if (!pubsFound) {
                if (IntTechTree != null) {
                    RepositoryUtil.reparentIntTechTree(IntTechTree, SystemTree);
                } else {
                    String pubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.PublishingFolder.Description.txt"));
                    Tree PubsTree = RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Publishing", pubsDesc, SystemTree);
                    String channelsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ChannelsFolder.Description.txt"));
                    RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Channels", channelsDesc, PubsTree);
                    String subsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SubscribersFolder.Description.txt"));
                    Tree SubsTree = RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Subscribers", subsDesc, PubsTree);
                    String contentsubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.ContentsFolder.Description.txt"));
                    RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Content Subscribers", contentsubsDesc, SubsTree);
                    String eventsubsDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.EventsFolder.Description.txt"));
                    RepositoryUtil.createSystemNodeSubTrees(m_Factory, store, strReposId, "Event Subscribers", eventsubsDesc, SubsTree);
                }
            } else if (IntTechTree != null) {
                ArrayList deleteList = new ArrayList();
                RepositoryUtil.removeTreeNodesandMembers(pubsTree, deleteList);
                m_Factory.deleteMetadataObjects(deleteList);
                RepositoryUtil.reparentIntTechTree(IntTechTree, SystemTree);
            }
        }
        store.updatedMetadataAll();
        if (bUsersFolderCreated || bSystemFolderCreated) {
            String strResourceId;
            String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
            IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
            ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
            if (iSecAdmin == null) {
                throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error8.txt"));
            }
            if (bUsersFolderCreated) {
                strResourceId = "OMSOBJ:Tree/" + UsersTree.getFQID();
                iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
            }
            if (bSystemFolderCreated) {
                strResourceId = "OMSOBJ:Tree/" + SystemTree.getFQID();
                iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
            }
        }
        store.dispose();
    }

    private static Tree createRootTreeNode(MdFactory m_Factory, MdObjectStore store, String strReposId, String nodeName, String desc, String treeType, SoftwareComponent parentSC) throws Exception {
        Tree newTree = (Tree)m_Factory.createComplexMetadataObject(store, (MdStore)null, nodeName, "Tree", strReposId.substring(9, 17));
        if (desc != null) {
            newTree.setDesc(desc);
        }
        if (treeType == null) {
            newTree.setTreeType("BIP Folder");
        } else {
            newTree.setTreeType(treeType);
        }
        newTree.setPublicType("Folder");
        newTree.setUsageVersion("1000000.0");
        newTree.getSoftwareComponents().add((java.lang.Object)parentSC);
        return newTree;
    }

    private static Tree createSystemNodeSubTrees(MdFactory m_Factory, MdObjectStore store, String strReposId, String nodeName, String desc, Tree parentTree) throws Exception {
        Tree subTree = (Tree)m_Factory.createComplexMetadataObject(store, (MdStore)null, nodeName, "Tree", strReposId.substring(9, 17));
        if (desc != null) {
            subTree.setDesc(desc);
        }
        subTree.setTreeType("BIP Folder");
        subTree.setPublicType("Folder");
        subTree.setUsageVersion("1000000.0");
        subTree.getParentTrees().add((java.lang.Object)parentTree);
        return subTree;
    }

    private static void removeTreeNodesandMembers(Tree treeNode, List deleteList) throws Exception {
        AssociationList subTrees = treeNode.getSubTrees();
        AssociationList members = treeNode.getMembers();
        if (members.size() > 0) {
            deleteList.addAll(members);
        }
        for (int x = 0; x < subTrees.size(); ++x) {
            Tree tree = (Tree)subTrees.get(x);
            RepositoryUtil.removeTreeNodesandMembers(tree, deleteList);
        }
        deleteList.add(treeNode);
    }

    private static void reparentIntTechTree(Tree IntTechTree, Tree parentTree) throws Exception {
        boolean reparented = false;
        Vector IntTechsubTrees = new Vector(IntTechTree.getSubTrees());
        int subTreeCount = IntTechsubTrees.size();
        for (int j = 0; j < subTreeCount; ++j) {
            Tree tree = (Tree)IntTechsubTrees.get(j);
            if (!tree.getName().equalsIgnoreCase("Publish-Subscribe")) continue;
            Vector publishsubTrees = new Vector(tree.getSubTrees());
            int pubsubTreeCount = publishsubTrees.size();
            for (int k = 0; k < pubsubTreeCount; ++k) {
                Tree pubSubtree = (Tree)publishsubTrees.get(k);
                if (!pubSubtree.getName().equalsIgnoreCase("Archiving")) continue;
                if (pubSubtree.getMembers().size() != 0 || pubSubtree.getSubTrees().size() != 0) break;
                pubSubtree.delete();
                break;
            }
            tree.setName("Publishing");
            tree.getParentTrees().removeAllElements();
            tree.getParentTrees().add((java.lang.Object)parentTree);
            reparented = true;
            --subTreeCount;
            break;
        }
        if (reparented && subTreeCount == 0 && IntTechTree.getMembers().size() == 0) {
            IntTechTree.delete();
        }
    }

    public static void upgradeCustomBIPTree(MdFactory m_Factory, Repository repos) throws Exception {
        Tree tree;
        int i;
        String strReposId = repos.getFQID();
        MdObjectStore store = m_Factory.createObjectStore();
        if (!WsRepositoryUtil.BIPTreeExists((MdFactory)m_Factory, (String)strReposId)) {
            RepositoryUtil.createBIPTreeCustom(m_Factory, repos);
            return;
        }
        String strSelect = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
        String strTemplate = "<Templates><SoftwareComponent Name=\"\"><SoftwareTrees/></SoftwareComponent></Templates>";
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        List comps = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "SoftwareComponent", flags, strOptions, false);
        SoftwareComponent sc = null;
        if (comps.size() != 1) {
            return;
        }
        sc = (SoftwareComponent)comps.get(0);
        Vector trees = new Vector(sc.getSoftwareTrees());
        String reposName = repos.getName();
        Tree reposTree = null;
        for (i = 0; i < trees.size(); ++i) {
            tree = (Tree)trees.get(i);
            if (!tree.getName().equalsIgnoreCase(reposName)) continue;
            reposTree = tree;
            break;
        }
        if (reposTree == null) {
            String reposFolderDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.formatString("RepositoryUtil.CustomReposFolder.Description.txt", (java.lang.Object)reposName));
            reposTree = RepositoryUtil.createRootTreeNode(m_Factory, store, strReposId, reposName, reposFolderDesc, "BIP Folder", sc);
        }
        if (reposTree != null) {
            String strFoundationOptions = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
            String foundationReposId = RepositoryUtil.getFoundationRepositoryId(m_Factory);
            List softComps = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, foundationReposId, "SoftwareComponent", 128, strFoundationOptions, false);
            SoftwareComponent foundationSC = null;
            if (softComps.size() != 1) {
                return;
            }
            foundationSC = (SoftwareComponent)softComps.get(0);
            reposTree.getSoftwareComponents().add((java.lang.Object)foundationSC);
        }
        for (i = 0; i < trees.size(); ++i) {
            tree = (Tree)trees.get(i);
            if (tree.getName().equalsIgnoreCase(reposName)) continue;
            tree.getSoftwareComponents().removeAllElements();
            tree.getParentTrees().add((java.lang.Object)reposTree);
        }
        store.updatedMetadataAll();
        store.dispose();
    }

    public static void createBIPTreeCustom(MdFactory m_Factory, Repository repos) throws Exception {
        String strReposId = repos.getFQID();
        String strReposName = repos.getName();
        String reposFolderName = Names.mapNameToOMRObjectName((String)strReposName);
        if (WsRepositoryUtil.BIPTreeExists((MdFactory)m_Factory, (String)strReposId)) {
            return;
        }
        String bipServiceId = RepositoryUtil.getFoundationRepositoryBIPService(m_Factory);
        if (bipServiceId == null) {
            throw new Exception(bundle2.getString("RepositoryUtil.FoundationBIPServiceId.NotFound.Error.txt"));
        }
        String scCustomDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.BIPServiceCustom.Description.txt"));
        String reposFolderDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.formatString("RepositoryUtil.CustomReposFolder.Description.txt", (java.lang.Object)strReposName));
        String systemDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SystemFolder.Description.txt"));
        String secLibFolderDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SecuredLibrariesFolder.Description.txt"));
        StringBuilder inXMLBuffer = new StringBuilder(750);
        inXMLBuffer.append("<SoftwareComponent Name=\"BIP Service\" Desc=\"" + scCustomDesc + "\" ClassIdentifier=\"E5F27790-2149-11D6-8828-AA0004006D06\" IsLicensed=\"0\" Major=\"9\" Minor=\"2\" ProductName=\"SAS\" Platform=\"Java\" PublicType=\"RootFolder\" UsageVersion=\"1000000.0\" >");
        inXMLBuffer.append("<SoftwareTrees>");
        inXMLBuffer.append("<Tree Name=\"" + reposFolderName + "\" Desc=\"" + reposFolderDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SoftwareComponents>");
        inXMLBuffer.append("<SoftwareComponent Objref=\"" + bipServiceId + "\" />");
        inXMLBuffer.append("</SoftwareComponents>");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"System\" Desc=\"" + systemDesc + "\" TreeType=\"System\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Secured Libraries\" Desc=\"" + secLibFolderDesc + "\" TreeType=\"System\" PublicType=\"Folder.SecuredData\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SoftwareTrees>");
        inXMLBuffer.append("</SoftwareComponent>");
        String inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        m_Factory.getOMIUtil().addMetadata(inXML, strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length()), outXML, 0x10000000);
        String outXMLString = "<dummy>" + outXML.value + "</dummy>";
        Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
            IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
            ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
            if (iSecAdmin == null) {
                throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error8.txt"));
            }
            Element replyRoot = mainDoc.getDocumentElement();
            NodeList nodeList = replyRoot.getElementsByTagName("SoftwareComponent");
            Node currentNode = nodeList.item(0);
            NamedNodeMap nodeMap = currentNode.getAttributes();
            String strName = nodeMap.getNamedItem("Name").getNodeValue();
            if (strName.equals("BIP Service")) {
                String strResourceId = "OMSOBJ:SoftwareComponent/" + nodeMap.getNamedItem("Id").getNodeValue();
                String strFoundationId = RepositoryUtil.getFoundationRepositoryId(m_Factory);
                String shortFoundationId = strFoundationId.substring(strFoundationId.indexOf(46) + 1, strFoundationId.length());
                String strAdminACT = "OMSOBJ:AccessControlTemplate/" + RepositoryUtil.getActId(iSecAdmin, bundle2.getString("RepositoryUtil.SASAdminACT.Name.notrans"), shortFoundationId);
                StringHolder shTransContext = new StringHolder();
                iSecAdmin.BeginTransactionContext(strResourceId, 0, shTransContext);
                iSecAdmin.ApplyACTToObj(shTransContext.value, "", 0, strAdminACT);
                iSecAdmin.SetAuthorizationsOnObj(shTransContext.value, "", 0, PublicDenials);
                ConnectedIdentityInfo connUserInfo = new ConnectedIdentityInfo(m_Factory);
                if (!(connUserInfo.m_Name.equalsIgnoreCase("Public") && connUserInfo.m_Type.equalsIgnoreCase("IdentityGroup") || connUserInfo.m_UserClass.toUpperCase().contains("UNRESTRICTED"))) {
                    String[][] CreatorAuths = new String[][]{{connUserInfo.m_Type, connUserInfo.m_Name, "G", "ReadMetadata", ""}, {connUserInfo.m_Type, connUserInfo.m_Name, "G", "WriteMetadata", ""}};
                    iSecAdmin.SetAuthorizationsOnObj(shTransContext.value, "", 0, CreatorAuths);
                }
                iSecAdmin.EndTransactionContext(shTransContext.value, strResourceId, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSystemFolder(MdFactory factory, Repository repos) throws MdException, RemoteException {
        Tree systemFolder = null;
        MdObjectStore store = factory.createObjectStore(null, "RepositoryUtil#createSystemFolder");
        try {
            String reposType = repos.getType();
            if ("FOUNDATION".equalsIgnoreCase(reposType)) {
                SoftwareComponent sc = RepositoryUtil.getBIPTreeObject(factory, repos.getFQID());
                if (sc == null) {
                    throw new MdException(bundle2.formatString("RepositoryUtil.NoRootFolder.fmt.txt", (java.lang.Object)repos.getName()));
                }
                systemFolder = RepositoryUtil.getTopLevelFolder(sc, "System");
                if (systemFolder == null) {
                    String reposID = repos.getFQID().substring(9, 17);
                    systemFolder = (Tree)factory.createComplexMetadataObject(store, null, "System", "Tree", reposID);
                    systemFolder.setTreeType("System");
                    systemFolder.setPublicType("Folder");
                    systemFolder.setUsageVersion("1000000.0");
                    systemFolder.setDesc(factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SystemFolder.Description.txt")));
                    systemFolder.getSoftwareComponents().add((java.lang.Object)sc);
                    systemFolder.updateMetadataAll();
                }
            } else if ("CUSTOM".equalsIgnoreCase(reposType)) {
                String BILINEAGE_REPOS_NAME = "BILineage";
                if ("BILineage".equalsIgnoreCase(repos.getName()) && "BILineage".equalsIgnoreCase(repos.getDesc())) {
                    return;
                }
                SoftwareComponent sc = RepositoryUtil.getBIPTreeObject(factory, repos.getFQID());
                if (sc == null) {
                    throw new MdException(bundle2.formatString("RepositoryUtil.NoRootFolder.fmt.txt", (java.lang.Object)repos.getName()));
                }
                String reposFolderName = Names.mapNameToOMRObjectName((String)repos.getName());
                Tree reposFolder = RepositoryUtil.getTopLevelFolder(sc, reposFolderName);
                if (reposFolder == null) {
                    throw new MdException(bundle2.formatString("RepositoryUtil.NoRootFolder.fmt.txt", (java.lang.Object)repos.getName()));
                }
                systemFolder = RepositoryUtil.getFolder(reposFolder, "System");
                if (systemFolder == null) {
                    String reposID = repos.getFQID().substring(9, 17);
                    systemFolder = (Tree)factory.createComplexMetadataObject(store, null, "System", "Tree", reposID);
                    systemFolder.setTreeType("System");
                    systemFolder.setPublicType("Folder");
                    systemFolder.setUsageVersion("1000000.0");
                    systemFolder.setDesc(factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SystemFolder.Description.txt")));
                    systemFolder.getParentTrees().add((java.lang.Object)reposFolder);
                    systemFolder.updateMetadataAll();
                }
            }
        }
        finally {
            store.dispose();
        }
    }

    private static Tree getFolder(Tree parentTree, String folderName) throws MdException, RemoteException {
        AssociationList folders = parentTree.getSubTrees();
        for (Tree tree : folders) {
            if (!folderName.equals(tree.getName()) || !"Folder".equals(tree.getPublicType())) continue;
            return tree;
        }
        return null;
    }

    private static Tree getTopLevelFolder(SoftwareComponent rootFolder, String folderName) throws MdException, RemoteException {
        AssociationList folders = rootFolder.getSoftwareTrees();
        for (Tree tree : folders) {
            if (!folderName.equals(tree.getName()) || !"Folder".equals(tree.getPublicType())) continue;
            return tree;
        }
        return null;
    }

    public static boolean setChannelsFolderPermissioninBIPTree(MdFactory m_Factory, Repository repos) throws Exception {
        Tree channelsFolder = null;
        String strReposId = repos.getFQID();
        if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
            String sXMLSelect;
            MdObjectStore store = m_Factory.createObjectStore();
            String sOptions = sXMLSelect = "<XMLSELECT search=\"*[@Name='Channels'][ParentTree/*[@Name='Publishing']/ParentTree/*[@Name='System']/SoftwareComponents/*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']]\" />";
            int flags = 392;
            List treeList = null;
            treeList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Tree", flags, sOptions, false);
            if (treeList == null || treeList.size() <= 0) {
                return false;
            }
            channelsFolder = (Tree)treeList.get(0);
            if (channelsFolder != null) {
                IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
                ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
                if (iSecAdmin == null) {
                    throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error6.txt"));
                }
                String[][] SASUsersAuthOnUpgradeRecords = new String[][]{{"IdentityGroup", "SASUSERS", "G", "Write", ""}};
                String strTreeObjID = "OMSOBJ:Tree/" + channelsFolder.getFQID();
                iSecAdmin.SetAuthorizationsOnObj("", strTreeObjID, 0, SASUsersAuthOnUpgradeRecords);
            }
            store.dispose();
        }
        return true;
    }

    public static boolean updateTreeTypesinBIPTree(MdFactory m_Factory, Repository repos) throws Exception {
        Tree systemFolder = null;
        Tree usersFolder = null;
        String strReposId = repos.getFQID();
        if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
            String sXMLSelect;
            MdObjectStore store = m_Factory.createObjectStore();
            String sOptions = sXMLSelect = "<XMLSELECT search=\"*[@Name='System'][SoftwareComponents/*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']]\" />";
            int flags = 392;
            List treeList = null;
            treeList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Tree", flags, sOptions, false);
            if (treeList != null && treeList.size() > 0) {
                systemFolder = (Tree)treeList.get(0);
            }
            if (systemFolder != null) {
                systemFolder.setTreeType("System");
            }
            String usersFoldername = bundle.getString("Common.DefaultFolderPolicy.txt");
            sOptions = sXMLSelect = "<XMLSELECT search=\"*[@Name='" + usersFoldername + "'][SoftwareComponents/*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']]\" />";
            flags = 392;
            treeList = null;
            treeList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Tree", flags, sOptions, false);
            if (treeList != null && treeList.size() > 0) {
                usersFolder = (Tree)treeList.get(0);
            }
            if (usersFolder != null) {
                usersFolder.setTreeType("System");
            }
            store.updatedMetadataAll();
            store.dispose();
        }
        return systemFolder != null && usersFolder != null;
    }

    public static String getFoundationRepositoryBIPService(MdFactory m_Factory) throws MdException, RemoteException {
        String FoundationReposId = null;
        String bipServiceID = null;
        m_Factory.getConnection().getCMRHandle();
        try {
            FoundationReposId = RepositoryUtil.getFoundationRepositoryId(m_Factory);
            if (FoundationReposId == null) {
                return null;
            }
            bipServiceID = RepositoryUtil.getBIPTreeId(m_Factory, FoundationReposId);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException re) {
            throw re;
        }
        return bipServiceID;
    }

    public static Tree getRepositoryFolder(MdStore store, String repositoryName, String reposId) throws RemoteException, MdException {
        Tree repositoryTree = null;
        MdFactory factory = Workspace.getMdFactory();
        String select = "<XMLSelect search=\"Tree[@Name = '" + repositoryName + "'][SoftwareComponents/SoftwareComponent[@Id='" + RepositoryUtil.getBIPTreeId(factory, reposId) + "']]\" />";
        String template = "<Templates><Tree><SoftwareComponents/></Tree></Templates>";
        String options = select + template;
        int flags = 396;
        List trees = factory.getOMIUtil().getMetadataObjectsSubset(store, reposId, "Tree", flags, options, false);
        if (trees.size() > 0) {
            repositoryTree = (Tree)trees.get(0);
        }
        return repositoryTree;
    }

    public static Tree getRepositoryFolder(MdObjectStore store, String strReposId) throws RemoteException, MdException {
        Tree repositoryTree = null;
        SoftwareComponent sc = null;
        MdFactory factory = Workspace.getMdFactory();
        String strSelect = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
        String strTemplate = "<Templates><SoftwareComponent Name=\"\"><SoftwareTrees/></SoftwareComponent></Templates>";
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        List comps = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "SoftwareComponent", flags, strOptions, false);
        if (comps.size() <= 0) {
            return null;
        }
        sc = (SoftwareComponent)comps.get(0);
        Vector trees = new Vector(sc.getSoftwareTrees());
        if (trees.size() > 0) {
            repositoryTree = (Tree)trees.get(0);
        }
        return repositoryTree;
    }

    public static void updateCustomRepositoryFolderSoftwareComponentAssociations(MdFactory m_Factory, String strReposId) throws Exception {
        String FoundationReposId;
        MdObjectStore store = m_Factory.createObjectStore();
        Tree reposFolder = RepositoryUtil.getRepositoryFolder(store, strReposId);
        if (reposFolder == null) {
            return;
        }
        AssociationList scList = reposFolder.getSoftwareComponents();
        SoftwareComponent oldSC = null;
        for (SoftwareComponent scObject : scList) {
            if (scObject.getFQID().substring(0, 8).equalsIgnoreCase(strReposId.substring(9, 17))) continue;
            oldSC = scObject;
            break;
        }
        if (oldSC != null) {
            reposFolder.getSoftwareComponents().remove(oldSC);
        }
        if ((FoundationReposId = RepositoryUtil.getFoundationRepositoryId(m_Factory)) != null) {
            SoftwareComponent foundationSC = RepositoryUtil.getBIPTreeObject(m_Factory, FoundationReposId);
            reposFolder.getSoftwareComponents().add((java.lang.Object)foundationSC);
        }
        reposFolder.updateMetadataAll();
        store.dispose();
    }

    private static String getFoundationRepositoryId(MdFactory m_Factory) throws MdException, RemoteException {
        String FoundationReposId = null;
        try {
            CMetadata FoundationObj = m_Factory.getOMIUtil().getFoundationRepository();
            if (FoundationObj == null) {
                return null;
            }
            FoundationReposId = FoundationObj.getId();
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException re) {
            throw re;
        }
        return FoundationReposId;
    }

    public static String associateIdentityToProjectRepos(MdFactory m_Factory, String strReposId, Identity owner) throws Exception {
        String newId = null;
        m_Factory.getConnection().getCMRHandle();
        MdObjectStore store = m_Factory.createObjectStore();
        Person per = RepositoryUtil.getProjectOwnerbyId(m_Factory, store, owner.getFQID());
        if (per != null) {
            Extension ext = (Extension)m_Factory.createComplexMetadataObject(store, "ProjectRepository", "Extension", per.getFQID().substring(0, 8));
            ext.setValue(strReposId);
            per.getExtensions().add((java.lang.Object)ext);
            per.updateMetadataAll();
            newId = ext.getFQID();
        }
        return newId;
    }

    public static Person getProjectOwnerbyId(MdFactory m_Factory, MdObjectStore store, String ownerId) throws MdException, RemoteException {
        Person projPerson = null;
        int flags = 260;
        String strTemplate = "<Templates><Person><Extensions/></Person></Templates>";
        projPerson = (Person)m_Factory.getOMIUtil().getMetadataAllDepths((MdStore)store, "Person", ownerId, null, null, strTemplate, flags);
        if (projPerson != null) {
            return projPerson;
        }
        return null;
    }

    public static Identity determineProjectOwner(MdFactory m_Factory, String strReposId, List extensionList) throws Exception {
        Identity ident = null;
        if (extensionList == null) {
            return ident;
        }
        if (extensionList.size() > 0) {
            Extension ext = (Extension)extensionList.get(0);
            ident = (Identity)ext.getOwningObject();
        }
        return ident;
    }

    public static List findProjectRepositoryExtensions(MdFactory m_Factory, String strReposId) throws Exception {
        List extensionList = new Vector(0);
        String options = "<XMLSELECT search=\"@Name='ProjectRepository' AND @Value ='" + strReposId + "'\"/>";
        int flags = 335544712;
        extensionList = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)m_Factory.getStore(), RepositoryUtil.getFoundationRepositoryId(m_Factory), "Extension", flags, options);
        if (extensionList == null || extensionList.size() == 0) {
            return null;
        }
        if (extensionList.size() > 1) {
            Collections.sort(extensionList, new extComparator());
        }
        return extensionList;
    }

    public static boolean deleteProjectRepositoryExtensions(MdFactory m_Factory, List extensionList) throws Exception {
        Extension ext = null;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        for (int index = 0; index < extensionList.size(); ++index) {
            ext = (Extension)extensionList.get(index);
            try {
                StringHolder outXML = new StringHolder();
                String inXML = "";
                inXML = "<Extension ID=\"" + ext.getFQID() + "\"></Extension>";
                omiConnection.DeleteMetadata(inXML, outXML, "SAS", 0x10000000, "");
                continue;
            }
            catch (Exception e) {
                if (index != 0) continue;
                throw e;
            }
        }
        return true;
    }

    public static int createDefaultIdentityGroups(MdFactory m_Factory, String strReposId) throws Exception {
        String cleanDesc;
        String cleanName;
        String cleanDesc2;
        int rc = 0;
        String inXML = null;
        int flags = 0x10000180;
        MdObjectStore store = m_Factory.createObjectStore();
        String options = "<XMLSELECT search=\"@Name = 'SASUSERS' OR @Name = 'PUBLIC' OR @Name = 'SASAdministrators' OR @Name = 'META: Unrestricted Users Role' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' OR @Name = 'SAS System Services' OR @Name = 'SAS Administrators' \"/>";
        List identityGroups = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "IdentityGroup", flags, options, false);
        boolean foundSASUSERS = false;
        boolean foundPUBLIC = false;
        boolean foundSASADMIN = false;
        boolean foundAltSASADMIN = false;
        boolean foundUNRESTRICTEDUSERS = false;
        boolean foundUSERADMINISTRATORS = false;
        boolean foundOPERATORS = false;
        boolean foundSASSystemServices = false;
        for (int i = 0; i < identityGroups.size(); ++i) {
            IdentityGroup group = (IdentityGroup)identityGroups.get(i);
            if (group.getName().equals("SASUSERS")) {
                foundSASUSERS = true;
                continue;
            }
            if (group.getName().equals("PUBLIC")) {
                foundPUBLIC = true;
                continue;
            }
            if (group.getName().equals("SASAdministrators")) {
                foundSASADMIN = true;
                continue;
            }
            if (group.getName().equals("META: Unrestricted Users Role")) {
                foundUNRESTRICTEDUSERS = true;
                continue;
            }
            if (group.getName().equals("META: User and Group Administrators Role")) {
                foundUSERADMINISTRATORS = true;
                continue;
            }
            if (group.getName().equals("META: Operators Role")) {
                foundOPERATORS = true;
                continue;
            }
            if (group.getName().equals("SAS System Services")) {
                foundSASSystemServices = true;
                continue;
            }
            if (!group.getName().equals("SAS Administrators")) continue;
            foundAltSASADMIN = true;
        }
        store.dispose();
        if (foundSASUSERS && foundPUBLIC && foundSASADMIN && foundUNRESTRICTEDUSERS && foundUSERADMINISTRATORS && foundOPERATORS && foundSASSystemServices) {
            return 0;
        }
        StringBuffer inXMLBuffer = new StringBuffer();
        if (!foundSASUSERS) {
            cleanDesc2 = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SASUSERS.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"SASUSERS\" Desc=\"" + cleanDesc2 + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundPUBLIC) {
            cleanDesc2 = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.PUBLIC.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"PUBLIC\" Desc=\"" + cleanDesc2 + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundSASADMIN && !foundAltSASADMIN) {
            cleanName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SASAdministrators.DisplayName.txt"));
            cleanDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SASAdministrators.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"SASAdministrators\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundUNRESTRICTEDUSERS) {
            cleanName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.UnrestrictedUsersRole.DisplayName.txt"));
            cleanDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.UnrestrictedUsersRole.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"META: Unrestricted Users Role\" GroupType=\"ROLE\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"Role\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundUSERADMINISTRATORS) {
            cleanName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.UserAdministratorsRole.DisplayName.txt"));
            cleanDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.UserAdministratorsRole.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"META: User and Group Administrators Role\" GroupType=\"ROLE\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"Role\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundOPERATORS) {
            cleanName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.OperatorsRole.DisplayName.txt"));
            cleanDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.OperatorsRole.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"META: Operators Role\" GroupType=\"ROLE\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"Role\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundSASSystemServices) {
            cleanName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SASSystemServices.DisplayName.txt"));
            cleanDesc = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SASSystemServices.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"SAS System Services\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        rc = m_Factory.getOMIUtil().addMetadata(inXML, strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length()), outXML, 0x10000000);
        if (rc == 0) {
            if (foundSASADMIN) {
                RepositoryUtil.upgradeSASAdminGroupRoleAssociations(m_Factory, strReposId, false);
            } else {
                RepositoryUtil.upgradeSASAdminGroupRoleAssociations(m_Factory, strReposId, foundAltSASADMIN);
            }
            String outXMLString = "<dummy>" + outXML.value + "</dummy>";
            Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
            if (mainDoc != null) {
                Element replyRoot = mainDoc.getDocumentElement();
                NodeList nodeList = replyRoot.getElementsByTagName("IdentityGroup");
                String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
                IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
                ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
                if (iSecAdmin == null) {
                    throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error8.txt"));
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    String strResourceId = "OMSOBJ:IdentityGroup/" + nodeMap.getNamedItem("Id").getNodeValue();
                    iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
                }
            }
        }
        return rc;
    }

    public static int createDefaultPermissions(MdFactory m_Factory, String strReposId) throws Exception {
        int rc = 0;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        int serverversion = m_Factory.getConnection().getPlatformVersion();
        int rposFormat = RepositoryUtil.getRepositoryFormatVersion(m_Factory, strReposId);
        int maxperms = RepositoryUtil.getMaxPermissionsForRepository(serverversion, rposFormat);
        int[] permissionCodes = RepositoryUtil.checkDefaultPermissions(m_Factory, strReposId, 0);
        StringBuffer inXMLBuffer = new StringBuffer();
        for (int i = 0; i < maxperms; ++i) {
            if ((permissionCodes[i] & 1) == 0) {
                inXMLBuffer.append("<Permission Name=\"" + PERMISSION_NAMES[i] + "\" Type = \"GRANT\"/>");
            }
            if ((permissionCodes[i] & 2) != 0) continue;
            inXMLBuffer.append("<Permission Name=\"" + PERMISSION_NAMES[i] + "\" Type = \"DENY\"/>");
        }
        if (inXMLBuffer.length() != 0) {
            rc = omiConnection.AddMetadata(inXMLBuffer.toString(), strReposId, new StringHolder(), "SAS", 0x10000000, "");
        }
        return rc;
    }

    public static int createDefaultPolicies(MdFactory m_Factory, String strReposId) throws Exception {
        StringBuffer inXMLBuffer;
        String bipserviceID;
        int rc = 0;
        m_Factory.getConnection().getCMRHandle();
        String inXML = null;
        int flags = 0x10000188;
        String repType = WsRepositoryUtil.getRepositoryType((MdFactory)m_Factory, (String)strReposId);
        if (RepositoryUtil.getRepositoryFormatVersion(m_Factory, strReposId) >= 6) {
            String propName;
            MdObjectStore store = m_Factory.createObjectStore();
            String options = "<XMLSELECT search=\"@PropertyName='Store User Definitions' OR @PropertyName='Path to Users Root Folder'\"/>";
            List policiesList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Property", flags, options, false);
            boolean foundStoreUsers = false;
            boolean foundPathtoRoot = false;
            for (int i = 0; i < policiesList.size(); ++i) {
                Property policy = (Property)policiesList.get(i);
                if (policy.getPropertyName().equals("Store User Definitions")) {
                    foundStoreUsers = true;
                    continue;
                }
                if (!policy.getPropertyName().equals("Path to Users Root Folder")) continue;
                foundPathtoRoot = true;
            }
            store.dispose();
            if (foundStoreUsers && foundPathtoRoot) {
                return 0;
            }
            bipserviceID = RepositoryUtil.getBIPTreeId(m_Factory, strReposId);
            if (bipserviceID == null) {
                return 8;
            }
            inXMLBuffer = new StringBuffer();
            String pSetName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.DefaultPolicySet.Name.txt"));
            inXMLBuffer.append("<PropertySet Name=\"" + pSetName + "\" PropertySetName=\"Metadata Repository Policies\">");
            inXMLBuffer.append("<SetProperties>");
            if (!foundStoreUsers) {
                propName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.DefaultStorePolicy.Name.txt"));
                if (repType.equalsIgnoreCase("Foundation")) {
                    inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Store User Definitions\" DefaultValue=\"Y\"/>");
                } else {
                    inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Store User Definitions\" DefaultValue=\"N\"/>");
                }
            }
            if (!foundPathtoRoot) {
                propName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.DefaultPathPolicy.Name.txt"));
                String defaultValue = m_Factory.getOMIUtil().cleanStringForXML(USER_FOLDER_SEPARATOR + bundle.getString("Common.DefaultFolderPolicy.txt"));
                inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Path to Users Root Folder\" DefaultValue=\"" + defaultValue + "\"/>");
            }
        } else {
            return 0;
        }
        inXMLBuffer.append("</SetProperties>");
        inXMLBuffer.append("<OwningObject>");
        inXMLBuffer.append("<SoftwareComponent Objref=\"" + bipserviceID + "\"/>");
        inXMLBuffer.append("</OwningObject>");
        inXMLBuffer.append("</PropertySet>");
        inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        rc = m_Factory.getOMIUtil().addMetadata(inXML, strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length()), outXML, 0x10000000);
        return rc;
    }

    public static int upgradeToDefaultPolicies(MdFactory m_Factory, String strReposId) throws Exception {
        StringBuffer inXMLBuffer;
        String bipserviceID;
        int rc = 0;
        String inXML = null;
        int flags = 0x10000188;
        m_Factory.getConnection().getCMRHandle();
        String repType = WsRepositoryUtil.getRepositoryType((MdFactory)m_Factory, (String)strReposId);
        if (RepositoryUtil.getRepositoryFormatVersion(m_Factory, strReposId) >= 6) {
            String propName;
            MdObjectStore store = m_Factory.createObjectStore();
            String options = "<XMLSELECT search=\"@PropertyName='Store User Definitions' OR @PropertyName='Path to Users Root Folder'\"/>";
            List policiesList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Property", flags, options, false);
            boolean foundStoreUsers = false;
            boolean foundPathtoRoot = false;
            for (int i = 0; i < policiesList.size(); ++i) {
                Property policy = (Property)policiesList.get(i);
                if (policy.getPropertyName().equals("Store User Definitions")) {
                    foundStoreUsers = true;
                    continue;
                }
                if (!policy.getPropertyName().equals("Path to Users Root Folder")) continue;
                foundPathtoRoot = true;
            }
            store.dispose();
            if (foundStoreUsers && foundPathtoRoot) {
                return 0;
            }
            bipserviceID = RepositoryUtil.getBIPTreeId(m_Factory, strReposId);
            if (bipserviceID == null) {
                return 1;
            }
            boolean personsExist = RepositoryUtil.doPersonIdentitiesExist(m_Factory, strReposId);
            inXMLBuffer = new StringBuffer();
            String pSetName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.DefaultPolicySet.Name.txt"));
            inXMLBuffer.append("<PropertySet Name=\"" + pSetName + "\" PropertySetName=\"Metadata Repository Policies\">");
            inXMLBuffer.append("<SetProperties>");
            if (!foundStoreUsers) {
                propName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.DefaultStorePolicy.Name.txt"));
                if (repType.equalsIgnoreCase("FOUNDATION")) {
                    inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Store User Definitions\" DefaultValue=\"Y\"/>");
                } else if (personsExist) {
                    inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Store User Definitions\" DefaultValue=\"Y\"/>");
                } else {
                    inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Store User Definitions\" DefaultValue=\"N\"/>");
                }
            }
            if (!foundPathtoRoot) {
                propName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.DefaultPathPolicy.Name.txt"));
                String defaultValue = m_Factory.getOMIUtil().cleanStringForXML(USER_FOLDER_SEPARATOR + bundle.getString("Common.DefaultFolderPolicy.txt"));
                inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Path to Users Root Folder\" DefaultValue=\"" + defaultValue + "\"/>");
            }
        } else {
            return 0;
        }
        inXMLBuffer.append("</SetProperties>");
        inXMLBuffer.append("<OwningObject>");
        inXMLBuffer.append("<SoftwareComponent Objref=\"" + bipserviceID + "\"/>");
        inXMLBuffer.append("</OwningObject>");
        inXMLBuffer.append("</PropertySet>");
        inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        rc = m_Factory.getOMIUtil().addMetadata(inXML, strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length()), outXML, 0x10000000);
        return rc;
    }

    public static boolean doPersonIdentitiesExist(MdFactory m_Factory, String strReposId) throws Exception {
        String type = "Person";
        int objCount = m_Factory.getOMIUtil().doesObjectExist(strReposId, type, null);
        return objCount > 0;
    }

    public static String getNameForReposId(MdFactory m_Factory, String strReposId) throws Exception {
        String strName = null;
        int flags = 384;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String type = "REPOSITORYBASE";
        String options = "<XMLSELECT search = \"@Id = '" + strReposId + "'\"/>";
        StringHolder outXML = new StringHolder();
        omiConnection.GetMetadataObjects(REPOSITORY_MANAGER_ID, type, outXML, "REPOS", flags, options);
        String outXMLString = outXML.value;
        Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                NamedNodeMap nodeMap = currentNode.getAttributes();
                strName = nodeMap.getNamedItem("Name").getNodeValue();
            }
        }
        return strName;
    }

    public static String getReposIdForName(MdFactory m_Factory, String strReposName) throws Exception {
        String strID = null;
        int flags = 384;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String type = "REPOSITORYBASE";
        String options = "<XMLSELECT search = \"@Name = '" + strReposName + "'\"/>";
        StringHolder outXML = new StringHolder();
        omiConnection.GetMetadataObjects(REPOSITORY_MANAGER_ID, type, outXML, "REPOS", flags, options);
        String outXMLString = outXML.value;
        Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                NamedNodeMap nodeMap = currentNode.getAttributes();
                strID = nodeMap.getNamedItem("Id").getNodeValue();
            }
        }
        return strID;
    }

    public static boolean defaultRepositoryACTExists(MdFactory m_Factory, String strReposId) throws Exception {
        String type = "AccessControlTemplate";
        String options = "<XMLSELECT search=\"@Use='REPOS'\"/>";
        int objCount = m_Factory.getOMIUtil().doesObjectExist(strReposId, type, options);
        return objCount > 0;
    }

    public static boolean doesNamedACTExist(MdFactory m_Factory, String strReposId, String actName) throws Exception {
        String type = "AccessControlTemplate";
        String options = "<XMLSELECT search=\"@Name = '" + actName + "' \"/>";
        int objCount = m_Factory.getOMIUtil().doesObjectExist(strReposId, type, options);
        return objCount > 0;
    }

    public static SoftwareComponent getBIPTreeObject(MdFactory m_Factory, String strReposId) throws MdException {
        List scObjects = null;
        String options = "<XMLSELECT search=\"@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06'\"/>";
        int flags = 0x10000180;
        try {
            scObjects = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)m_Factory.getStore(), strReposId, "SoftwareComponent", flags, options);
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        if (scObjects != null && scObjects.size() > 0) {
            return (SoftwareComponent)scObjects.get(0);
        }
        return null;
    }

    public static String getBIPTreeId(MdFactory m_Factory, String strReposId) {
        String strID = null;
        String type = "SoftwareComponent";
        String options = "<XMLSELECT search=\"@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06'\"/>";
        int flags = 0x10000180;
        try {
            IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
            StringHolder outXML = new StringHolder();
            omiConnection.GetMetadataObjects(strReposId, type, outXML, "SAS", flags, options);
            String outXMLString = outXML.value;
            Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
            if (mainDoc != null) {
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    strID = nodeMap.getNamedItem("Id").getNodeValue();
                }
            }
        }
        catch (Exception e) {
            try {
                m_Factory.getUtil().printOutputln(e.getMessage());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return strID;
    }

    public static String defaultPermissionsExist(MdFactory m_Factory, String strReposId) throws Exception {
        int i;
        List permissions = new Vector(0);
        int flags = 0x10000180;
        int serverversion = m_Factory.getConnection().getPlatformVersion();
        int rposFormat = RepositoryUtil.getRepositoryFormatVersion(m_Factory, strReposId);
        int maxperms = RepositoryUtil.getMaxPermissionsForRepository(serverversion, rposFormat);
        String options = "<XMLSELECT search=\"";
        for (int i2 = 0; i2 < maxperms; ++i2) {
            if (i2 > 0) {
                options = options.concat(" OR");
            }
            options = options.concat(" @Name='");
            options = options.concat(PERMISSION_NAMES[i2]);
            options = options.concat("'");
        }
        options = options.concat("\"/>");
        MdObjectStore store = m_Factory.createObjectStore();
        permissions = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)store, strReposId, "Permission", flags, options);
        String reposid2match = "";
        boolean[] permsfound = new boolean[maxperms];
        for (i = 0; i < maxperms; ++i) {
            permsfound[i] = false;
        }
        for (i = 0; i < permissions.size(); ++i) {
            Permission perm = (Permission)permissions.get(i);
            for (int j = 0; j < maxperms; ++j) {
                if (!perm.getName().equals(PERMISSION_NAMES[j])) continue;
                permsfound[j] = true;
                if (i == 0) {
                    reposid2match = perm.getFQID().substring(0, 8);
                    continue;
                }
                if (reposid2match.equals(perm.getFQID().substring(0, 8))) continue;
                store.dispose();
                return null;
            }
        }
        for (i = 0; i < maxperms; ++i) {
            if (permsfound[i]) continue;
            store.dispose();
            return null;
        }
        reposid2match = "A0000001" + reposid2match;
        store.dispose();
        return reposid2match;
    }

    public static String getRepositoryVersionString(MdFactory m_Factory, String strReposId) throws Exception {
        if (m_Factory.getConnection().getPlatformVersion() < 9200) {
            return "5";
        }
        ISecurity_1_1 iSecurity = null;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        if (omiConnection != null) {
            VariableArray2dOfStringHolder vaTmpOut = new VariableArray2dOfStringHolder();
            try {
                iSecurity = m_Factory.getConnection().MakeISecurityConnection(omiConnection);
                iSecurity.GetAuthorizations("getRepositoryModel", "", strReposId.substring(strReposId.indexOf(46) + 1), "", vaTmpOut);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    iSecurity._release();
                    iSecurity = null;
                }
                catch (Exception exception) {}
            }
            return vaTmpOut.value[0][0];
        }
        return "";
    }

    public static Vector getIdentityObjects(MdObjectStore store, MdFactory m_Factory, String strReposId) throws Exception {
        int flags = 272;
        Vector<IdentityReposPair> items = new Vector<IdentityReposPair>();
        List identityObjects = new Vector(0);
        identityObjects = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)store, strReposId, "Identity", flags, "");
        for (int i = 0; i < identityObjects.size(); ++i) {
            if (!(identityObjects.get(i) instanceof IdentityGroup) && !(identityObjects.get(i) instanceof Person)) continue;
            Identity idObj = (Identity)identityObjects.get(i);
            items.add(new IdentityReposPair(idObj, strReposId));
        }
        return items;
    }

    public static boolean repositoryExistsOnServer(IOMI omiConnection, String strReposId) {
        if (omiConnection == null) {
            omiConnection = Workspace.getWorkspace().getCMRHandle();
        }
        StringHolder outXML = new StringHolder();
        String options = "<XMLSELECT search=\"@ID='" + strReposId + "'\"/>";
        try {
            omiConnection.GetMetadataObjects(REPOSITORY_MANAGER_ID, "RepositoryBase", outXML, "REPOS", 128, options);
            String outXMLString = outXML.value.toString();
            if (outXMLString.equalsIgnoreCase("<Objects/>")) {
                return false;
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)("Result of find repository:" + e.getMessage()));
            return false;
        }
        return true;
    }

    public static boolean repositoryExistsOnServer(MdFactory m_Factory, String strReposId) {
        try {
            IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
            if (omiConnection == null) {
                omiConnection = Workspace.getWorkspace().getCMRHandle();
            }
            StringHolder outXML = new StringHolder();
            String options = "<XMLSELECT search=\"@ID='" + strReposId + "'\"/>";
            omiConnection.GetMetadataObjects(REPOSITORY_MANAGER_ID, "RepositoryBase", outXML, "REPOS", 128, options);
            String outXMLString = outXML.value.toString();
            if (outXMLString.equalsIgnoreCase("<Objects/>")) {
                return false;
            }
        }
        catch (Exception e) {
            try {
                m_Factory.getUtil().printOutputln("Result of find repository:" + e.getMessage());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public static int createDefaultInheritanceRules(MdFactory m_Factory, String strReposId) throws Exception {
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String ruleReposID = RepositoryUtil.defaultInheritanceRulesExist(m_Factory, strReposId);
        if (ruleReposID != null && ruleReposID.equals(strReposId)) {
            return 0;
        }
        int rc = 0;
        URL url = XMLUtility.urlFromFile((String)"com/sas/workspace/visuals/res/PhysicalRules.xml");
        InputStream inputStream = null;
        inputStream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String strContents = "";
        String strBuffer = null;
        while ((strBuffer = reader.readLine()) != null) {
            strContents = strContents + strBuffer;
        }
        StringHolder outXML = new StringHolder();
        String inXML = strContents;
        rc = omiConnection.AddMetadata(inXML, strReposId, outXML, "SAS", 0x10000000, "");
        return rc;
    }

    @Deprecated
    public static int upgradeDefaultInheritanceRules(MdFactory m_Factory, String strReposId) throws Exception {
        int rc = 0;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        URL url = XMLUtility.urlFromFile((String)"com/sas/workspace/visuals/res/PhysicalRules.xml");
        InputStream inputStream = null;
        inputStream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String strContents = new String();
        String strBuffer = null;
        while ((strBuffer = reader.readLine()) != null) {
            strContents = strContents + strBuffer;
        }
        StringHolder outXML = new StringHolder();
        String inXML = strContents;
        rc = omiConnection.AddMetadata(inXML, strReposId, outXML, "SAS", 0x10000000, "");
        return rc;
    }

    public static String defaultInheritanceRulesExist(MdFactory m_Factory, String strReposId) throws Exception {
        String rulesRepos = null;
        List rulesSchemeList = new Vector(0);
        String options = "<XMLSELECT search=\"@Name='Physical'\"/>";
        int flags = 0x10000180;
        MdObjectStore store = m_Factory.createObjectStore();
        rulesSchemeList = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)store, strReposId, "SecurityRuleScheme", flags, options);
        if (rulesSchemeList == null || rulesSchemeList.size() == 0) {
            store.dispose();
            return null;
        }
        for (int i = 0; i < rulesSchemeList.size(); ++i) {
            SecurityRuleScheme scheme = (SecurityRuleScheme)rulesSchemeList.get(i);
            if (!scheme.getName().equalsIgnoreCase("Physical")) continue;
            rulesRepos = "A0000001." + scheme.getRepositoryID();
            break;
        }
        store.dispose();
        return rulesRepos;
    }

    public static SecurityRuleScheme findDefaultInheritanceRule(MdFactory m_Factory, String strReposId) throws Exception {
        SecurityRuleScheme scheme = null;
        boolean found = false;
        List rulesSchemeList = new Vector(0);
        String options = new String("<XMLSELECT search=\"@Name='Physical'\"/>");
        int flags = 0x10000180;
        rulesSchemeList = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)m_Factory.getStore(), strReposId, "SecurityRuleScheme", flags, options);
        if (rulesSchemeList == null || rulesSchemeList.size() == 0) {
            return null;
        }
        for (int i = 0; i < rulesSchemeList.size(); ++i) {
            scheme = (SecurityRuleScheme)rulesSchemeList.get(i);
            if (!scheme.getName().equalsIgnoreCase("Physical")) continue;
            found = true;
            break;
        }
        if (found) {
            return scheme;
        }
        return null;
    }

    public static boolean deleteInheritanceRules(MdFactory m_Factory, String strReposId, SecurityRuleScheme scheme) throws Exception {
        StringHolder outXML = new StringHolder();
        String inXML = new String("");
        inXML = "<SecurityRuleScheme ID=\"" + scheme.getFQID() + "\"></SecurityRuleScheme>";
        int flags = 0x10000000;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        int rc = omiConnection.DeleteMetadata(inXML, outXML, "SAS", flags, "");
        if (rc != 0) {
            return false;
        }
        return true;
    }

    public static void upgradeSecurityDisplayNamesAndDescriptions(MdFactory m_Factory, Repository repos) throws Exception {
        RepositoryUtil.upgradeACTDescriptions(m_Factory, repos);
        if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
            RepositoryUtil.upgradeRoleAttributes(m_Factory, repos);
            RepositoryUtil.upgradeGroupDescriptions(m_Factory, repos);
        }
    }

    public static void upgradeACTDescriptions(MdFactory m_Factory, Repository repos) throws Exception {
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String strReposId = repos.getFQID();
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        String defaultACTname = bundle2.getString("RepositoryUtil.DefaultACT.Name.txt");
        String defaultACTdesc = bundle2.getString("RepositoryUtil.DefaultACT.Desc.fmt.txt");
        String[][] DefaultACTAttributes = new String[][]{{"DESC", defaultACTdesc}};
        String privateUFACTname = bundle2.getString("RepositoryUtil.privatefolderACT.Name.notrans");
        String privateUFACTdesc = bundle2.getString("RepositoryUtil.privatefolderACT.Desc.fmt.txt");
        String[][] privateACTAttributes = new String[][]{{"DESC", privateUFACTdesc}};
        String sasAdminSettingsACTname = bundle2.getString("RepositoryUtil.SASAdminACT.Name.notrans");
        String sasAdminSettingsACTdesc = bundle2.getString("RepositoryUtil.SASAdminACT.Desc.fmt.txt");
        String[][] sasAdminSettingsACTAttributes = new String[][]{{"DESC", sasAdminSettingsACTdesc}};
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error3.txt"));
        }
        String defaultActId = RepositoryUtil.getActId(iSecAdmin, defaultACTname, shortReposId);
        String privateActId = "";
        String sasAdminActId = "";
        if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
            privateActId = RepositoryUtil.getActId(iSecAdmin, privateUFACTname, shortReposId);
            sasAdminActId = RepositoryUtil.getActId(iSecAdmin, sasAdminSettingsACTname, shortReposId);
        }
        try {
            if (defaultActId.length() > 0) {
                RepositoryUtil.updateACTAttributes(iSecAdmin, defaultActId, DefaultACTAttributes);
            }
            if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
                if (privateActId.length() > 0) {
                    RepositoryUtil.updateACTAttributes(iSecAdmin, privateActId, privateACTAttributes);
                }
                if (sasAdminActId.length() > 0) {
                    RepositoryUtil.updateACTAttributes(iSecAdmin, sasAdminActId, sasAdminSettingsACTAttributes);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(bundle2.formatString("RepositoryUtil.UpdateACTattributes.Exception.txt", (java.lang.Object)e.getMessage()));
        }
    }

    private static void updateACTAttributes(ISecurityAdmin iSecAdmin, String actId, String[][] attributes) throws Exception {
        String strACTObj = "OMSOBJ:AccessControlTemplate/" + actId;
        iSecAdmin.SetAccessControlTemplateAttribs("", strACTObj, attributes);
    }

    public static void upgradeRoleAttributes(MdFactory m_Factory, Repository repos) throws Exception {
        MdObjectStore store = m_Factory.createObjectStore();
        int flags = 0x10000180;
        String options = "<XMLSELECT search=\"@Name = 'META: Unrestricted Users Role' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' \"/>";
        List identityRoles = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "IdentityGroup", flags, options, false);
        for (int i = 0; i < identityRoles.size(); ++i) {
            IdentityGroup role = (IdentityGroup)identityRoles.get(i);
            if (role.getName().equals("META: Unrestricted Users Role")) {
                role.setDisplayName(bundle2.getString("RepositoryUtil.UnrestrictedUsersRole.DisplayName.txt"));
                role.setDesc(bundle2.getString("RepositoryUtil.UnrestrictedUsersRole.Description.txt"));
                continue;
            }
            if (role.getName().equals("META: User and Group Administrators Role")) {
                role.setDisplayName(bundle2.getString("RepositoryUtil.UserAdministratorsRole.DisplayName.txt"));
                role.setDesc(bundle2.getString("RepositoryUtil.UserAdministratorsRole.Description.txt"));
                continue;
            }
            if (!role.getName().equals("META: Operators Role")) continue;
            role.setDisplayName(bundle2.getString("RepositoryUtil.OperatorsRole.DisplayName.txt"));
            role.setDesc(bundle2.getString("RepositoryUtil.OperatorsRole.Description.txt"));
        }
        store.updatedMetadataAll();
        store.dispose();
    }

    public static void upgradeSASAdminGroupRoleAssociations(MdFactory m_Factory, String strReposId, boolean fixGroupName) throws Exception {
        int flags = 0x10000180;
        MdObjectStore store = m_Factory.createObjectStore();
        String options = "";
        options = fixGroupName ? "<XMLSELECT search=\"@Name = 'SAS Administrators' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' \"/>" : "<XMLSELECT search=\"@Name = 'SASAdministrators' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' \"/>";
        IdentityGroup adminsGrp = null;
        IdentityGroup opRole = null;
        IdentityGroup userAdmRole = null;
        List identityGroups = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "IdentityGroup", flags, options, false);
        for (int i = 0; i < identityGroups.size(); ++i) {
            IdentityGroup group = (IdentityGroup)identityGroups.get(i);
            if (group.getName().equals("SASAdministrators") || group.getName().equals("SAS Administrators")) {
                adminsGrp = group;
                continue;
            }
            if (group.getName().equals("META: User and Group Administrators Role")) {
                userAdmRole = group;
                continue;
            }
            if (!group.getName().equals("META: Operators Role")) continue;
            opRole = group;
        }
        if (adminsGrp == null || userAdmRole == null || opRole == null) {
            store.dispose();
            throw new Exception(bundle2.getString("RepositoryUtil.UpgradeSASAdminRoleAssociations.NotFound.Exception.txt"));
        }
        String updateMeta = "";
        if (fixGroupName) {
            String cleanName = m_Factory.getOMIUtil().cleanStringForXML(bundle2.getString("RepositoryUtil.SASAdministrators.DisplayName.txt"));
            String fixedAdminsGrp = "<IdentityGroup Id=\"" + adminsGrp.getFQID() + "\" Name=\"SASAdministrators\" DisplayName=\"" + cleanName + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" >";
            updateMeta = fixedAdminsGrp + "   <IdentityGroups Function=\"Append\">      <IdentityGroup ObjRef=\"" + userAdmRole.getFQID() + "\" />      <IdentityGroup ObjRef=\"" + opRole.getFQID() + "\" />   </IdentityGroups> </IdentityGroup>";
        } else {
            updateMeta = "<IdentityGroup Id=\"" + adminsGrp.getFQID() + "\" >   <IdentityGroups Function=\"Append\">      <IdentityGroup ObjRef=\"" + userAdmRole.getFQID() + "\" />      <IdentityGroup ObjRef=\"" + opRole.getFQID() + "\" />   </IdentityGroups> </IdentityGroup>";
        }
        store.dispose();
        StringHolder outXML2 = new StringHolder();
        m_Factory.getOMIUtil().updateMetadata(updateMeta, outXML2, 0x10000000);
    }

    public static void upgradeGroupDescriptions(MdFactory m_Factory, Repository repos) throws Exception {
        MdObjectStore store = m_Factory.createObjectStore();
        int flags = 0x10000180;
        String options = "<XMLSELECT search=\"@Name = 'SASUSERS' OR @Name = 'PUBLIC' OR @Name = 'SASAdministrators' OR @Name = 'SAS System Services' \"/>";
        List identityGroups = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos.getFQID(), "IdentityGroup", flags, options, false);
        for (int i = 0; i < identityGroups.size(); ++i) {
            IdentityGroup group = (IdentityGroup)identityGroups.get(i);
            if (group.getName().equals("SASUSERS")) {
                group.setDesc(bundle2.getString("RepositoryUtil.SASUSERS.Description.txt"));
                continue;
            }
            if (group.getName().equals("PUBLIC")) {
                group.setDesc(bundle2.getString("RepositoryUtil.PUBLIC.Description.txt"));
                continue;
            }
            if (group.getName().equals("SASAdministrators")) {
                group.setDesc(bundle2.getString("RepositoryUtil.SASAdministrators.Description.txt"));
                continue;
            }
            if (!group.getName().equals("SAS System Services")) continue;
            group.setDesc(bundle2.getString("RepositoryUtil.SASSystemServices.Description.txt"));
        }
        store.updatedMetadataAll();
        store.dispose();
    }

    public static boolean upgradeRepositoryACT(MdFactory m_Factory, Repository repos) throws Exception {
        boolean fixACTname = false;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String defaultACTname = bundle2.getString("RepositoryUtil.DefaultACT.Name.txt");
        String strReposId = repos.getFQID();
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        String[][] DefaultAuths = new String[][]{{"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}};
        String[][] DefaultACTNameAttribute = new String[][]{{"NAME", defaultACTname}};
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error3.txt"));
        }
        String defaultActId = RepositoryUtil.getdefaultActId(iSecAdmin, shortReposId);
        if (defaultActId.equalsIgnoreCase("")) {
            defaultActId = RepositoryUtil.getActId(iSecAdmin, "DefaultACT", shortReposId);
            if (defaultActId.equalsIgnoreCase("")) {
                throw new Exception(bundle2.getString("RepositoryUtil.defaultACTQuery.Error.txt"));
            }
            fixACTname = true;
        }
        try {
            String strDefaultACT = "OMSOBJ:AccessControlTemplate/" + defaultActId;
            if (!repos.getType().equalsIgnoreCase("Project")) {
                iSecAdmin.SetAuthorizationsOnObj("", strDefaultACT, 4, DefaultAuths);
            }
            if (fixACTname) {
                RepositoryUtil.updateACTAttributes(iSecAdmin, defaultActId, DefaultACTNameAttribute);
            }
        }
        catch (Exception e) {
            throw new Exception(bundle2.formatString("RepositoryUtil.UpdateDefaultACT.Exception.txt", (java.lang.Object)e.getMessage()));
        }
        return true;
    }

    public static boolean upgradeSASAdminACT(MdFactory m_Factory, String strReposId) throws Exception {
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String SASAdminACTname = bundle2.getString("RepositoryUtil.SASAdminACT.Name.notrans");
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        String[][] DefaultAuths = new String[][]{{"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}};
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error3.txt"));
        }
        String SASAdminActId = RepositoryUtil.getActId(iSecAdmin, SASAdminACTname, shortReposId);
        if (SASAdminActId.equalsIgnoreCase("")) {
            return false;
        }
        try {
            String strSASAdminACT = "OMSOBJ:AccessControlTemplate/" + SASAdminActId;
            iSecAdmin.SetAuthorizationsOnObj("", strSASAdminACT, 4, DefaultAuths);
        }
        catch (Exception e) {
            throw new Exception(bundle2.formatString("RepositoryUtil.UpdateSASAdminsACT.Exception.txt", (java.lang.Object)e.getMessage()));
        }
        return true;
    }

    public static boolean upgradePrivateUserFolderACT(MdFactory m_Factory, String strReposId) throws Exception {
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String privatefolderACTname = bundle2.getString("RepositoryUtil.privatefolderACT.Name.notrans");
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        String[][] DefaultAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}};
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error3.txt"));
        }
        String privateFolderActId = RepositoryUtil.getActId(iSecAdmin, privatefolderACTname, shortReposId);
        if (privateFolderActId.equalsIgnoreCase("")) {
            return false;
        }
        try {
            String strprivateFolderACT = "OMSOBJ:AccessControlTemplate/" + privateFolderActId;
            iSecAdmin.SetAuthorizationsOnObj("", strprivateFolderACT, 4, DefaultAuths);
        }
        catch (Exception e) {
            throw new Exception(bundle2.formatString("RepositoryUtil.UpdatePrivateFolderACT.Exception.txt", (java.lang.Object)e.getMessage()));
        }
        return true;
    }

    public static boolean createRepositoryACTs(MdFactory m_Factory, Repository repos) throws Exception {
        String strReposId = repos.getFQID();
        String reposType = repos.getType();
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        String reposName = m_Factory.getOMIUtil().cleanStringForXML(repos.getName());
        String defaultACTname = bundle2.getString("RepositoryUtil.DefaultACT.Name.txt");
        String defaultACTdesc = bundle2.getString("RepositoryUtil.DefaultACT.Desc.fmt.txt");
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        StringHolder tCtxt = new StringHolder();
        String[][] DefaultACTAttributes = new String[][]{{"NAME", defaultACTname}, {"USE", "REPOS"}, {"DESC", defaultACTdesc}};
        String[][] DefaultFoundationAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMemberMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "Administer", ""}, {"IdentityGroup", "PUBLIC", "D", "Read", ""}, {"IdentityGroup", "PUBLIC", "D", "Write", ""}, {"IdentityGroup", "PUBLIC", "D", "Create", ""}, {"IdentityGroup", "PUBLIC", "D", "Delete", ""}, {"IdentityGroup", "PUBLIC", "D", "Execute", ""}, {"IdentityGroup", "PUBLIC", "D", "Create Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Drop Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Alter Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Select", ""}, {"IdentityGroup", "PUBLIC", "D", "Insert", ""}, {"IdentityGroup", "PUBLIC", "D", "Update", ""}, {"IdentityGroup", "PUBLIC", "D", "References", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}, {"IdentityGroup", "SAS System Services", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "CheckInMetadata", ""}};
        String[][] DefaultCustomAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMemberMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "Administer", ""}, {"IdentityGroup", "PUBLIC", "D", "Read", ""}, {"IdentityGroup", "PUBLIC", "D", "Write", ""}, {"IdentityGroup", "PUBLIC", "D", "Create", ""}, {"IdentityGroup", "PUBLIC", "D", "Delete", ""}, {"IdentityGroup", "PUBLIC", "D", "Execute", ""}, {"IdentityGroup", "PUBLIC", "D", "Create Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Drop Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Alter Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Select", ""}, {"IdentityGroup", "PUBLIC", "D", "Insert", ""}, {"IdentityGroup", "PUBLIC", "D", "Update", ""}, {"IdentityGroup", "PUBLIC", "D", "References", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}, {"IdentityGroup", "SAS System Services", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "CheckInMetadata", ""}};
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error4.txt"));
        }
        if (!reposType.equalsIgnoreCase("Foundation")) {
            if (RepositoryUtil.defaultRepositoryACTExists(m_Factory, strReposId)) {
                return false;
            }
            try {
                iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                try {
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, DefaultACTAttributes);
                }
                catch (SECAD_ACT_ALREADY_EXISTS se) {
                    DefaultACTAttributes[0][1] = defaultACTname + "NEW";
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, DefaultACTAttributes);
                }
                if (reposType.equalsIgnoreCase("Custom")) {
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, DefaultCustomAuths);
                } else if (reposType.equalsIgnoreCase("Project")) {
                    String[][] DefaultProjectAuths = RepositoryUtil.buildDefaultProjectACTEntries(m_Factory, strReposId);
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, DefaultProjectAuths);
                }
                ConnectedIdentityInfo connUserInfo = new ConnectedIdentityInfo(m_Factory);
                if (!(connUserInfo.m_Name.equalsIgnoreCase("Public") && connUserInfo.m_Type.equalsIgnoreCase("IdentityGroup") || connUserInfo.m_UserClass.toUpperCase().contains("UNRESTRICTED"))) {
                    String[][] CreatorAuths = new String[][]{{connUserInfo.m_Type, connUserInfo.m_Name, "G", "ReadMetadata", ""}, {connUserInfo.m_Type, connUserInfo.m_Name, "G", "WriteMetadata", ""}};
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 0, CreatorAuths);
                }
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
            }
            catch (Exception e) {
                if (reposType.equalsIgnoreCase("Custom")) {
                    throw new Exception(bundle2.formatString("RepositoryUtil.CustomACT.Creation.Exception.txt", (java.lang.Object)e.getMessage()));
                }
                throw new Exception(bundle2.formatString("RepositoryUtil.ProjectACT.Creation.Exception.txt", (java.lang.Object)e.getMessage()));
            }
        }
        boolean addedACTs = RepositoryUtil.addAdditionalFoundationRepositoryACTs(m_Factory, repos, iSecAdmin);
        boolean createdDefaultACT = false;
        if (!RepositoryUtil.defaultRepositoryACTExists(m_Factory, strReposId)) {
            try {
                iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, DefaultACTAttributes);
                iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, DefaultFoundationAuths);
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                createdDefaultACT = true;
            }
            catch (Exception e) {
                throw new Exception(bundle2.formatString("RepositoryUtil.FoundationACT.Creation.Exception.txt", (java.lang.Object)e.getMessage()));
            }
        }
        if (!createdDefaultACT && !addedACTs) {
            return false;
        }
        return true;
    }

    public static boolean addAdditionalFoundationRepositoryACTs(MdFactory m_Factory, Repository repos, ISecurityAdmin iSecAdmin) throws Exception {
        boolean addedACT = false;
        String strReposId = repos.getFQID();
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        String SASAdminACTname = bundle2.getString("RepositoryUtil.SASAdminACT.Name.notrans");
        String SASAdminACTdesc = bundle2.getString("RepositoryUtil.SASAdminACT.Desc.fmt.txt");
        String privatefolderACTname = bundle2.getString("RepositoryUtil.privatefolderACT.Name.notrans");
        String privatefolderACTdesc = bundle2.getString("RepositoryUtil.privatefolderACT.Desc.fmt.txt");
        String[][] SASAdminACTAttributes = new String[][]{{"NAME", SASAdminACTname}, {"USE", ""}, {"DESC", SASAdminACTdesc}};
        String[][] SASAdminGroupAuths = new String[][]{{"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}};
        String[][] PrivateFolderACTAttributes = new String[][]{{"NAME", privatefolderACTname}, {"USE", ""}, {"DESC", privatefolderACTdesc}};
        String[][] PrivateFolderGroupAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}};
        if (repos.getType().equalsIgnoreCase("Foundation")) {
            StringHolder tCtxt = new StringHolder();
            if (iSecAdmin == null) {
                throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error2.txt"));
            }
            if (!RepositoryUtil.doesNamedACTExist(m_Factory, strReposId, SASAdminACTname)) {
                try {
                    iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, SASAdminACTAttributes);
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, SASAdminGroupAuths);
                    iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                    addedACT = true;
                }
                catch (Exception e) {
                    throw new MdException(bundle2.formatString("RepositoryUtil.SASAdminSettingsACT.Creation.Exception.txt", (java.lang.Object)e.getMessage()));
                }
            }
            if (!RepositoryUtil.doesNamedACTExist(m_Factory, strReposId, privatefolderACTname)) {
                try {
                    iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, PrivateFolderACTAttributes);
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, PrivateFolderGroupAuths);
                    iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                    addedACT = true;
                }
                catch (Exception e) {
                    throw new MdException(bundle2.formatString("RepositoryUtil.PrivateUserFolderACT.Creation.Exception.txt", (java.lang.Object)e.getMessage()));
                }
            }
        }
        return addedACT;
    }

    public static boolean addAdditionalFoundationRepositoryACTs(MdFactory m_Factory, Repository repos) throws Exception {
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)m_Factory.getConnection().getCMRHandle());
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error2.txt"));
        }
        return RepositoryUtil.addAdditionalFoundationRepositoryACTs(m_Factory, repos, iSecAdmin);
    }

    public static void applyAdminACT(MdFactory m_Factory, Repository repos) throws Exception {
        String strReposId = repos.getFQID();
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        String reposType = repos.getType();
        StringHolder tCtxt = new StringHolder();
        String SASAdminACTname = bundle2.getString("RepositoryUtil.SASAdminACT.Name.notrans");
        String privatefolderACTname = bundle2.getString("RepositoryUtil.privatefolderACT.Name.notrans");
        String[][] PublicAuthOnACT = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}};
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error.txt"));
        }
        if (reposType.equalsIgnoreCase("Foundation")) {
            try {
                String actId = RepositoryUtil.getActId(iSecAdmin, SASAdminACTname, shortReposId);
                String strSASAdminACT = "";
                if (actId != "") {
                    strSASAdminACT = "OMSOBJ:AccessControlTemplate/" + actId;
                }
                String privatefolderActId = RepositoryUtil.getActId(iSecAdmin, privatefolderACTname, shortReposId);
                String strPrivateFolderACT = "";
                if (privatefolderActId != "") {
                    strPrivateFolderACT = "OMSOBJ:AccessControlTemplate/" + privatefolderActId;
                }
                MdObjectStore store = m_Factory.createObjectStore();
                int flags = 0x10000180;
                String options = "<XMLSELECT search=\"@Name = 'SASUSERS' OR @Name = 'PUBLIC' OR @Name = 'SASAdministrators' OR @Name = 'META: Unrestricted Users Role' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' OR @Name = 'SAS System Services' \"/>";
                List identityGroups = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "IdentityGroup", flags, options, false);
                String strSASUSERS = null;
                String strPUBLIC = null;
                String strSASADMIN = null;
                String strUNRESTRICTEDUSERS = null;
                String strUSERADMINISTRATORS = null;
                String strOPERATORS = null;
                String strSASSystemServices = null;
                for (int i = 0; i < identityGroups.size(); ++i) {
                    IdentityGroup group = (IdentityGroup)identityGroups.get(i);
                    if (group.getName().equals("SASUSERS")) {
                        strSASUSERS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("PUBLIC")) {
                        strPUBLIC = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("SASAdministrators")) {
                        strSASADMIN = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("META: Unrestricted Users Role")) {
                        strUNRESTRICTEDUSERS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("META: User and Group Administrators Role")) {
                        strUSERADMINISTRATORS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("META: Operators Role")) {
                        strOPERATORS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (!group.getName().equals("SAS System Services")) continue;
                    strSASSystemServices = "OMSOBJ:IdentityGroup/" + group.getFQID();
                }
                store.dispose();
                String defaultActId = RepositoryUtil.getdefaultActId(iSecAdmin, shortReposId);
                String strDefaultACT = "";
                if (defaultActId.length() > 0) {
                    strDefaultACT = "OMSOBJ:AccessControlTemplate/" + defaultActId;
                }
                iSecAdmin.ApplyACTToObj("", strPrivateFolderACT, 0, strSASAdminACT);
                iSecAdmin.SetAuthorizationsOnObj("", strPrivateFolderACT, 0, PublicAuthOnACT);
                String bipServiceID = RepositoryUtil.getBIPTreeId(m_Factory, strReposId);
                if (bipServiceID != null) {
                    String strBIPService = "OMSOBJ:SoftwareComponent/" + bipServiceID;
                    iSecAdmin.ApplyACTToObj("", strBIPService, 0, strSASAdminACT);
                    String usersFolder = bundle.getString("Common.DefaultFolderPolicy.txt");
                    store = m_Factory.createObjectStore();
                    SoftwareComponent sc = (SoftwareComponent)m_Factory.createComplexMetadataObject(store, "BIP Service", "SoftwareComponent", bipServiceID);
                    AssociationList Trees = sc.getSoftwareTrees();
                    for (int i = 0; i < Trees.size(); ++i) {
                        Tree tree = (Tree)Trees.get(i);
                        if (!tree.getName().equals(usersFolder) && !tree.getName().equals("System")) continue;
                        String strResourceId = "OMSOBJ:Tree/" + tree.getFQID();
                        iSecAdmin.ApplyACTToObj("", strResourceId, 0, strSASAdminACT);
                    }
                    store.dispose();
                }
                if (strSASUSERS != null) {
                    iSecAdmin.ApplyACTToObj("", strSASUSERS, 0, strSASAdminACT);
                }
                if (strPUBLIC != null) {
                    iSecAdmin.ApplyACTToObj("", strPUBLIC, 0, strSASAdminACT);
                }
                if (strSASADMIN != null) {
                    iSecAdmin.ApplyACTToObj("", strSASADMIN, 0, strSASAdminACT);
                }
                if (strUNRESTRICTEDUSERS != null) {
                    iSecAdmin.ApplyACTToObj("", strUNRESTRICTEDUSERS, 0, strSASAdminACT);
                }
                if (strUSERADMINISTRATORS != null) {
                    iSecAdmin.ApplyACTToObj("", strUSERADMINISTRATORS, 0, strSASAdminACT);
                }
                if (strOPERATORS != null) {
                    iSecAdmin.ApplyACTToObj("", strOPERATORS, 0, strSASAdminACT);
                }
                if (strSASSystemServices != null) {
                    iSecAdmin.ApplyACTToObj("", strSASSystemServices, 0, strSASAdminACT);
                }
                iSecAdmin.ApplyACTToObj("", strSASAdminACT, 0, strSASAdminACT);
                iSecAdmin.SetAuthorizationsOnObj("", strSASAdminACT, 0, PublicAuthOnACT);
                iSecAdmin.BeginTransactionContext(strDefaultACT, 0, tCtxt);
                iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 0, PublicAuthOnACT);
                iSecAdmin.ApplyACTToObj(tCtxt.value, "", 0, strSASAdminACT);
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
            }
            catch (Exception e) {
                throw new Exception(bundle2.formatString("RepositoryUtil.ApplyAdminACT.Foundation.Exception.txt", (java.lang.Object)e.getMessage()));
            }
        }
        try {
            String strFoundationReposId = RepositoryUtil.getFoundationRepositoryId(m_Factory);
            String shortFoundationReposId = strFoundationReposId.substring(strFoundationReposId.indexOf(46) + 1, strFoundationReposId.length());
            if (strFoundationReposId != null) {
                String actId = RepositoryUtil.getActId(iSecAdmin, SASAdminACTname, shortFoundationReposId);
                String strSASAdminACT = "OMSOBJ:AccessControlTemplate/" + actId;
                String defaultActId = RepositoryUtil.getdefaultActId(iSecAdmin, shortReposId);
                String strDefaultACT = "OMSOBJ:AccessControlTemplate/" + defaultActId;
                iSecAdmin.BeginTransactionContext(strDefaultACT, 0, tCtxt);
                if (!repos.getType().equalsIgnoreCase("Project")) {
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 0, PublicAuthOnACT);
                }
                iSecAdmin.ApplyACTToObj(tCtxt.value, "", 0, strSASAdminACT);
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                if (!repos.getType().equalsIgnoreCase("Project")) {
                    String strBIPResId = "OMSOBJ:SoftwareComponent/" + RepositoryUtil.getBIPTreeId(m_Factory, repos.getFQID());
                    iSecAdmin.ApplyACTToObj("", strBIPResId, 0, strSASAdminACT);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(bundle2.formatString("RepositoryUtil.ApplyAdminACT.Exception.txt", (java.lang.Object)e.getMessage()));
        }
    }

    private static String getActId(ISecurityAdmin iSecAdmin, String name, String repositoryID) throws Exception {
        String actId = "";
        VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
        int flags = 0;
        try {
            iSecAdmin.GetAccessControlTemplateList("", "REPOSID:" + repositoryID, flags, actList);
        }
        catch (Exception e) {
            throw new Exception(bundle2.formatString("RepositoryUtil.ACTQuery.Exception.txt", (java.lang.Object)e.getMessage()));
        }
        for (int i = 0; i < actList.value.length; ++i) {
            if (!actList.value[i][2].equals(name)) continue;
            actId = actList.value[i][1].toString();
            break;
        }
        return actId;
    }

    private static String getdefaultActId(ISecurityAdmin iSecAdmin, String repositoryID) throws Exception {
        String actId = "";
        VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
        try {
            iSecAdmin.GetAccessControlTemplateList("", "REPOSID:" + repositoryID, 0, actList);
        }
        catch (Exception e) {
            throw new Exception(bundle2.formatString("RepositoryUtil.ACTQuery.Exception.txt", (java.lang.Object)e.getMessage()));
        }
        for (int i = 0; i < actList.value.length; ++i) {
            if (!actList.value[i][4].equalsIgnoreCase("REPOS")) continue;
            actId = actList.value[i][1].toString();
            break;
        }
        return actId;
    }

    public static IdentityGroup getPublicGroup(MdFactory m_Factory, String strReposId) throws MdException, RemoteException {
        List identityGroups = null;
        String publicIdentityOptions = "<XMLSELECT search=\"@Name = 'PUBLIC'\"/>";
        int flags = 0x10000180;
        try {
            identityGroups = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)m_Factory.getStore(), strReposId, "IdentityGroup", flags, publicIdentityOptions);
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        if (identityGroups != null && identityGroups.size() > 0) {
            return (IdentityGroup)identityGroups.get(0);
        }
        return null;
    }

    public static Permission getPermission(MdFactory m_Factory, String strReposId, String name, String type) throws MdException, RemoteException {
        List permissions = null;
        String permissionOptions = "<XMLSELECT search=\"@Name = '" + name + "' AND @Type ='" + type + "'\"/>";
        int flags = 0x10000180;
        try {
            permissions = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)m_Factory.getStore(), strReposId, "Permission", flags, permissionOptions);
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        if (permissions != null && permissions.size() > 0) {
            return (Permission)permissions.get(0);
        }
        return null;
    }

    private static String[][] buildDefaultProjectACTEntries(MdFactory m_Factory, String strReposId) throws MdException, RemoteException {
        m_Factory.getConnection().getCMRHandle();
        IdentityGroup publicGroup = RepositoryUtil.getPublicGroup(m_Factory, strReposId);
        Identity owner = WsRepositoryUtil.getRepositoryOwner((MdFactory)m_Factory, (String)strReposId);
        if (owner == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ProjectACT.Exception.txt"));
        }
        if (owner.getFQID().equals(publicGroup.getFQID())) {
            throw new MdException(bundle2.getString("RepositoryUtil.BuildDefaultProjectACTEntries.PublicOwner.Error.txt"));
        }
        boolean isOwnerGroup = owner instanceof IdentityGroup;
        ConnectedIdentityInfo connUserInfo = new ConnectedIdentityInfo(m_Factory);
        if (!connUserInfo.m_UserClass.toUpperCase().contains("UNRESTRICTED") && connUserInfo.m_Name.equalsIgnoreCase("Public") && connUserInfo.m_Type.equalsIgnoreCase("IdentityGroup")) {
            throw new MdException(bundle2.getString("RepositoryUtil.BuildDefaultProjectACTEntries.PublicCreator.Error.txt"));
        }
        String strOwnerType = null;
        strOwnerType = isOwnerGroup ? new String("IdentityGroup") : new String("Person");
        if (connUserInfo.m_UserClass.toUpperCase().contains("UNRESTRICTED") || connUserInfo.m_Type.equalsIgnoreCase(strOwnerType) && connUserInfo.m_Name.equalsIgnoreCase(owner.getName())) {
            String[][] DefaultProjectAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {strOwnerType, owner.getName(), "G", "WriteMetadata", ""}, {strOwnerType, owner.getName(), "G", "ReadMetadata", ""}};
            return DefaultProjectAuths;
        }
        String[][] DefaultProjectAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {strOwnerType, owner.getName(), "G", "WriteMetadata", ""}, {strOwnerType, owner.getName(), "G", "ReadMetadata", ""}, {connUserInfo.m_Type, connUserInfo.m_Name, "G", "ReadMetadata", ""}, {connUserInfo.m_Type, connUserInfo.m_Name, "G", "WriteMetadata", ""}};
        return DefaultProjectAuths;
    }

    public static int[] checkDefaultPermissions(MdFactory m_Factory, String strReposId, int reposDependenciesType) throws Exception {
        int flags = 0x10000108 | reposDependenciesType;
        int serverversion = m_Factory.getConnection().getPlatformVersion();
        int rposFormat = RepositoryUtil.getRepositoryFormatVersion(m_Factory, strReposId);
        int maxperms = RepositoryUtil.getMaxPermissionsForRepository(serverversion, rposFormat);
        int[] permissionCodes = new int[17];
        int i = 0;
        while (i < 17) {
            permissionCodes[i++] = 0;
        }
        MdObjectStore store = m_Factory.createObjectStore();
        List permissions = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Permission", flags, "", false);
        for (int i2 = 0; i2 < permissions.size(); ++i2) {
            Permission perm = (Permission)permissions.get(i2);
            for (int j = 0; j < maxperms; ++j) {
                if (!perm.getName().equals(PERMISSION_NAMES[j])) continue;
                if (perm.getType().equalsIgnoreCase("GRANT")) {
                    int n = j;
                    permissionCodes[n] = permissionCodes[n] | 1;
                    continue;
                }
                if (!perm.getType().equalsIgnoreCase("DENY")) continue;
                int n = j;
                permissionCodes[n] = permissionCodes[n] | 2;
            }
        }
        store.dispose();
        return permissionCodes;
    }

    public static boolean entityPropertyTypesExists(MdFactory m_Factory, String strReposId) throws Exception {
        List resultList = null;
        String strSelect = "<XMLSELECT search=\"Group[@Name='Entity Property Types']\"/>";
        String strTemplate = "<Templates><Group><Members/></Group></Templates>";
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        MdObjectStore store = m_Factory.createObjectStore();
        resultList = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)store, strReposId, "Group", flags, strOptions);
        if (resultList == null || resultList.size() == 0) {
            store.dispose();
            return false;
        }
        store.dispose();
        return true;
    }

    public static void createEntityPropertyTypes(MdFactory m_Factory, String strReposId) throws Exception {
        if (RepositoryUtil.entityPropertyTypesExists(m_Factory, strReposId)) {
            return;
        }
        String inXML = bundle.getString("NewReposWizard.EntityPropertyType.template.notrans");
        StringHolder outXML = new StringHolder();
        m_Factory.getOMIUtil().addMetadata(inXML, strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length()), outXML, 0x10000000);
    }

    public static String transformationPrototypesExist(MdFactory m_Factory, String strReposId) throws Exception {
        List tpList = new Vector(0);
        String strSelect = "<XMLSELECT Search=\"@MetadataType='TransformationStep2'\"/>";
        String strTemplate = "<TEMPLATES><Prototype Id=\"\"><Properties/><Extensions/></Prototype><Property Id=\"\"><StoredConfiguration/></Property><StoredConfiguration Id=\"\"><StoredText/></StoredConfiguration></TEMPLATES>";
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        MdObjectStore store = m_Factory.createObjectStore();
        tpList = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)store, strReposId, "Prototype", flags, strOptions);
        if (tpList != null && tpList.size() > 0) {
            String repId = "A0000001." + ((Prototype)tpList.get(0)).getRepositoryID();
            store.dispose();
            return repId;
        }
        store.dispose();
        return null;
    }

    public static void addTypeDictionaryDefinitions(MdFactory m_Factory, String strReposId, ArrayList errorList, boolean uiEnabled) throws Exception {
        boolean problem = false;
        m_Factory.getConnection().getCMRHandle();
        String strReposType = WsRepositoryUtil.getRepositoryType((MdFactory)m_Factory, (String)strReposId);
        if (!strReposType.equalsIgnoreCase("FOUNDATION")) {
            return;
        }
        if (_fileList == null) {
            RepositoryUtil.getTypeDefList(m_Factory);
        }
        if (errorList == null) {
            errorList = new ArrayList<String>();
        }
        if (_session == null || _session.isDestroyPending()) {
            SessionContextInterface session = Workspace.getWorkspace().getSessionContext();
            if (session == null || session.isDestroyPending()) {
                UserContextInterface userCtx = Workspace.getWorkspace().getUserContext();
                if (userCtx != null) {
                    session = CorePlatformServices.getSessionService().newSessionContext(userCtx);
                }
                if (session == null) {
                    problem = true;
                    if (uiEnabled) {
                        MessageUtil.displayMessage((String)bundle2.getString("RepositoryUtil.TypeDictionaryTemplate.sessionerror.txt"), (int)64);
                    } else {
                        try {
                            String errorMsg = bundle2.getString("RepositoryUtil.TypeDictionaryTemplate.sessionerror.txt");
                            m_Factory.getUtil().printOutputln(errorMsg);
                            errorList.add(errorMsg);
                        }
                        catch (RemoteException errorMsg) {
                            // empty catch block
                        }
                    }
                }
            }
            _session = session;
        }
        if (!problem) {
            Set keys = _fileList.keySet();
            for (String typeName : keys) {
                Map fileInfo = (Map)_fileList.get(typeName);
                String fileName = (String)fileInfo.get("File");
                String templateName = (String)fileInfo.get("Template");
                if (fileName == null || fileName.equalsIgnoreCase("")) break;
                boolean loadedEntry = RepositoryUtil.loadDictionaryEntries(m_Factory, fileName, strReposId, typeName, errorList, uiEnabled, templateName);
                if (loadedEntry) continue;
                problem = true;
            }
        }
        if (problem) {
            throw new Exception(bundle2.getString("RepositoryUtil.AddTypeDictionary.Error.txt"));
        }
    }

    public static void addTypeDictionaryDefinitions(MdFactory m_Factory, String strReposId, SessionContextInterface session, ArrayList errorList, boolean uiEnabled) throws Exception {
        _session = session;
        RepositoryUtil.addTypeDictionaryDefinitions(m_Factory, strReposId, errorList, uiEnabled);
    }

    @Deprecated
    private static void getTypeDefList(MdFactory m_Factory) throws IOException, MdException {
        String indexFile = bundle2.getString("RepositoryUtil.TypeDictionaryIndexFile.notrans");
        HashMap fileList = new HashMap();
        URL url = XMLUtility.urlFromFile((String)indexFile);
        Document doc = m_Factory.getOMIUtil().parseXML(url);
        Element docRoot = doc.getDocumentElement();
        NodeList typeDefNodeList = docRoot.getElementsByTagName("TypeDef");
        for (int i = 0; i < typeDefNodeList.getLength(); ++i) {
            Element typeDef = (Element)typeDefNodeList.item(i);
            HashMap<String, String> fileInfo = new HashMap<String, String>();
            if (typeDef.hasAttribute("TemplateName")) {
                fileInfo.put("Template", typeDef.getAttribute("TemplateName"));
            }
            fileInfo.put("File", typeDef.getAttribute("FileName"));
            fileList.put(typeDef.getAttribute("TypeName"), fileInfo);
        }
        _fileList = fileList;
    }

    @Deprecated
    private static String insertTemplate(MdFactory m_Factory, String appXMLstring, String templateName, ArrayList errorList, boolean uiEnabled) throws MdException {
        try {
            URL url = XMLUtility.urlFromFile((String)templateName);
            String strTemplate = "";
            InputStream inputStream = null;
            inputStream = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String strBuffer = "";
            while ((strBuffer = reader.readLine()) != null) {
                strTemplate = strTemplate + strBuffer;
            }
            if (appXMLstring.contains("/></Application")) {
                int indx = appXMLstring.indexOf("/></Application");
                appXMLstring = appXMLstring.substring(0, indx) + ">" + strTemplate + "</TypeDefinition>" + appXMLstring.substring(indx + 2);
            } else if (appXMLstring.contains("</TypeDefinition>")) {
                int indx = appXMLstring.indexOf("</TypeDefinition>");
                appXMLstring = appXMLstring.substring(0, indx) + strTemplate + appXMLstring.substring(indx);
            }
            return appXMLstring;
        }
        catch (IOException exc) {
            if (uiEnabled) {
                MessageUtil.displayMessage((String)bundle2.formatString("RepositoryUtil.TypeDictionaryTemplate.fileerror.txt", (java.lang.Object)templateName, (java.lang.Object)exc.getMessage()), (int)64);
            } else {
                try {
                    String errorMsg = bundle2.formatString("RepositoryUtil.TypeDictionaryTemplate.fileerror.txt", (java.lang.Object)templateName, (java.lang.Object)exc.getMessage());
                    m_Factory.getUtil().printOutputln(errorMsg);
                    errorList.add(errorMsg);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return appXMLstring;
        }
        catch (Exception e) {
            return appXMLstring;
        }
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public static boolean loadDictionaryEntries(MdFactory m_Factory, String strFileName, String strReposId, String typeName, ArrayList errorList, boolean uiEnabled, String templateName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static TypeDefinition findTypeDictionaryTemplate(MdFactory m_Factory, MdObjectStore store, String strReposId, String typeName, ArrayList errorList) throws MdException, RemoteException {
        TypeDefinition typeDef = null;
        int flags = 392;
        String strSelect = "<XMLSELECT search=\"@TypeName='" + typeName + "'\" />";
        List typeList = RepositoryUtil.retrieveObjects(m_Factory, (MdStore)store, strReposId, "TypeDefinition", flags, strSelect);
        if (typeList != null && typeList.size() > 0) {
            typeDef = (TypeDefinition)typeList.get(0);
        }
        return typeDef;
    }

    @Deprecated
    private static boolean deleteTypeDefinition(MdFactory m_Factory, TypeDefinition typedef) throws MdException, RemoteException {
        String typeName;
        if (_fileList == null) {
            try {
                RepositoryUtil.getTypeDefList(m_Factory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (typedef != null && _fileList.containsKey(typeName = typedef.getTypeName())) {
            String strTemplate = bundle2.getString("RepositoryUtil.TypeDefinition.Template.notrans");
            m_Factory.deletePublicObject((CMetadata)typedef, strTemplate);
        }
        return true;
    }

    @Deprecated
    public static boolean deleteTypeDefinitions(MdFactory m_Factory, Repository repos) throws MdException, RemoteException {
        String reposId;
        List m_typesList = null;
        if (_fileList == null) {
            try {
                RepositoryUtil.getTypeDefList(m_Factory);
            }
            catch (IOException e) {
                return false;
            }
        }
        if ((reposId = repos.getFQID()) != null) {
            try {
                m_typesList = RepositoryUtil.populateTypeDefinitionsList(m_Factory, reposId);
            }
            catch (MdException exc) {
                throw new MdException(bundle2.formatString("RepositoryUtil.PopulateTemplateList.error.txt", (java.lang.Object)exc.getLocalizedMessage()));
            }
            catch (RemoteException re) {
                throw new MdException(bundle2.formatString("RepositoryUtil.PopulateTemplateList.error.txt", (java.lang.Object)re.getLocalizedMessage()));
            }
            if (m_typesList == null) {
                return false;
            }
            if (m_typesList.isEmpty()) {
                return true;
            }
            for (int index = 0; index < m_typesList.size(); ++index) {
                String strTemplate;
                TypeDefinition item = (TypeDefinition)m_typesList.get(index);
                if (item == null) continue;
                String typeName = item.getTypeName();
                if (_fileList.containsKey(typeName)) {
                    strTemplate = bundle2.getString("RepositoryUtil.TypeDefinition.Template.notrans");
                    m_Factory.deletePublicObject((CMetadata)item, strTemplate);
                    continue;
                }
                if (!typeName.equals("IdentityGroup") && !typeName.equals("Person") && !typeName.equals("AuthDomain")) continue;
                strTemplate = bundle2.getString("RepositoryUtil.TypeDefinition.Template.notrans");
                m_Factory.deletePublicObject((CMetadata)item, strTemplate);
            }
        } else {
            return false;
        }
        return true;
    }

    @Deprecated
    public static List populateTypeDefinitionsList(MdFactory m_Factory, String reposId) throws MdException, RemoteException {
        Vector typesList = null;
        String strType = "TypeDefinition";
        int flags = 264;
        typesList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_Factory.createObjectStore(), reposId, strType, flags, "", false);
        if (typesList == null) {
            typesList = new Vector();
        }
        return typesList;
    }

    public static String getCurrentRepositoryUpgradeLevel(MdFactory m_Factory, String strReposId, String identifier) throws MdException, RemoteException {
        String firstrelease = "9.1";
        String firstfixpack = "0";
        List resultList = null;
        MdObjectStore store = m_Factory.createObjectStore();
        String template = "<Templates><TextStore Name=\"\" StoredText=\"\" TextRole=\"\"><Objects><Group Name=\"\" /></Objects></TextStore></Templates>";
        String select = "<XMLSELECT search=\"TextStore[@TextRole='UpgradeLevel'][Objects/Group[@Name='RepositoryUpgrades']]\"/>";
        String strOptions = template + select;
        int flags = 388;
        try {
            resultList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "TextStore", flags, strOptions, false);
        }
        catch (MdException e) {
            store.dispose();
            throw e;
        }
        catch (RemoteException re) {
            store.dispose();
            throw re;
        }
        if (resultList.size() == 0) {
            store.dispose();
            if (identifier.equalsIgnoreCase("FIXPACK")) {
                return firstfixpack;
            }
            return firstrelease;
        }
        String fixPack = firstfixpack;
        String level = firstrelease;
        for (int i = 0; i < resultList.size(); ++i) {
            TextStore ts = (TextStore)resultList.get(i);
            if (ts.getName().equalsIgnoreCase("AdminMetadata Conversion")) continue;
            String reposfixPack = ts.getStoredText();
            String reposlevel = ts.getName();
            Integer reposfixPackInt = Integer.valueOf(reposfixPack);
            if (reposfixPackInt.compareTo(Integer.valueOf(fixPack)) < 0) continue;
            fixPack = reposfixPack;
            level = reposlevel;
        }
        store.dispose();
        if (identifier.equalsIgnoreCase("FIXPACK")) {
            return fixPack;
        }
        return level;
    }

    public static Group getUpgradeGroupRecord(MdFactory m_Factory, MdObjectStore store, String strReposId) throws Exception {
        List resultList = null;
        String template = "<Templates><Group><Notes><TextStore Name=\"\" StoredText=\"\" TextRole=\"\" /></Notes></Group></Templates>";
        String select = "<XMLSELECT search=\"Group[@Name='RepositoryUpgrades'][Notes/TextStore[@TextRole='UpgradeLevel' OR @TextRole='Marker']]\"/>";
        String strOptions = template + select;
        int flags = 388;
        resultList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Group", flags, strOptions, false);
        if (resultList == null || resultList.size() == 0) {
            return null;
        }
        Group grp = (Group)resultList.get(0);
        return grp;
    }

    public static Property getRepositoryDetailsProperty(MdFactory m_Factory, MdObjectStore store, String strReposId) throws Exception {
        List resultList = null;
        String template = "<Templates><Property Name=\"\" DefaultValue=\"\"><AssociatedObject><Group Name=\"\" /></AssociatedObject></Property></Templates>";
        String select = "<XMLSELECT search=\"Property[@Name='RepositoryDetails'][AssociatedObject/Group[@Name='RepositoryUpgrades']]\"/>";
        String strOptions = template + select;
        int flags = 388;
        resultList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "Property", flags, strOptions, false);
        if (resultList == null || resultList.size() == 0) {
            return null;
        }
        Property prop = (Property)resultList.get(0);
        return prop;
    }

    public static void createUpdateRecord(MdFactory m_Factory, Repository repos, String release, String fixpack) throws Exception {
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String reposId = repos.getFQID();
        if (RepositoryUtil.needsUpgradeRecord(m_Factory, reposId, release, fixpack)) {
            MdObjectStore store = m_Factory.createObjectStore();
            String[][] PublicAuthOnUpgradeRecords = new String[][]{{"IdentityGroup", "PUBLIC", "G", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}};
            Group grp = null;
            String grpId = null;
            grp = RepositoryUtil.getUpgradeGroupRecord(m_Factory, store, reposId);
            if (grp != null) {
                TextStore ts = (TextStore)m_Factory.createComplexMetadataObject(store, release, "TextStore", reposId.substring(9, 17));
                ts.setStoredText(fixpack);
                ts.setTextRole("UpgradeLevel");
                grp.getNotes().add((java.lang.Object)ts);
                Property prop = null;
                prop = RepositoryUtil.getRepositoryDetailsProperty(m_Factory, store, reposId);
                if (prop == null) {
                    String propName = "RepositoryDetails";
                    String propRole = "initialization";
                    String propDesc = bundle2.getString("RepositoryUtil.RepositoryDetailsProperty.description.txt");
                    String defaultValue = repos.getType() + ":" + repos.getName();
                    prop = (Property)m_Factory.createComplexMetadataObject(store, propName, "Property", reposId.substring(9, 17));
                    prop.setPropertyName(propName);
                    prop.setPropertyRole(propRole);
                    prop.setDesc(propDesc);
                    prop.setDefaultValue(defaultValue);
                    grp.getProperties().add((java.lang.Object)prop);
                }
                grpId = grp.getFQID();
                grp.updateMetadataAll();
            } else {
                StringHolder outXML = new StringHolder();
                String propName = "RepositoryDetails";
                String propRole = "initialization";
                String propDesc = bundle2.getString("RepositoryUtil.RepositoryDetailsProperty.description.txt");
                String defaultValue = repos.getType() + ":" + repos.getName();
                StringBuffer inXMLBuffer = new StringBuffer();
                inXMLBuffer.append("<Group Name=\"RepositoryUpgrades\">");
                inXMLBuffer.append("<Notes>");
                inXMLBuffer.append("<TextStore Name=\"" + release + "\" StoredText=\"" + fixpack + "\" TextRole=\"UpgradeLevel\"/>");
                inXMLBuffer.append("</Notes>");
                inXMLBuffer.append("<Properties>");
                inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"" + propName + "\" PropertyRole=\"" + propRole + "\" Desc=\"" + propDesc + "\" DefaultValue=\"" + defaultValue + "\"/>");
                inXMLBuffer.append("</Properties>");
                inXMLBuffer.append("</Group>");
                String inXML = inXMLBuffer.toString();
                omiConnection.AddMetadata(inXML, reposId, outXML, "SAS", 0x10000000, "");
                String outXMLString = outXML.value;
                Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
                if (mainDoc != null) {
                    Node firstNode = mainDoc.getFirstChild();
                    NamedNodeMap firstNodeMap = firstNode.getAttributes();
                    grpId = firstNodeMap.getNamedItem("Id").getNodeValue();
                }
            }
            if (grpId != null) {
                ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
                if (iSecAdmin == null) {
                    throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error5.txt"));
                }
                String strFoundationId = RepositoryUtil.getFoundationRepositoryId(m_Factory);
                String shortFoundationId = strFoundationId.substring(strFoundationId.indexOf(46) + 1, strFoundationId.length());
                String strAdminACT = "OMSOBJ:AccessControlTemplate/" + RepositoryUtil.getActId(iSecAdmin, bundle2.getString("RepositoryUtil.SASAdminACT.Name.notrans"), shortFoundationId);
                String strGRPObjID = "OMSOBJ:Group/" + grpId;
                StringHolder shTransContext = new StringHolder();
                iSecAdmin.BeginTransactionContext(strGRPObjID, 0, shTransContext);
                iSecAdmin.ApplyACTToObj(shTransContext.value, "", 0, strAdminACT);
                iSecAdmin.SetAuthorizationsOnObj("", strGRPObjID, 0, PublicAuthOnUpgradeRecords);
                iSecAdmin.EndTransactionContext(shTransContext.value, strGRPObjID, 1);
            }
            store.dispose();
        }
    }

    private static boolean needsUpgradeRecord(MdFactory m_Factory, String strReposId, String release, String fixpack) throws Exception {
        List resultList = null;
        Integer usedFixPack = Integer.valueOf(fixpack);
        m_Factory.getConnection().getCMRHandle();
        MdObjectStore store = m_Factory.createObjectStore();
        String template = "<Templates><TextStore Name=\"\" StoredText=\"\" TextRole=\"\"><Objects><Group Name=\"\" /></Objects></TextStore></Templates>";
        String select = "<XMLSELECT search=\"TextStore[@Name='" + release + "' AND @TextRole='UpgradeLevel'][Objects/Group[@Name='RepositoryUpgrades']]\"/>";
        String strOptions = template + select;
        int flags = 388;
        try {
            resultList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "TextStore", flags, strOptions, false);
        }
        catch (MdException e) {
            store.dispose();
            throw e;
        }
        catch (RemoteException re) {
            store.dispose();
            throw re;
        }
        if (resultList.size() == 0) {
            store.dispose();
            return true;
        }
        for (int i = 0; i < resultList.size(); ++i) {
            TextStore ts = (TextStore)resultList.get(i);
            String fixPack = ts.getStoredText();
            String currentlevel = ts.getName();
            Integer fixPackAsInt = Integer.valueOf(fixPack);
            if (!currentlevel.equals(release) || fixPackAsInt.compareTo(usedFixPack) < 0) continue;
            store.dispose();
            return false;
        }
        store.dispose();
        return true;
    }

    public static String getUpgradeReleaseBasedonServerVersion(MdFactory m_Factory, String reposId) throws Exception {
        int platformVer = m_Factory.getConnection().getPlatformVersion();
        int formatVer = RepositoryUtil.getRepositoryFormatVersion(m_Factory, reposId);
        if (platformVer >= 9200) {
            if (formatVer < 6) {
                return "9.1.3";
            }
            return CURRENT_RELEASE;
        }
        return "9.1.3";
    }

    public static String getUpgradeFixpackBasedonServerVersion(MdFactory m_Factory, String reposId) throws Exception {
        int platformVer = m_Factory.getConnection().getPlatformVersion();
        int formatVer = RepositoryUtil.getRepositoryFormatVersion(m_Factory, reposId);
        if (platformVer >= 9200) {
            if (formatVer < 6) {
                return "5";
            }
            return CURRENT_FIXPACK;
        }
        return "5";
    }

    public static int getRepositoryFormatVersion(MdFactory m_Factory, String strReposId) throws Exception {
        int repVersion = 0;
        String sRepFormatVer = RepositoryUtil.getRepositoryVersionString(m_Factory, strReposId);
        repVersion = Integer.valueOf(sRepFormatVer);
        return repVersion;
    }

    public static int getMaxPermissionsForRepository(int platver, int rposFormat) throws Exception {
        if (platver >= 9200 && rposFormat < 6) {
            platver = 9130;
        }
        for (int i = 0; i < NUM_PERMISSIONS_FOR_RELEASE.length; ++i) {
            if (platver < NUM_PERMISSIONS_FOR_RELEASE[i][0]) continue;
            return NUM_PERMISSIONS_FOR_RELEASE[i][1];
        }
        return NUM_PERMISSIONS_FOR_RELEASE[NUM_PERMISSIONS_FOR_RELEASE.length - 1][1];
    }

    public static String getRepositoryType(MdFactory m_Factory, String strReposId) {
        String repType = "";
        try {
            m_Factory.getConnection().getCMRHandle();
            repType = WsRepositoryUtil.getRepositoryType((MdFactory)m_Factory, (String)strReposId);
        }
        catch (RemoteException re) {
            try {
                m_Factory.getUtil().printStackTrace((Throwable)re);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return repType;
    }

    private static List retrieveObjects(MdFactory m_Factory, MdStore objectStore, String strReposId, String strMetadataType, int xmlFlags, String xmlOptions) throws MdException {
        List objectList;
        block6: {
            int flags = xmlFlags;
            objectList = null;
            try {
                m_Factory.getConnection().getCMRHandle();
                Vector dependencies = WsRepositoryUtil.getRepositoryDependencies((MdFactory)m_Factory, (String)strReposId);
                if (dependencies.size() > 0) {
                    objectList = m_Factory.getOMIUtil().getMetadataObjectsSubset(objectStore, strReposId, strMetadataType, flags |= 0x2000, xmlOptions, false);
                    break block6;
                }
                objectList = m_Factory.getOMIUtil().getMetadataObjectsSubset(objectStore, strReposId, strMetadataType, flags, xmlOptions, false);
                Repository[] repositories = Repository.getRepositories((MdFactory)m_Factory);
                for (int i = 0; i < repositories.length; ++i) {
                    Repository repository = repositories[i];
                    if (!repository.getType().equalsIgnoreCase("FOUNDATION") || repository.getFQID().equalsIgnoreCase(strReposId)) continue;
                    List subList = m_Factory.getOMIUtil().getMetadataObjectsSubset(objectStore, repository.getFQID(), strMetadataType, flags, xmlOptions, false);
                    if (objectList != null) {
                        objectList.addAll(subList);
                    } else {
                        objectList = subList;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new MdException((Throwable)e);
            }
        }
        return objectList;
    }

    public static boolean validateRepositoryName(MdFactory m_Factory, String strReposName, String strReposType) {
        try {
            CMetadata FoundationObj = null;
            String FoundationReposId = null;
            try {
                Repository[] repositories = Repository.getRepositories((MdFactory)m_Factory);
                for (int i = 0; i < repositories.length; ++i) {
                    Repository repository = repositories[i];
                    if (!strReposName.equalsIgnoreCase(repository.getName())) continue;
                    return false;
                }
                if (repositories == null || repositories.length == 0) {
                    return true;
                }
                FoundationObj = m_Factory.getOMIUtil().getFoundationRepository();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return false;
            }
            if (FoundationObj == null) {
                return false;
            }
            FoundationReposId = FoundationObj.getId();
            if (strReposType.equalsIgnoreCase("PROJECT")) {
                return true;
            }
            MdObjectStore newStore = m_Factory.createObjectStore();
            try {
                String strSelect = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
                String strTemplate = "<Templates><SoftwareComponent Name=\"\"><SoftwareTrees/></SoftwareComponent></Templates>";
                String strOptions = strTemplate + strSelect;
                int flags = 396;
                List comps = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)newStore, FoundationReposId, "SoftwareComponent", flags, strOptions, false);
                SoftwareComponent sc = null;
                if (comps.size() != 1) {
                    return false;
                }
                sc = (SoftwareComponent)comps.get(0);
                Vector trees = new Vector(sc.getSoftwareTrees());
                if (trees != null && trees.size() > 0) {
                    for (int j = 0; j < trees.size(); ++j) {
                        Tree tr = (Tree)trees.get(j);
                        if (!strReposName.equalsIgnoreCase(tr.getName())) continue;
                        newStore.dispose();
                        return false;
                    }
                }
            }
            catch (MdException exc) {
                exc.printStackTrace();
                newStore.dispose();
                return false;
            }
            catch (RemoteException re) {
                newStore.dispose();
                return false;
            }
            newStore.dispose();
            return true;
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public static void removeConnectedIdentityFromRepositoryACT(MdFactory m_Factory, String strReposId) throws Exception {
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        String shortReposId = strReposId.substring(strReposId.indexOf(46) + 1, strReposId.length());
        ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)omiConnection);
        if (iSecAdmin == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ISecurityAdmin.Connection.Error7.txt"));
        }
        String defaultActId = RepositoryUtil.getdefaultActId(iSecAdmin, shortReposId);
        if (defaultActId.equalsIgnoreCase("")) {
            throw new MdException(bundle2.getString("RepositoryUtil.defaultACTQuery.Error.txt"));
        }
        Identity owner = WsRepositoryUtil.getRepositoryOwner((MdFactory)m_Factory, (String)strReposId);
        if (owner == null) {
            throw new MdException(bundle2.getString("RepositoryUtil.ProjectACT.Exception.txt"));
        }
        String strOwnerType = owner instanceof IdentityGroup ? "IdentityGroup" : (owner instanceof Person ? "Person" : "");
        ConnectedIdentityInfo connUserInfo = new ConnectedIdentityInfo(m_Factory);
        if (!(connUserInfo.m_Name.equalsIgnoreCase("Public") && connUserInfo.m_Type.equalsIgnoreCase("IdentityGroup") || connUserInfo.m_UserClass.toUpperCase().contains("UNRESTRICTED") || strOwnerType.equalsIgnoreCase(connUserInfo.m_Type) && owner.getName().equalsIgnoreCase(connUserInfo.m_Name))) {
            try {
                String strDefaultACT = "OMSOBJ:AccessControlTemplate/" + defaultActId;
                String[][] ConnUserAuths = new String[][]{{connUserInfo.m_Type, connUserInfo.m_Name, "R", "", ""}};
                iSecAdmin.SetAuthorizationsOnObj("", strDefaultACT, 4, ConnUserAuths);
            }
            catch (Exception e) {
                throw new Exception(bundle2.formatString("RepositoryUtil.RemoveConnectedUserFromACT.Exception.txt", (java.lang.Object)e.getMessage()));
            }
        }
    }

    public static boolean isConnectedUserAuthorizedOnIdentity(MdFactory m_Factory, Identity ident) throws Exception {
        ConnectedIdentityInfo connUserInfo = null;
        try {
            connUserInfo = new ConnectedIdentityInfo(m_Factory);
        }
        catch (Exception e) {
            throw new Exception(bundle.getString("RepositoryUtil.UnableToDetermineAdminPermission.Error.txt"));
        }
        if (connUserInfo.m_UserClass.indexOf("Unrestricted") != -1) {
            return true;
        }
        if (connUserInfo.m_ObjectID.equalsIgnoreCase(ident.getFQID())) {
            return true;
        }
        ISecurity_1_1 iSecurity = null;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        iSecurity = ISecurity_1_1Helper.narrow((Object)omiConnection);
        if (iSecurity == null) {
            throw new MdException(bundle.getString("RepositoryUtil.ISecurity.Connection.Error.txt"));
        }
        String resource = ident instanceof IdentityGroup ? "OMSOBJ:IdentityGroup/" + ident.getFQID() : "OMSOBJ:Person/" + ident.getFQID();
        StringHolder permissionCondition = new StringHolder();
        BooleanHolder authorized = new BooleanHolder();
        try {
            iSecurity.IsAuthorized("", resource, "WriteMetadata", permissionCondition, authorized);
        }
        catch (Exception e) {
            throw new MdException(bundle.formatString("RepositoryUtil.ISecurity.IsAuthorized.Error.txt", (java.lang.Object)e.getMessage()));
        }
        finally {
            try {
                iSecurity._release();
                iSecurity = null;
            }
            catch (Exception exception) {}
        }
        return authorized.value;
    }

    public static boolean isConnectedUserAuthorizedforRepositoryAction(MdFactory m_Factory) throws Exception {
        ConnectedIdentityInfo connUserInfo = null;
        try {
            connUserInfo = new ConnectedIdentityInfo(m_Factory);
        }
        catch (Exception e) {
            throw new Exception(bundle.getString("RepositoryUtil.UnableToDetermineAdminPermission.Error.txt"));
        }
        if (connUserInfo.m_UserClass.indexOf("Unrestricted") != -1) {
            return true;
        }
        if (connUserInfo.m_Name.equalsIgnoreCase("Public") && connUserInfo.m_Type.equalsIgnoreCase("IdentityGroup")) {
            throw new Exception(bundle2.getString("RepositoryUtil.PublicUserNotAuthorized.Error.txt"));
        }
        return connUserInfo.m_UserClass.indexOf("Administrator") != -1 || connUserInfo.m_UserClass.indexOf("Operator") != -1;
    }

    public static boolean isConnectedUserAuthorizedOnBIPService(MdFactory m_Factory) throws Exception {
        String strBipService = RepositoryUtil.getFoundationRepositoryBIPService(m_Factory);
        if (strBipService == null) {
            throw new Exception(bundle2.getString("RepositoryUtil.FoundationBIPServiceId.NotFound.Error.txt"));
        }
        String strResource = "OMSOBJ:SoftwareComponent/" + strBipService;
        ISecurity_1_1 iSec = ISecurity_1_1Helper.narrow((Object)m_Factory.getConnection().getCMRHandle());
        StringHolder permCond = new StringHolder();
        BooleanHolder authorized = new BooleanHolder();
        iSec.IsAuthorized("", strResource, "WriteMetadata", permCond, authorized);
        if (!authorized.value) {
            throw new Exception(bundle2.getString("RepositoryUtil.UserNotAuthorizedToBIPService.Error.txt"));
        }
        return true;
    }

    public static boolean isConnectedUserASASAdministratorsGroupMember(MdFactory m_Factory) throws Exception {
        boolean isAdmin = false;
        ISecurity_1_1 iSecurity = null;
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        if (omiConnection != null) {
            VariableArray2dOfStringHolder vaTmpOut = new VariableArray2dOfStringHolder();
            try {
                iSecurity = m_Factory.getConnection().MakeISecurityConnection(omiConnection);
                iSecurity.GetAuthorizations("getIdentityDrivenPropertyValues", "", "SAS.IdentityGroups", "", vaTmpOut);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    iSecurity._release();
                    iSecurity = null;
                }
                catch (Exception exception) {}
            }
            for (int i = 0; i < vaTmpOut.value.length; ++i) {
                String strGroupName = vaTmpOut.value[i][2];
                if (!strGroupName.equalsIgnoreCase("SASAdministrators")) continue;
                isAdmin = true;
                break;
            }
            return isAdmin;
        }
        return isAdmin;
    }

    public static class ConnectedIdentityInfo {
        public String m_Name;
        public String m_Type;
        public String m_UserClass;
        public String m_UserId;
        public String m_ObjectID;
        public String m_UnrestrictedSource = null;

        public ConnectedIdentityInfo(MdFactory m_Factory) throws MdException, RemoteException {
            ISecurity_1_1 iSecurity = null;
            IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
            iSecurity = ISecurity_1_1Helper.narrow((Object)omiConnection);
            if (iSecurity == null) {
                throw new MdException(bundle2.getString("RepositoryUtil.ISecurity.Connection.Error.txt"));
            }
            VariableArray2dOfStringHolder vaTmpOut = new VariableArray2dOfStringHolder();
            String[][] options = new String[][]{{"ReturnUnrestrictedSource"}, {""}};
            try {
                iSecurity.GetInfo("GetIdentityInfo", "", options, vaTmpOut);
            }
            catch (Exception e) {
                throw new MdException(bundle2.formatString("RepositoryUtil.ISecurity.GetInfo.Error.txt", (java.lang.Object)e.getMessage()));
            }
            finally {
                try {
                    iSecurity._release();
                    iSecurity = null;
                }
                catch (Exception exception) {}
            }
            for (int i = 0; i < vaTmpOut.value.length; ++i) {
                String strKeyword = vaTmpOut.value[i][0];
                String strValue = vaTmpOut.value[i][1];
                if (strKeyword.equalsIgnoreCase("UserClass")) {
                    this.m_UserClass = new String(strValue);
                    continue;
                }
                if (strKeyword.equalsIgnoreCase("AuthenticatedUserid")) {
                    this.m_UserId = new String(strValue);
                    continue;
                }
                if (strKeyword.equalsIgnoreCase("IdentityName")) {
                    this.m_Name = new String(strValue);
                    continue;
                }
                if (strKeyword.equalsIgnoreCase("IdentityType")) {
                    this.m_Type = new String(strValue);
                    continue;
                }
                if (strKeyword.equalsIgnoreCase("IdentityObjectID")) {
                    this.m_ObjectID = new String(strValue);
                    continue;
                }
                if (!strKeyword.equalsIgnoreCase("UnrestrictedSource")) continue;
                this.m_UnrestrictedSource = new String(strValue);
            }
        }
    }

    private static class extComparator
    implements Comparator {
        private extComparator() {
        }

        public int compare(java.lang.Object obj1, java.lang.Object obj2) {
            try {
                Extension ext1 = (Extension)obj1;
                Extension ext2 = (Extension)obj2;
                String strDate1 = ext1.getMetadataCreated();
                String strDate2 = ext2.getMetadataCreated();
                if (strDate1.length() < 1 || strDate2.length() < 1) {
                    return -1;
                }
                Double dDate1 = new Double(strDate1);
                Double dDate2 = new Double(strDate2);
                return dDate2.compareTo(dDate1);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return -1;
            }
        }
    }
}

